/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ul.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.ul.dao.UlLevelUllistMapper;
import com.yqbsoft.laser.service.ul.dao.UlLevelUpointsMapper;
import com.yqbsoft.laser.service.ul.domain.UlLevelUllistDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUllistReDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUpointsDomain;
import com.yqbsoft.laser.service.ul.domain.UlLevelUpointsReDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoDomain;
import com.yqbsoft.laser.service.ul.domain.UmUserinfoQua;
import com.yqbsoft.laser.service.ul.model.UlLevelList;
import com.yqbsoft.laser.service.ul.model.UlLevelListconf;
import com.yqbsoft.laser.service.ul.model.UlLevelUllist;
import com.yqbsoft.laser.service.ul.model.UlLevelUpoints;
import com.yqbsoft.laser.service.ul.service.UlLevelListconfService;
import com.yqbsoft.laser.service.ul.service.UlLevelService;
import com.yqbsoft.laser.service.ul.service.UlLevelUllistService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UlLevelUllistServiceImpl
extends BaseServiceImpl
implements UlLevelUllistService {
    private static final String SYS_CODE = "ul.UlLevelUllistServiceImpl";
    private UlLevelUllistMapper ulLevelUllistMapper;
    private UlLevelUpointsMapper ulLevelUpointsMapper;
    private UlLevelService ulLevelService;
    private UlLevelListconfService ulLevelListconfService;

    public void setUlLevelUllistMapper(UlLevelUllistMapper ulLevelUllistMapper) {
        this.ulLevelUllistMapper = ulLevelUllistMapper;
    }

    public void setUlLevelUpointsMapper(UlLevelUpointsMapper ulLevelUpointsMapper) {
        this.ulLevelUpointsMapper = ulLevelUpointsMapper;
    }

    public UlLevelService getUlLevelService() {
        return this.ulLevelService;
    }

    public void setUlLevelService(UlLevelService ulLevelService) {
        this.ulLevelService = ulLevelService;
    }

    public void setUlLevelListconfService(UlLevelListconfService ulLevelListconfService) {
        this.ulLevelListconfService = ulLevelListconfService;
    }

    private Date getSysDate() {
        try {
            return this.ulLevelUllistMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) {
        if (null == ulLevelUllistDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelUllistDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelUllistDefault(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return;
        }
        if (null == ulLevelUllist.getDataState()) {
            ulLevelUllist.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelUllist.getGmtCreate()) {
            ulLevelUllist.setGmtCreate(date);
        }
        ulLevelUllist.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelUllist.getLevelListCode())) {
            ulLevelUllist.setLevelListCode(this.getNo(null, "UlLevelUllist", "ulLevelUllist", ulLevelUllist.getTenantCode()));
        }
    }

    private int getUlLevelUllistMaxCode() {
        int code = 0;
        try {
            return this.ulLevelUllistMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelUllistUpdataDefault(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return;
        }
        ulLevelUllist.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelUllistModel(UlLevelUllist ulLevelUllist) throws ApiException {
        if (null == ulLevelUllist) {
            return;
        }
        try {
            this.ulLevelUllistMapper.insert(ulLevelUllist);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllistModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelUllistBatchModel(List<UlLevelUllist> ulLevelUllistList) throws ApiException {
        if (null == ulLevelUllistList || ulLevelUllistList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelUllistMapper.insertBatch(ulLevelUllistList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllistBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelUllist getUlLevelUllistModelById(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        try {
            return this.ulLevelUllistMapper.selectByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelUllist getUlLevelUllistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUllistMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUllistModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelUllistModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUllistModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUllistModelByCode.num");
        }
    }

    private void deleteUlLevelUllistModel(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.deleteByPrimaryKey(levelListId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUllistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUllistModel.num");
        }
    }

    private void updateUlLevelUllistModel(UlLevelUllist ulLevelUllist) throws ApiException {
        if (null == ulLevelUllist) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateByPrimaryKey(ulLevelUllist);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllistModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllistModel.num");
        }
    }

    private void updateStateUlLevelUllistModel(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == levelListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelListId", levelListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModel.null");
        }
    }

    private void updateStateUlLevelUllistModelByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUllistModelByCode.null");
        }
    }

    private UlLevelUllist makeUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain, UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllistDomain) {
            return null;
        }
        if (null == ulLevelUllist) {
            ulLevelUllist = new UlLevelUllist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUllist, (Object)ulLevelUllistDomain);
            return ulLevelUllist;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUllist", (Throwable)e);
            return null;
        }
    }

    private UlLevelUllistReDomain makeUlLevelUllistReDomain(UlLevelUllist ulLevelUllist) {
        if (null == ulLevelUllist) {
            return null;
        }
        UlLevelUllistReDomain ulLevelUllistReDomain = new UlLevelUllistReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUllistReDomain, (Object)ulLevelUllist);
            return ulLevelUllistReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUllistReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelUllist> queryUlLevelUllistModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelUllistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.queryUlLevelUllistModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelUllist(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelUllistMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.countUlLevelUllist", (Throwable)e);
        }
        return i;
    }

    private UlLevelUllist createUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) {
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUllist.checkUlLevelUllist", msg);
        }
        UlLevelUllist ulLevelUllist = this.makeUlLevelUllist(ulLevelUllistDomain, null);
        this.setUlLevelUllistDefault(ulLevelUllist);
        return ulLevelUllist;
    }

    private String checkUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) {
        if (null == ulLevelUpointsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ulLevelUpointsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUlLevelUpointsDefault(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return;
        }
        if (null == ulLevelUpoints.getDataState()) {
            ulLevelUpoints.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ulLevelUpoints.getGmtCreate()) {
            ulLevelUpoints.setGmtCreate(date);
        }
        ulLevelUpoints.setGmtModified(date);
        if (StringUtils.isBlank((String)ulLevelUpoints.getLevelUpointsCode())) {
            ulLevelUpoints.setLevelUpointsCode(this.getNo(null, "UlLevelUpoints", "ulLevelUpoints", ulLevelUpoints.getTenantCode()));
        }
    }

    private int getUlLevelUpointsMaxCode() {
        int code = 0;
        try {
            return this.ulLevelUpointsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUlLevelUpointsUpdataDefault(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return;
        }
        ulLevelUpoints.setGmtModified(this.getSysDate());
    }

    private void saveUlLevelUpointsModel(UlLevelUpoints ulLevelUpoints) throws ApiException {
        if (null == ulLevelUpoints) {
            return;
        }
        try {
            this.ulLevelUpointsMapper.insert(ulLevelUpoints);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsModel.ex", (Throwable)e);
        }
    }

    private void saveUlLevelUpointsBatchModel(List<UlLevelUpoints> ulLevelUpointsList) throws ApiException {
        if (null == ulLevelUpointsList || ulLevelUpointsList.isEmpty()) {
            return;
        }
        try {
            this.ulLevelUpointsMapper.insertBatch(ulLevelUpointsList);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsBatchModel.ex", (Throwable)e);
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelById(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.selectByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelById", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelByCode", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpoints getUlLevelUpointsModelByMember(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ulLevelUpointsMapper.getByMember(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.getUlLevelUpointsModelByMember", (Throwable)e);
            return null;
        }
    }

    private void delUlLevelUpointsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUpointsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.delUlLevelUpointsModelByCode.num");
        }
    }

    private void deleteUlLevelUpointsModel(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.deleteByPrimaryKey(upointsId);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.deleteUlLevelUpointsModel.num");
        }
    }

    private void updateUlLevelUpointsModel(UlLevelUpoints ulLevelUpoints) throws ApiException {
        if (null == ulLevelUpoints) {
            return;
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateByPrimaryKey(ulLevelUpoints);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpointsModel.num");
        }
    }

    private void updateStateUlLevelUpointsModel(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == upointsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelUpointsId", upointsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModel.null");
        }
    }

    private void updateStateUlLevelUpointsModelByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateStateUlLevelUpointsModelByCode.null");
        }
    }

    private UlLevelUpoints makeUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain, UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpointsDomain) {
            return null;
        }
        if (null == ulLevelUpoints) {
            ulLevelUpoints = new UlLevelUpoints();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpoints, (Object)ulLevelUpointsDomain);
            return ulLevelUpoints;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUpoints", (Throwable)e);
            return null;
        }
    }

    private UlLevelUpointsReDomain makeUlLevelUpointsReDomain(UlLevelUpoints ulLevelUpoints) {
        if (null == ulLevelUpoints) {
            return null;
        }
        UlLevelUpointsReDomain ulLevelUpointsReDomain = new UlLevelUpointsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsReDomain, (Object)ulLevelUpoints);
            return ulLevelUpointsReDomain;
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUlLevelUpointsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UlLevelUpoints> queryUlLevelUpointsModelPage(Map<String, Object> parammap) {
        try {
            return this.ulLevelUpointsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.queryUlLevelUpointsModel", (Throwable)e);
            return null;
        }
    }

    private int countUlLevelUpoints(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ulLevelUpointsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.countUlLevelUpoints", (Throwable)e);
        }
        return i;
    }

    private UlLevelUpoints createUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) {
        String msg = this.checkUlLevelUpoints(ulLevelUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpoints.checkUlLevelUpoints", msg);
        }
        UlLevelUpoints ulLevelUpoints = this.makeUlLevelUpoints(ulLevelUpointsDomain, null);
        this.setUlLevelUpointsDefault(ulLevelUpoints);
        return ulLevelUpoints;
    }

    @Override
    public String saveUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
        this.saveUlLevelUllistModel(ulLevelUllist);
        return ulLevelUllist.getLevelListCode();
    }

    public UlLevelUllist saveUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
        this.saveUlLevelUllistModel(ulLevelUllist);
        return ulLevelUllist;
    }

    @Override
    public UlLevelUllist saveUlLevelUpointsByUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        String value;
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.checkUlLevelUllist", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelUllistDomain.getLevelType());
        map.put("memberCode", ulLevelUllistDomain.getMemberCode());
        map.put("tenantCode", ulLevelUllistDomain.getTenantCode());
        map.put("levelUserqua", ulLevelUllistDomain.getLevelUserqua());
        String pointsDataType = ulLevelUllistDomain.getLevelDatatype();
        if (StringUtils.isNotBlank((String)pointsDataType) && StringUtils.isNotBlank((String)(value = (String)BeanUtils.forceGetProperty((Object)ulLevelUllistDomain, (String)ulLevelUllistDomain.getLevelDatatype())))) {
            map.put("levelDatatype", pointsDataType);
            map.put("levelDatacode", value);
        }
        UlLevelUpoints ulLevelUpoints = this.getUlLevelUpointsModelByMember(map);
        UlLevelUpointsDomain ulLevelUpointsDomain = null;
        if (null == ulLevelUpoints) {
            if (!"0".equals(ulLevelUllistDomain.getLevelListDirection())) {
                throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.upmUpoints");
            }
            ulLevelUpointsDomain = this.makeUlLevelUpoints(ulLevelUllistDomain);
        } else {
            this.updateStateUlLevelUpointsModel(ulLevelUpoints.getLevelUpointsId(), ulLevelUpoints.getDataState(), ulLevelUpoints.getDataState(), null);
            ulLevelUpoints = this.getUlLevelUpointsModelByMember(map);
        }
        UlLevelUllistDomain ullistDomain = this.makeUmUlLevelListDomain(ulLevelUpoints, ulLevelUllistDomain);
        if (null == ullistDomain) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.saveUlLevelUpointsByUllist.ullistDomain");
        }
        if (null != ulLevelUpointsDomain) {
            this.saveUlLevelUpoints(ulLevelUpointsDomain);
        } else {
            ulLevelUpoints.setLevelLnum(ullistDomain.getLevelAflnum());
            ulLevelUpoints.setLevelNum(ullistDomain.getLevelAfnum());
            ulLevelUpoints.setLevelOnum(ullistDomain.getLevelAfonum());
            this.updateUlLevelUpointsModel(ulLevelUpoints);
        }
        UlLevelUllist ulLevelUllist = this.saveUllist(ullistDomain);
        return ulLevelUllist;
    }

    private UlLevelUpointsDomain makeUlLevelUpoints(UlLevelUllistDomain ulLevelUllistDomain) {
        String value;
        if (null == ulLevelUllistDomain) {
            return null;
        }
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        ulLevelUpointsDomain.setLevelLnum(BigDecimal.ZERO);
        ulLevelUpointsDomain.setLevelNum(ulLevelUllistDomain.getLevelListNum());
        ulLevelUpointsDomain.setLevelOnum(BigDecimal.ZERO);
        ulLevelUpointsDomain.setMemberCode(ulLevelUllistDomain.getMemberCode());
        ulLevelUpointsDomain.setMemberName(ulLevelUllistDomain.getMemberName());
        ulLevelUpointsDomain.setTenantCode(ulLevelUllistDomain.getTenantCode());
        ulLevelUpointsDomain.setLevelType(ulLevelUllistDomain.getLevelType());
        ulLevelUpointsDomain.setLevelUserqua(ulLevelUllistDomain.getLevelUserqua());
        String levelDatatype = ulLevelUllistDomain.getLevelDatatype();
        if (StringUtils.isNotBlank((String)levelDatatype) && StringUtils.isNotBlank((String)(value = (String)BeanUtils.forceGetProperty((Object)ulLevelUllistDomain, (String)ulLevelUllistDomain.getLevelDatatype())))) {
            ulLevelUpointsDomain.setLevelDatatype(levelDatatype);
            ulLevelUpointsDomain.setLevelDatavalue(value);
        }
        return ulLevelUpointsDomain;
    }

    private UlLevelUllistDomain makeDisUlLevelUllist(UlLevelUpoints ulLevelUpointsByMember, UlLevelUllistDomain ulLevelUllistDomain) {
        List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(this.getQueryMapParam("levelType,levelUserqua,levelDatatype,tenantCode,levelDatavalue", new Object[]{"0", "dis", "levelListParentCode", ulLevelUpointsByMember.getTenantCode(), ulLevelUpointsByMember.getLevelDatavalue()}));
        if (ListUtil.isEmpty(ulLevelLists)) {
            return null;
        }
        String key = ulLevelUllistDomain.getLevelRuleApi() + "-" + ulLevelUllistDomain.getTenantCode() + "-" + ulLevelUllistDomain.getLevelUserqua() + "-" + ulLevelLists.get(0).getLevelListCode();
        UlLevelListconf ulLevelListconf = (UlLevelListconf)DisUtil.getMapJson((String)"UlLevelListConft-type", (String)key, UlLevelListconf.class);
        if (null == ulLevelListconf) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeDisLevelUllisByClear.ulLevelListconf", (Object)key);
            return null;
        }
        List<UlLevelUllist> ulLevelUllists = this.queryUlLevelUllistModelPage(this.getQueryParamMap("levelUserqua,tenantCode,levelRuleApi,memberCode,levelType", new Object[]{ulLevelUllistDomain.getLevelUserqua(), ulLevelUllistDomain.getTenantCode(), ulLevelUllistDomain.getLevelRuleApi(), ulLevelUllistDomain.getMemberCode(), ulLevelUllistDomain.getLevelType()}));
        if (null != ulLevelUllists && ListUtil.isNotEmpty(ulLevelUllists)) {
            ulLevelUllistDomain.setLevelBfnum(ulLevelUllists.get(0).getLevelAfnum());
        }
        return ulLevelUllistDomain;
    }

    private UlLevelUllistDomain makeUmUlLevelListDomain(UlLevelUpoints ulLevelUpoints, UlLevelUllistDomain ulLevelUllistDomain) {
        if (null == ulLevelUllistDomain) {
            return null;
        }
        UlLevelUllistDomain levelUllistDomain = new UlLevelUllistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)levelUllistDomain, (Object)ulLevelUllistDomain);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.makeUmUlLevelListDomain.e", (Throwable)e);
            return null;
        }
        levelUllistDomain.setLevelAflnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelAfnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelAfonum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBflnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBfnum(BigDecimal.ZERO);
        levelUllistDomain.setLevelBfonum(BigDecimal.ZERO);
        if (null != ulLevelUpoints) {
            if ("dis".equals(ulLevelUllistDomain.getLevelUserqua())) {
                this.makeDisUlLevelUllist(ulLevelUpoints, levelUllistDomain);
            } else {
                levelUllistDomain.setLevelAflnum(ulLevelUpoints.getLevelLnum());
                levelUllistDomain.setLevelAfnum(ulLevelUpoints.getLevelNum());
                levelUllistDomain.setLevelAfonum(ulLevelUpoints.getLevelOnum());
                levelUllistDomain.setLevelBflnum(ulLevelUpoints.getLevelLnum());
                levelUllistDomain.setLevelBfnum(ulLevelUpoints.getLevelNum());
                levelUllistDomain.setLevelBfonum(ulLevelUpoints.getLevelOnum());
            }
        }
        if ("0".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("1".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("2".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().add(levelUllistDomain.getLevelListNum()));
        } else if ("3".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("4".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("5".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().add(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAflnum(levelUllistDomain.getLevelBflnum().subtract(levelUllistDomain.getLevelListNum()));
        } else if ("6".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfonum(levelUllistDomain.getLevelBfonum().subtract(levelUllistDomain.getLevelListNum()));
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        } else if ("7".equals(levelUllistDomain.getLevelListDirection())) {
            levelUllistDomain.setLevelAfnum(levelUllistDomain.getLevelBfnum().add(levelUllistDomain.getLevelListNum()));
        }
        if (levelUllistDomain.getLevelAfnum().compareTo(BigDecimal.ZERO) == -1 || levelUllistDomain.getLevelAflnum().compareTo(BigDecimal.ZERO) == -1 || levelUllistDomain.getLevelAfonum().compareTo(BigDecimal.ZERO) == -1) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.makeUmUpointsListDomain.num");
        }
        return levelUllistDomain;
    }

    @Override
    public String saveUlLevelUllistBatch(List<UlLevelUllistDomain> ulLevelUllistDomainList) throws ApiException {
        if (null == ulLevelUllistDomainList || ulLevelUllistDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelUllist> ulLevelUllistList = new ArrayList<UlLevelUllist>();
        String code = "";
        for (UlLevelUllistDomain ulLevelUllistDomain : ulLevelUllistDomainList) {
            UlLevelUllist ulLevelUllist = this.createUlLevelUllist(ulLevelUllistDomain);
            code = ulLevelUllist.getLevelListCode();
            ulLevelUllistList.add(ulLevelUllist);
        }
        this.saveUlLevelUllistBatchModel(ulLevelUllistList);
        return code;
    }

    @Override
    public void updateUlLevelUllistState(Integer levelListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.updateStateUlLevelUllistModel(levelListId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUllistStateByCode(String tenantCode, String levelListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelUllistModelByCode(tenantCode, levelListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUllist(UlLevelUllistDomain ulLevelUllistDomain) throws ApiException {
        String msg = this.checkUlLevelUllist(ulLevelUllistDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllist.checkUlLevelUllist", msg);
        }
        UlLevelUllist oldUlLevelUllist = this.getUlLevelUllistModelById(ulLevelUllistDomain.getLevelListId());
        if (null == oldUlLevelUllist) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUllist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelUllist ulLevelUllist = this.makeUlLevelUllist(ulLevelUllistDomain, oldUlLevelUllist);
        this.setUlLevelUllistUpdataDefault(ulLevelUllist);
        this.updateUlLevelUllistModel(ulLevelUllist);
    }

    @Override
    public UlLevelUllist getUlLevelUllist(Integer levelListId) {
        if (null == levelListId) {
            return null;
        }
        return this.getUlLevelUllistModelById(levelListId);
    }

    @Override
    public void deleteUlLevelUllist(Integer levelListId) throws ApiException {
        if (null == levelListId) {
            return;
        }
        this.deleteUlLevelUllistModel(levelListId);
    }

    @Override
    public QueryResult<UlLevelUllist> queryUlLevelUllistPage(Map<String, Object> map) {
        List<UlLevelUllist> ulLevelUllistList = this.queryUlLevelUllistModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelUllist(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelUllistList);
        return queryResult;
    }

    @Override
    public UlLevelUllist getUlLevelUllistByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        return this.getUlLevelUllistModelByCode(map);
    }

    @Override
    public void deleteUlLevelUllistByCode(String tenantCode, String levelListCode) throws ApiException {
        if (StringUtils.isBlank((String)levelListCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("levelListCode", levelListCode);
        this.delUlLevelUllistModelByCode(map);
    }

    @Override
    public String saveUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) throws ApiException {
        if (null != ulLevelUpointsDomain.getLevelUpointsId()) {
            this.updateUlLevelUpoints(ulLevelUpointsDomain);
            return ulLevelUpointsDomain.getLevelUpointsCode();
        }
        UlLevelUpoints ulLevelUpoints = this.createUlLevelUpoints(ulLevelUpointsDomain);
        this.saveUlLevelUpointsModel(ulLevelUpoints);
        return ulLevelUpoints.getLevelUpointsCode();
    }

    @Override
    public String saveUlLevelUpointsBatch(List<UlLevelUpointsDomain> ulLevelUpointsDomainList) throws ApiException {
        if (null == ulLevelUpointsDomainList || ulLevelUpointsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UlLevelUpoints> ulLevelUpointsList = new ArrayList<UlLevelUpoints>();
        String code = "";
        for (UlLevelUpointsDomain ulLevelUpointsDomain : ulLevelUpointsDomainList) {
            UlLevelUpoints ulLevelUpoints = this.createUlLevelUpoints(ulLevelUpointsDomain);
            code = ulLevelUpoints.getLevelUpointsCode();
            ulLevelUpointsList.add(ulLevelUpoints);
        }
        this.saveUlLevelUpointsBatchModel(ulLevelUpointsList);
        return code;
    }

    @Override
    public void updateUlLevelUpointsState(Integer upointsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.updateStateUlLevelUpointsModel(upointsId, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUpointsStateByCode(String tenantCode, String upointsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUlLevelUpointsModelByCode(tenantCode, upointsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUlLevelUpoints(UlLevelUpointsDomain ulLevelUpointsDomain) throws ApiException {
        String msg = this.checkUlLevelUpoints(ulLevelUpointsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpoints.checkUlLevelUpoints", msg);
        }
        UlLevelUpoints oldUlLevelUpoints = this.getUlLevelUpointsModelById(ulLevelUpointsDomain.getLevelUpointsId());
        if (null == oldUlLevelUpoints) {
            throw new ApiException("ul.UlLevelUllistServiceImpl.updateUlLevelUpoints.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UlLevelUpoints ulLevelUpoints = this.makeUlLevelUpoints(ulLevelUpointsDomain, oldUlLevelUpoints);
        this.setUlLevelUpointsUpdataDefault(ulLevelUpoints);
        this.updateUlLevelUpointsModel(ulLevelUpoints);
    }

    @Override
    public UlLevelUpoints getUlLevelUpoints(Integer upointsId) {
        if (null == upointsId) {
            return null;
        }
        return this.getUlLevelUpointsModelById(upointsId);
    }

    @Override
    public void deleteUlLevelUpoints(Integer upointsId) throws ApiException {
        if (null == upointsId) {
            return;
        }
        this.deleteUlLevelUpointsModel(upointsId);
    }

    @Override
    public QueryResult<UlLevelUpoints> queryUlLevelUpointsPage(Map<String, Object> map) {
        List<UlLevelUpoints> ulLevelUpointsList = this.queryUlLevelUpointsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUlLevelUpoints(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ulLevelUpointsList);
        return queryResult;
    }

    @Override
    public UlLevelUpoints getUlLevelUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        return this.getUlLevelUpointsModelByCode(map);
    }

    @Override
    public UlLevelUpoints getUlLevelUpointsByMember(Map<String, Object> map) throws ApiException {
        return this.getUlLevelUpointsModelByMember(map);
    }

    @Override
    public void deleteUlLevelUpointsByCode(String tenantCode, String upointsCode) throws ApiException {
        if (StringUtils.isBlank((String)upointsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("upointsCode", upointsCode);
        this.delUlLevelUpointsModelByCode(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public String saveLevelGrant(UlLevelUllist ulLevelUllist) throws ApiException {
        if (null == ulLevelUllist) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", ulLevelUllist.getLevelType());
        map.put("memberCode", ulLevelUllist.getMemberCode());
        map.put("tenantCode", ulLevelUllist.getTenantCode());
        map.put("levelUserqua", ulLevelUllist.getLevelUserqua());
        UlLevelUpoints levelUpoints = this.getUlLevelUpointsByMember(map);
        this.logger.error("ul.UlLevelUllistServiceImpl.saveLevelGrant.levelUpoints", (Object)JsonUtil.buildNormalBinder().toJson((Object)levelUpoints));
        if (null == levelUpoints) {
            return "error";
        }
        map.remove("memberCode");
        map.put("levelDatavalue", levelUpoints.getLevelDatavalue());
        List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(map);
        boolean updateLevelUpoints = false;
        if (null == ulLevelLists) return "error";
        if (ListUtil.isEmpty(ulLevelLists)) {
            return "error";
        }
        UlLevelList ulLevelList = ulLevelLists.get(0);
        this.logger.error("ul.UlLevelUllistServiceImpl.saveLevelGrant.ulLevelList", (Object)JsonUtil.buildNormalBinder().toJson((Object)ulLevelList));
        if ("dis".equals(ulLevelList.getLevelUserqua())) {
            if (!this.upDisLevelUpoints(ulLevelList, levelUpoints)) return "error";
            updateLevelUpoints = true;
        } else {
            if (levelUpoints.getLevelNum().intValue() < ulLevelList.getLevelListStart()) return "error";
            updateLevelUpoints = true;
        }
        this.logger.error("ul.UlLevelUllistServiceImpl.saveLevelGrant.updateLevelUpoints", (Object)updateLevelUpoints);
        if (!updateLevelUpoints) return "error";
        levelUpoints.setLevelListLevel(ulLevelList.getLevelListLevel());
        levelUpoints.setLevelListName(ulLevelList.getLevelListName());
        levelUpoints.setLevelDatatype("levelListCode");
        levelUpoints.setLevelDatavalue(ulLevelList.getLevelListCode());
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.ulLevelUpointsDomain.e", (Throwable)e);
            return "error";
        }
        this.updateUlLevelUpoints(ulLevelUpointsDomain);
        if (!this.updateUserInfoLevel(levelUpoints)) return "success";
        return "error";
    }

    private boolean upDisLevelUpoints(UlLevelList ulLevelList, UlLevelUpoints levelUpoints) {
        QueryResult<UlLevelListconf> ulLevelListconfQueryResult = this.ulLevelListconfService.queryUlLevelListconfPage(this.getQueryParamMap("levelListCode,tenantCode,levelUserqua", new Object[]{ulLevelList.getLevelListCode(), ulLevelList.getTenantCode(), ulLevelList.getLevelUserqua()}));
        this.logger.error("ul.UlLevelUllistServiceImplupDisLevelUpoints.ulLevelListconfQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(ulLevelListconfQueryResult));
        if (null == ulLevelListconfQueryResult || ListUtil.isNotEmpty((Collection)ulLevelListconfQueryResult.getList())) {
            return false;
        }
        for (UlLevelListconf ulLevelListconf : ulLevelListconfQueryResult.getList()) {
            QueryResult<UlLevelUllist> ulLevelUllistQueryResult = this.queryUlLevelUllistPage(this.getQueryParamMap("memberCode,tenantCode,levelRuleApi", new Object[]{levelUpoints.getMemberCode(), levelUpoints.getTenantCode(), ulLevelListconf.getLevelDatatype()}));
            this.logger.error("ul.UlLevelUllistServiceImplupDisLevelUpoints.ulLevelUllistQueryResult", (Object)JsonUtil.buildNormalBinder().toJson(ulLevelUllistQueryResult));
            if (null == ulLevelUllistQueryResult || ListUtil.isEmpty((Collection)ulLevelUllistQueryResult.getList())) {
                return false;
            }
            UlLevelUllist ulLevelUllist = (UlLevelUllist)ulLevelUllistQueryResult.getList().get(0);
            if (ulLevelUllist.getLevelAfnum().intValue() >= ulLevelListconf.getLevelListStart()) continue;
            return false;
        }
        return true;
    }

    @Override
    public String saveDisUlLevelUpointsByUserInfo(UmUserinfoDomain umUserinfo, UmUserDomain umUser, String optype) {
        if (null == umUserinfo || null == umUserinfo.getUserinfoQuality() || !umUserinfo.getUserinfoQuality().contains("dis")) {
            return "error";
        }
        UmUserinfoQua userinfoQua = new UmUserinfoQua();
        boolean boo = false;
        if (ListUtil.isNotEmpty(umUserinfo.getUmUserinfoQuaList())) {
            for (UmUserinfoQua umUserinfoQua : umUserinfo.getUmUserinfoQuaList()) {
                if (!"levelListCode".equals(umUserinfoQua.getUserinfoQuaKey())) continue;
                userinfoQua = umUserinfoQua;
                boo = true;
            }
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("levelType", "0");
        map.put("levelUserqua", "dis");
        map.put("tenantCode", umUserinfo.getTenantCode());
        map.put("memberCode", umUserinfo.getUserinfoCode());
        UlLevelUpoints levelUpoints = this.getUlLevelUpointsByMember(map);
        UlLevelUpointsDomain ulLevelUpointsDomain = new UlLevelUpointsDomain();
        if (null == levelUpoints) {
            ulLevelUpointsDomain.setLevelLnum(BigDecimal.ZERO);
            ulLevelUpointsDomain.setLevelNum(BigDecimal.ZERO);
            ulLevelUpointsDomain.setLevelOnum(BigDecimal.ZERO);
            ulLevelUpointsDomain.setMemberCode(umUserinfo.getUserinfoCode());
            ulLevelUpointsDomain.setMemberName(umUserinfo.getUserinfoCompname());
            ulLevelUpointsDomain.setTenantCode(umUserinfo.getTenantCode());
            ulLevelUpointsDomain.setLevelType("0");
            ulLevelUpointsDomain.setLevelUserqua("dis");
        } else {
            try {
                BeanUtils.copyAllPropertys((Object)ulLevelUpointsDomain, (Object)levelUpoints);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (boo) {
            ulLevelUpointsDomain.setLevelDatatype(userinfoQua.getUserinfoQuaKey());
            ulLevelUpointsDomain.setLevelDatavalue(userinfoQua.getUserinfoQuaVaule());
            ulLevelUpointsDomain.setLevelListName(userinfoQua.getUserinfoQuaVaule1());
            ulLevelUpointsDomain.setLevelListLevel(Integer.getInteger(userinfoQua.getUserinfoQuaUrl2()));
        } else {
            HashMap<String, Object> ulLevelmap = new HashMap<String, Object>();
            ulLevelmap.put("levelType", "0");
            ulLevelmap.put("tenantCode", umUserinfo.getTenantCode());
            ulLevelmap.put("levelUserqua", "dis");
            ulLevelmap.put("levelDatatype", "levelListParentCode");
            ulLevelmap.put("levelDatavalue", "0");
            List<UlLevelList> ulLevelLists = this.ulLevelService.queryLevelListByLevelNum(ulLevelmap);
            if (null == ulLevelLists || ListUtil.isEmpty(ulLevelLists)) {
                return "error";
            }
            UlLevelList ulLevelList = ulLevelLists.get(0);
            ulLevelUpointsDomain.setLevelDatatype("levelListCode");
            ulLevelUpointsDomain.setLevelDatavalue(ulLevelList.getLevelListCode());
            ulLevelUpointsDomain.setLevelListName(ulLevelList.getLevelListName());
            ulLevelUpointsDomain.setLevelListLevel(ulLevelList.getLevelListLevel());
        }
        this.saveUlLevelUpoints(ulLevelUpointsDomain);
        if (this.updateUserInfoLevel(this.makeUlLevelUpoints(ulLevelUpointsDomain, levelUpoints))) {
            return "error";
        }
        return "success";
    }

    private boolean updateUserInfoLevel(UlLevelUpoints levelUpoints) throws ApiException {
        this.logger.error("ul.UlLevelUllistServiceImpl.updateUserInfoLevel.levelUpoints", (Object)JsonUtil.buildNormalBinder().toJson((Object)levelUpoints));
        HashMap<String, Object> umInfoMapStr = new HashMap<String, Object>();
        umInfoMapStr.put("userinfoCode", levelUpoints.getMemberCode());
        umInfoMapStr.put("tenantCode", levelUpoints.getTenantCode());
        umInfoMapStr.put("userinfoQuaKey", "levelListCode_" + levelUpoints.getLevelUserqua());
        umInfoMapStr.put("levelDatavalue", levelUpoints.getLevelDatavalue());
        umInfoMapStr.put("levelListName", levelUpoints.getLevelListName());
        umInfoMapStr.put("levelListLevel", levelUpoints.getLevelListLevel());
        HashMap<String, String> umUserParamMap = new HashMap<String, String>();
        umUserParamMap.put("map", JsonUtil.buildNormalBinder().toJson(umInfoMapStr));
        try {
            this.getInternalRouter().inInvoke("um.userinfoQua.updateLevel", umUserParamMap);
        }
        catch (Exception e) {
            this.logger.error("ul.UlLevelUllistServiceImpl.updateUserInfoLevel.updateLevel.e", (Object)("\u4fee\u6539\u7528\u6237\u4f1a\u5458\u5f02\u5e38\uff01\uff01\uff01umUserParamMap:" + JsonUtil.buildNormalBinder().toJson(umUserParamMap)));
            return false;
        }
        return true;
    }
}

