/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.UserConstants;
import com.yqbsoft.laser.service.user.dao.UmUserMapper;
import com.yqbsoft.laser.service.user.dao.UmUserattrMapper;
import com.yqbsoft.laser.service.user.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.user.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.user.model.UmUser;
import com.yqbsoft.laser.service.user.model.UmUserattr;
import com.yqbsoft.laser.service.user.model.UmUserinfo;
import com.yqbsoft.laser.service.user.service.UserService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class UserServiceImpl
extends BaseServiceImpl
implements UserService {
    public static final String SYS_CODE = "um.USER.UserServiceImpl";
    private UmUserMapper umUserMapper;
    private UmUserinfoMapper umUserinfoMapper;
    private UmUserattrMapper umUserattrMapper;

    public void setUmUserattrMapper(UmUserattrMapper umUserattrMapper) {
        this.umUserattrMapper = umUserattrMapper;
    }

    public void setUmUserMapper(UmUserMapper umUserMapper) {
        this.umUserMapper = umUserMapper;
    }

    public void setUmUserinfoMapper(UmUserinfoMapper umUserinfoMapper) {
        this.umUserinfoMapper = umUserinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUser(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setUserDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
        if (null == umUser.getDataState()) {
            umUser.setDataState(0);
        }
        if (null == umUser.getGmtCreate()) {
            umUser.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isNotBlank((String)umUser.getUserEmial())) {
            String verifyTime = this.getSysParam("OPEN_VERIFY_TIME", "00", "00");
            if (null != verifyTime) {
                umUser.setGmtValid(this.getGmtValid(Integer.parseInt(verifyTime)));
            }
            umUser.setGmtValid(this.getGmtValid(2));
        }
        if (StringUtils.isBlank((String)umUser.getUserCode())) {
            int code = this.getMaxCode();
            umUser.setUserCode(this.makeMaxCode8(++code));
        }
        if ("0".equals(String.valueOf(umUser.getUserType())) && StringUtils.isBlank((String)umUser.getUserPcode())) {
            umUser.setUserPcode(umUser.getUserCode());
        }
    }

    private Date getGmtValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(11, validTime);
        return dar.getTime();
    }

    private Date getDayValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(5, validTime);
        return dar.getTime();
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.umUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserUpdataDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
    }

    private int saveUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserModel.ex");
        }
        try {
            return this.umUserMapper.insert(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserModel.ex", (Throwable)e);
        }
    }

    private UmUser getUserModelById(Integer userId) {
        if (null == userId) {
            return null;
        }
        try {
            return this.umUserMapper.selectByPrimaryKey(userId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private UmUser getUserModelByCode(String userCode) {
        if (null == userCode) {
            return null;
        }
        try {
            return this.umUserMapper.selectByCode(userCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteUserModel(Integer userId) throws ApiException {
        if (null == userId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserMapper.deleteByPrimaryKey(userId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserModel.num");
        }
    }

    private void updateUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return;
        }
        try {
            this.umUserMapper.updateByPrimaryKeySelective(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModel.ex");
        }
    }

    private void updateUserModelByCode(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return;
        }
        try {
            this.umUserMapper.updateByCode(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModel.ex");
        }
    }

    private void updateStateUserModel(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserModel.null");
        }
    }

    private UmUser makeUser(UmUserDomainBean umUserDomainBean, UmUser umUser) {
        if (null == umUserDomainBean) {
            return null;
        }
        if (null == umUser) {
            umUser = new UmUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUser, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.makeUser", (Throwable)e);
        }
        return umUser;
    }

    private List<UmUser> queryUserModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserModel", (Throwable)e);
            return null;
        }
    }

    private int countUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    private String checkUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setUserinfoDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
        if (null == umUserinfo.getDataState()) {
            umUserinfo.setDataState(0);
        }
        if (null == umUserinfo.getGmtCreate()) {
            umUserinfo.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoCode())) {
            int code = this.getMaxUserinfoCode();
            umUserinfo.setUserinfoCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxUserinfoCode() {
        int code = 0;
        try {
            return this.umUserinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserinfoUpdataDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
    }

    private int saveUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return 0;
        }
        try {
            return this.umUserinfoMapper.insert(umUserinfo);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserinfoModel.ex");
        }
    }

    private UmUserinfo getUserinfoModelById(Integer userinfoId) {
        if (null == userinfoId) {
            return null;
        }
        try {
            return this.umUserinfoMapper.selectByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelById", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo getUserinfoModelByCode(String userinfoCode) {
        if (null == userinfoCode) {
            return null;
        }
        try {
            return this.umUserinfoMapper.selectByUserinfoCode(userinfoCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByName(String userName) {
        if (null == userName) {
            return null;
        }
        try {
            return this.umUserMapper.selectByName(userName);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.selectByName", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo getUserinfoModelByUserCode(String userCode) {
        if (null == userCode) {
            return null;
        }
        try {
            return this.umUserinfoMapper.selectByUserCode(userCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelByUserCode", (Throwable)e);
            return null;
        }
    }

    private void deleteUserinfoModel(Integer userinfoId) throws ApiException {
        if (null == userinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.deleteByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.num");
        }
    }

    private void deleteByUserCodeModel(String userCode) throws ApiException {
        if (null == userCode) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.deleteByUserCode(userCode);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.num");
        }
    }

    private List<UmUserattr> queryUmUserattrsByUserCode(String userCode) {
        try {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("userCode", userCode);
            return this.umUserattrMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserattrModel", (Throwable)e);
            return null;
        }
    }

    private void deleteAttrByUserCodeModel(String userCode) throws ApiException {
        if (null == userCode) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserattrMapper.deleteByUserCode(userCode);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserattrModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserattrModel.num");
        }
    }

    private void updateUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return;
        }
        try {
            this.umUserinfoMapper.updateByPrimaryKeySelective(umUserinfo);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoModel.ex");
        }
    }

    private void updateStateUserinfoModel(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateSyncUserinfoModel(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoTestsync", userinfoTestsync);
        map.put("userinfoProdsync", userinfoProdsync);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateSyncByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateFeeUserinfoModel(String userCode, Integer userinfoFeeStatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoFeeStatus", userinfoFeeStatus);
        map.put("userinfoFeeEdate", DateUtil.getDateToString((String)userinfoFeeEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserServiceImpl.updateFeeUserinfoModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateFeeByUserCode(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserServiceImpl.updateFeeUserinfoModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserServiceImpl.updateFeeUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateUserinfoRealnameModel(String userCode, String userinfoEdate, Integer dataState) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoEdate", DateUtil.getDateToString((String)userinfoEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserServiceImpl.updateUserinfoRealnameModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateUserinfoRealname(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserServiceImpl.updateUserinfoRealnameModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoRealnameModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoRealnameModel.null");
        }
    }

    private UmUserinfo makeUserinfo(UmUserinfoDomainBean umUserinfoDomainBean, UmUserinfo umUserinfo) {
        if (null == umUserinfoDomainBean) {
            return null;
        }
        if (null == umUserinfo) {
            umUserinfo = new UmUserinfo();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)umUserinfoDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.makeUserinfo", (Throwable)e);
        }
        return umUserinfo;
    }

    private List<UmUserinfo> queryUserinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfo> queryUserinfoModelList(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.queryUserinfoList(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countUserinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.countUserinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public UmUser saveUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.saveUser.checkUser", msg);
        }
        UmUser umUser = this.makeUser(umUserDomainBean, null);
        this.setUserDefault(umUser);
        umUser.setUserPwsswd(this.getMd5(umUser.getUserPwsswd()));
        int result = this.saveUserModel(umUser);
        if (result == 1) {
            return umUser;
        }
        return null;
    }

    @Override
    public void updateUserState(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserModel(userId, dataState, oldDataState);
    }

    @Override
    public void updateUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.checkUser", msg);
        }
        umUserDomainBean.setUserPwsswd(this.getMd5(umUserDomainBean.getUserPwsswd()));
        UmUser oldUmUser = this.getUserModelById(umUserDomainBean.getUserId());
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        this.setUserUpdataDefault(umUser);
        this.updateUserModel(umUser);
    }

    @Override
    public void updateUserByCode(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.checkUser", msg);
        }
        umUserDomainBean.setUserPwsswd(this.getMd5(umUserDomainBean.getUserPwsswd()));
        UmUser oldUmUser = this.getUserModelByCode(umUserDomainBean.getUserCode());
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        this.setUserUpdataDefault(umUser);
        this.updateUserModelByCode(umUser);
    }

    @Override
    public void updateUserRegister(Integer userId, Integer dataState, String memo) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.umUserMapper.updateUserCheck(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.checkUserRegister.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.checkUserRegister.null");
        }
    }

    @Override
    public UmUser getUser(Integer userId) {
        return this.getUserModelById(userId);
    }

    @Override
    public UmUser getUserByCode(String userCode) {
        return this.getUserModelByCode(userCode);
    }

    @Override
    public void deleteUser(Integer userId) throws ApiException {
        List<UmUserattr> umUserattrs;
        UmUser vu = this.getUser(userId);
        this.deleteUserModel(userId);
        UmUserinfo umUserinfo = this.getUserinfoModelByUserCode(vu.getUserCode());
        if (umUserinfo != null) {
            this.deleteByUserCodeModel(vu.getUserCode());
        }
        if (ListUtil.isNotEmpty(umUserattrs = this.queryUmUserattrsByUserCode(vu.getUserCode()))) {
            this.deleteAttrByUserCodeModel(vu.getUserCode());
        }
    }

    @Override
    public QueryResult<UmUser> queryUserPage(Map<String, Object> map) {
        List<UmUser> umUserList = this.queryUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserList);
        return queryResult;
    }

    @Override
    public List<UmUser> queryUserList(Map<String, Object> map) {
        List<UmUser> umUserList = this.queryUserModelPage(map);
        return umUserList;
    }

    @Override
    public int saveUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserinfo.checkUserinfo", msg);
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, null);
        this.setUserinfoDefault(umUserinfo);
        this.saveUserinfoModel(umUserinfo);
        return umUserinfo.getUserinfoId();
    }

    private String saveUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserinfo.checkUserinfo", msg);
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, null);
        this.setUserinfoDefault(umUserinfo);
        this.saveUserinfoModel(umUserinfo);
        return umUserinfo.getUserinfoCode();
    }

    @Override
    public void updateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserinfoModel(userinfoId, dataState, oldDataState);
    }

    @Override
    public void updateUserinfoSync(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        this.updateSyncUserinfoModel(userCode, userinfoTestsync, userinfoProdsync);
    }

    @Override
    public void updateUserinfoFeeStatus(String userCode, Integer userinfoFeeStatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        this.updateFeeUserinfoModel(userCode, userinfoFeeStatus, userinfoFeeEdate, dataState);
    }

    @Override
    public void updateUserinfoRealname(String userCode, String userinfoEdate, Integer dataState) throws ApiException {
        this.updateUserinfoRealnameModel(userCode, userinfoEdate, dataState);
    }

    @Override
    public void updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfo.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(umUserinfoDomainBean.getUserinfoId());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public void updateUserinfoByUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoByUserinfoCode.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelByCode(umUserinfoDomainBean.getUserinfoCode());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoByUserinfoCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public UmUserinfo getUserinfo(Integer userinfoId) {
        return this.getUserinfoModelById(userinfoId);
    }

    @Override
    public UmUserinfo getUserinfoByUserCode(String userCode) {
        return this.getUserinfoModelByUserCode(userCode);
    }

    @Override
    public void deleteUserinfo(Integer userinfoId) throws ApiException {
        this.deleteUserinfoModel(userinfoId);
    }

    @Override
    public QueryResult<UmUserinfo> queryUserinfoPage(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoList);
        return queryResult;
    }

    @Override
    public List<UmUserinfo> queryUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelList(map);
        return umUserinfoList;
    }

    @Override
    public void updateUserPwsswd(int userId, String userPwsswd) throws ApiException {
        if (StringUtils.isBlank((String)userPwsswd)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserPwsswd.", "\u5bc6\u7801\u4e3a\u7a7a");
        }
        UmUser oldUmUser = this.getUserModelById(userId);
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUser.setUserPwsswd(this.getMd5(userPwsswd));
        this.updateUserModel(oldUmUser);
    }

    @Override
    public void updateUserinfoConPhone(int userinfoId, String userinfoConPhone) throws ApiException {
        if (StringUtils.isBlank((String)userinfoConPhone)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoConPhone.", "\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(userinfoId);
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoConPhone.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUserinfo.setUserinfoConPhone(userinfoConPhone);
        this.updateUserinfoModel(oldUmUserinfo);
    }

    @Override
    public UmUser getUserByName(String userName) {
        return this.selectByName(userName);
    }

    public void InvalidateUserinfModel() {
        try {
            List<UmUserinfo> userInfoList = this.umUserinfoMapper.queryInvalidUserinfoList();
            if (CollectionUtils.isNotEmpty(userInfoList)) {
                for (UmUserinfo umUserinfo : userInfoList) {
                    HashMap<String, Object> mapUserinfo = new HashMap<String, Object>();
                    mapUserinfo.put("userinfoId", umUserinfo.getUserinfoId());
                    mapUserinfo.put("dataState", "2");
                    mapUserinfo.put("oldDataState", "1");
                    this.umUserinfoMapper.updateStateByPrimaryKey(mapUserinfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.InvalidateUserinfModel", (Throwable)e);
        }
    }

    private List<UmUserinfo> getUserinfoList(Map<String, Object> map) {
        return this.umUserinfoMapper.queryInvalidUserinfoListWeek(map);
    }

    private void queryInvalidateUserinfoList(Map<String, Object> map) {
        try {
            String mnsExp;
            ArrayList<UmUser> userList = new ArrayList<UmUser>();
            List<UmUserinfo> userinfoList = this.getUserinfoList(map);
            if (CollectionUtils.isNotEmpty(userinfoList)) {
                for (UmUserinfo umUserinfo : userinfoList) {
                    String userCode = umUserinfo.getUserCode();
                    if (!StringUtils.isNotBlank((String)userCode)) continue;
                    userList.add(this.getUserModelByCode(userCode));
                }
            }
            this.logger.debug("um.USER.UserServiceImpl_queryInvalidateUserinfoList", (Object)("list size is-->" + userList.size()));
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "00013", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "00013");
                paramsMap.put("mnslistBusName", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryInvalidateUserinfoList", (Throwable)e);
        }
    }

    private String getMnsExp(List<UmUser> userList, String businessType, String theme) {
        if (CollectionUtils.isEmpty(userList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        for (UmUser umUser : userList) {
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", umUser.getUserCode());
            mapReceiver.put("name", umUser.getUserName());
            mapReceiver.put("email", umUser.getUserEmial());
            mapReceiver.put("telphone", umUser.getUserPhone());
            listReceiver.add(mapReceiver);
        }
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", theme);
        map.put("businessType", businessType);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("proName", "\u7ef4\u91d1SaaS");
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap1));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    @Override
    public void updateInvalidateUserinfo() throws ApiException {
        this.InvalidateUserinfModel();
    }

    @Override
    public void sendMnsInvalidateUserinfo() throws ApiException {
        String openRemindTime = this.getSysParam("OPEN_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        this.queryInvalidateUserinfoList(map);
    }

    @Override
    public void executeOverdueRemind() {
        List<UmUser> userList = this.getOverdueUserList();
        this.logger.debug("um.USER.UserServiceImpl_executeOverdueRemind", (Object)("list size is-->" + userList.size()));
        if (CollectionUtils.isNotEmpty(userList)) {
            this.sendOverdueMns(userList);
        }
    }

    @Override
    public void executeOverdueUpdate() {
        this.updateFeeOverdueStatus();
    }

    private void updateFeeOverdueStatus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", "0");
        map.put("userinfoFeeStatus", "0");
        try {
            this.umUserinfoMapper.updateFeeStatus(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.updateFeeOverdueStatus", (Throwable)e);
        }
    }

    private List<UmUser> getOverdueUserList() {
        String openRemindTime = this.getSysParam("SAAS_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoFeeEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoFeeEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        ArrayList<UmUser> userList = new ArrayList<UmUser>();
        List<UmUserinfo> userinfoList = this.getOverdueUserinfoList(map);
        this.logger.debug("um.USER.UserServiceImpl_getOverdueUserList", (Object)("list size is-->" + userinfoList.size()));
        if (CollectionUtils.isNotEmpty(userinfoList)) {
            for (UmUserinfo umUserinfo : userinfoList) {
                String userCode = umUserinfo.getUserCode();
                this.logger.debug("um.USER.UserServiceImpl_getOverdueUserList", (Object)("userCode is-->" + userCode));
                if (!StringUtils.isNotBlank((String)userCode)) continue;
                userList.add(this.getUserModelByCode(userCode));
            }
        }
        return userList;
    }

    private List<UmUserinfo> getOverdueUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> userinfoList = null;
        try {
            userinfoList = this.umUserinfoMapper.queryOverdueUserinfoList(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getOverdueUserinfoList", (Throwable)e);
        }
        return userinfoList;
    }

    private void sendOverdueMns(List<UmUser> userList) {
        try {
            String mnsExp;
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "10016", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "10016");
                paramsMap.put("mnslistBusName", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.sendOverdueMns", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> queryUmuserCheck(String userName, String password, String appmanageIcode) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        UmUser muser = this.selectByName(userName);
        if (null == muser || !MD5Util.saltMD5Verify((String)password, (String)muser.getUserPwsswd())) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u540d\u6216\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            return result;
        }
        result.put("flag", true);
        result.put("message", JsonUtil.getAllJsonUtil().toJson((Object)muser));
        return result;
    }

    @Override
    public UmUser saveUmuserAll(UmUserDomainBean umUserDomainBean) {
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        umUserinfoDomainBean.setUserinfoFeeStatus(0);
        umUserinfoDomainBean.setTenantCode(umUserDomainBean.getTenantCode());
        String infoCode = this.saveUserinfoCode(umUserinfoDomainBean);
        umUserDomainBean.setUserPcode(infoCode);
        UmUser user = this.saveUser(umUserDomainBean);
        return user;
    }

    private String getMd5(String password) {
        if (StringUtils.isNotBlank((String)password)) {
            return MD5Util.saltMD5((String)password);
        }
        return "";
    }
}

