/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.UserConstants;
import com.yqbsoft.laser.service.user.dao.UmTeamMapper;
import com.yqbsoft.laser.service.user.domain.UmTeamDomain;
import com.yqbsoft.laser.service.user.model.UmGroup;
import com.yqbsoft.laser.service.user.model.UmTeam;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import com.yqbsoft.laser.service.user.service.UmRelationService;
import com.yqbsoft.laser.service.user.service.UmTeamService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class UmTeamServiceImpl
extends BaseServiceImpl
implements UmTeamService {
    public static final String SYS_CODE = "um.USER.UmTeamServiceImpl";
    private static final String roleNameKey = "roleName";
    private static final String roleCodeKey = "roleCode";
    private UmTeamMapper umTeamMapper;
    private UmRelationService umRelationService;
    private UmGroupService umGroupService;

    public void setUmTeamMapper(UmTeamMapper umTeamMapper) {
        this.umTeamMapper = umTeamMapper;
    }

    public void setUmRelationService(UmRelationService umRelationService) {
        this.umRelationService = umRelationService;
    }

    public void setUmGroupService(UmGroupService umGroupService) {
        this.umGroupService = umGroupService;
    }

    private Date getSysDate() {
        try {
            return this.umTeamMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTeam(UmTeamDomain umTeamDomain) {
        if (null == umTeamDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setTeamDefault(UmTeam umTeam) {
        if (null == umTeam) {
            return;
        }
        if (null == umTeam.getDataState()) {
            umTeam.setDataState(0);
        }
        if (null == umTeam.getGmtCreate()) {
            umTeam.setGmtCreate(this.getSysDate());
        }
        umTeam.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umTeam.getTeamCode())) {
            umTeam.setTeamCode(this.createUUIDString());
        }
    }

    private int getTeamMaxCode() {
        int code = 0;
        try {
            return this.umTeamMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTeamUpdataDefault(UmTeam umTeam) {
        if (null == umTeam) {
            return;
        }
        umTeam.setGmtModified(this.getSysDate());
    }

    private void saveTeamModel(UmTeam umTeam) throws ApiException {
        if (null == umTeam) {
            return;
        }
        try {
            this.umTeamMapper.insert(umTeam);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmTeamServiceImpl.saveTeamModel.ex", (Throwable)e);
        }
    }

    private UmTeam getTeamModelById(Integer teamId) {
        if (null == teamId) {
            return null;
        }
        try {
            return this.umTeamMapper.selectByPrimaryKey(teamId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamModelById", (Throwable)e);
            return null;
        }
    }

    public UmTeam getTeamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umTeamMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTeamModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umTeamMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmTeamServiceImpl.delTeamModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmTeamServiceImpl.delTeamModelByCode.num");
        }
    }

    private void deleteTeamModel(Integer teamId) throws ApiException {
        if (null == teamId) {
            return;
        }
        int i = 0;
        try {
            i = this.umTeamMapper.deleteByPrimaryKey(teamId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmTeamServiceImpl.deleteTeamModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmTeamServiceImpl.deleteTeamModel.num");
        }
    }

    private void updateTeamModel(UmTeam umTeam) throws ApiException {
        if (null == umTeam) {
            return;
        }
        try {
            this.umTeamMapper.updateByPrimaryKeySelective(umTeam);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmTeamServiceImpl.updateTeamModel.ex", (Throwable)e);
        }
    }

    private void updateStateTeamModel(Integer teamId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == teamId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("teamId", teamId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umTeamMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmTeamServiceImpl.updateStateTeamModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmTeamServiceImpl.updateStateTeamModel.null");
        }
    }

    private UmTeam makeTeam(UmTeamDomain umTeamDomain, UmTeam umTeam) {
        if (null == umTeamDomain) {
            return null;
        }
        if (null == umTeam) {
            umTeam = new UmTeam();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umTeam, (Object)umTeamDomain);
            return umTeam;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.makeTeam", (Throwable)e);
            return null;
        }
    }

    private List<UmTeam> queryTeamModelPage(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.queryTeamModel", (Throwable)e);
            return null;
        }
    }

    private int countTeam(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umTeamMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.countTeam", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveTeam(UmTeamDomain umTeamDomain) throws ApiException {
        String msg = this.checkTeam(umTeamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmTeamServiceImpl.saveTeam.checkTeam", msg);
        }
        UmTeam umTeam = this.makeTeam(umTeamDomain, null);
        this.setTeamDefault(umTeam);
        this.saveTeamModel(umTeam);
        return umTeam.getTeamCode();
    }

    @Override
    public void updateTeamState(Integer teamId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTeamModel(teamId, dataState, oldDataState);
    }

    @Override
    public void updateTeam(UmTeamDomain umTeamDomain) throws ApiException {
        String msg = this.checkTeam(umTeamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmTeamServiceImpl.updateTeam.checkTeam", msg);
        }
        UmTeam oldUmTeam = this.getTeamModelById(umTeamDomain.getTeamId());
        if (null == oldUmTeam) {
            throw new ApiException("um.USER.UmTeamServiceImpl.updateTeam.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmTeam umTeam = this.makeTeam(umTeamDomain, oldUmTeam);
        this.setTeamUpdataDefault(umTeam);
        this.updateTeamModel(umTeam);
    }

    @Override
    public UmTeam getTeam(Integer teamId) {
        return this.getTeamModelById(teamId);
    }

    @Override
    public void deleteTeam(Integer teamId) throws ApiException {
        this.deleteTeamModel(teamId);
    }

    @Override
    public QueryResult<UmTeam> queryTeamPage(Map<String, Object> map) {
        List<UmTeam> umTeamList = this.queryTeamModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTeam(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umTeamList);
        return queryResult;
    }

    @Override
    public UmTeam getTeamByCode(Map<String, Object> map) {
        return this.getTeamModelByCode(map);
    }

    @Override
    public void delTeamByCode(Map<String, Object> map) throws ApiException {
        this.delTeamModelByCode(map);
    }

    @Override
    public List<Map<String, Object>> queryTeamTypeInfo(Map<String, Object> map) {
        if (map == null || map.get("wrapperRoles") == null) {
            throw new ApiException("um.USER.UmTeamServiceImpl.queryTeamTypeInfo.null", "\u89d2\u8272\u4fe1\u606f\u4e3a\u7a7a");
        }
        List<Map<String, Object>> roles = this.groupByRoleModel(map);
        List<Map<String, Object>> teams = this.getObjOrCountModel(map);
        ArrayList<Map<String, Object>> teamRoles = new ArrayList<Map<String, Object>>();
        Map<String, String> manager = this.getUserInfoByTeamCodeNotRelationModel(map);
        List wrapperRoles = (List)map.get("wrapperRoles");
        if (ListUtil.isEmpty(teams)) {
            HashMap<String, Object> teamTypeObj = new HashMap<String, Object>();
            teamTypeObj.put(roleCodeKey, manager.get(roleCodeKey));
            for (Map role : wrapperRoles) {
                if (!teamTypeObj.get(roleCodeKey).equals(role.get(roleCodeKey))) continue;
                this.getRoleType(role, teamTypeObj);
                if (manager.get(roleCodeKey).equals(role.get(roleCodeKey))) {
                    manager.put(roleNameKey, (String)role.get(roleNameKey));
                    teamTypeObj.put("manager", manager);
                }
                teamTypeObj.put("teamInfos", new ArrayList());
            }
            teamRoles.add(teamTypeObj);
            return teamRoles;
        }
        for (Map<String, Object> teamTypeObj : roles) {
            boolean flag = false;
            for (Map role : wrapperRoles) {
                this.getRoleType(role, teamTypeObj);
                if (!manager.get(roleCodeKey).equals(role.get(roleCodeKey))) continue;
                manager.put(roleNameKey, (String)role.get(roleNameKey));
                teamTypeObj.put("manager", manager);
            }
            ArrayList<Map<String, Object>> teamInfos = new ArrayList<Map<String, Object>>();
            ArrayList<String> notQueryRoleCodes = new ArrayList<String>();
            for (Map<String, Object> map2 : teams) {
                if (UserConstants.RoleEnum.XSZJ.getRoleCode().equals(map2.get(roleCodeKey))) {
                    notQueryRoleCodes.add(UserConstants.RoleEnum.JD.getRoleCode());
                }
                int userCount = this.getSonUserCodeByTeamCode(this.getSonUserCodeParam(map2, notQueryRoleCodes)).size();
                map2.put("userCount", userCount + 1);
                if (!teamTypeObj.get(roleCodeKey).equals(map2.get(roleCodeKey))) continue;
                teamInfos.add(map2);
                flag = true;
            }
            if (!flag) continue;
            teamTypeObj.put("teamInfos", teamInfos);
            teamRoles.add(teamTypeObj);
        }
        return teamRoles;
    }

    private void getRoleType(Map<String, Object> role, Map<String, Object> teamTypeObj) {
        String roleName = (String)role.get(roleNameKey);
        if (teamTypeObj.get(roleCodeKey).equals(role.get(roleCodeKey))) {
            if (role.get(roleCodeKey) != null) {
                if (UserConstants.RoleTeamEnum.XSZJ.getRoleCode().equals(role.get(roleCodeKey))) {
                    roleName = UserConstants.RoleTeamEnum.XSZJ.getRoleName();
                } else if (UserConstants.RoleTeamEnum.XXZJ.getRoleCode().equals(role.get(roleCodeKey))) {
                    roleName = UserConstants.RoleTeamEnum.XXZJ.getRoleName();
                } else if (UserConstants.RoleTeamEnum.XXJL.getRoleCode().equals(role.get(roleCodeKey))) {
                    roleName = UserConstants.RoleTeamEnum.XXJL.getRoleName();
                } else if (UserConstants.RoleTeamEnum.XSJL.getRoleCode().equals(role.get(roleCodeKey))) {
                    roleName = UserConstants.RoleTeamEnum.XSJL.getRoleName();
                }
            }
            teamTypeObj.put(roleNameKey, roleName);
        }
    }

    private Map<String, Object> getSonUserCodeParam(Map<String, Object> map, List<String> notQueryRoleCodes) {
        HashMap<String, Object> param = new HashMap<String, Object>();
        ArrayList<String> inUserCodes = new ArrayList<String>();
        inUserCodes.add((String)map.get("userCode"));
        param.put("queryManager", true);
        param.put("inUserCodes", inUserCodes);
        param.put("tenantCode", map.get("tenantCode"));
        param.put("notQueryRoleCodes", notQueryRoleCodes);
        return param;
    }

    private Map<String, String> getUserInfoByTeamCodeNotRelationModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getUserInfoByTeamCodeNotRelation(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getUserInfoByTeamCodeNotRelationModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getUserInfoByTeamCodeNotRelationModel.ex", (Throwable)e);
        }
    }

    private List<Map<String, Object>> groupByRoleModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.groupByRole(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.groupByRoleModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.groupByRoleModel.ex", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getTeamOrRoleComModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getTeamOrRoleCom(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamOrRoleComModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamOrRoleComModel.ex", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getObjOrCountModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getObjOrCount(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getObjOrCountModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getObjOrCountModel.ex", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> queryTeamConditionPage(Map<String, Object> map) {
        HashMap<String, Object> member = new HashMap<String, Object>();
        List<Map<String, Object>> members = this.getMemberInfoModel(map);
        Map<String, Object> tc = null;
        if (members == null || members.size() == 0) {
            tc = this.getTeamOrCompanyModel(map);
            if (tc != null) {
                member.put("memberCount", 0);
                member.put("teamName", tc.get("teamName"));
                member.put("teamId", tc.get("teamId"));
                member.put("companyName", tc.get("companyName"));
            }
        } else {
            Iterator<Map<String, Object>> i$ = members.iterator();
            if (i$.hasNext()) {
                Map<String, Object> m = i$.next();
                member.put("memberCount", members.size());
                member.put("teamName", m.get("teamName"));
                member.put("teamId", m.get("teamId"));
                member.put("companyName", m.get("companyName"));
            }
        }
        member.put("members", members);
        return member;
    }

    @Override
    public Map<String, Object> queryMyTeamGroup(Map<String, Object> map) {
        boolean queryDefaultTeam = false;
        if (map != null && map.get("queryDefaultTeam") != null) {
            queryDefaultTeam = Boolean.valueOf(String.valueOf(map.get("queryDefaultTeam")));
        }
        HashMap<String, Object> member = new HashMap<String, Object>();
        List<Map<String, Object>> members = this.getMemberInfoModel(map);
        Map<String, Object> tc = null;
        if (ListUtil.isEmpty(members)) {
            tc = this.getTeamOrCompanyModel(map);
            if (tc != null) {
                member.put("memberCount", 0);
                member.put("teamName", tc.get("teamName"));
                member.put("teamId", tc.get("teamId"));
                member.put("companyName", tc.get("companyName"));
                member.put("groups", new ArrayList());
            }
        } else {
            Iterator<Map<String, Object>> i$ = members.iterator();
            if (i$.hasNext()) {
                Map<String, Object> m = i$.next();
                member.put("memberCount", members.size());
                member.put("teamName", m.get("teamName"));
                member.put("teamId", m.get("teamId"));
                member.put("companyName", m.get("companyName"));
            }
            HashMap<String, String> groupMap = new HashMap<String, String>();
            HashMap<String, Object> paramGroup = new HashMap<String, Object>();
            paramGroup.put("teamCode", map.get("teamCode"));
            paramGroup.put("tenantCode", map.get("tenantCode"));
            QueryResult<UmGroup> result = this.umGroupService.queryGroupPage(paramGroup);
            if (result != null && ListUtil.isNotEmpty((Collection)result.getList())) {
                for (UmGroup temp : result.getList()) {
                    groupMap.put(temp.getGroupCode(), temp.getGroupName());
                }
            }
            String relationTypeKey = "relationType";
            List<Map<String, Object>> groups = this.umRelationService.getRelationTypeByTeamCode(map);
            if (ListUtil.isNotEmpty(groups)) {
                if (!queryDefaultTeam) {
                    Iterator<Map<String, Object>> it = groups.iterator();
                    while (it.hasNext()) {
                        Map<String, Object> temp = it.next();
                        if (temp.get("groupCode") != null && !StringUtils.isEmpty((String)String.valueOf(temp.get("groupCode"))) && !"0".equals(String.valueOf(temp.get("groupCode")))) continue;
                        it.remove();
                    }
                }
                for (Map<String, Object> temp : groups) {
                    String groupCode = String.valueOf(temp.get("groupCode"));
                    String relationType = String.valueOf(temp.get(relationTypeKey));
                    ArrayList<Map<String, Object>> groupMembers = new ArrayList<Map<String, Object>>();
                    if (temp.get("groupCode") != null && !"0".equals(temp.get("groupCode")) && !MapUtil.isEmpty(groupMap)) {
                        temp.put("groupName", groupMap.get(groupCode));
                    } else {
                        temp.put("groupName", "\u6211\u7684\u56e2\u961f");
                    }
                    for (Map<String, Object> memberTemp : members) {
                        if (!relationType.equals(memberTemp.get(relationTypeKey))) continue;
                        memberTemp.remove("userId");
                        memberTemp.remove("teamId");
                        memberTemp.remove("companyCode");
                        memberTemp.remove("companyName");
                        memberTemp.remove("teamName");
                        groupMembers.add(memberTemp);
                    }
                    temp.put("members", groupMembers);
                }
            }
            member.put("groups", groups);
        }
        return member;
    }

    @Override
    public Map<String, Object> queryTeamAllPerson(Map<String, Object> map) {
        HashMap<String, Object> member = new HashMap<String, Object>();
        List<Map<String, Object>> members = this.getTeamAllPersonModel(map);
        Map<String, Object> tc = null;
        if (members == null || members.size() == 0) {
            tc = this.getTeamOrCompanyModel(map);
            if (tc != null) {
                member.put("memberCount", 0);
                member.put("teamName", tc.get("teamName"));
                member.put("teamId", tc.get("teamId"));
                member.put("companyName", tc.get("companyName"));
            }
        } else {
            Iterator<Map<String, Object>> i$ = members.iterator();
            if (i$.hasNext()) {
                Map<String, Object> m = i$.next();
                member.put("memberCount", members.size());
                member.put("teamName", m.get("teamName"));
                member.put("teamId", m.get("teamId"));
                member.put("companyName", m.get("companyName"));
            }
        }
        member.put("members", members);
        return member;
    }

    @Override
    public List<Map<String, Object>> queryTeamsPersons(Map<String, Object> map) {
        ArrayList<Map<String, Object>> retMaps = new ArrayList<Map<String, Object>>();
        List<Map<String, Object>> members = this.getTeamsPersonsModel(map);
        if (members != null && members.size() >= 0) {
            boolean flag = false;
            for (Map<String, Object> m : members) {
                for (Map map2 : retMaps) {
                    if (!m.get("teamId").equals(map2.get("teamId"))) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                HashMap<String, Object> retMap = new HashMap<String, Object>();
                retMap.put("teamName", m.get("teamName"));
                retMap.put("teamId", m.get("teamId"));
                retMap.put("companyName", m.get("companyName"));
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                for (Map<String, Object> map2 : members) {
                    if (!m.get("teamId").equals(map2.get("teamId"))) continue;
                    arrayList.add(map2);
                }
                retMap.put("memberCount", arrayList.size());
                retMap.put("member", arrayList);
                retMaps.add(retMap);
            }
        }
        return retMaps;
    }

    private List<Map<String, Object>> getTeamsPersonsModel(Map<String, Object> map) {
        try {
            return this.umTeamMapper.getTeamsPersons(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamsPersonsModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamsPersonsModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> queryTeamByUser(Map<String, Object> map) {
        List<Map<String, Object>> teams;
        if (map == null) {
            return null;
        }
        if ((map.get("queryParentTeam") == null || "".equals(map.get("queryParentTeam"))) && map.get("userCode") != null && !"".equals(map.get("userCode")) && (teams = this.umTeamMapper.getTeamByUserCode(map)) != null && teams.size() > 0) {
            return teams;
        }
        return this.getMemberInfoModel(map);
    }

    private List<Map<String, Object>> getTeamAllPersonModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getTeamAllPerson(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamAllPersonModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamAllPersonModel.ex", (Throwable)e);
        }
    }

    private List<Map<String, Object>> getMemberInfoModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getMemberInfo(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getMemberInfoModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getMemberInfoModel.ex", (Throwable)e);
        }
    }

    private Map<String, Object> getTeamOrCompanyModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getTeamOrCompany(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamOrCompanyModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamOrCompanyModel.ex", "");
        }
    }

    @Override
    public List<Map<String, Object>> queryTeamAndMember(Map<String, Object> map) {
        List<Map<String, Object>> members = this.getMemberInfoModel(map);
        List<Map<String, Object>> roles = this.getTeamOrRoleComModel(map);
        ArrayList<Map<String, Object>> teamMembers = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> role : roles) {
            HashMap<String, Object> member = new HashMap<String, Object>();
            ArrayList<Map<String, Object>> ms = new ArrayList<Map<String, Object>>();
            int memNum = 0;
            for (Map<String, Object> m : members) {
                if (!role.get("teamCode").equals(m.get("teamCode"))) continue;
                ++memNum;
                ms.add(m);
            }
            if (memNum <= 0) continue;
            member.put("memberCount", memNum);
            member.put("teamName", role.get("teamName"));
            member.put("teamId", role.get("teamId"));
            member.put("companyCode", role.get("companyName"));
            member.put("member", ms);
            teamMembers.add(member);
        }
        return teamMembers;
    }

    @Override
    public String getTeamCodeByPhone(Map<String, Object> map) {
        String teamCode = this.getTeamCodeByCondModel(map);
        return teamCode;
    }

    private String getTeamCodeByCondModel(Map<String, Object> parameters) {
        if (parameters != null && (parameters.get("userCode") == null || "".equals(parameters.get("userCode"))) && (parameters.get("userPhone") == null || "".equals(parameters.get("userPhone")))) {
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamCodeByCondModel.ex", "\u8bf7\u4f20\u5165\u7528\u6237\u4ee3\u7801\u6216\u624b\u673a\u53f7");
        }
        try {
            String teamCode = "";
            List<Map<String, Object>> teams = this.umTeamMapper.getTeamByUserCode(parameters);
            if (teams != null && teams.size() > 0) {
                UmTeam ut = (UmTeam)((Object)teams.get(0));
                teamCode = ut.getTeamCode();
            } else {
                teamCode = this.umTeamMapper.getTeamCodeByCond(parameters);
            }
            return teamCode;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getTeamCodeByPhoneModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getTeamCodeByPhoneModel.ex", "\u83b7\u53d6\u56e2\u961f\u5f02\u5e38");
        }
    }

    @Override
    public UmTeam saveInitTeam(UmTeamDomain umTeamDomain) throws ApiException {
        String msg = this.checkTeam(umTeamDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmTeamServiceImpl.saveInitTeam.checkTeam", msg);
        }
        UmTeam umTeam = this.makeTeam(umTeamDomain, null);
        this.setTeamDefault(umTeam);
        this.saveTeamModel(umTeam);
        return umTeam;
    }

    @Override
    public List<String> getUserCodeByTeamCode(Map<String, Object> parameters) {
        List<String> userCodes = this.getUserCodeByTeamCodeModel(parameters);
        return userCodes;
    }

    private List<String> getUserCodeByTeamCodeModel(Map<String, Object> parammap) {
        try {
            return this.umTeamMapper.getUserCodeByTeamCode(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getUserCodeByTeamCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getUserCodeByTeamCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<String> getSonTeamCodeByTeamCode(Map<String, Object> map) {
        List<String> teamCodes = this.getSonTeamCodeByTeamCodeModel(map);
        return teamCodes;
    }

    private List<String> getSonTeamCodeByTeamCodeModel(Map<String, Object> map) {
        try {
            return this.umTeamMapper.getSonTeamCodeByTeamCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getSonTeamCodeByTeamCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getSonTeamCodeByTeamCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<String> getSonUserCodeByTeamCode(Map<String, Object> map) {
        if (map == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> userCodes = new ArrayList<String>();
        return this.loopGetSonUserCode(map, userCodes);
    }

    private List<String> loopGetSonUserCode(Map<String, Object> map, List<String> userCodes) {
        ArrayList<String> inUserCodes = new ArrayList<String>();
        List<Map<String, Object>> userInfos = this.getSonUserCodeByTeamCodeModel(map);
        if (userInfos != null && userInfos.size() > 0) {
            if (map.get("queryManager") != null && ((Boolean)map.get("queryManager")).booleanValue()) {
                for (Map<String, Object> user : userInfos) {
                    userCodes.add((String)user.get("userCode"));
                    inUserCodes.add((String)user.get("userCode"));
                }
            } else {
                for (Map<String, Object> user : userInfos) {
                    long hasSon = (Long)user.get("hasSon");
                    if (hasSon == 0L) {
                        userCodes.add((String)user.get("userCode"));
                    }
                    inUserCodes.add((String)user.get("userCode"));
                }
            }
            if (inUserCodes.size() == 0) {
                return userCodes;
            }
            map.put("inUserCodes", inUserCodes);
            return this.loopGetSonUserCode(map, userCodes);
        }
        return userCodes;
    }

    private List<Map<String, Object>> getSonUserCodeByTeamCodeModel(Map<String, Object> map) {
        try {
            return this.umTeamMapper.getSonUserCodeByTeamCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.getSonUserCodeByTeamCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UmTeamServiceImpl.getSonUserCodeByTeamCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<Map<String, Object>> querySonTeamsByTeamCode(Map<String, Object> map) {
        return null;
    }

    @Override
    public List<Map<String, Object>> queryPersonTeamByParam(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        List<Map<String, Object>> queryPersonTeamByParamModel = this.queryPersonTeamByParamModel(map);
        return queryPersonTeamByParamModel;
    }

    private List<Map<String, Object>> queryPersonTeamByParamModel(Map<String, Object> map) {
        try {
            return this.umTeamMapper.queryPersonTeamByParam(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmTeamServiceImpl.queryPersonTeamByParamModel", (Throwable)e);
            return null;
        }
    }
}

