/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmGroupMapper;
import com.yqbsoft.laser.service.user.domain.UmGroupDomain;
import com.yqbsoft.laser.service.user.model.UmGroup;
import com.yqbsoft.laser.service.user.model.UmRelation;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import com.yqbsoft.laser.service.user.service.UmRelationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmGroupServiceImpl
extends BaseServiceImpl
implements UmGroupService {
    public static final String SYS_CODE = "um.USER.UmGroupServiceImpl";
    private UmGroupMapper umGroupMapper;
    private UmRelationService umRelationService;

    public void setUmGroupMapper(UmGroupMapper umGroupMapper) {
        this.umGroupMapper = umGroupMapper;
    }

    public void setUmRelationService(UmRelationService umRelationService) {
        this.umRelationService = umRelationService;
    }

    private Date getSysDate() {
        try {
            return this.umGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGroup(UmGroupDomain umGroupDomain) {
        if (null == umGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setGroupDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        if (null == umGroup.getDataState()) {
            umGroup.setDataState(0);
        }
        if (null == umGroup.getGmtCreate()) {
            umGroup.setGmtCreate(this.getSysDate());
        }
        umGroup.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umGroup.getGroupCode())) {
            umGroup.setGroupCode(this.createUUIDString());
        }
    }

    private int getGroupMaxCode() {
        int code = 0;
        try {
            return this.umGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupUpdataDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        umGroup.setGmtModified(this.getSysDate());
    }

    private void saveGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        try {
            this.umGroupMapper.insert(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupModel.ex", (Throwable)e);
        }
    }

    private UmGroup getGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.umGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelById", (Throwable)e);
            return null;
        }
    }

    public UmGroup getGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    public int delGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return 0;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.num");
        }
        return i;
    }

    private void deleteGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.num");
        }
    }

    private void updateGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        try {
            this.umGroupMapper.updateByPrimaryKeySelective(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupModel.ex", (Throwable)e);
        }
    }

    private void updateStateGroupModel(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.null");
        }
    }

    private UmGroup makeGroup(UmGroupDomain umGroupDomain, UmGroup umGroup) {
        if (null == umGroupDomain) {
            return null;
        }
        if (null == umGroup) {
            umGroup = new UmGroup();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umGroup, (Object)umGroupDomain);
            return umGroup;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroup", (Throwable)e);
            return null;
        }
    }

    private List<UmGroup> queryGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroup", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveGroup(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroup.checkGroup", msg);
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, null);
        this.setGroupDefault(umGroup);
        this.saveGroupModel(umGroup);
        return umGroup.getGroupCode();
    }

    @Override
    public void updateGroupState(Integer groupId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateGroupModel(groupId, dataState, oldDataState);
    }

    @Override
    public void updateGroup(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.checkGroup", msg);
        }
        UmGroup oldUmGroup = this.getGroupModelById(umGroupDomain.getGroupId());
        if (null == oldUmGroup) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, oldUmGroup);
        this.setGroupUpdataDefault(umGroup);
        this.updateGroupModel(umGroup);
    }

    @Override
    public UmGroup getGroup(Integer groupId) {
        return this.getGroupModelById(groupId);
    }

    @Override
    public void deleteGroup(Integer groupId) throws ApiException {
        this.deleteGroupModel(groupId);
    }

    @Override
    public QueryResult<UmGroup> queryGroupPage(Map<String, Object> map) {
        List<UmGroup> umGroupList = this.queryGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupList);
        return queryResult;
    }

    @Override
    public UmGroup getGroupByCode(Map<String, Object> map) {
        return this.getGroupModelByCode(map);
    }

    @Override
    public void delGroupByCode(Map<String, Object> map) throws ApiException {
        this.delGroupModelByCode(map);
    }

    @Override
    public String saveGroupAddRelation(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupAddRelation.checkGroup", msg);
        }
        List<String> userCodes = umGroupDomain.getUserCodes();
        if (ListUtil.isNotEmpty(userCodes)) {
            List<UmRelation> list = this.queryUmRelation(userCodes, umGroupDomain.getTenantCode(), null, true);
            for (UmRelation umRelation : list) {
                if (StringUtils.isEmpty((String)umRelation.getRelationBillno2())) continue;
                throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupRelation", "\u65b0\u6dfb\u52a0\u7684\u67d0\u4e9b\u6210\u5458\u5df2\u5b58\u5728\u5c0f\u7ec4,\u64cd\u4f5c\u5931\u8d25");
            }
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, null);
        this.setGroupDefault(umGroup);
        this.updateRelationInfo(umGroupDomain.getUserCodes(), umGroup.getGroupCode(), umGroupDomain.getTenantCode(), "2");
        this.saveGroupModel(umGroup);
        return umGroup.getGroupCode();
    }

    @Override
    public boolean updateGroupRelation(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupRelation.checkGroup", msg);
        }
        HashMap<String, Object> getGroupParam = new HashMap<String, Object>();
        getGroupParam.put("groupCode", umGroupDomain.getGroupCode());
        getGroupParam.put("tenantCode", umGroupDomain.getTenantCode());
        UmGroup oldUmGroup = this.getGroupModelByCode(getGroupParam);
        if (null == oldUmGroup) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupRelation.null", "\u672a\u83b7\u53d6\u5230\u5c0f\u7ec4\u4fe1\u606f");
        }
        List<String> userCodes = umGroupDomain.getUserCodes();
        if (ListUtil.isNotEmpty(userCodes)) {
            List<UmRelation> list = this.queryUmRelation(userCodes, umGroupDomain.getTenantCode(), umGroupDomain.getGroupCode(), false);
            if ("2".equals(umGroupDomain.getRelationType())) {
                if (ListUtil.isNotEmpty(list) && list.size() > 0) {
                    throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupRelation", "\u65b0\u6dfb\u52a0\u7684\u67d0\u4e9b\u6210\u5458\u5df2\u5b58\u5728\u5c0f\u7ec4,\u64cd\u4f5c\u5931\u8d25");
                }
                this.updateRelationInfo(umGroupDomain.getUserCodes(), umGroupDomain.getGroupCode(), umGroupDomain.getTenantCode(), umGroupDomain.getRelationType());
            } else if ("1".equals(umGroupDomain.getRelationType())) {
                if (ListUtil.isEmpty(list) || list.size() != userCodes.size()) {
                    throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupRelation", "\u672a\u627e\u5230\u6210\u5458\u7684\u5206\u7ec4,\u64cd\u4f5c\u5931\u8d25");
                }
                this.updateRelationInfo(umGroupDomain.getUserCodes(), null, umGroupDomain.getTenantCode(), umGroupDomain.getRelationType());
                boolean hasExists = this.hasOtherMember(umGroupDomain.getTenantCode(), umGroupDomain.getGroupCode());
                if (hasExists) {
                    HashMap<String, Object> delmap = new HashMap<String, Object>();
                    delmap.put("tenantCode", umGroupDomain.getTenantCode());
                    delmap.put("groupCode", umGroupDomain.getGroupCode());
                    this.delGroupByCode(delmap);
                }
            }
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, oldUmGroup);
        this.setGroupUpdataDefault(umGroup);
        this.updateGroupModel(umGroup);
        return true;
    }

    @Override
    public boolean deleteGroupUpdateRelation(String groupCode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupCode", groupCode);
        map.put("tenantCode", tenantCode);
        int i = this.delGroupModelByCode(map);
        if (i > 0) {
            List<UmRelation> list = this.queryUmRelation(null, tenantCode, groupCode, false);
            if (ListUtil.isNotEmpty(list)) {
                ArrayList<String> userCodes = new ArrayList<String>();
                for (UmRelation umRelation : list) {
                    userCodes.add(umRelation.getUserCode());
                }
                if (ListUtil.isNotEmpty(userCodes)) {
                    this.updateRelationInfo(userCodes, "", tenantCode, "1");
                    return true;
                }
                this.logger.info("um.USER.UmGroupServiceImpl.deleteGroupUpdateRelation", (Object)("\u67e5\u8be2\u8be5\u5c0f\u7ec4\u7684\u7528\u6237\u6570\u4e3a0\uff1a" + groupCode));
                throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupUpdateRelation", "\u67e5\u8be2\u8be5\u5c0f\u7ec4\u7684\u7528\u6237\u6570\u4e3a0\uff0c\u5220\u9664\u5931\u8d25");
            }
        } else {
            this.logger.info("um.USER.UmGroupServiceImpl.deleteGroupUpdateRelation", (Object)("\u5220\u9664\u5206\u7ec4\u5931\u8d25\uff1a" + groupCode));
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupUpdateRelation", "\u5220\u9664\u5206\u7ec4\u5931\u8d25\uff1a");
        }
        throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupUpdateRelation", "\u5220\u9664\u5206\u7ec4\u5931\u8d25\uff1a");
    }

    private List<UmRelation> queryUmRelation(List<String> userCodes, String tenantCode, String groupCode, boolean notGroupCode) {
        QueryResult<UmRelation> result;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        if (notGroupCode) {
            if (!StringUtils.isEmpty((String)groupCode)) {
                map.put("relationBillno2", groupCode);
            }
        } else {
            map.put("relationBillno2", groupCode);
        }
        if (ListUtil.isNotEmpty(userCodes)) {
            map.put("userCodes", userCodes);
        }
        if ((result = this.umRelationService.queryRelationPage(map)) != null) {
            List list = result.getList();
            return list;
        }
        return null;
    }

    private int updateRelationInfo(List<String> userCodes, String groupCode, String tenantCode, String relationType) {
        int index = 0;
        if (ListUtil.isEmpty(userCodes)) {
            this.logger.info("um.USER.UmGroupServiceImpl.updateRelationInfo", (Object)"\u672a\u4f20\u5165\u4fee\u6539\u5173\u8054\u8868\u7528\u6237\uff0c\u4ec5\u4fee\u6539group\u8868\u4fe1\u606f");
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userCodes", userCodes);
            if (!StringUtils.isEmpty((String)groupCode)) {
                map.put("relationBillno2", groupCode);
            }
            map.put("relationType", relationType);
            map.put("tenantCode", tenantCode);
            index = this.umRelationService.updateRelationGroup(map);
            this.logger.info("um.USER.UmGroupServiceImpl.updateRelationInfo", (Object)("\u65b0\u589e\u5c0f\u7ec4\u66f4\u65b0\u7528\u6237\u4fe1\u606f\u5f71\u54cd\u884c\u6570\uff1a" + index));
        }
        return index;
    }

    @Override
    public List<Map<String, Object>> queryGroupMemberCount(Map<String, Object> map) {
        List<Map<String, Object>> list = this.queryGroupMemberCountModel(map);
        return list;
    }

    private List<Map<String, Object>> queryGroupMemberCountModel(Map<String, Object> map) {
        try {
            return this.umGroupMapper.queryGroupMemberCount(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupMemberCountModel", (Throwable)e);
            return null;
        }
    }

    private boolean hasOtherMember(String tenantCode, String groupCode) {
        List<UmRelation> otherMembers = this.queryUmRelation(null, tenantCode, groupCode, false);
        return ListUtil.isEmpty(otherMembers) || otherMembers.size() == 0;
    }
}

