/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.adapter.kafka.KafkaProducerUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.PhoneFormatCheckUtils;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.UserConstants;
import com.yqbsoft.laser.service.user.dao.UmUserMapper;
import com.yqbsoft.laser.service.user.dao.UmUserattrMapper;
import com.yqbsoft.laser.service.user.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.user.domain.MerberType;
import com.yqbsoft.laser.service.user.domain.UmRelationDomain;
import com.yqbsoft.laser.service.user.domain.UmTeamDomain;
import com.yqbsoft.laser.service.user.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.user.domain.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.user.model.TmTenant;
import com.yqbsoft.laser.service.user.model.UmGroup;
import com.yqbsoft.laser.service.user.model.UmRelation;
import com.yqbsoft.laser.service.user.model.UmTeam;
import com.yqbsoft.laser.service.user.model.UmUser;
import com.yqbsoft.laser.service.user.model.UmUserattr;
import com.yqbsoft.laser.service.user.model.UmUserinfo;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import com.yqbsoft.laser.service.user.service.UmRelationService;
import com.yqbsoft.laser.service.user.service.UmTeamService;
import com.yqbsoft.laser.service.user.service.UserService;
import com.yqbsoft.laser.service.user.service.impl.UserinfoPollThread;
import com.yqbsoft.laser.service.user.service.impl.UserinfoService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;

public class UserServiceImpl
extends BaseServiceImpl
implements UserService {
    public static final String SYS_CODE = "um.USER.UserServiceImpl";
    private UmUserMapper umUserMapper;
    private UmUserinfoMapper umUserinfoMapper;
    private UmUserattrMapper umUserattrMapper;
    private UmTeamService umTeamService;
    private UmRelationService umRelationService;
    private UmGroupService umGroupService;
    private static UserinfoService userinfoService;
    private static Object lock;

    public void setUmTeamService(UmTeamService umTeamService) {
        this.umTeamService = umTeamService;
    }

    public void setUmRelationService(UmRelationService umRelationService) {
        this.umRelationService = umRelationService;
    }

    public void setUmUserattrMapper(UmUserattrMapper umUserattrMapper) {
        this.umUserattrMapper = umUserattrMapper;
    }

    public void setUmUserMapper(UmUserMapper umUserMapper) {
        this.umUserMapper = umUserMapper;
    }

    public void setUmUserinfoMapper(UmUserinfoMapper umUserinfoMapper) {
        this.umUserinfoMapper = umUserinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUser(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (!StringUtils.isNotBlank((String)umUserDomainBean.getTenantCode())) {
            msg = msg + "TenantCode;";
        }
        if (!StringUtils.isNotBlank((String)umUserDomainBean.getUserPcode())) {
            msg = msg + "UserPcode;";
        }
        return msg;
    }

    private void setUserDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
        if (null == umUser.getDataState()) {
            umUser.setDataState(0);
        }
        if (null == umUser.getGmtCreate()) {
            umUser.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isNotBlank((String)umUser.getUserEmial())) {
            String verifyTime = this.getSysParam("OPEN_VERIFY_TIME", umUser.getTenantCode(), "00");
            if (null != verifyTime) {
                umUser.setGmtValid(this.getGmtValid(Integer.parseInt(verifyTime)));
            }
            umUser.setGmtValid(this.getGmtValid(2));
        }
        if (StringUtils.isBlank((String)umUser.getUserCode())) {
            int code = this.getMaxCode();
            umUser.setUserCode(this.makeMaxCode8(++code));
        }
        if ("0".equals(String.valueOf(umUser.getUserType())) && StringUtils.isBlank((String)umUser.getUserPcode())) {
            umUser.setUserPcode(umUser.getUserCode());
        }
    }

    private Date getGmtValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(11, validTime);
        return dar.getTime();
    }

    private Date getDayValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(5, validTime);
        return dar.getTime();
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.umUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserUpdataDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
    }

    private int saveUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserModel.ex");
        }
        try {
            return this.umUserMapper.insert(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserModel.ex", (Throwable)e);
        }
    }

    private void updateUserModelByCode(String memo, String userCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memo", memo);
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.umUserMapper.updateUserByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModelByCode.i");
        }
    }

    private UmUser getUserModelById(Integer userId) {
        if (null == userId) {
            return null;
        }
        try {
            return this.umUserMapper.selectByPrimaryKey(userId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private UmUser getUserModelByCode(String userCode) {
        if (null == userCode) {
            return null;
        }
        try {
            return this.umUserMapper.selectByCode(userCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    @Override
    public UmUser getUserByUserCode(String userCode, String tenantCode) {
        if (null == userCode) {
            return null;
        }
        try {
            return this.umUserMapper.selectByUserCode(userCode, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteUserModel(Integer userId) throws ApiException {
        if (null == userId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserMapper.deleteByPrimaryKey(userId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserModel.num");
        }
    }

    private int updateUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return 0;
        }
        try {
            return this.umUserMapper.updateByPrimaryKeySelective(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModel.ex");
        }
    }

    private void updateUserModelByCode(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return;
        }
        try {
            this.umUserMapper.updateByCode(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserModel.ex");
        }
    }

    private void updateStateUserModel(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserModel.null");
        }
    }

    private UmUser makeUser(UmUserDomainBean umUserDomainBean, UmUser umUser) {
        if (null == umUserDomainBean) {
            return null;
        }
        if (null == umUser) {
            umUser = new UmUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUser, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.makeUser", (Throwable)e);
        }
        return umUser;
    }

    private List<UmUser> queryUserModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserModel", (Throwable)e);
            return null;
        }
    }

    private int countUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    private String checkUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setUserinfoDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
        if (null == umUserinfo.getDataState()) {
            umUserinfo.setDataState(0);
        }
        if (null == umUserinfo.getUserinfoType()) {
            umUserinfo.setUserinfoType(1);
        }
        if (null == umUserinfo.getUserinfoState()) {
            umUserinfo.setUserinfoState(0);
        }
        if (null == umUserinfo.getGmtCreate()) {
            umUserinfo.setGmtCreate(this.getSysDate());
        }
        if (null == umUserinfo.getAreaCode()) {
            umUserinfo.setAreaCode("0021");
        }
        if (umUserinfo.getAreaCode().length() < 4) {
            Long l = Long.valueOf(umUserinfo.getAreaCode());
            String no = String.format("%04d", l);
            umUserinfo.setAreaCode(no);
        } else if (umUserinfo.getAreaCode().length() > 4) {
            String area = umUserinfo.getAreaCode();
            Long l = Long.valueOf(area.substring(0, 4));
            String no = String.format("%04d", l);
            umUserinfo.setAreaCode(no);
        }
        umUserinfo.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoCode())) {
            String userinfoCode = this.getUserinfoCode(umUserinfo);
            umUserinfo.setUserinfoCode(userinfoCode);
        }
    }

    private String getUserinfoCode(UmUserinfo umUserinfo) {
        String userinfoCode = "";
        userinfoCode = userinfoCode + umUserinfo.getUserinfoType();
        userinfoCode = userinfoCode + umUserinfo.getAreaCode();
        String[] params = UserConstants.PARAMS_NO;
        userinfoCode = userinfoCode + this.getNo(params[0], params[1], params[2], params[3]);
        userinfoCode = userinfoCode + RandomUtils.generateRandom((int)1, (Integer)0);
        return userinfoCode;
    }

    public int getMaxUserinfoCode() {
        int code = 0;
        try {
            return this.umUserinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserinfoUpdataDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
    }

    private int saveUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return 0;
        }
        try {
            return this.umUserinfoMapper.insert(umUserinfo);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserinfoModel.ex", (Throwable)e);
        }
    }

    private UmUserinfo getUserinfoModelById(Integer userinfoId) {
        if (null == userinfoId) {
            return null;
        }
        try {
            return this.umUserinfoMapper.selectByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelById", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo getUserinfoModelByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            List<UmUserinfo> list = this.umUserinfoMapper.query(map);
            if (null == list || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByName(String userName, String tenantCode) {
        if (null == userName) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByName(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.selectByName", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByPhone(String userPhone, String tenantCode) {
        if (null == userPhone) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPhone", userPhone);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.selectByPhone", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo getUserinfoModelByUserCode(String userinfoCode, String tenantCode) {
        if (null == userinfoCode) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoModelByUserCode", (Throwable)e);
            return null;
        }
    }

    private void deleteUserinfoModel(Integer userinfoId) throws ApiException {
        if (null == userinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.deleteByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.num");
        }
    }

    private void deleteByUserCodeModel(String userCode) throws ApiException {
        if (null == userCode) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.deleteByUserCode(userCode);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserinfoModel.num");
        }
    }

    private List<UmUserattr> queryUmUserattrsByUserCode(String userCode) {
        try {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("userCode", userCode);
            return this.umUserattrMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserattrModel", (Throwable)e);
            return null;
        }
    }

    private void deleteAttrByUserCodeModel(String userCode) throws ApiException {
        if (null == userCode) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserattrMapper.deleteByUserCode(userCode);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserattrModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserServiceImpl.deleteUserattrModel.num");
        }
    }

    private void updateUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return;
        }
        try {
            this.umUserinfoMapper.updateByPrimaryKeySelective(umUserinfo);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoModel.ex");
        }
    }

    private void updateStateUserinfoModel(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateSyncUserinfoModel(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoTestsync", userinfoTestsync);
        map.put("userinfoProdsync", userinfoProdsync);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateSyncByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateFeeUserinfoModel(String userCode, Integer userinfoFeestatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoFeestatus", userinfoFeestatus);
        map.put("userinfoFeeEdate", DateUtil.getDateToString((String)userinfoFeeEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserServiceImpl.updateFeeUserinfoModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateFeeByUserCode(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserServiceImpl.updateFeeUserinfoModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserServiceImpl.updateFeeUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateUserinfoRealnameModel(String userinfoCode, String userinfoEdate, Integer dataState) throws ApiException {
        if (null == userinfoCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("userinfoEdate", DateUtil.getDateToString((String)userinfoEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserServiceImpl.updateUserinfoRealnameModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateUserinfoRealname(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserServiceImpl.updateUserinfoRealnameModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoRealnameModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoRealnameModel.null");
        }
    }

    private UmUserinfo makeUserinfo(UmUserinfoDomainBean umUserinfoDomainBean, UmUserinfo umUserinfo) {
        if (null == umUserinfoDomainBean) {
            return null;
        }
        if (null == umUserinfo) {
            umUserinfo = new UmUserinfo();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)umUserinfoDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.makeUserinfo", (Throwable)e);
        }
        return umUserinfo;
    }

    private List<UmUserinfo> queryUserinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfo> queryUserinfoModelList(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.queryUserinfoList(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countUserinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.countUserinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public UmUser saveUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.saveUser.checkUser", msg);
        }
        UmUser umUser = this.makeUser(umUserDomainBean, null);
        this.setUserDefault(umUser);
        String old = umUser.getUserPwsswd();
        umUser.setUserPwsswd(this.getMd5(umUser.getUserPwsswd()));
        int result = this.saveUserModel(umUser);
        if (result == 1) {
            umUser.setUserPwsswd(old);
            return umUser;
        }
        return null;
    }

    @Override
    public void updateUserState(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserModel(userId, dataState, oldDataState);
    }

    @Override
    public void updateUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.checkUser", msg);
        }
        UmUser oldUmUser = this.getUserModelById(umUserDomainBean.getUserId());
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        this.setUserUpdataDefault(umUser);
        this.updateUserModel(umUser);
    }

    @Override
    public void updateUserByCode(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.checkUser", msg);
        }
        umUserDomainBean.setUserPwsswd(this.getMd5(umUserDomainBean.getUserPwsswd()));
        UmUser oldUmUser = this.getUserModelByCode(umUserDomainBean.getUserCode());
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        this.setUserUpdataDefault(umUser);
        this.updateUserModelByCode(umUser);
    }

    @Override
    public void updateUserRegister(Integer userId, Integer dataState, String memo) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.umUserMapper.updateUserCheck(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.checkUserRegister.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.checkUserRegister.null");
        }
    }

    @Override
    public UmUser getUser(Integer userId) {
        return this.getUserModelById(userId);
    }

    @Override
    public UmUser getUserByCode(String userCode) {
        return this.getUserModelByCode(userCode);
    }

    @Override
    public UmUser getUserByUnique(UmUser umUserSearch) {
        try {
            Objects.requireNonNull(umUserSearch);
            return this.umUserMapper.getUserByUnqiue(umUserSearch);
        }
        catch (Exception e) {
            this.logger.error("getUserByUnique.ERROR", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteUser(Integer userId) throws ApiException {
        List<UmUserattr> umUserattrs;
        UmUser vu = this.getUser(userId);
        this.deleteUserModel(userId);
        UmUserinfo umUserinfo = this.getUserinfoModelByUserCode(vu.getUserPcode(), vu.getTenantCode());
        if (umUserinfo != null) {
            this.deleteByUserCodeModel(vu.getUserCode());
        }
        if (ListUtil.isNotEmpty(umUserattrs = this.queryUmUserattrsByUserCode(vu.getUserPcode()))) {
            this.deleteAttrByUserCodeModel(vu.getUserCode());
        }
    }

    @Override
    public QueryResult<UmUser> queryUserPage(Map<String, Object> map) {
        List<UmUser> umUserList = this.queryUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserList);
        return queryResult;
    }

    @Override
    public List<UmUser> queryUserList(Map<String, Object> map) {
        return this.queryUserModelPage(map);
    }

    @Override
    public String saveUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        return this.saveUserinfoCode(umUserinfoDomainBean);
    }

    private String saveUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        UmUserinfo umUserinfo = this.saveUserinfoReModel(umUserinfoDomainBean);
        return umUserinfo.getUserinfoCode();
    }

    private UmUserinfo saveUserinfoReModel(UmUserinfoDomainBean umUserinfoDomainBean) {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.saveUserinfo.checkUserinfo", msg);
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, null);
        this.setUserinfoDefault(umUserinfo);
        this.saveUserinfoModel(umUserinfo);
        return umUserinfo;
    }

    @Override
    public void updateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserinfoModel(userinfoId, dataState, oldDataState);
    }

    @Override
    public void updateUserinfoSync(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        this.updateSyncUserinfoModel(userCode, userinfoTestsync, userinfoProdsync);
    }

    @Override
    public void updateUserinfoFeeStatus(String userCode, Integer userinfoFeeStatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        this.updateFeeUserinfoModel(userCode, userinfoFeeStatus, userinfoFeeEdate, dataState);
    }

    @Override
    public void updateUserinfoRealname(String userinfoCode, String userinfoEdate, Integer dataState) throws ApiException {
        this.updateUserinfoRealnameModel(userinfoCode, userinfoEdate, dataState);
    }

    @Override
    public void updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfo.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(umUserinfoDomainBean.getUserinfoId());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public void updateUserinfoByUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoByUserinfoCode.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelByCode(umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getTenantCode());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoByUserinfoCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public UmUserinfo getUserinfo(Integer userinfoId) {
        return this.getUserinfoModelById(userinfoId);
    }

    @Override
    public UmUserinfo getUserinfoByUserCode(String userinfoCode, String tenantCode) {
        return this.getUserinfoModelByUserCode(userinfoCode, tenantCode);
    }

    @Override
    public void deleteUserinfo(Integer userinfoId) throws ApiException {
        this.deleteUserinfoModel(userinfoId);
    }

    @Override
    public QueryResult<UmUserinfo> queryUserinfoPage(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoList);
        return queryResult;
    }

    @Override
    public List<UmUserinfo> queryUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelList(map);
        return umUserinfoList;
    }

    @Override
    public void updateUserPwsswd(int userId, String userPwsswd) throws ApiException {
        if (StringUtils.isBlank((String)userPwsswd)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserPwsswd.", "\u5bc6\u7801\u4e3a\u7a7a");
        }
        UmUser oldUmUser = this.getUserModelById(userId);
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUser.setUserPwsswd(this.getMd5(userPwsswd));
        this.updateUserModel(oldUmUser);
    }

    @Override
    public void updateUserinfoConPhone(int userinfoId, String userinfoConPhone) throws ApiException {
        if (StringUtils.isBlank((String)userinfoConPhone)) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoConPhone.", "\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(userinfoId);
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.updateUserinfoConPhone.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUserinfo.setUserinfoConPhone(userinfoConPhone);
        this.updateUserinfoModel(oldUmUserinfo);
    }

    @Override
    public UmUser getUserByName(String userName, String tenantCode) {
        return this.selectByName(userName, tenantCode);
    }

    public void InvalidateUserinfModel() {
        try {
            List<UmUserinfo> userInfoList = this.umUserinfoMapper.queryInvalidUserinfoList();
            if (CollectionUtils.isNotEmpty(userInfoList)) {
                for (UmUserinfo umUserinfo : userInfoList) {
                    HashMap<String, Object> mapUserinfo = new HashMap<String, Object>();
                    mapUserinfo.put("userinfoId", umUserinfo.getUserinfoId());
                    mapUserinfo.put("dataState", "2");
                    mapUserinfo.put("oldDataState", "1");
                    this.umUserinfoMapper.updateStateByPrimaryKey(mapUserinfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.InvalidateUserinfModel", (Throwable)e);
        }
    }

    private List<UmUserinfo> getUserinfoList(Map<String, Object> map) {
        return this.umUserinfoMapper.queryInvalidUserinfoListWeek(map);
    }

    private void queryInvalidateUserinfoList(Map<String, Object> map) {
        try {
            String mnsExp;
            ArrayList<UmUser> userList = new ArrayList<UmUser>();
            List<UmUserinfo> userinfoList = this.getUserinfoList(map);
            if (CollectionUtils.isNotEmpty(userinfoList)) {
                for (UmUserinfo umUserinfo : userinfoList) {
                    String userCode = umUserinfo.getUserCode();
                    if (!StringUtils.isNotBlank((String)userCode)) continue;
                    userList.add(this.getUserModelByCode(userCode));
                }
            }
            this.logger.debug("um.USER.UserServiceImpl_queryInvalidateUserinfoList", (Object)("list size is-->" + userList.size()));
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "00013", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "00013");
                paramsMap.put("mnslistBusName", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.queryInvalidateUserinfoList", (Throwable)e);
        }
    }

    private String getMnsExp(List<UmUser> userList, String businessType, String theme) {
        if (CollectionUtils.isEmpty(userList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        for (UmUser umUser : userList) {
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", umUser.getUserCode());
            mapReceiver.put("name", umUser.getUserName());
            mapReceiver.put("email", umUser.getUserEmial());
            mapReceiver.put("telphone", umUser.getUserPhone());
            listReceiver.add(mapReceiver);
        }
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", theme);
        map.put("businessType", businessType);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("proName", "\u7ef4\u91d1SaaS");
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap1));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    @Override
    public void updateInvalidateUserinfo() throws ApiException {
        this.InvalidateUserinfModel();
    }

    @Override
    public void sendMnsInvalidateUserinfo() throws ApiException {
        String openRemindTime = this.getSysParam("OPEN_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        this.queryInvalidateUserinfoList(map);
    }

    @Override
    public void executeOverdueRemind() {
        List<UmUser> userList = this.getOverdueUserList();
        this.logger.debug("um.USER.UserServiceImpl_executeOverdueRemind", (Object)("list size is-->" + userList.size()));
        if (CollectionUtils.isNotEmpty(userList)) {
            this.sendOverdueMns(userList);
        }
    }

    @Override
    public void executeOverdueUpdate() {
        this.updateFeeOverdueStatus();
    }

    private void updateFeeOverdueStatus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", "0");
        map.put("userinfoFeestatus", "0");
        try {
            this.umUserinfoMapper.updateFeeStatus(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.updateFeeOverdueStatus", (Throwable)e);
        }
    }

    private List<UmUser> getOverdueUserList() {
        String openRemindTime = this.getSysParam("SAAS_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoFeeEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoFeeEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        ArrayList<UmUser> userList = new ArrayList<UmUser>();
        List<UmUserinfo> userinfoList = this.getOverdueUserinfoList(map);
        this.logger.debug("um.USER.UserServiceImpl_getOverdueUserList", (Object)("list size is-->" + userinfoList.size()));
        if (CollectionUtils.isNotEmpty(userinfoList)) {
            for (UmUserinfo umUserinfo : userinfoList) {
                String userCode = umUserinfo.getUserCode();
                this.logger.debug("um.USER.UserServiceImpl_getOverdueUserList", (Object)("userCode is-->" + userCode));
                if (!StringUtils.isNotBlank((String)userCode)) continue;
                userList.add(this.getUserModelByCode(userCode));
            }
        }
        return userList;
    }

    private List<UmUserinfo> getOverdueUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> userinfoList = null;
        try {
            userinfoList = this.umUserinfoMapper.queryOverdueUserinfoList(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getOverdueUserinfoList", (Throwable)e);
        }
        return userinfoList;
    }

    private void sendOverdueMns(List<UmUser> userList) {
        try {
            String mnsExp;
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "10016", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "10016");
                paramsMap.put("mnslistBusName", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.sendOverdueMns", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> queryUmuserCheck(String userName, String password, String appmanageIcode, String tenantCode, String isValid) {
        TmTenant tmTenant;
        String json;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String phone = "0";
        UmUser muser = null;
        if (!PhoneFormatCheckUtils.isPhoneLegal((String)userName)) {
            phone = "1";
        }
        if (StringUtils.isBlank((String)isValid)) {
            isValid = "1";
        }
        if (phone.equals("0")) {
            muser = this.selectByPhone(userName, tenantCode);
            if (null == muser) {
                muser = this.selectByName(userName, tenantCode);
            }
        } else {
            muser = this.selectByName(userName, tenantCode);
            if (null == muser) {
                muser = this.selectByPhone(userName, tenantCode);
            }
        }
        if (null == muser) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            this.logger.error("um.USER.UserServiceImpl.queryUmuserCheck", (Object)(userName + " | " + tenantCode));
            return result;
        }
        if (!"0".equals(isValid) && !MD5Util.saltMD5Verify((String)password, (String)muser.getUserPwsswd())) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            this.logger.error("um.USER.UserServiceImpl.queryUmuserCheck1", (Object)(password + " | " + muser.getUserPwsswd()));
            return result;
        }
        if (muser.getDataState() != 0) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return result;
        }
        UmUserinfo umUserinfo = this.getUserinfoModelByCode(muser.getUserPcode(), muser.getTenantCode());
        if (null == umUserinfo) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
            return result;
        }
        if (umUserinfo.getDataState() == -1) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return result;
        }
        if (StringUtils.isNotBlank((String)muser.getUserPcode()) && StringUtils.isNotBlank((String)(json = DisUtil.getMap((String)"tmtenant-code", (String)muser.getTenantCode()))) && (tmTenant = (TmTenant)JsonUtil.buildNormalBinder().getJsonToObject(json, TmTenant.class)) != null) {
            if (tmTenant.getDataState() == -1) {
                result.put("flag", false);
                result.put("message", "\u5e73\u53f0\u767b\u5f55\u88ab\u9650\u5236\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                return result;
            }
            muser.setTenantCode(tmTenant.getTenantCode());
        }
        muser.setUserinfoQuality(umUserinfo.getUserinfoQuality());
        muser.setMerberCompname(StringUtils.isBlank((String)umUserinfo.getUserinfoCompname()) ? muser.getUserName() : umUserinfo.getUserinfoCompname());
        String str = JsonUtil.getAllJsonUtil().toJson((Object)muser);
        Map umap = (Map)JsonUtil.getAllJsonUtil().getJsonToMap(str, String.class, Object.class);
        umap.put("merberCompname", StringUtils.isBlank((String)umUserinfo.getUserinfoCompname()) ? muser.getUserName() : umUserinfo.getUserinfoCompname());
        umap.put("userinfoQuality", umUserinfo.getUserinfoQuality());
        umap.put("openId", muser.getUserOpenid());
        umap.put("userinfoParentCode", umUserinfo.getUserinfoParentCode());
        result.put("flag", true);
        result.put("message", JsonUtil.getAllJsonUtil().toJson((Object)umap));
        return result;
    }

    @Override
    public UmUser saveUmuserAll(UmUserDomainBean umUserDomainBean) {
        UmUser user = this.saveAll(umUserDomainBean);
        return user;
    }

    private UmUser saveAll(UmUserDomainBean umUserDomainBean) {
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        umUserinfoDomainBean.setTenantCode(umUserDomainBean.getTenantCode());
        UmUserinfo umUserinfo = this.saveUserinfoReModel(umUserinfoDomainBean);
        String infoCode = umUserinfo.getUserinfoCode();
        umUserDomainBean.setUserPcode(infoCode);
        UmUser user = this.saveUser(umUserDomainBean);
        return user;
    }

    private UmUserinfo saveAllReInfo(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            throw new ApiException("um.USER.UserServiceImpl.saveAllReInfo.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.saveAllReInfo.e", (Throwable)e);
        }
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        umUserinfoDomainBean.setTenantCode(umUserDomainBean.getTenantCode());
        umUserinfoDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        UmUserinfo umUserinfo = this.saveUserinfoReModel(umUserinfoDomainBean);
        String infoCode = umUserinfo.getUserinfoCode();
        umUserDomainBean.setUserPcode(infoCode);
        umUserDomainBean.setUserName(umUserDomainBean.getUserPhone());
        UmUser user = this.saveUser(umUserDomainBean);
        umUserinfo.setUserCode(user.getUserCode());
        return umUserinfo;
    }

    @Override
    public UmUser saveUmuserAndInfo(UmUserDomainBean umUserDomainBean, UmUserinfoDomainBean umUserinfoDomainBean) {
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        String infoCode = this.saveUserinfoCode(umUserinfoDomainBean);
        umUserDomainBean.setUserPcode(infoCode);
        return this.saveUser(umUserDomainBean);
    }

    private String getMd5(String password) {
        if (StringUtils.isNotBlank((String)password)) {
            return MD5Util.saltMD5((String)password);
        }
        return "";
    }

    @Override
    public UmUser getUserByNameOrPhone(Map<String, Object> map) {
        return this.selectByNameOrPhone(map);
    }

    private UmUser selectByNameOrPhone(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.umUserMapper.selectByNameOrPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.selectByNameOrPhone", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> saveInitUser(Map<String, Object> map) throws ApiException {
        HashMap<String, Object> succs = new HashMap<String, Object>();
        String relationType = "1";
        if (map != null && map.get("tenantCode") != null) {
            String tenantCode = (String)map.get("tenantCode");
            String companyCode = (String)map.get("companyCode");
            relationType = (String)map.get("relationType");
            List infos = (List)map.get("impUserInfo");
            HashMap<String, String> managerByTeamCode = new HashMap<String, String>();
            String teamCode = "";
            String createTeamUserCode = "";
            for (Map info : infos) {
                String roleInfo = this.convertRoleCode((String)info.get("userOffice"));
                if ("".equals(roleInfo)) {
                    try {
                        throw new Exception("\u6ca1\u6709\u5339\u914d\u89d2\u8272:" + info.get("userRelname"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String roleCode = roleInfo.split("\\|")[0];
                String manager = roleInfo.split("\\|")[1];
                UmUser umUser = this.buildUser(info, tenantCode, roleCode);
                this.setUserDefault(umUser);
                int result = this.saveUserModel(umUser);
                String groupCode = null;
                if (relationType.equals("2") && map.get("groupCode") != null) {
                    groupCode = (String)map.get("groupCode");
                }
                if (result > 0) {
                    UmRelationDomain umRelationDomain;
                    if ("teamLeader".equals(manager)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        teamCode = umTeam.getTeamCode();
                        createTeamUserCode = umTeam.getUserCode();
                        managerByTeamCode.put(umUser.getUserRelname(), teamCode);
                    }
                    if (!createTeamUserCode.equals(umUser.getUserCode())) {
                        umRelationDomain = this.buildRelation(umUser, teamCode, relationType);
                        if (!StringUtils.isEmpty((String)groupCode) && this.checkGroupHasExists(groupCode, tenantCode)) {
                            umRelationDomain.setRelationBillno2(groupCode);
                        }
                        this.umRelationService.saveInitRelation(umRelationDomain);
                        continue;
                    }
                    if (managerByTeamCode.get(info.get("managerName")) == null) continue;
                    umRelationDomain = this.buildRelation(umUser, (String)managerByTeamCode.get(info.get("managerName")), relationType);
                    if (!StringUtils.isEmpty((String)groupCode) && this.checkGroupHasExists(groupCode, tenantCode)) {
                        umRelationDomain.setRelationBillno2(groupCode);
                    }
                    this.umRelationService.saveInitRelation(umRelationDomain);
                    continue;
                }
                try {
                    throw new Exception("\u6570\u636e\u672a\u5f55\u5165\u6210\u529f,\u7ec8\u6b62\u5f55\u5165:" + umUser.getUserRelname());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            succs.put("succSize", infos.size());
        } else {
            succs.put("succSize", 0);
        }
        return succs;
    }

    public UmUser buildUser(Map<String, Object> info, String tenantCode, String roleCode) {
        UmUser umUser = new UmUser();
        umUser.setTenantCode(tenantCode);
        umUser.setUserName((String)info.get("userPhone"));
        umUser.setUserRelname((String)info.get("userRelname"));
        umUser.setUserNickname((String)info.get("userRelname"));
        umUser.setUserPhone((String)info.get("userPhone"));
        umUser.setUserPcode((String)info.get("userPcode"));
        umUser.setUserType(1);
        umUser.setUserPwsswd(this.getMd5((String)info.get("userPwsswd")));
        umUser.setRoleCode(roleCode);
        umUser.setUserSex(this.convertUserSex((String)info.get("userSex")));
        umUser.setDataState(0);
        return umUser;
    }

    public UmTeamDomain buildTeam(UmUser umUser, String companyCode) {
        UmTeamDomain umTeamDomain = new UmTeamDomain();
        umTeamDomain.setAppmanageIcode(ServletMain.getAppName());
        umTeamDomain.setCompanyCode(companyCode);
        umTeamDomain.setRoleCode(umUser.getRoleCode());
        umTeamDomain.setTeamName(umUser.getUserRelname() + "\u56e2\u961f");
        umTeamDomain.setUserCode(umUser.getUserCode());
        umTeamDomain.setUserName(umUser.getUserName());
        umTeamDomain.setTenantCode(umUser.getTenantCode());
        umTeamDomain.setAppmanageIcode(ServletMain.getAppName());
        return umTeamDomain;
    }

    public UmRelationDomain buildRelation(UmUser umUser, String teamCode, String relationType) {
        UmRelationDomain umRelationDomain = new UmRelationDomain();
        umRelationDomain.setAppmanageIcode(ServletMain.getAppName());
        umRelationDomain.setRelationBillno(teamCode);
        umRelationDomain.setRoleCode(umUser.getRoleCode());
        umRelationDomain.setRelationType(relationType);
        umRelationDomain.setUserCode(umUser.getUserCode());
        umRelationDomain.setUserName(umUser.getUserName());
        umRelationDomain.setTenantCode(umUser.getTenantCode());
        return umRelationDomain;
    }

    public String convertRoleCode(String officeName) {
        if (officeName != null) {
            if (UserConstants.RoleEnum.FZJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.FZJL.getRoleCode() + "|" + UserConstants.RoleEnum.FZJL.getManager();
            }
            if (UserConstants.RoleEnum.XSZJ.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XSZJ.getRoleCode() + "|" + UserConstants.RoleEnum.XSZJ.getManager();
            }
            if (UserConstants.RoleEnum.JD.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.JD.getRoleCode() + "|" + UserConstants.RoleEnum.JD.getManager();
            }
            if (UserConstants.RoleEnum.XSJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XSJL.getRoleCode() + "|" + UserConstants.RoleEnum.XSJL.getManager();
            }
            if (UserConstants.RoleEnum.ZYGW.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.ZYGW.getRoleCode() + "|" + UserConstants.RoleEnum.ZYGW.getManager();
            }
            if (UserConstants.RoleEnum.XXZJ.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZJ.getRoleCode() + "|" + UserConstants.RoleEnum.XXZJ.getManager();
            }
            if (UserConstants.RoleEnum.XXJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXJL.getRoleCode() + "|" + UserConstants.RoleEnum.XXJL.getManager();
            }
            if (UserConstants.RoleEnum.XXZG.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZG.getRoleCode() + "|" + UserConstants.RoleEnum.XXZG.getManager();
            }
            if (UserConstants.RoleEnum.XXZY.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZY.getRoleCode() + "|" + UserConstants.RoleEnum.XXZY.getManager();
            }
            if (UserConstants.RoleEnum.TZZG.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.TZZG.getRoleCode() + "|" + UserConstants.RoleEnum.TZZG.getManager();
            }
        }
        return "";
    }

    public String convertUserSex(String userSex) {
        String sex = "1";
        if ("\u5973".equals(userSex)) {
            sex = "2";
        }
        return sex;
    }

    @Override
    public Map<String, Object> saveUserOrTeam(Map<String, Object> map) throws ApiException {
        String newTeamCode = "";
        String newTeamName = "";
        boolean failure = false;
        String userCode = "";
        if (map != null) {
            String tenantCode = (String)map.get("tenantCode");
            String roleCode = (String)map.get("roleCode");
            String companyCode = (String)map.get("companyCode");
            String oldTeamCode = (String)map.get("teamCode");
            String addType = (String)map.get("addType");
            String relationType = "1";
            if (map.get("relationType") != null) {
                relationType = (String)map.get("relationType");
            }
            if (map.get("hasDel") != null && 0 == (Integer)map.get("hasDel")) {
                UmUser umUser = this.buildUser(map, tenantCode, roleCode);
                this.setUserDefault(umUser);
                int result = this.saveUserModel(umUser);
                userCode = umUser.getUserCode();
                if (result > 0) {
                    String groupCode;
                    if (addType != null && !"".equals(addType) && "addTeam".equals(addType)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        newTeamCode = umTeam.getTeamCode();
                        newTeamName = umTeam.getTeamName();
                    }
                    UmRelationDomain umRelationDomain = this.buildRelation(umUser, oldTeamCode, relationType);
                    if (relationType.equals("2") && map.get("groupCode") != null && !StringUtils.isEmpty((String)(groupCode = (String)map.get("groupCode"))) && this.checkGroupHasExists(groupCode, tenantCode)) {
                        umRelationDomain.setRelationBillno2(groupCode);
                    }
                    UmRelation umRelation = this.umRelationService.saveInitRelation(umRelationDomain);
                }
            } else if (map.get("hasDel") != null && 1 == (Integer)map.get("hasDel")) {
                UmUser umUser = this.buildUser(map, tenantCode, roleCode);
                if (map.get("userId") != null && !"".equals(map.get("userId"))) {
                    umUser.setUserId((Integer)map.get("userId"));
                }
                int i = this.updateUserModel(umUser);
                umUser = this.getUser(umUser.getUserId());
                if (i > 0) {
                    if (addType != null && !"".equals(addType) && "addTeam".equals(addType)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        newTeamCode = umTeam.getTeamCode();
                        newTeamName = umTeam.getTeamName();
                    }
                    HashMap<String, Object> relationMap = new HashMap<String, Object>();
                    relationMap.put("userCode", umUser.getUserCode());
                    relationMap.put("tenantCode", umUser.getTenantCode());
                    QueryResult<UmRelation> relationResult = this.umRelationService.queryRelationPage(relationMap);
                    List relations = relationResult.getList();
                    if (ListUtil.isNotEmpty((Collection)relations)) {
                        UmRelation ur = (UmRelation)relations.get(0);
                        ur.setDataState(0);
                        ur.setRelationBillno(oldTeamCode);
                        ur.setUserName(umUser.getUserName());
                        ur.setRoleCode(umUser.getRoleCode());
                        this.umRelationService.updateRelation(ur);
                    } else {
                        failure = true;
                    }
                } else {
                    failure = true;
                }
            }
        } else {
            failure = true;
        }
        HashMap<String, Object> team = new HashMap<String, Object>();
        if (failure) {
            team.put("succ", false);
        } else {
            team.put("succ", true);
        }
        team.put("userCode", userCode);
        team.put("teamCode", newTeamCode);
        team.put("teamName", newTeamName);
        return team;
    }

    @Override
    public List<UmUser> getUsersByRelnames(List<UmUserDomainBean> list) {
        ArrayList<UmUser> users = new ArrayList<UmUser>();
        for (UmUserDomainBean user : list) {
            UmUser uu = this.getUsersByRelnamesModel(user.getUserRelname(), user.getTenantCode());
            if (uu == null) {
                uu = new UmUser();
                uu.setUserRelname(user.getUserRelname());
                uu.setTenantCode(user.getTenantCode());
            }
            users.add(uu);
        }
        return users;
    }

    private UmUser getUsersByRelnamesModel(String userRelname, String tenantCode) {
        try {
            return this.umUserMapper.getUsersByRelnames(userRelname, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUsersByRelnamesModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean updateUserValid(Map<String, Object> map) throws ApiException {
        int i = this.updateUserValidModel(map);
        if (i > 0) {
            this.umRelationService.updateRelationValid(map);
            return true;
        }
        throw new ApiException("um.USER.UserServiceImpl.updateUserValid", "\u4fee\u6539\u7528\u6237\u5728\u804c\u72b6\u6001\u5931\u8d25");
    }

    private int updateUserValidModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.updateUserValid(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.updateUserValidModel", (Throwable)e);
            return 0;
        }
    }

    @Override
    public List<UmUser> getManagerByCode(Map<String, Object> map) throws ApiException {
        if (map.get("roleCode") == null) {
            return null;
        }
        return this.loopManager(map);
    }

    private List<UmUser> loopManager(Map<String, Object> map) {
        List<UmUser> manages = this.getManagerByCodeModel(map);
        if (manages != null && manages.size() > 0 && map.get("roleCode").equals(manages.get(0).getRoleCode())) {
            return manages;
        }
        String userCode = manages.get(0).getUserCode();
        map.put("userCode", userCode);
        return this.loopManager(map);
    }

    private List<UmUser> getManagerByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getManagerByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getManagerByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserServiceImpl.getManagerByCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getDirectManagerByCode(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        Map<String, Object> directManager = this.getDirectManagerByCodeModel(map);
        Boolean defaultQuery = false;
        if (map.get("defaultQuery") != null) {
            defaultQuery = (Boolean)map.get("defaultQuery");
        }
        if (MapUtil.isEmpty(directManager) && defaultQuery.booleanValue()) {
            directManager = this.getMyselftByCodeModel(map);
        }
        return directManager;
    }

    private Map<String, Object> getDirectManagerByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getDirectManagerByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getDirectManagerByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserServiceImpl.getDirectManagerByCodeModel.ex", (Throwable)e);
        }
    }

    private Map<String, Object> getMyselftByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getMyselftByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getMyselftByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserServiceImpl.getMyselftByCodeModel.ex", (Throwable)e);
        }
    }

    private UmUser validate(String userPhone, String userName, String tenantCode) {
        HashMap<String, Object> validateMap = new HashMap<String, Object>();
        validateMap.put("userPhone", userPhone);
        validateMap.put("userName", userName);
        validateMap.put("tenantCode", tenantCode);
        UmUser user = this.getUserByNameOrPhone(validateMap);
        return user;
    }

    @Override
    public Map<String, Object> updateUserPhoneByUserPhone(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        map.put("successFlag", false);
        UmUser user = this.validate((String)map.get("newUserPhone"), (String)map.get("newUserPhone"), (String)map.get("tenantCode"));
        if (user != null) {
            return map;
        }
        user = this.validate((String)map.get("oldUserPhone"), (String)map.get("oldUserPhone"), (String)map.get("tenantCode"));
        if (user == null) {
            return map;
        }
        map.put("userCode", user.getUserCode());
        int index = this.updateUserPhoneByUserPhoneModel(map);
        if (index > 0) {
            map.put("successFlag", true);
            return map;
        }
        this.logger.error("\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25\uff0c\u539f\u624b\u673a\u53f7\u4e3a" + map.get("oldUserPhone"));
        return map;
    }

    private int updateUserPhoneByUserPhoneModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.updateUserPhoneByUserPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.updateUserPhoneByUserPhoneModel", (Object)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
            throw new ApiException("um.USER.UserServiceImpl.updateUserPhoneByUserPhoneModel.ex", "\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
        }
    }

    private boolean checkGroupHasExists(String groupCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupCode", groupCode);
        map.put("tenantCode", tenantCode);
        UmGroup user = this.umGroupService.getGroupByCode(map);
        return user != null;
    }

    public void setUmGroupService(UmGroupService umGroupService) {
        this.umGroupService = umGroupService;
    }

    @Override
    public UmUserinfo getUserinfoByCode(String userinfoCode, String tenantCode) {
        return this.getUserinfoByCodeModel(userinfoCode, tenantCode);
    }

    private UmUserinfo getUserinfoByCodeModel(String userinfoCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserServiceImpl.getUserinfoByCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAllManagerByCode(String userCode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        ArrayList<String> lists = new ArrayList<String>();
        this.loopManager(map, lists);
        if (ListUtil.isNotEmpty(lists)) {
            return lists;
        }
        return null;
    }

    private List<UmUser> loopManager(Map<String, Object> map, List<String> lists) {
        List<UmUser> manages = this.getManagerByCodeModel(map);
        if (ListUtil.isEmpty(manages)) {
            return manages;
        }
        String userCode = manages.get(0).getUserCode();
        map.put("userCode", userCode);
        lists.add(userCode);
        return this.loopManager(map, lists);
    }

    @Override
    public String getUserByNickName(String userNickname, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userNickname", userNickname);
        parammap.put("tenantCode", tenantCode);
        List<UmUser> list = this.queryUserModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return "";
        }
        return list.get(0).getUserCode();
    }

    @Override
    public void updateUserLoginByCode(String userCode, String memo, String tenantCode) {
        this.updateUserModelByCode(memo, userCode, tenantCode);
    }

    private void updateOpenUserinfoModelByCode(String userinfoCode, String tenantCode, Integer userinfoState, Integer oldUserinfoState) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || null == userinfoState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("userinfoState", userinfoState);
        map.put("oldUserinfoState", oldUserinfoState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateOpenByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.updateOpenUserinfoModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserServiceImpl.updateOpenUserinfoModelByCode.null");
        }
    }

    @Override
    public void sendUserinfo(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.sendUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        this.updateOpenUserinfoModelByCode(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 1, 0);
        String apiCode = "vd.faccount.saveOpenFaccoun";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain = new VdFaccountOuterCtrlDomain();
        String batchcode = "0201";
        if (MerberType.PRE.getCode().equals(String.valueOf(umUserinfo.getUserinfoType()))) {
            batchcode = "0101";
        }
        vdFaccountOuterCtrlDomain.setFaccountDefBatchcode(batchcode);
        vdFaccountOuterCtrlDomain.setMerchantCode(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setTenantCode(umUserinfo.getTenantCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlExno(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlCallurl("um.user.udateCallFaccount");
        paramMap.put("vdFaccountOuterCtrlDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterCtrlDomain));
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    @Override
    public void loadUserinfoProcess() {
        this.loadSendDb();
    }

    private void loadSendDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userinfoState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<UmUserinfo> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getUserinfoService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getUserinfoService().getPage());
                result = this.queryUserinfoPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (UmUserinfo umUserinfo : result.getRows()) {
                        this.getUserinfoService().putQueue(umUserinfo);
                    }
                    if (result.getRows().size() == this.getUserinfoService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getUserinfoService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserServiceImpl.loadSendDb.e", (Throwable)e);
        }
    }

    @Override
    public String sendOpenUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUserinfo umUserinfo = this.saveAllReInfo(umUserDomainBean);
        this.getUserinfoService().putQueue(umUserinfo);
        return umUserinfo.getUserinfoCode();
    }

    @Override
    public void udateCallFaccount(String faccountExno, String faccountCall, String tenantCode) {
        UmUserinfo umUserinfo = this.getUserinfoModelByCode(faccountExno, tenantCode);
        if (null == umUserinfo || 2 == umUserinfo.getUserinfoState()) {
            return;
        }
        this.updateOpenUserinfoModelByCode(faccountExno, tenantCode, 2, 1);
    }

    @Override
    public void sendBigDataForUser(Map<String, Object> map) {
        System.out.println(map.get("topic").toString() + "===" + map.get("bigdata").toString());
        KafkaProducerUtil.sendProducerInfo((String)map.get("topic").toString(), (String)map.get("bigdata").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserinfoService getUserinfoService() {
        Object object = lock;
        synchronized (object) {
            if (null == userinfoService) {
                userinfoService = new UserinfoService((UserService)SpringApplicationContextUtil.getBean((String)"userService"));
                userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
            }
            return userinfoService;
        }
    }

    static {
        lock = new Object();
    }
}

