/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmQualityProappMapper;
import com.yqbsoft.laser.service.user.domain.UmQualityProappDomain;
import com.yqbsoft.laser.service.user.domain.UmQualityProappReDomain;
import com.yqbsoft.laser.service.user.model.UmQualityProapp;
import com.yqbsoft.laser.service.user.service.UmQualityProappService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class UmQualityProappServiceImpl
extends BaseServiceImpl
implements UmQualityProappService {
    private static final String SYS_CODE = "um.USER.UmQualityProappServiceImpl";
    private UmQualityProappMapper umQualityProappMapper;

    public void setUmQualityProappMapper(UmQualityProappMapper umQualityProappMapper) {
        this.umQualityProappMapper = umQualityProappMapper;
    }

    private Date getSysDate() {
        try {
            return this.umQualityProappMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkQualityProapp(UmQualityProappDomain umQualityProappDomain) {
        if (null == umQualityProappDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umQualityProappDomain.getProappCode())) {
            msg = msg + "ProappCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umQualityProappDomain.getQualityCode())) {
            msg = msg + "QualityCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umQualityProappDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setQualityProappDefault(UmQualityProapp umQualityProapp) {
        if (null == umQualityProapp) {
            return;
        }
        if (null == umQualityProapp.getDataState()) {
            umQualityProapp.setDataState(0);
        }
        if (null == umQualityProapp.getGmtCreate()) {
            umQualityProapp.setGmtCreate(this.getSysDate());
        }
        umQualityProapp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umQualityProapp.getQualityProappCode())) {
            umQualityProapp.setQualityProappCode(this.createUUIDString());
        }
    }

    private int getQualityProappMaxCode() {
        int code = 0;
        try {
            return this.umQualityProappMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.getQualityProappMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setQualityProappUpdataDefault(UmQualityProapp umQualityProapp) {
        if (null == umQualityProapp) {
            return;
        }
        umQualityProapp.setGmtModified(this.getSysDate());
    }

    private void saveQualityProappModel(UmQualityProapp umQualityProapp) throws ApiException {
        if (null == umQualityProapp) {
            return;
        }
        try {
            this.umQualityProappMapper.insert(umQualityProapp);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.saveQualityProappModel.ex", (Throwable)e);
        }
    }

    private void saveQualityProappBatchModel(List<UmQualityProapp> umQualityProappList) throws ApiException {
        if (null == umQualityProappList || umQualityProappList.isEmpty()) {
            return;
        }
        try {
            this.umQualityProappMapper.insertBatch(umQualityProappList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.saveQualityProappBatchModel.ex", (Throwable)e);
        }
    }

    private UmQualityProapp getQualityProappModelById(Integer qualityProappId) {
        if (null == qualityProappId) {
            return null;
        }
        try {
            return this.umQualityProappMapper.selectByPrimaryKey(qualityProappId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.getQualityProappModelById", (Throwable)e);
            return null;
        }
    }

    private UmQualityProapp getQualityProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umQualityProappMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.getQualityProappModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delQualityProappModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityProappMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.delQualityProappModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.delQualityProappModelByCode.num");
        }
    }

    private void deleteQualityProappModel(Integer qualityProappId) throws ApiException {
        if (null == qualityProappId) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityProappMapper.deleteByPrimaryKey(qualityProappId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.deleteQualityProappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.deleteQualityProappModel.num");
        }
    }

    private void updateQualityProappModel(UmQualityProapp umQualityProapp) throws ApiException {
        if (null == umQualityProapp) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityProappMapper.updateByPrimaryKeySelective(umQualityProapp);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateQualityProappModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateQualityProappModel.num");
        }
    }

    private void updateStateQualityProappModel(Integer qualityProappId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == qualityProappId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qualityProappId", qualityProappId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umQualityProappMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateStateQualityProappModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateStateQualityProappModel.null");
        }
    }

    private void updateStateQualityProappModelByCode(String tenantCode, String qualityProappCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)qualityProappCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityProappCode", qualityProappCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umQualityProappMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateStateQualityProappModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateStateQualityProappModelByCode.null");
        }
    }

    private UmQualityProapp makeQualityProapp(UmQualityProappDomain umQualityProappDomain, UmQualityProapp umQualityProapp) {
        if (null == umQualityProappDomain) {
            return null;
        }
        if (null == umQualityProapp) {
            umQualityProapp = new UmQualityProapp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umQualityProapp, (Object)umQualityProappDomain);
            return umQualityProapp;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.makeQualityProapp", (Throwable)e);
            return null;
        }
    }

    private UmQualityProappReDomain makeUmQualityProappReDomain(UmQualityProapp umQualityProapp) {
        if (null == umQualityProapp) {
            return null;
        }
        UmQualityProappReDomain umQualityProappReDomain = new UmQualityProappReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umQualityProappReDomain, (Object)umQualityProapp);
            return umQualityProappReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.makeUmQualityProappReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmQualityProapp> queryQualityProappModelPage(Map<String, Object> parammap) {
        try {
            return this.umQualityProappMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.queryQualityProappModel", (Throwable)e);
            return null;
        }
    }

    private int countQualityProapp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umQualityProappMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityProappServiceImpl.countQualityProapp", (Throwable)e);
        }
        return i;
    }

    private UmQualityProapp createUmQualityProapp(UmQualityProappDomain umQualityProappDomain) {
        String msg = this.checkQualityProapp(umQualityProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.saveQualityProapp.checkQualityProapp", msg);
        }
        UmQualityProapp umQualityProapp = this.makeQualityProapp(umQualityProappDomain, null);
        this.setQualityProappDefault(umQualityProapp);
        return umQualityProapp;
    }

    @Override
    public String saveQualityProapp(UmQualityProappDomain umQualityProappDomain) throws ApiException {
        UmQualityProapp umQualityProapp = this.createUmQualityProapp(umQualityProappDomain);
        this.saveQualityProappModel(umQualityProapp);
        return umQualityProapp.getQualityProappCode();
    }

    @Override
    public String saveQualityProappBatch(List<UmQualityProappDomain> umQualityProappDomainList) throws ApiException {
        if (null == umQualityProappDomainList || umQualityProappDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmQualityProapp> umQualityProappList = new ArrayList<UmQualityProapp>();
        String code = "";
        for (UmQualityProappDomain umQualityProappDomain : umQualityProappDomainList) {
            UmQualityProapp umQualityProapp = this.createUmQualityProapp(umQualityProappDomain);
            code = umQualityProapp.getQualityProappCode();
            umQualityProappList.add(umQualityProapp);
        }
        this.saveQualityProappBatchModel(umQualityProappList);
        return code;
    }

    @Override
    public void updateQualityProappState(Integer qualityProappId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateQualityProappModel(qualityProappId, dataState, oldDataState);
    }

    @Override
    public void updateQualityProappStateByCode(String tenantCode, String qualityProappCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateQualityProappModelByCode(tenantCode, qualityProappCode, dataState, oldDataState);
    }

    @Override
    public void updateQualityProapp(UmQualityProappDomain umQualityProappDomain) throws ApiException {
        String msg = this.checkQualityProapp(umQualityProappDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateQualityProapp.checkQualityProapp", msg);
        }
        UmQualityProapp oldUmQualityProapp = this.getQualityProappModelById(umQualityProappDomain.getQualityProappId());
        if (null == oldUmQualityProapp) {
            throw new ApiException("um.USER.UmQualityProappServiceImpl.updateQualityProapp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmQualityProapp umQualityProapp = this.makeQualityProapp(umQualityProappDomain, oldUmQualityProapp);
        this.setQualityProappUpdataDefault(umQualityProapp);
        this.updateQualityProappModel(umQualityProapp);
    }

    @Override
    public UmQualityProapp getQualityProapp(Integer qualityProappId) {
        return this.getQualityProappModelById(qualityProappId);
    }

    @Override
    public void deleteQualityProapp(Integer qualityProappId) throws ApiException {
        this.deleteQualityProappModel(qualityProappId);
    }

    @Override
    public QueryResult<UmQualityProapp> queryQualityProappPage(Map<String, Object> map) {
        List<UmQualityProapp> umQualityProappList = this.queryQualityProappModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countQualityProapp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umQualityProappList);
        return queryResult;
    }

    @Override
    public UmQualityProapp getQualityProappByCode(String tenantCode, String qualityProappCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityProappCode", qualityProappCode);
        return this.getQualityProappModelByCode(map);
    }

    @Override
    public void deleteQualityProappByCode(String tenantCode, String qualityProappCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityProappCode", qualityProappCode);
        this.delQualityProappModelByCode(map);
    }

    @Override
    public void queryQualityProappLoadCache() {
        this.logger.info("UmQualityProappService.queryQualityProappLoadCache", (Object)"===========start==========");
        String cachekeydomain = "UmQualityProapp-list";
        String cachekeymodel = "UmQualityProapp-model";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("dataState", 1);
        List<UmQualityProapp> umQualityProappList = this.queryQualityProappModelPage(parammap);
        if (null == umQualityProappList || umQualityProappList.isEmpty()) {
            DisUtil.delVer((String)cachekeydomain);
            DisUtil.delVer((String)cachekeymodel);
            this.logger.info("UmQualityProappService.queryQualityProappLoadCache", (Object)"===========del-end==========");
            return;
        }
        ConcurrentHashMap<String, String> proappDomainMap = new ConcurrentHashMap<String, String>();
        ArrayList<String> list = null;
        String key = "";
        ConcurrentHashMap<String, String> proappMap = new ConcurrentHashMap<String, String>();
        for (UmQualityProapp umQualityProapp : umQualityProappList) {
            key = umQualityProapp.getQualityCode() + "-" + umQualityProapp.getTenantCode();
            String str = (String)proappDomainMap.get(key);
            list = null;
            if (StringUtils.isNotBlank((String)str)) {
                list = (ArrayList<String>)JsonUtil.buildNormalBinder().getJsonToList(str, String.class);
            }
            if (null == list) {
                list = new ArrayList<String>();
            }
            list.add(umQualityProapp.getProappCode());
            proappDomainMap.put(key, JsonUtil.buildNormalBinder().toJson(list));
            if (StringUtils.isBlank((String)umQualityProapp.getQualityProappTginfo())) {
                umQualityProapp.setQualityProappTginfo("0");
            }
            proappMap.put(umQualityProapp.getQualityCode() + "-" + umQualityProapp.getProappCode() + "-" + umQualityProapp.getTenantCode(), umQualityProapp.getQualityProappTginfo());
        }
        DisUtil.setMapVer((String)cachekeydomain, proappDomainMap);
        DisUtil.setMapVer((String)cachekeymodel, proappMap);
        this.logger.info("UmQualityProappService.queryQualityProappLoadCache", (Object)"===========add-end==========");
    }
}

