/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmQualityMapper;
import com.yqbsoft.laser.service.user.domain.UmQualityDomain;
import com.yqbsoft.laser.service.user.domain.UmQualityReDomain;
import com.yqbsoft.laser.service.user.model.UmQuality;
import com.yqbsoft.laser.service.user.service.UmQualityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmQualityServiceImpl
extends BaseServiceImpl
implements UmQualityService {
    private static final String SYS_CODE = "um.USER.UmQualityServiceImpl";
    private UmQualityMapper umQualityMapper;

    public void setUmQualityMapper(UmQualityMapper umQualityMapper) {
        this.umQualityMapper = umQualityMapper;
    }

    private Date getSysDate() {
        try {
            return this.umQualityMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkQuality(UmQualityDomain umQualityDomain) {
        if (null == umQualityDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umQualityDomain.getQualityCode())) {
            msg = msg + "QualityCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)umQualityDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setQualityDefault(UmQuality umQuality) {
        if (null == umQuality) {
            return;
        }
        if (null == umQuality.getDataState()) {
            umQuality.setDataState(0);
        }
        if (null == umQuality.getGmtCreate()) {
            umQuality.setGmtCreate(this.getSysDate());
        }
        umQuality.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umQuality.getQualityCode())) {
            umQuality.setQualityCode(this.createUUIDString());
        }
    }

    private int getQualityMaxCode() {
        int code = 0;
        try {
            return this.umQualityMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.getQualityMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setQualityUpdataDefault(UmQuality umQuality) {
        if (null == umQuality) {
            return;
        }
        umQuality.setGmtModified(this.getSysDate());
    }

    private void saveQualityModel(UmQuality umQuality) throws ApiException {
        if (null == umQuality) {
            return;
        }
        try {
            this.umQualityMapper.insert(umQuality);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.saveQualityModel.ex", (Throwable)e);
        }
    }

    private void saveQualityBatchModel(List<UmQuality> umQualityList) throws ApiException {
        if (null == umQualityList || umQualityList.isEmpty()) {
            return;
        }
        try {
            this.umQualityMapper.insertBatch(umQualityList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.saveQualityBatchModel.ex", (Throwable)e);
        }
    }

    private UmQuality getQualityModelById(Integer qualityId) {
        if (null == qualityId) {
            return null;
        }
        try {
            return this.umQualityMapper.selectByPrimaryKey(qualityId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.getQualityModelById", (Throwable)e);
            return null;
        }
    }

    private UmQuality getQualityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umQualityMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.getQualityModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delQualityModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.delQualityModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityServiceImpl.delQualityModelByCode.num");
        }
    }

    private void deleteQualityModel(Integer qualityId) throws ApiException {
        if (null == qualityId) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityMapper.deleteByPrimaryKey(qualityId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.deleteQualityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityServiceImpl.deleteQualityModel.num");
        }
    }

    private void updateQualityModel(UmQuality umQuality) throws ApiException {
        if (null == umQuality) {
            return;
        }
        int i = 0;
        try {
            i = this.umQualityMapper.updateByPrimaryKeySelective(umQuality);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateQualityModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateQualityModel.num");
        }
    }

    private void updateStateQualityModel(Integer qualityId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == qualityId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("qualityId", qualityId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umQualityMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateStateQualityModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateStateQualityModel.null");
        }
    }

    private void updateStateQualityModelByCode(String tenantCode, String qualityCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)qualityCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityCode", qualityCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umQualityMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateStateQualityModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateStateQualityModelByCode.null");
        }
    }

    private UmQuality makeQuality(UmQualityDomain umQualityDomain, UmQuality umQuality) {
        if (null == umQualityDomain) {
            return null;
        }
        if (null == umQuality) {
            umQuality = new UmQuality();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umQuality, (Object)umQualityDomain);
            return umQuality;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.makeQuality", (Throwable)e);
            return null;
        }
    }

    private UmQualityReDomain makeUmQualityReDomain(UmQuality umQuality) {
        if (null == umQuality) {
            return null;
        }
        UmQualityReDomain umQualityReDomain = new UmQualityReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umQualityReDomain, (Object)umQuality);
            return umQualityReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.makeUmQualityReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmQuality> queryQualityModelPage(Map<String, Object> parammap) {
        try {
            return this.umQualityMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.queryQualityModel", (Throwable)e);
            return null;
        }
    }

    private int countQuality(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umQualityMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmQualityServiceImpl.countQuality", (Throwable)e);
        }
        return i;
    }

    private UmQuality createUmQuality(UmQualityDomain umQualityDomain) {
        String msg = this.checkQuality(umQualityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmQualityServiceImpl.saveQuality.checkQuality", msg);
        }
        UmQuality umQuality = this.makeQuality(umQualityDomain, null);
        this.setQualityDefault(umQuality);
        return umQuality;
    }

    @Override
    public String saveQuality(UmQualityDomain umQualityDomain) throws ApiException {
        UmQuality umQuality = this.createUmQuality(umQualityDomain);
        this.saveQualityModel(umQuality);
        return umQuality.getQualityCode();
    }

    @Override
    public String saveQualityBatch(List<UmQualityDomain> umQualityDomainList) throws ApiException {
        if (null == umQualityDomainList || umQualityDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmQuality> umQualityList = new ArrayList<UmQuality>();
        String code = "";
        for (UmQualityDomain umQualityDomain : umQualityDomainList) {
            UmQuality umQuality = this.createUmQuality(umQualityDomain);
            code = umQuality.getQualityCode();
            umQualityList.add(umQuality);
        }
        this.saveQualityBatchModel(umQualityList);
        return code;
    }

    @Override
    public void updateQualityState(Integer qualityId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateQualityModel(qualityId, dataState, oldDataState);
    }

    @Override
    public void updateQualityStateByCode(String tenantCode, String qualityCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateQualityModelByCode(tenantCode, qualityCode, dataState, oldDataState);
    }

    @Override
    public void updateQuality(UmQualityDomain umQualityDomain) throws ApiException {
        String msg = this.checkQuality(umQualityDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateQuality.checkQuality", msg);
        }
        UmQuality oldUmQuality = this.getQualityModelById(umQualityDomain.getQualityId());
        if (null == oldUmQuality) {
            throw new ApiException("um.USER.UmQualityServiceImpl.updateQuality.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmQuality umQuality = this.makeQuality(umQualityDomain, oldUmQuality);
        this.setQualityUpdataDefault(umQuality);
        this.updateQualityModel(umQuality);
    }

    @Override
    public UmQuality getQuality(Integer qualityId) {
        return this.getQualityModelById(qualityId);
    }

    @Override
    public void deleteQuality(Integer qualityId) throws ApiException {
        this.deleteQualityModel(qualityId);
    }

    @Override
    public QueryResult<UmQuality> queryQualityPage(Map<String, Object> map) {
        List<UmQuality> umQualityList = this.queryQualityModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countQuality(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umQualityList);
        return queryResult;
    }

    @Override
    public UmQuality getQualityByCode(String tenantCode, String qualityCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityCode", qualityCode);
        return this.getQualityModelByCode(map);
    }

    @Override
    public void deleteQualityByCode(String tenantCode, String qualityCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("qualityCode", qualityCode);
        this.delQualityModelByCode(map);
    }
}

