/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmGroupListMapper;
import com.yqbsoft.laser.service.user.dao.UmGroupMapper;
import com.yqbsoft.laser.service.user.domain.UmGroupDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupListDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupListReDomain;
import com.yqbsoft.laser.service.user.domain.UmGroupReDomain;
import com.yqbsoft.laser.service.user.model.UmGroup;
import com.yqbsoft.laser.service.user.model.UmGroupList;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmGroupServiceImpl
extends BaseServiceImpl
implements UmGroupService {
    private static final String SYS_CODE = "um.USER.UmGroupServiceImpl";
    private UmGroupMapper umGroupMapper;
    private UmGroupListMapper umGroupListMapper;

    public void setUmGroupMapper(UmGroupMapper umGroupMapper) {
        this.umGroupMapper = umGroupMapper;
    }

    public void setUmGroupListMapper(UmGroupListMapper umGroupListMapper) {
        this.umGroupListMapper = umGroupListMapper;
    }

    private Date getSysDate() {
        try {
            return this.umGroupMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkGroup(UmGroupDomain umGroupDomain) {
        if (null == umGroupDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umGroupDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        if (null == umGroup.getDataState()) {
            umGroup.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umGroup.getGmtCreate()) {
            umGroup.setGmtCreate(date);
        }
        umGroup.setGmtModified(date);
        if (StringUtils.isBlank((String)umGroup.getGroupCode())) {
            umGroup.setGroupCode(this.getNo(null, "UmGroup", "umGroup", umGroup.getTenantCode()));
        }
    }

    private int getGroupMaxCode() {
        int code = 0;
        try {
            return this.umGroupMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupUpdataDefault(UmGroup umGroup) {
        if (null == umGroup) {
            return;
        }
        umGroup.setGmtModified(this.getSysDate());
    }

    private void saveGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        try {
            this.umGroupMapper.insert(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupModel.ex", (Throwable)e);
        }
    }

    private void saveGroupBatchModel(List<UmGroup> umGroupList) throws ApiException {
        if (null == umGroupList || umGroupList.isEmpty()) {
            return;
        }
        try {
            this.umGroupMapper.insertBatch(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupBatchModel.ex", (Throwable)e);
        }
    }

    private UmGroup getGroupModelById(Integer groupId) {
        if (null == groupId) {
            return null;
        }
        try {
            return this.umGroupMapper.selectByPrimaryKey(groupId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelById", (Throwable)e);
            return null;
        }
    }

    private UmGroup getGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupModelByCode.num");
        }
    }

    private void deleteGroupModel(Integer groupId) throws ApiException {
        if (null == groupId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.deleteByPrimaryKey(groupId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupModel.num");
        }
    }

    private void updateGroupModel(UmGroup umGroup) throws ApiException {
        if (null == umGroup) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateByPrimaryKey(umGroup);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupModel.num");
        }
    }

    private void updateStateGroupModel(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupId", groupId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModel.null");
        }
    }

    private void updateStateGroupModelByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupModelByCode.null");
        }
    }

    private UmGroup makeGroup(UmGroupDomain umGroupDomain, UmGroup umGroup) {
        if (null == umGroupDomain) {
            return null;
        }
        if (null == umGroup) {
            umGroup = new UmGroup();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umGroup, (Object)umGroupDomain);
            return umGroup;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroup", (Throwable)e);
            return null;
        }
    }

    private UmGroupReDomain makeUmGroupReDomain(UmGroup umGroup) {
        if (null == umGroup) {
            return null;
        }
        UmGroupReDomain umGroupReDomain = new UmGroupReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umGroupReDomain, (Object)umGroup);
            return umGroupReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeUmGroupReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmGroup> queryGroupModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupModel", (Throwable)e);
            return null;
        }
    }

    private int countGroup(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroup", (Throwable)e);
        }
        return i;
    }

    private UmGroup createUmGroup(UmGroupDomain umGroupDomain) {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroup.checkGroup", msg);
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, null);
        this.setGroupDefault(umGroup);
        return umGroup;
    }

    private String checkGroupList(UmGroupListDomain umGroupListDomain) {
        if (null == umGroupListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umGroupListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setGroupListDefault(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return;
        }
        if (null == umGroupList.getDataState()) {
            umGroupList.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umGroupList.getGmtCreate()) {
            umGroupList.setGmtCreate(date);
        }
        umGroupList.setGmtModified(date);
        if (StringUtils.isBlank((String)umGroupList.getGroupListCode())) {
            umGroupList.setGroupListCode(this.getNo(null, "UmGroupList", "umGroupList", umGroupList.getTenantCode()));
        }
    }

    private int getGroupListMaxCode() {
        int code = 0;
        try {
            return this.umGroupListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setGroupListUpdataDefault(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return;
        }
        umGroupList.setGmtModified(this.getSysDate());
    }

    private void saveGroupListModel(UmGroupList umGroupList) throws ApiException {
        if (null == umGroupList) {
            return;
        }
        try {
            this.umGroupListMapper.insert(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupListModel.ex", (Throwable)e);
        }
    }

    private void saveGroupListBatchModel(List<UmGroupList> umGroupListList) throws ApiException {
        if (null == umGroupListList || umGroupListList.isEmpty()) {
            return;
        }
        try {
            this.umGroupListMapper.insertBatch(umGroupListList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupListBatchModel.ex", (Throwable)e);
        }
    }

    private UmGroupList getGroupListModelById(Integer groupListId) {
        if (null == groupListId) {
            return null;
        }
        try {
            return this.umGroupListMapper.selectByPrimaryKey(groupListId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListModelById", (Throwable)e);
            return null;
        }
    }

    private UmGroupList getGroupListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umGroupListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.getGroupListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delGroupListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.delGroupListModelByCode.num");
        }
    }

    private void deleteGroupListModel(Integer groupListId) throws ApiException {
        if (null == groupListId) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.deleteByPrimaryKey(groupListId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.deleteGroupListModel.num");
        }
    }

    private void updateGroupListModel(UmGroupList umGroupList) throws ApiException {
        if (null == umGroupList) {
            return;
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateByPrimaryKey(umGroupList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupListModel.num");
        }
    }

    private void updateStateGroupListModel(Integer groupListId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == groupListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("groupListId", groupListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModel.null");
        }
    }

    private void updateStateGroupListModelByCode(String tenantCode, String groupListCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)groupListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umGroupListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateStateGroupListModelByCode.null");
        }
    }

    private UmGroupList makeGroupList(UmGroupListDomain umGroupListDomain, UmGroupList umGroupList) {
        if (null == umGroupListDomain) {
            return null;
        }
        if (null == umGroupList) {
            umGroupList = new UmGroupList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umGroupList, (Object)umGroupListDomain);
            return umGroupList;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeGroupList", (Throwable)e);
            return null;
        }
    }

    private UmGroupListReDomain makeUmGroupListReDomain(UmGroupList umGroupList) {
        if (null == umGroupList) {
            return null;
        }
        UmGroupListReDomain umGroupListReDomain = new UmGroupListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umGroupListReDomain, (Object)umGroupList);
            return umGroupListReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.makeUmGroupListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmGroupList> queryGroupListModelPage(Map<String, Object> parammap) {
        try {
            return this.umGroupListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.queryGroupListModel", (Throwable)e);
            return null;
        }
    }

    private int countGroupList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umGroupListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmGroupServiceImpl.countGroupList", (Throwable)e);
        }
        return i;
    }

    private UmGroupList createUmGroupList(UmGroupListDomain umGroupListDomain) {
        String msg = this.checkGroupList(umGroupListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.saveGroupList.checkGroupList", msg);
        }
        UmGroupList umGroupList = this.makeGroupList(umGroupListDomain, null);
        this.setGroupListDefault(umGroupList);
        return umGroupList;
    }

    @Override
    public String saveGroup(UmGroupDomain umGroupDomain) throws ApiException {
        UmGroup umGroup = this.createUmGroup(umGroupDomain);
        this.saveGroupModel(umGroup);
        return umGroup.getGroupCode();
    }

    @Override
    public String saveGroupBatch(List<UmGroupDomain> umGroupDomainList) throws ApiException {
        if (null == umGroupDomainList || umGroupDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmGroup> umGroupList = new ArrayList<UmGroup>();
        String code = "";
        for (UmGroupDomain umGroupDomain : umGroupDomainList) {
            UmGroup umGroup = this.createUmGroup(umGroupDomain);
            code = umGroup.getGroupCode();
            umGroupList.add(umGroup);
        }
        this.saveGroupBatchModel(umGroupList);
        return code;
    }

    @Override
    public void updateGroupState(Integer groupId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupModel(groupId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupStateByCode(String tenantCode, String groupCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupModelByCode(tenantCode, groupCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroup(UmGroupDomain umGroupDomain) throws ApiException {
        String msg = this.checkGroup(umGroupDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.checkGroup", msg);
        }
        UmGroup oldUmGroup = this.getGroupModelById(umGroupDomain.getGroupId());
        if (null == oldUmGroup) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroup.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroup umGroup = this.makeGroup(umGroupDomain, oldUmGroup);
        this.setGroupUpdataDefault(umGroup);
        this.updateGroupModel(umGroup);
    }

    @Override
    public UmGroup getGroup(Integer groupId) {
        return this.getGroupModelById(groupId);
    }

    @Override
    public void deleteGroup(Integer groupId) throws ApiException {
        this.deleteGroupModel(groupId);
    }

    @Override
    public QueryResult<UmGroup> queryGroupPage(Map<String, Object> map) {
        List<UmGroup> umGroupList = this.queryGroupModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroup(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupList);
        return queryResult;
    }

    @Override
    public UmGroup getGroupByCode(String tenantCode, String groupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        return this.getGroupModelByCode(map);
    }

    @Override
    public void deleteGroupByCode(String tenantCode, String groupCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupCode", groupCode);
        this.delGroupModelByCode(map);
    }

    @Override
    public String saveGroupList(UmGroupListDomain umGroupListDomain) throws ApiException {
        UmGroupList umGroupList = this.createUmGroupList(umGroupListDomain);
        this.saveGroupListModel(umGroupList);
        return umGroupList.getGroupListCode();
    }

    @Override
    public String saveGroupListBatch(List<UmGroupListDomain> umGroupListDomainList) throws ApiException {
        if (null == umGroupListDomainList || umGroupListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmGroupList> umGroupListList = new ArrayList<UmGroupList>();
        String code = "";
        for (UmGroupListDomain umGroupListDomain : umGroupListDomainList) {
            UmGroupList umGroupList = this.createUmGroupList(umGroupListDomain);
            code = umGroupList.getGroupListCode();
            umGroupListList.add(umGroupList);
        }
        this.saveGroupListBatchModel(umGroupListList);
        return code;
    }

    @Override
    public void updateGroupListState(Integer groupListId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupListModel(groupListId, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupListStateByCode(String tenantCode, String groupListCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateGroupListModelByCode(tenantCode, groupListCode, dataState, oldDataState, map);
    }

    @Override
    public void updateGroupList(UmGroupListDomain umGroupListDomain) throws ApiException {
        String msg = this.checkGroupList(umGroupListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupList.checkGroupList", msg);
        }
        UmGroupList oldUmGroupList = this.getGroupListModelById(umGroupListDomain.getGroupListId());
        if (null == oldUmGroupList) {
            throw new ApiException("um.USER.UmGroupServiceImpl.updateGroupList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmGroupList umGroupList = this.makeGroupList(umGroupListDomain, oldUmGroupList);
        this.setGroupListUpdataDefault(umGroupList);
        this.updateGroupListModel(umGroupList);
    }

    @Override
    public UmGroupList getGroupList(Integer groupListId) {
        return this.getGroupListModelById(groupListId);
    }

    @Override
    public void deleteGroupList(Integer groupListId) throws ApiException {
        this.deleteGroupListModel(groupListId);
    }

    @Override
    public QueryResult<UmGroupList> queryGroupListPage(Map<String, Object> map) {
        List<UmGroupList> umGroupListList = this.queryGroupListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countGroupList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umGroupListList);
        return queryResult;
    }

    @Override
    public UmGroupList getGroupListByCode(String tenantCode, String groupListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        return this.getGroupListModelByCode(map);
    }

    @Override
    public void deleteGroupListByCode(String tenantCode, String groupListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("groupListCode", groupListCode);
        this.delGroupListModelByCode(map);
    }
}

