/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.domain.MerberType;
import com.yqbsoft.laser.service.user.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserBean;
import com.yqbsoft.laser.service.user.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.user.domain.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.user.es.EsEnginePutThread;
import com.yqbsoft.laser.service.user.model.UmUser;
import com.yqbsoft.laser.service.user.model.UmUserinfo;
import com.yqbsoft.laser.service.user.model.UmUsersend;
import com.yqbsoft.laser.service.user.service.UserBaseService;
import com.yqbsoft.laser.service.user.service.UserService;
import com.yqbsoft.laser.service.user.service.impl.UmUsersendServiceImpl;
import com.yqbsoft.laser.service.user.service.impl.UserinfoPollThread;
import com.yqbsoft.laser.service.user.service.impl.UserinfoPutThread;
import com.yqbsoft.laser.service.user.service.impl.UserinfoService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class UserServiceImpl
extends BaseServiceImpl
implements UserService {
    public static final String SYS_CODE = "um.USER.UserServiceImpl";
    private UserBaseService userBaseService;
    private static UserinfoService userinfoService;
    private static Object lock;
    String sendMnsApi = "mns.mns.sendMnslist";

    public void setUserBaseService(UserBaseService userBaseService) {
        this.userBaseService = userBaseService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserinfoService getUserinfoService() {
        Object object = lock;
        synchronized (object) {
            if (null == userinfoService) {
                userinfoService = new UserinfoService((UserService)SpringApplicationContextUtil.getBean((String)"userService"));
                userinfoService.putExecutor(50, 2000, 30L, TimeUnit.SECONDS, new SynchronousQueue(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
                for (int i = 0; i < 200; ++i) {
                    userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                }
            }
            return userinfoService;
        }
    }

    @Override
    public UmUser saveUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        return this.userBaseService.saveUser(umUserDomainBean);
    }

    @Override
    public void updateUserState(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        this.userBaseService.updateUserState(userId, dataState, oldDataState);
    }

    @Override
    public void updateUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        this.userBaseService.updateUser(umUserDomainBean);
    }

    @Override
    public void updateUserByCode(UmUserDomainBean umUserDomainBean) throws ApiException {
        this.userBaseService.updateUserByCode(umUserDomainBean);
    }

    @Override
    public void updateUserRegister(Integer userId, Integer dataState, String memo) throws ApiException {
        this.userBaseService.updateUserRegister(userId, dataState, memo);
    }

    @Override
    public UmUser getUser(Integer userId) {
        return this.userBaseService.getUser(userId);
    }

    @Override
    public UmUser getUserByCode(String userCode) {
        return this.userBaseService.getUserByCode(userCode);
    }

    @Override
    public void updateUserLoginByCode(String userCode, String memo, String tenantCode) {
        this.userBaseService.updateUserLoginByCode(userCode, memo, tenantCode);
    }

    @Override
    public UmUser getUserByUnique(UmUser umUserSearch) {
        return this.userBaseService.getUserByUnique(umUserSearch);
    }

    @Override
    public UmUser getUserByUserCode(String userCode, String tenantCode) {
        return this.userBaseService.getUserByUserCode(userCode, tenantCode);
    }

    @Override
    public UmUser getUserByName(String userName, String tenantCode) {
        return this.userBaseService.getUserByName(userName, tenantCode);
    }

    @Override
    public String getUserByNickName(String userNickname, String tenantCode) {
        return this.userBaseService.getUserByNickName(userNickname, tenantCode);
    }

    @Override
    public void deleteUser(Integer userId) throws ApiException {
        this.userBaseService.deleteUser(userId);
    }

    @Override
    public QueryResult<UmUser> queryUserPage(Map<String, Object> map) {
        return this.userBaseService.queryUserPage(map);
    }

    @Override
    public List<UmUser> queryUserList(Map<String, Object> map) {
        return this.userBaseService.queryUserList(map);
    }

    @Override
    public String saveUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        return this.userBaseService.saveUserinfo(umUserinfoDomainBean);
    }

    @Override
    public void updateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.userBaseService.updateUserinfoState(userinfoId, dataState, oldDataState);
    }

    @Override
    public void sendUpdateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        UmUsersend umUsersend = this.userBaseService.updateUserinfoState(userinfoId, dataState, oldDataState);
        if (null != umUsersend) {
            ArrayList<UmUsersend> umUsersendList = new ArrayList<UmUsersend>();
            umUsersendList.add(umUsersend);
            UmUsersendServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(UmUsersendServiceImpl.getEsEngineService(), umUsersendList));
        }
    }

    @Override
    public void updateUserinfoSync(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        this.userBaseService.updateUserinfoSync(userCode, userinfoTestsync, userinfoProdsync);
    }

    @Override
    public void updateUserinfoFeeStatus(String userCode, Integer userinfoFeeStatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        this.userBaseService.updateUserinfoFeeStatus(userCode, userinfoFeeStatus, userinfoFeeEdate, dataState);
    }

    @Override
    public void updateUserinfoRealname(String userinfoCode, String userinfoEdate, Integer dataState) throws ApiException {
        this.userBaseService.updateUserinfoRealname(userinfoCode, userinfoEdate, dataState);
    }

    @Override
    public void updateUserinfoByUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        this.userBaseService.updateUserinfoByUserinfoCode(umUserinfoDomainBean);
    }

    @Override
    public void updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        this.userBaseService.updateUserinfo(umUserinfoDomainBean);
    }

    @Override
    public UmUserinfo getUserinfo(Integer userinfoId) {
        return this.userBaseService.getUserinfo(userinfoId);
    }

    @Override
    public UmUserinfo getUserinfoByUserCode(String userinfoCode, String tenantCode) {
        return this.userBaseService.getUserinfoByUserCode(userinfoCode, tenantCode);
    }

    @Override
    public void deleteUserinfo(Integer userinfoId) throws ApiException {
        this.userBaseService.deleteUserinfo(userinfoId);
    }

    @Override
    public QueryResult<UmUserinfo> queryUserinfoPage(Map<String, Object> map) {
        return this.userBaseService.queryUserinfoPage(map);
    }

    @Override
    public List<UmUserinfo> queryUserinfoList(Map<String, Object> map) {
        return this.userBaseService.queryUserinfoList(map);
    }

    @Override
    public void updateUserPwsswd(int userId, String userPwsswd) throws ApiException {
        this.userBaseService.updateUserPwsswd(userId, userPwsswd);
    }

    @Override
    public void updateUserinfoConPhone(int userinfoId, String userinfoConPhone) throws ApiException {
        this.userBaseService.updateUserinfoConPhone(userinfoId, userinfoConPhone);
    }

    @Override
    public void updateInvalidateUserinfo() throws ApiException {
        this.userBaseService.updateInvalidateUserinfo();
    }

    @Override
    public void sendMnsInvalidateUserinfo() throws ApiException {
        this.userBaseService.sendMnsInvalidateUserinfo();
    }

    @Override
    public void executeOverdueRemind() {
        this.userBaseService.executeOverdueRemind();
    }

    @Override
    public void executeOverdueUpdate() {
        this.userBaseService.executeOverdueUpdate();
    }

    @Override
    public UmUserBean queryUmuserCheck(String userName, String password, String appmanageIcode, String tenantCode, String isValid) {
        return this.userBaseService.queryUmuserCheck(userName, password, appmanageIcode, tenantCode, isValid);
    }

    @Override
    public UmUser saveUmuserAll(UmUserDomainBean umUserDomainBean) {
        return this.userBaseService.saveUmuserAll(umUserDomainBean);
    }

    @Override
    public UmUser saveUmuserAndInfo(UmUserDomainBean umUserDomainBean, UmUserinfoDomainBean umUserinfoDomainBean) {
        return this.userBaseService.saveUmuserAndInfo(umUserDomainBean, umUserinfoDomainBean);
    }

    @Override
    public UmUser getUserByNameOrPhone(Map<String, Object> map) {
        return this.userBaseService.getUserByNameOrPhone(map);
    }

    @Override
    public Map<String, Object> saveInitUser(Map<String, Object> map) throws ApiException {
        return this.userBaseService.saveInitUser(map);
    }

    @Override
    public Map<String, Object> saveUserOrTeam(Map<String, Object> map) throws ApiException {
        return this.userBaseService.saveUserOrTeam(map);
    }

    @Override
    public List<UmUser> getUsersByRelnames(List<UmUserDomainBean> list) {
        return this.userBaseService.getUsersByRelnames(list);
    }

    @Override
    public boolean updateUserValid(Map<String, Object> map) throws ApiException {
        return this.userBaseService.updateUserValid(map);
    }

    @Override
    public List<UmUser> getManagerByCode(Map<String, Object> map) throws ApiException {
        return this.userBaseService.getManagerByCode(map);
    }

    @Override
    public Map<String, Object> getDirectManagerByCode(Map<String, Object> map) throws ApiException {
        return this.userBaseService.getDirectManagerByCode(map);
    }

    @Override
    public Map<String, Object> updateUserPhoneByUserPhone(Map<String, Object> map) throws ApiException {
        return this.userBaseService.updateUserPhoneByUserPhone(map);
    }

    @Override
    public UmUserinfo getUserinfoByCode(String userinfoCode, String tenantCode) {
        return this.userBaseService.getUserinfoByCode(userinfoCode, tenantCode);
    }

    @Override
    public List<String> getAllManagerByCode(String userCode, String tenantCode) throws ApiException {
        return this.userBaseService.getAllManagerByCode(userCode, tenantCode);
    }

    @Override
    public void sendUserinfo(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserServiceImpl.sendUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        int i = this.userBaseService.updateOpenUserinfoModelByCode(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 1, 0);
        if (i < 0) {
            throw new ApiException("um.USER.UserServiceImpl.sendUserinfo.datastate");
        }
        if (i == 0) {
            return;
        }
        String apiCode = "vd.faccount.saveOpenFaccoun";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain = new VdFaccountOuterCtrlDomain();
        String batchcode = "0201";
        if (MerberType.PRE.getCode().equals(String.valueOf(umUserinfo.getUserinfoType()))) {
            batchcode = "0101";
        }
        vdFaccountOuterCtrlDomain.setFaccountDefBatchcode(batchcode);
        vdFaccountOuterCtrlDomain.setMerchantCode(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setMerchantName(null == umUserinfo.getUserinfoCompname() ? umUserinfo.getUserinfoPhone() : umUserinfo.getUserinfoCompname());
        vdFaccountOuterCtrlDomain.setTenantCode(umUserinfo.getTenantCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlExno(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlCallurl("um.user.udateCallFaccount");
        paramMap.put("vdFaccountOuterCtrlDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterCtrlDomain));
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    @Override
    public void loadUserinfoProcess() {
        this.userBaseService.loadUserinfoProcess();
    }

    @Override
    public String sendOpenUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        this.logger.info("um.USER.UserServiceImpl.sendOpenUserinfo ---------*********---------" + umUserDomainBean.getTenantCode());
        UmUserinfo umUserinfo = this.userBaseService.saveAllReInfo(umUserDomainBean);
        String userinfoCode = umUserinfo.getUserinfoCode();
        String tenantCode = "00000000";
        String userinfoPhone = umUserinfo.getUserinfoPhone();
        String randomNum = umUserinfo.getMemo();
        String s = this.sendMnsToUser(userinfoCode, tenantCode, userinfoPhone, randomNum, tenantCode);
        if (!"success".equals(s)) {
            this.logger.error("um.USER.UserServiceImplsendOpenUserinfo=randomNum=" + randomNum);
        }
        umUserinfo.setMemo(null);
        this.logger.info("um.USER.UserServiceImpl.sendOpenUserinfo ---------*********--------- saveAllReInfo out");
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        umUserinfoList.add(umUserinfo);
        this.getUserinfoService().addPutPool(new UserinfoPutThread(this.getUserinfoService(), umUserinfoList));
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", umUserinfo.getUserinfoCode());
        map.put("tenantCode", umUserinfo.getTenantCode());
        QueryResult<UmUsersend> qUmUsersend = this.userBaseService.queryUsersendPage(map);
        if (null != qUmUsersend && ListUtil.isNotEmpty((Collection)qUmUsersend.getList())) {
            UmUsersendServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(UmUsersendServiceImpl.getEsEngineService(), qUmUsersend.getList()));
        }
        return umUserinfo.getUserinfoCode();
    }

    private String sendMnsToUser(String userinfoCode, String tenantCode, String userinfoPhone, String randomNum, String dataTenant) {
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnschannelType(0);
        mnsMnslistDomainBean.setMnslistBustype("umPwd");
        mnsMnslistDomainBean.setMnslistBusname("\u7528\u6237\u968f\u673a\u7801");
        mnsMnslistDomainBean.setMemberCode(userinfoCode);
        mnsMnslistDomainBean.setDataTenant(dataTenant);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> mape = new HashMap<String, String>();
        mape.put("telphone", userinfoPhone);
        receiverList.add(mape);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("phone", userinfoPhone);
        contentMap.put("randomNum", randomNum);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        String params = JsonUtil.buildNonDefaultBinder().toJson(expMap);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        HashMap<String, String> mnsMap = new HashMap<String, String>();
        mnsMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        String json = this.internalInvoke(this.sendMnsApi, mnsMap);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("um.USER.UserServiceImpl.sendMnsToUser", (Object)"sendMns is blank!");
            return "um.USER.UserServiceImplsendMnsToUsersendMns is blank!";
        }
        return "success";
    }

    @Override
    public void udateCallFaccount(String faccountExno, String faccountCall, String tenantCode) {
        this.userBaseService.udateCallFaccount(faccountExno, faccountCall, tenantCode);
    }

    @Override
    public void sendBigDataForUser(Map<String, Object> map) {
        this.userBaseService.sendBigDataForUser(map);
    }

    @Override
    public void updateUserPaywd(String userCode, String tenantCode, String userPaywd, String oldUserPaywd) throws ApiException {
        this.userBaseService.updateUserPaywd(userCode, tenantCode, userPaywd, oldUserPaywd);
    }

    @Override
    public Map<String, Object> queryCheckPaywd(String userCode, String tenantCode, String userPaywd, String proappCode) throws ApiException {
        return this.userBaseService.queryCheckPaywd(userCode, tenantCode, userPaywd, proappCode);
    }

    @Override
    public UmUserinfo getUserinfoModelByUserCode(String userinfoCode, String tenantCode) throws ApiException {
        return this.userBaseService.getUserinfoModelByUserCode(userinfoCode, tenantCode);
    }

    @Override
    public UmUserinfo getUserinfoByTenCode(String tenantCode) throws ApiException {
        return this.userBaseService.getUserinfoByTenCode(tenantCode);
    }

    @Override
    public void updateUserByUserPcode(String userinfoCode, String tenantCode) throws ApiException {
        this.userBaseService.updateUserByUserPcode(userinfoCode, tenantCode);
    }

    @Override
    public UmUser getUserByUserOcode(Map<String, Object> map) throws ApiException {
        return this.userBaseService.getUserByUserOcode(map);
    }

    @Override
    public UmUser getUserByNameAndPhone(String userName, String phone, String tenantCode) {
        return this.userBaseService.getUserByNameAndPhone(userName, phone, tenantCode);
    }

    @Override
    public UmUser getUserByUserPhone(String userPhone, String tenantCode) {
        return this.userBaseService.getUserByUserPhone(userPhone, tenantCode);
    }

    @Override
    public void updateOcodeByUserName(String userOcode, String userName, String tenantCode) throws ApiException {
        this.userBaseService.updateOcodeByUserName(userOcode, userName, tenantCode);
    }

    @Override
    public String signCA(String userCode, String userPcode, String tenantCode) throws ApiException {
        return this.userBaseService.signCA(userCode, userPcode, tenantCode);
    }

    @Override
    public UmUserinfo getUserInfoByPhone(String userInfoPhone, String tenantCode) {
        return this.userBaseService.getUserInfoByPhone(userInfoPhone, tenantCode);
    }

    @Override
    public void updateUserCacode(String userPhone, String userCacode, String tenantCode) {
        this.userBaseService.updateUserCacode(userPhone, userCacode, tenantCode);
    }

    @Override
    public void updateStoreState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.userBaseService.updateStoreState(userinfoId, dataState, oldDataState);
    }

    @Override
    public String saveOpenUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        return this.userBaseService.saveOpenUserinfo(umUserDomainBean);
    }

    @Override
    public String sendOpenOperator(UmUserDomainBean umUserDomainBean) throws ApiException {
        this.logger.info("um.USER.UserServiceImpl.sendOpenOperator ---------*********---------" + umUserDomainBean.getTenantCode());
        UmUser umUser = this.userBaseService.saveOperatorByMns(umUserDomainBean);
        String userinfoCode = umUser.getUserPcode();
        String tenantCode = "00000000";
        String userinfoPhone = umUser.getUserPhone();
        String randomNum = umUser.getUserPwsswd();
        String s = this.sendMnsToUser(userinfoCode, tenantCode, userinfoPhone, randomNum, tenantCode);
        if (!"success".equals(s)) {
            this.logger.error("um.USER.UserServiceImplsendOpenUserinfo=randomNum=" + randomNum);
        }
        return umUser.getUserPcode();
    }

    static {
        lock = new Object();
    }
}

