/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmMemoauthMapper;
import com.yqbsoft.laser.service.user.domain.UmMemoauthDomain;
import com.yqbsoft.laser.service.user.domain.UmMemoauthReDomain;
import com.yqbsoft.laser.service.user.model.UmMemoauth;
import com.yqbsoft.laser.service.user.service.UmMemoauthService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmMemoauthServiceImpl
extends BaseServiceImpl
implements UmMemoauthService {
    private static final String SYS_CODE = SYS_CODE + ".UmMemoauthServiceImpl";
    private UmMemoauthMapper umMemoauthMapper;

    public void setUmMemoauthMapper(UmMemoauthMapper umMemoauthMapper) {
        this.umMemoauthMapper = umMemoauthMapper;
    }

    private Date getSysDate() {
        return null;
    }

    private String checkMemoauth(UmMemoauthDomain umMemoauthDomain) {
        if (null == umMemoauthDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umMemoauthDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemoauthDefault(UmMemoauth umMemoauth) {
        if (null == umMemoauth) {
            return;
        }
        if (null == umMemoauth.getDataState()) {
            umMemoauth.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umMemoauth.getGmtCreate()) {
            umMemoauth.setGmtCreate(date);
        }
        umMemoauth.setGmtModified(date);
        if (StringUtils.isBlank((String)umMemoauth.getMemoauthCode())) {
            umMemoauth.setMemoauthCode(this.getNo(null, "UmMemoauth", "umMemoauth", umMemoauth.getTenantCode()));
        }
    }

    private int getMemoauthMaxCode() {
        int code = 0;
        try {
            return this.umMemoauthMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemoauthMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemoauthUpdataDefault(UmMemoauth umMemoauth) {
        if (null == umMemoauth) {
            return;
        }
        umMemoauth.setGmtModified(this.getSysDate());
    }

    private void saveMemoauthModel(UmMemoauth umMemoauth) throws ApiException {
        if (null == umMemoauth) {
            return;
        }
        try {
            this.umMemoauthMapper.insert(umMemoauth);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveMemoauthModel.ex", (Throwable)e);
        }
    }

    private void saveMemoauthBatchModel(List<UmMemoauth> umMemoauthList) throws ApiException {
        if (null == umMemoauthList || umMemoauthList.isEmpty()) {
            return;
        }
        try {
            this.umMemoauthMapper.insertBatch(umMemoauthList);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveMemoauthBatchModel.ex", (Throwable)e);
        }
    }

    private UmMemoauth getMemoauthModelById(Integer memoauthId) {
        if (null == memoauthId) {
            return null;
        }
        try {
            return this.umMemoauthMapper.selectByPrimaryKey(memoauthId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemoauthModelById", (Throwable)e);
            return null;
        }
    }

    private UmMemoauth getMemoauthModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umMemoauthMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getMemoauthModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemoauthModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemoauthMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".delMemoauthModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".delMemoauthModelByCode.num");
        }
    }

    private void deleteMemoauthModel(Integer memoauthId) throws ApiException {
        if (null == memoauthId) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemoauthMapper.deleteByPrimaryKey(memoauthId);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".deleteMemoauthModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".deleteMemoauthModel.num");
        }
    }

    private void updateMemoauthModel(UmMemoauth umMemoauth) throws ApiException {
        if (null == umMemoauth) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemoauthMapper.updateByPrimaryKey(umMemoauth);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateMemoauthModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateMemoauthModel.num");
        }
    }

    private void updateStateMemoauthModel(Integer memoauthId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memoauthId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memoauthId", memoauthId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemoauthMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemoauthModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateMemoauthModel.null");
        }
    }

    private void updateStateMemoauthModelByCode(String tenantCode, String memoauthCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memoauthCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memoauthCode", memoauthCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemoauthMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateMemoauthModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateMemoauthModelByCode.null");
        }
    }

    private UmMemoauth makeMemoauth(UmMemoauthDomain umMemoauthDomain, UmMemoauth umMemoauth) {
        if (null == umMemoauthDomain) {
            return null;
        }
        if (null == umMemoauth) {
            umMemoauth = new UmMemoauth();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umMemoauth, (Object)umMemoauthDomain);
            return umMemoauth;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeMemoauth", (Throwable)e);
            return null;
        }
    }

    private UmMemoauthReDomain makeUmMemoauthReDomain(UmMemoauth umMemoauth) {
        if (null == umMemoauth) {
            return null;
        }
        UmMemoauthReDomain umMemoauthReDomain = new UmMemoauthReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umMemoauthReDomain, (Object)umMemoauth);
            return umMemoauthReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeUmMemoauthReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmMemoauth> queryMemoauthModelPage(Map<String, Object> parammap) {
        try {
            return this.umMemoauthMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryMemoauthModel", (Throwable)e);
            return null;
        }
    }

    private int countMemoauth(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umMemoauthMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countMemoauth", (Throwable)e);
        }
        return i;
    }

    private UmMemoauth createUmMemoauth(UmMemoauthDomain umMemoauthDomain) {
        String msg = this.checkMemoauth(umMemoauthDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveMemoauth.checkMemoauth", msg);
        }
        UmMemoauth umMemoauth = this.makeMemoauth(umMemoauthDomain, null);
        this.setMemoauthDefault(umMemoauth);
        return umMemoauth;
    }

    @Override
    public String saveMemoauth(UmMemoauthDomain umMemoauthDomain) throws ApiException {
        UmMemoauth umMemoauth = this.createUmMemoauth(umMemoauthDomain);
        this.saveMemoauthModel(umMemoauth);
        return umMemoauth.getMemoauthCode();
    }

    @Override
    public String saveMemoauthBatch(List<UmMemoauthDomain> umMemoauthDomainList) throws ApiException {
        if (null == umMemoauthDomainList || umMemoauthDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmMemoauth> umMemoauthList = new ArrayList<UmMemoauth>();
        String code = "";
        for (UmMemoauthDomain umMemoauthDomain : umMemoauthDomainList) {
            UmMemoauth umMemoauth = this.createUmMemoauth(umMemoauthDomain);
            code = umMemoauth.getMemoauthCode();
            umMemoauthList.add(umMemoauth);
        }
        this.saveMemoauthBatchModel(umMemoauthList);
        return code;
    }

    @Override
    public void updateMemoauthState(Integer memoauthId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memoauthId) {
            return;
        }
        this.updateStateMemoauthModel(memoauthId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemoauthStateByCode(String tenantCode, String memoauthCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memoauthCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemoauthModelByCode(tenantCode, memoauthCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemoauth(UmMemoauthDomain umMemoauthDomain) throws ApiException {
        String msg = this.checkMemoauth(umMemoauthDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateMemoauth.checkMemoauth", msg);
        }
        UmMemoauth oldUmMemoauth = this.getMemoauthModelById(umMemoauthDomain.getMemoauthId());
        if (null == oldUmMemoauth) {
            throw new ApiException(SYS_CODE + ".updateMemoauth.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmMemoauth umMemoauth = this.makeMemoauth(umMemoauthDomain, oldUmMemoauth);
        this.setMemoauthUpdataDefault(umMemoauth);
        this.updateMemoauthModel(umMemoauth);
    }

    @Override
    public UmMemoauth getMemoauth(Integer memoauthId) {
        if (null == memoauthId) {
            return null;
        }
        return this.getMemoauthModelById(memoauthId);
    }

    @Override
    public void deleteMemoauth(Integer memoauthId) throws ApiException {
        if (null == memoauthId) {
            return;
        }
        this.deleteMemoauthModel(memoauthId);
    }

    @Override
    public QueryResult<UmMemoauth> queryMemoauthPage(Map<String, Object> map) {
        List<UmMemoauth> umMemoauthList = this.queryMemoauthModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemoauth(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umMemoauthList);
        return queryResult;
    }

    @Override
    public UmMemoauth getMemoauthByCode(String tenantCode, String memoauthCode) throws ApiException {
        if (StringUtils.isBlank((String)memoauthCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memoauthCode", memoauthCode);
        return this.getMemoauthModelByCode(map);
    }

    @Override
    public void deleteMemoauthByCode(String tenantCode, String memoauthCode) throws ApiException {
        if (StringUtils.isBlank((String)memoauthCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memoauthCode", memoauthCode);
        this.delMemoauthModelByCode(map);
    }
}

