/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmMemberRelationMapper;
import com.yqbsoft.laser.service.user.domain.UmMemberRelationDomain;
import com.yqbsoft.laser.service.user.domain.UmMemberRelationReDomain;
import com.yqbsoft.laser.service.user.model.UmMemberRelation;
import com.yqbsoft.laser.service.user.service.UmMemberRelationService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmMemberRelationServiceImpl
extends BaseServiceImpl
implements UmMemberRelationService {
    private static final String SYS_CODE = "um.USER.UmMemberRelationServiceImpl";
    private UmMemberRelationMapper umMemberRelationMapper;

    public void setUmMemberRelationMapper(UmMemberRelationMapper umMemberRelationMapper) {
        this.umMemberRelationMapper = umMemberRelationMapper;
    }

    private Date getSysDate() {
        try {
            return this.umMemberRelationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkMemberRelation(UmMemberRelationDomain umMemberRelationDomain) {
        if (null == umMemberRelationDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umMemberRelationDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setMemberRelationDefault(UmMemberRelation umMemberRelation) {
        if (null == umMemberRelation) {
            return;
        }
        if (null == umMemberRelation.getDataState()) {
            umMemberRelation.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umMemberRelation.getGmtCreate()) {
            umMemberRelation.setGmtCreate(date);
        }
        umMemberRelation.setGmtModified(date);
        if (StringUtils.isBlank((String)umMemberRelation.getMemberRelationCode())) {
            umMemberRelation.setMemberRelationCode(this.getNo(null, "UmMemberRelation", "umMemberRelation", umMemberRelation.getTenantCode()));
        }
    }

    private int getMemberRelationMaxCode() {
        int code = 0;
        try {
            return this.umMemberRelationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.getMemberRelationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setMemberRelationUpdataDefault(UmMemberRelation umMemberRelation) {
        if (null == umMemberRelation) {
            return;
        }
        umMemberRelation.setGmtModified(this.getSysDate());
    }

    private void saveMemberRelationModel(UmMemberRelation umMemberRelation) throws ApiException {
        if (null == umMemberRelation) {
            return;
        }
        try {
            this.umMemberRelationMapper.insert(umMemberRelation);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.saveMemberRelationModel.ex", (Throwable)e);
        }
    }

    private void saveMemberRelationBatchModel(List<UmMemberRelation> umMemberRelationList) throws ApiException {
        if (null == umMemberRelationList || umMemberRelationList.isEmpty()) {
            return;
        }
        try {
            this.umMemberRelationMapper.insertBatch(umMemberRelationList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.saveMemberRelationBatchModel.ex", (Throwable)e);
        }
    }

    private UmMemberRelation getMemberRelationModelById(Integer memberRelationId) {
        if (null == memberRelationId) {
            return null;
        }
        try {
            return this.umMemberRelationMapper.selectByPrimaryKey(memberRelationId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.getMemberRelationModelById", (Throwable)e);
            return null;
        }
    }

    private UmMemberRelation getMemberRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umMemberRelationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.getMemberRelationModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delMemberRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemberRelationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.delMemberRelationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.delMemberRelationModelByCode.num");
        }
    }

    private void deleteMemberRelationModel(Integer memberRelationId) throws ApiException {
        if (null == memberRelationId) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemberRelationMapper.deleteByPrimaryKey(memberRelationId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.deleteMemberRelationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.deleteMemberRelationModel.num");
        }
    }

    private void updateMemberRelationModel(UmMemberRelation umMemberRelation) throws ApiException {
        if (null == umMemberRelation) {
            return;
        }
        int i = 0;
        try {
            i = this.umMemberRelationMapper.updateByPrimaryKey(umMemberRelation);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateMemberRelationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateMemberRelationModel.num");
        }
    }

    private void updateStateMemberRelationModel(Integer memberRelationId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == memberRelationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberRelationId", memberRelationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemberRelationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateStateMemberRelationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateStateMemberRelationModel.null");
        }
    }

    private void updateStateMemberRelationModelByCode(String tenantCode, String memberRelationCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)memberRelationCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberRelationCode", memberRelationCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umMemberRelationMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateStateMemberRelationModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateStateMemberRelationModelByCode.null");
        }
    }

    private UmMemberRelation makeMemberRelation(UmMemberRelationDomain umMemberRelationDomain, UmMemberRelation umMemberRelation) {
        if (null == umMemberRelationDomain) {
            return null;
        }
        if (null == umMemberRelation) {
            umMemberRelation = new UmMemberRelation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umMemberRelation, (Object)umMemberRelationDomain);
            return umMemberRelation;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.makeMemberRelation", (Throwable)e);
            return null;
        }
    }

    private UmMemberRelationReDomain makeUmMemberRelationReDomain(UmMemberRelation umMemberRelation) {
        if (null == umMemberRelation) {
            return null;
        }
        UmMemberRelationReDomain umMemberRelationReDomain = new UmMemberRelationReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umMemberRelationReDomain, (Object)umMemberRelation);
            return umMemberRelationReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.makeUmMemberRelationReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmMemberRelation> queryMemberRelationModelPage(Map<String, Object> parammap) {
        try {
            return this.umMemberRelationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.queryMemberRelationModel", (Throwable)e);
            return null;
        }
    }

    private int countMemberRelation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umMemberRelationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmMemberRelationServiceImpl.countMemberRelation", (Throwable)e);
        }
        return i;
    }

    private UmMemberRelation createUmMemberRelation(UmMemberRelationDomain umMemberRelationDomain) {
        String msg = this.checkMemberRelation(umMemberRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.saveMemberRelation.checkMemberRelation", msg);
        }
        UmMemberRelation umMemberRelation = this.makeMemberRelation(umMemberRelationDomain, null);
        this.setMemberRelationDefault(umMemberRelation);
        return umMemberRelation;
    }

    @Override
    public String saveMemberRelation(UmMemberRelationDomain umMemberRelationDomain) throws ApiException {
        UmMemberRelation umMemberRelation = this.createUmMemberRelation(umMemberRelationDomain);
        this.saveMemberRelationModel(umMemberRelation);
        return umMemberRelation.getMemberRelationCode();
    }

    @Override
    public String saveMemberRelationBatch(List<UmMemberRelationDomain> umMemberRelationDomainList) throws ApiException {
        if (null == umMemberRelationDomainList || umMemberRelationDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmMemberRelation> umMemberRelationList = new ArrayList<UmMemberRelation>();
        String code = "";
        for (UmMemberRelationDomain umMemberRelationDomain : umMemberRelationDomainList) {
            UmMemberRelation umMemberRelation = this.createUmMemberRelation(umMemberRelationDomain);
            code = umMemberRelation.getMemberRelationCode();
            umMemberRelationList.add(umMemberRelation);
        }
        this.saveMemberRelationBatchModel(umMemberRelationList);
        return code;
    }

    @Override
    public void updateMemberRelationState(Integer memberRelationId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == memberRelationId) {
            return;
        }
        this.updateStateMemberRelationModel(memberRelationId, dataState, oldDataState, map);
    }

    @Override
    public void updateMemberRelationStateByCode(String tenantCode, String memberRelationCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)memberRelationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateMemberRelationModelByCode(tenantCode, memberRelationCode, dataState, oldDataState, map);
    }

    @Override
    public void updateMemberRelation(UmMemberRelationDomain umMemberRelationDomain) throws ApiException {
        String msg = this.checkMemberRelation(umMemberRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateMemberRelation.checkMemberRelation", msg);
        }
        UmMemberRelation oldUmMemberRelation = this.getMemberRelationModelById(umMemberRelationDomain.getMemberRelationId());
        if (null == oldUmMemberRelation) {
            throw new ApiException("um.USER.UmMemberRelationServiceImpl.updateMemberRelation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmMemberRelation umMemberRelation = this.makeMemberRelation(umMemberRelationDomain, oldUmMemberRelation);
        this.setMemberRelationUpdataDefault(umMemberRelation);
        this.updateMemberRelationModel(umMemberRelation);
    }

    @Override
    public UmMemberRelation getMemberRelation(Integer memberRelationId) {
        if (null == memberRelationId) {
            return null;
        }
        return this.getMemberRelationModelById(memberRelationId);
    }

    @Override
    public void deleteMemberRelation(Integer memberRelationId) throws ApiException {
        if (null == memberRelationId) {
            return;
        }
        this.deleteMemberRelationModel(memberRelationId);
    }

    @Override
    public QueryResult<UmMemberRelation> queryMemberRelationPage(Map<String, Object> map) {
        List<UmMemberRelation> umMemberRelationList = this.queryMemberRelationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countMemberRelation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umMemberRelationList);
        return queryResult;
    }

    @Override
    public UmMemberRelation getMemberRelationByCode(String tenantCode, String memberRelationCode) throws ApiException {
        if (StringUtils.isBlank((String)memberRelationCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberRelationCode", memberRelationCode);
        return this.getMemberRelationModelByCode(map);
    }

    @Override
    public void deleteMemberRelationByCode(String tenantCode, String memberRelationCode) throws ApiException {
        if (StringUtils.isBlank((String)memberRelationCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("memberRelationCode", memberRelationCode);
        this.delMemberRelationModelByCode(map);
    }
}

