/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmRelationMapper;
import com.yqbsoft.laser.service.user.domain.UmRelationDomain;
import com.yqbsoft.laser.service.user.model.UmRelation;
import com.yqbsoft.laser.service.user.service.UmRelationService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmRelationServiceImpl
extends BaseServiceImpl
implements UmRelationService {
    public static final String SYS_CODE = "um.USER.UmRelationServiceImpl";
    private UmRelationMapper umRelationMapper;

    public void setUmRelationMapper(UmRelationMapper umRelationMapper) {
        this.umRelationMapper = umRelationMapper;
    }

    private Date getSysDate() {
        try {
            return this.umRelationMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRelation(UmRelationDomain umRelationDomain) {
        if (null == umRelationDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setRelationDefault(UmRelation umRelation) {
        if (null == umRelation) {
            return;
        }
        if (null == umRelation.getDataState()) {
            umRelation.setDataState(0);
        }
        if (null == umRelation.getGmtCreate()) {
            umRelation.setGmtCreate(this.getSysDate());
        }
        umRelation.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)umRelation.getRelationCode())) {
            umRelation.setRelationCode(this.createUUIDString());
        }
    }

    private int getRelationMaxCode() {
        int code = 0;
        try {
            return this.umRelationMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getRelationMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRelationUpdataDefault(UmRelation umRelation) {
        if (null == umRelation) {
            return;
        }
        umRelation.setGmtModified(this.getSysDate());
    }

    private void saveRelationModel(UmRelation umRelation) throws ApiException {
        if (null == umRelation) {
            return;
        }
        try {
            this.umRelationMapper.insert(umRelation);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRelationServiceImpl.saveRelationModel.ex", (Throwable)e);
        }
    }

    private UmRelation getRelationModelById(Integer relationId) {
        if (null == relationId) {
            return null;
        }
        try {
            return this.umRelationMapper.selectByPrimaryKey(relationId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getRelationModelById", (Throwable)e);
            return null;
        }
    }

    public UmRelation getRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umRelationMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getRelationModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRelationModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umRelationMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRelationServiceImpl.delRelationModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRelationServiceImpl.delRelationModelByCode.num");
        }
    }

    private void deleteRelationModel(Integer relationId) throws ApiException {
        if (null == relationId) {
            return;
        }
        int i = 0;
        try {
            i = this.umRelationMapper.deleteByPrimaryKey(relationId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRelationServiceImpl.deleteRelationModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRelationServiceImpl.deleteRelationModel.num");
        }
    }

    private int updateRelationModel(UmRelation umRelation) throws ApiException {
        if (null == umRelation) {
            return 0;
        }
        try {
            return this.umRelationMapper.updateByPrimaryKeySelective(umRelation);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRelationServiceImpl.updateRelationModel.ex", (Throwable)e);
        }
    }

    private void updateStateRelationModel(Integer relationId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == relationId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("relationId", relationId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umRelationMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRelationServiceImpl.updateStateRelationModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmRelationServiceImpl.updateStateRelationModel.null");
        }
    }

    private UmRelation makeRelation(UmRelationDomain umRelationDomain, UmRelation umRelation) {
        if (null == umRelationDomain) {
            return null;
        }
        if (null == umRelation) {
            umRelation = new UmRelation();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umRelation, (Object)umRelationDomain);
            return umRelation;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.makeRelation", (Throwable)e);
            return null;
        }
    }

    private List<UmRelation> queryRelationModelPage(Map<String, Object> parammap) {
        try {
            return this.umRelationMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.queryRelationModel", (Throwable)e);
            return null;
        }
    }

    private int countRelation(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umRelationMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.countRelation", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveRelation(UmRelationDomain umRelationDomain) throws ApiException {
        String msg = this.checkRelation(umRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRelationServiceImpl.saveRelation.checkRelation", msg);
        }
        UmRelation umRelation = this.makeRelation(umRelationDomain, null);
        this.setRelationDefault(umRelation);
        this.saveRelationModel(umRelation);
    }

    @Override
    public void updateRelationState(Integer relationId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRelationModel(relationId, dataState, oldDataState);
    }

    @Override
    public void updateRelation(UmRelationDomain umRelationDomain) throws ApiException {
        String msg = this.checkRelation(umRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRelationServiceImpl.updateRelation.checkRelation", msg);
        }
        UmRelation oldUmRelation = this.getRelationModelById(umRelationDomain.getRelationId());
        if (null == oldUmRelation) {
            throw new ApiException("um.USER.UmRelationServiceImpl.updateRelation.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmRelation umRelation = this.makeRelation(umRelationDomain, oldUmRelation);
        this.setRelationUpdataDefault(umRelation);
        this.updateRelationModel(umRelation);
    }

    @Override
    public UmRelation getRelation(Integer relationId) {
        return this.getRelationModelById(relationId);
    }

    @Override
    public void deleteRelation(Integer relationId) throws ApiException {
        this.deleteRelationModel(relationId);
    }

    @Override
    public QueryResult<UmRelation> queryRelationPage(Map<String, Object> map) {
        List<UmRelation> umRelationList = this.queryRelationModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRelation(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umRelationList);
        return queryResult;
    }

    @Override
    public UmRelation getRelationByCode(Map<String, Object> map) {
        return this.getRelationModelByCode(map);
    }

    @Override
    public void delRelationByCode(Map<String, Object> map) throws ApiException {
        this.delRelationModelByCode(map);
    }

    @Override
    public UmRelation saveInitRelation(UmRelationDomain umRelationDomain) throws ApiException {
        String msg = this.checkRelation(umRelationDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRelationServiceImpl.saveInitRelation.checkRelation", msg);
        }
        UmRelation umRelation = this.makeRelation(umRelationDomain, null);
        this.setRelationDefault(umRelation);
        this.saveRelationModel(umRelation);
        return umRelation;
    }

    @Override
    public int updateRelationValid(Map<String, Object> map) throws ApiException {
        int i = this.updateRelationValidModel(map);
        if (i > 0) {
            return i;
        }
        throw new ApiException("um.USER.UmRelationServiceImpl.updateRelationValid", "\u4fee\u6539\u7528\u6237\u5728\u804c\u72b6\u6001\u5931\u8d25");
    }

    private int updateRelationValidModel(Map<String, Object> map) throws ApiException {
        try {
            return this.umRelationMapper.updateRelationValid(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.updateRelationValidModel", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int updateRelation(UmRelation umRelation) throws ApiException {
        return this.updateRelationModel(umRelation);
    }

    @Override
    public List<Map<String, Object>> getRelationTypeByTeamCode(Map<String, Object> map) throws ApiException {
        List<Map<String, Object>> list = this.getRelationTypeByTeamCodeModel(map);
        return list;
    }

    public List<Map<String, Object>> getRelationTypeByTeamCodeModel(Map<String, Object> map) throws ApiException {
        try {
            return this.umRelationMapper.getRelationTypeByTeamCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getRelationTypeByTeamCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public int updateRelationGroup(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return 0;
        }
        int i = this.updateRelationGroupModel(map);
        return i;
    }

    public int updateRelationGroupModel(Map<String, Object> map) {
        try {
            return this.umRelationMapper.updateRelationGroup(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.updateRelationGroupModel", (Throwable)e);
            return 0;
        }
    }

    @Override
    public Map<String, Object> getGroupByUserCode(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        return this.getGroupByUserCodeModel(map);
    }

    private Map<String, Object> getGroupByUserCodeModel(Map<String, Object> map) {
        try {
            return this.umRelationMapper.getGroupByUserCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRelationServiceImpl.getGroupByUserCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<UmRelation> queryRelationList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<UmRelation> queryRelationList = this.queryRelationModelPage(map);
        return queryRelationList;
    }
}

