/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmUconfigMapper;
import com.yqbsoft.laser.service.user.domain.UmUconfigDomain;
import com.yqbsoft.laser.service.user.domain.UmUconfigReDomain;
import com.yqbsoft.laser.service.user.model.UmUconfig;
import com.yqbsoft.laser.service.user.service.UmUconfigService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmUconfigServiceImpl
extends BaseServiceImpl
implements UmUconfigService {
    private static final String SYS_CODE = "um.USER.UmUconfigServiceImpl";
    private UmUconfigMapper umUconfigMapper;

    public void setUmUconfigMapper(UmUconfigMapper umUconfigMapper) {
        this.umUconfigMapper = umUconfigMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUconfigMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUmUconfig(UmUconfigDomain umUconfigDomain) {
        if (null == umUconfigDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umUconfigDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setUmUconfigDefault(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return;
        }
        if (null == umUconfig.getDataState()) {
            umUconfig.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umUconfig.getGmtCreate()) {
            umUconfig.setGmtCreate(date);
        }
        umUconfig.setGmtModified(date);
        if (StringUtils.isBlank((String)umUconfig.getUconfigCode())) {
            umUconfig.setUconfigCode(this.getNo(null, "UmUconfig", "umUconfig", umUconfig.getTenantCode()));
        }
    }

    private int getUmUconfigMaxCode() {
        int code = 0;
        try {
            return this.umUconfigMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUmUconfigUpdataDefault(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return;
        }
        umUconfig.setGmtModified(this.getSysDate());
    }

    private void saveUmUconfigModel(UmUconfig umUconfig) throws ApiException {
        if (null == umUconfig) {
            return;
        }
        try {
            this.umUconfigMapper.insert(umUconfig);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfigModel.ex", (Throwable)e);
        }
    }

    private void saveUmUconfigBatchModel(List<UmUconfig> umUconfigList) throws ApiException {
        if (null == umUconfigList || umUconfigList.isEmpty()) {
            return;
        }
        try {
            this.umUconfigMapper.insertBatch(umUconfigList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfigBatchModel.ex", (Throwable)e);
        }
    }

    private UmUconfig getUmUconfigModelById(Integer uconfigId) {
        if (null == uconfigId) {
            return null;
        }
        try {
            return this.umUconfigMapper.selectByPrimaryKey(uconfigId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigModelById", (Throwable)e);
            return null;
        }
    }

    private UmUconfig getUmUconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUconfigMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.getUmUconfigModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delUmUconfigModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.delUmUconfigModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.delUmUconfigModelByCode.num");
        }
    }

    private void deleteUmUconfigModel(Integer uconfigId) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.deleteByPrimaryKey(uconfigId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.deleteUmUconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.deleteUmUconfigModel.num");
        }
    }

    private void updateUmUconfigModel(UmUconfig umUconfig) throws ApiException {
        if (null == umUconfig) {
            return;
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateByPrimaryKey(umUconfig);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfigModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfigModel.num");
        }
    }

    private void updateStateUmUconfigModel(Integer uconfigId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == uconfigId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("uconfigId", uconfigId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModel.null");
        }
    }

    private void updateStateUmUconfigModelByCode(String tenantCode, String uconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umUconfigMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateStateUmUconfigModelByCode.null");
        }
    }

    private UmUconfig makeUmUconfig(UmUconfigDomain umUconfigDomain, UmUconfig umUconfig) {
        if (null == umUconfigDomain) {
            return null;
        }
        if (null == umUconfig) {
            umUconfig = new UmUconfig();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUconfig, (Object)umUconfigDomain);
            return umUconfig;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.makeUmUconfig", (Throwable)e);
            return null;
        }
    }

    private UmUconfigReDomain makeUmUconfigReDomain(UmUconfig umUconfig) {
        if (null == umUconfig) {
            return null;
        }
        UmUconfigReDomain umUconfigReDomain = new UmUconfigReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umUconfigReDomain, (Object)umUconfig);
            return umUconfigReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.makeUmUconfigReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmUconfig> queryUmUconfigModelPage(Map<String, Object> parammap) {
        try {
            return this.umUconfigMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.queryUmUconfigModel", (Throwable)e);
            return null;
        }
    }

    private int countUmUconfig(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUconfigMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmUconfigServiceImpl.countUmUconfig", (Throwable)e);
        }
        return i;
    }

    private UmUconfig createUmUconfig(UmUconfigDomain umUconfigDomain) {
        String msg = this.checkUmUconfig(umUconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.saveUmUconfig.checkUmUconfig", msg);
        }
        UmUconfig umUconfig = this.makeUmUconfig(umUconfigDomain, null);
        this.setUmUconfigDefault(umUconfig);
        return umUconfig;
    }

    @Override
    public String saveUmUconfig(UmUconfigDomain umUconfigDomain) throws ApiException {
        UmUconfig umUconfig = this.createUmUconfig(umUconfigDomain);
        this.saveUmUconfigModel(umUconfig);
        return umUconfig.getUconfigCode();
    }

    @Override
    public String saveUmUconfigBatch(List<UmUconfigDomain> umUconfigDomainList) throws ApiException {
        if (null == umUconfigDomainList || umUconfigDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmUconfig> umUconfigList = new ArrayList<UmUconfig>();
        String code = "";
        for (UmUconfigDomain umUconfigDomain : umUconfigDomainList) {
            UmUconfig umUconfig = this.createUmUconfig(umUconfigDomain);
            code = umUconfig.getUconfigCode();
            umUconfigList.add(umUconfig);
        }
        this.saveUmUconfigBatchModel(umUconfigList);
        return code;
    }

    @Override
    public void updateUmUconfigState(Integer uconfigId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        this.updateStateUmUconfigModel(uconfigId, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUconfigStateByCode(String tenantCode, String uconfigCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateUmUconfigModelByCode(tenantCode, uconfigCode, dataState, oldDataState, map);
    }

    @Override
    public void updateUmUconfig(UmUconfigDomain umUconfigDomain) throws ApiException {
        String msg = this.checkUmUconfig(umUconfigDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfig.checkUmUconfig", msg);
        }
        UmUconfig oldUmUconfig = this.getUmUconfigModelById(umUconfigDomain.getUconfigId());
        if (null == oldUmUconfig) {
            throw new ApiException("um.USER.UmUconfigServiceImpl.updateUmUconfig.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUconfig umUconfig = this.makeUmUconfig(umUconfigDomain, oldUmUconfig);
        this.setUmUconfigUpdataDefault(umUconfig);
        this.updateUmUconfigModel(umUconfig);
    }

    @Override
    public UmUconfig getUmUconfig(Integer uconfigId) {
        if (null == uconfigId) {
            return null;
        }
        return this.getUmUconfigModelById(uconfigId);
    }

    @Override
    public void deleteUmUconfig(Integer uconfigId) throws ApiException {
        if (null == uconfigId) {
            return;
        }
        this.deleteUmUconfigModel(uconfigId);
    }

    @Override
    public QueryResult<UmUconfig> queryUmUconfigPage(Map<String, Object> map) {
        List<UmUconfig> umUconfigList = this.queryUmUconfigModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUmUconfig(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUconfigList);
        return queryResult;
    }

    @Override
    public UmUconfig getUmUconfigByCode(String tenantCode, String uconfigCode) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        return this.getUmUconfigModelByCode(map);
    }

    @Override
    public void deleteUmUconfigByCode(String tenantCode, String uconfigCode) throws ApiException {
        if (StringUtils.isBlank((String)uconfigCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("uconfigCode", uconfigCode);
        this.delUmUconfigModelByCode(map);
    }
}

