/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.adapter.kafka.KafkaProducerUtil;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.ApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.point.ServletMain;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MD5Util;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.PhoneFormatCheckUtils;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.UserConstants;
import com.yqbsoft.laser.service.user.dao.UmUserMapper;
import com.yqbsoft.laser.service.user.dao.UmUserinfoMapper;
import com.yqbsoft.laser.service.user.domain.MerberType;
import com.yqbsoft.laser.service.user.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.user.domain.UmGroupDomain;
import com.yqbsoft.laser.service.user.domain.UmRelationDomain;
import com.yqbsoft.laser.service.user.domain.UmTeamDomain;
import com.yqbsoft.laser.service.user.domain.UmUserBean;
import com.yqbsoft.laser.service.user.domain.UmUserDomain;
import com.yqbsoft.laser.service.user.domain.UmUserDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserInfoSaveBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoQuaDomain;
import com.yqbsoft.laser.service.user.domain.UmUserinfoReDomainBean;
import com.yqbsoft.laser.service.user.domain.UmUserinfoapplyDomain;
import com.yqbsoft.laser.service.user.domain.UmUserinfoapplyQuaDomain;
import com.yqbsoft.laser.service.user.domain.UmUserinfoblakDomain;
import com.yqbsoft.laser.service.user.domain.UmUsersendDomain;
import com.yqbsoft.laser.service.user.domain.UserSendBean;
import com.yqbsoft.laser.service.user.domain.VdFaccountOuterCtrlDomain;
import com.yqbsoft.laser.service.user.es.EsEnginePutThread;
import com.yqbsoft.laser.service.user.model.TmTenant;
import com.yqbsoft.laser.service.user.model.UmGroupList;
import com.yqbsoft.laser.service.user.model.UmQuality;
import com.yqbsoft.laser.service.user.model.UmRelation;
import com.yqbsoft.laser.service.user.model.UmTeam;
import com.yqbsoft.laser.service.user.model.UmUser;
import com.yqbsoft.laser.service.user.model.UmUserinfo;
import com.yqbsoft.laser.service.user.model.UmUserinfoDataModel;
import com.yqbsoft.laser.service.user.model.UmUserinfoQua;
import com.yqbsoft.laser.service.user.model.UmUserinfoapply;
import com.yqbsoft.laser.service.user.model.UmUserinfoapplyQua;
import com.yqbsoft.laser.service.user.model.UmUserinfoblak;
import com.yqbsoft.laser.service.user.model.UmUsersend;
import com.yqbsoft.laser.service.user.service.UmGroupService;
import com.yqbsoft.laser.service.user.service.UmQualityService;
import com.yqbsoft.laser.service.user.service.UmRelationService;
import com.yqbsoft.laser.service.user.service.UmTeamService;
import com.yqbsoft.laser.service.user.service.UmUserinfoChannelService;
import com.yqbsoft.laser.service.user.service.UmUserinfoQuaService;
import com.yqbsoft.laser.service.user.service.UmUserinfoapplyQuaService;
import com.yqbsoft.laser.service.user.service.UmUserinfoapplyService;
import com.yqbsoft.laser.service.user.service.UmUserinfoblakService;
import com.yqbsoft.laser.service.user.service.UmUsersendBaseService;
import com.yqbsoft.laser.service.user.service.UserBaseService;
import com.yqbsoft.laser.service.user.service.UserService;
import com.yqbsoft.laser.service.user.service.impl.UmUsersendServiceImpl;
import com.yqbsoft.laser.service.user.service.impl.UserinfoPollThread;
import com.yqbsoft.laser.service.user.service.impl.UserinfoPutThread;
import com.yqbsoft.laser.service.user.service.impl.UserinfoService;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections.CollectionUtils;

public class UserBaseServiceImpl
extends BaseServiceImpl
implements UserBaseService {
    public static final String SYS_CODE = "um.USER.UserBaseServiceImpl";
    private UmUserMapper umUserMapper;
    private UmUserinfoMapper umUserinfoMapper;
    private UmTeamService umTeamService;
    private UmRelationService umRelationService;
    private UmUsersendBaseService umUsersendBaseService;
    private UmQualityService umQualityService;
    private UserService userService;
    private UmUserinfoblakService umUserinfoblakService;
    private UmUserinfoChannelService umUserinfoChannelService;
    private UmUserinfoapplyService umUserinfoapplyService;
    UmGroupService umGroupService;
    private UmUserinfoQuaService umUserinfoQuaService;
    String sendMnsApi = "mns.mns.sendMnslist";
    private static UserinfoService userinfoService;
    private static Object lock;
    String cacheUserkey = "os-UmUser";
    String cacheInfokey = "os-UmUserInfo";
    private UmUserinfoapplyQuaService umUserinfoapplyQuaService;

    public void setUmGroupService(UmGroupService umGroupService) {
        this.umGroupService = umGroupService;
    }

    public UmUserinfoChannelService getUmUserinfoChannelService() {
        if (null == this.umUserinfoChannelService) {
            this.umUserinfoChannelService = (UmUserinfoChannelService)ApplicationContextUtil.getService((String)"umUserinfoChannelService");
        }
        return this.umUserinfoChannelService;
    }

    public UmUserinfoapplyService getUmUserinfoapplyService() {
        if (null == this.umUserinfoapplyService) {
            this.umUserinfoapplyService = (UmUserinfoapplyService)ApplicationContextUtil.getService((String)"umUserinfoapplyService");
        }
        return this.umUserinfoapplyService;
    }

    public UmUserinfoblakService getUmUserinfoblakService() {
        if (null == this.umUserinfoblakService) {
            this.umUserinfoblakService = (UmUserinfoblakService)ApplicationContextUtil.getService((String)"umUserinfoblakService");
        }
        return this.umUserinfoblakService;
    }

    public UserService getUserService() {
        if (null == this.userService) {
            this.userService = (UserService)ApplicationContextUtil.getService((String)"userService");
        }
        return this.userService;
    }

    public UmQualityService getRsGoodsClassService() {
        if (null == this.umQualityService) {
            this.umQualityService = (UmQualityService)ApplicationContextUtil.getService((String)"umQualityService");
        }
        return this.umQualityService;
    }

    public void setUmTeamService(UmTeamService umTeamService) {
        this.umTeamService = umTeamService;
    }

    public void setUmRelationService(UmRelationService umRelationService) {
        this.umRelationService = umRelationService;
    }

    public void setUmUsersendBaseService(UmUsersendBaseService umUsersendBaseService) {
        this.umUsersendBaseService = umUsersendBaseService;
    }

    public void setUmUserMapper(UmUserMapper umUserMapper) {
        this.umUserMapper = umUserMapper;
    }

    public void setUmUserinfoMapper(UmUserinfoMapper umUserinfoMapper) {
        this.umUserinfoMapper = umUserinfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.umUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkUser(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (!StringUtils.isNotBlank((String)umUserDomainBean.getTenantCode())) {
            msg = msg + "TenantCode;";
        }
        if (!StringUtils.isNotBlank((String)umUserDomainBean.getUserPcode())) {
            msg = msg + "UserPcode;";
        }
        return msg;
    }

    private void setUserDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
        if (null == umUser.getDataState()) {
            umUser.setDataState(0);
        }
        if (null == umUser.getGmtCreate()) {
            umUser.setGmtCreate(this.getSysDate());
        }
        if (StringUtils.isNotBlank((String)umUser.getUserEmial())) {
            String verifyTime = DisUtil.getMap((String)"DdFalgSetting-key", (String)(umUser.getTenantCode() + "-OPEN_VERIFY_TIME-OPEN_VERIFY_TIME"));
            if (null != verifyTime) {
                umUser.setGmtValid(this.getGmtValid(Integer.parseInt(verifyTime)));
            } else {
                umUser.setGmtValid(this.getGmtValid(2));
            }
        }
        if (StringUtils.isBlank((String)umUser.getUserCode())) {
            umUser.setUserCode(this.getNo("", "UmUser", "UserCode", umUser.getTenantCode()));
        }
        if ("0".equals(String.valueOf(umUser.getUserType())) && StringUtils.isBlank((String)umUser.getUserPcode())) {
            umUser.setUserPcode(umUser.getUserCode());
        }
        if (StringUtils.isBlank((String)umUser.getUserName())) {
            umUser.setUserName(umUser.getUserCode());
        }
        if (StringUtils.isBlank((String)umUser.getUserinfoQuality())) {
            UmUserinfo umUserinfo = this.getUserinfoByCodeModel(umUser.getUserPcode(), umUser.getTenantCode());
            umUser.setUserinfoQuality(umUserinfo.getUserinfoQuality());
        }
    }

    private Date getGmtValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(11, validTime);
        return dar.getTime();
    }

    private Date getDayValid(int validTime) {
        Date date = new Date();
        Calendar dar = Calendar.getInstance();
        dar.setTime(date);
        dar.add(5, validTime);
        return dar.getTime();
    }

    private void setUserUpdataDefault(UmUser umUser) {
        if (null == umUser) {
            return;
        }
    }

    private int saveUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserModel.ex");
        }
        try {
            return this.umUserMapper.insert(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserModel.ex", (Throwable)e);
        }
    }

    private void updateUserModelByCode(String memo, String userCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memo", memo);
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.umUserMapper.updateUserByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserModelByCode.i");
        }
    }

    private void updateUserinfoParentModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateParentByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoParentModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoParentModel.num", map.toString());
        }
    }

    private void updateUserinfoLevel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateLevelByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoLevel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoLevel.num", map.toString());
        }
    }

    private void updateUserinfoDiscodeByCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateUserinfoDiscodeByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoDiscode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoDiscode.num", map.toString());
        }
    }

    private UmUser getUserModelById(Integer userId) {
        if (null == userId) {
            return null;
        }
        try {
            return this.umUserMapper.selectByPrimaryKey(userId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private UmUser getUserModelByCode(String userCode, String tenantCode) {
        if (null == userCode) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserModelByCode", (Throwable)e);
            return null;
        }
    }

    private UmUser getUserModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserModelByCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public UmUser getUserByUserCode(String userCode, String tenantCode) {
        if (null == userCode) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteUserModel(Integer userId) throws ApiException {
        if (null == userId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserMapper.deleteByPrimaryKey(userId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.deleteUserModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserBaseServiceImpl.deleteUserModel.num");
        }
    }

    private int updateUserCacodeModel(String userPhone, String userCacode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userPhone", userPhone);
        map.put("userCacode", userCacode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.updateUserCacodeModel(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserCacodeModel.ex");
        }
    }

    private int updateUserModel(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return 0;
        }
        try {
            return this.umUserMapper.updateByPrimaryKeySelective(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserModel.ex");
        }
    }

    private void updateUserModelByCode(UmUser umUser) throws ApiException {
        if (null == umUser) {
            return;
        }
        try {
            this.umUserMapper.updateByCode(umUser);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserModel.ex");
        }
    }

    private void updateStateUserModel(Integer userId, Integer dataState, Integer oldDataState, Map<String, Object> extmap) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (MapUtil.isNotEmpty(extmap)) {
            map.putAll(extmap);
        }
        int i = 0;
        try {
            i = this.umUserMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserModel.null");
        }
    }

    private UmUser makeUser(UmUserDomainBean umUserDomainBean, UmUser umUser) {
        if (null == umUserDomainBean) {
            return null;
        }
        if (null == umUser) {
            umUser = new UmUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUser, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.makeUser", (Throwable)e);
        }
        return umUser;
    }

    private List<UmUser> queryUserModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserModel", (Throwable)e);
            return null;
        }
    }

    private int countUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.countUser", (Throwable)e);
        }
        return i;
    }

    private String checkUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) {
        if (null == umUserinfoDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        return "";
    }

    private void setUserinfoDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
        Date date = this.getSysDate();
        if (null == umUserinfo.getDataState()) {
            umUserinfo.setDataState(0);
        }
        if (null == umUserinfo.getUserinfoType() || 0 == umUserinfo.getUserinfoType()) {
            umUserinfo.setUserinfoType(1);
        }
        if (null == umUserinfo.getUserinfoState()) {
            umUserinfo.setUserinfoState(0);
        }
        if (null == umUserinfo.getGmtCreate()) {
            umUserinfo.setGmtCreate(date);
        }
        if (StringUtils.isBlank((String)umUserinfo.getAreaCode())) {
            umUserinfo.setAreaCode("000021");
        }
        if ("agCode".equals(umUserinfo.getMemo())) {
            umUserinfo.setDataState(2);
        }
        if (umUserinfo.getAreaCode().length() < 6) {
            Long l = Long.valueOf(umUserinfo.getAreaCode());
            String no = String.format("%06d", l);
            umUserinfo.setAreaCode(no);
        } else if (umUserinfo.getAreaCode().length() > 6) {
            String area = umUserinfo.getAreaCode();
            Long l = Long.valueOf(area.substring(0, 4));
            String no = String.format("%06d", l);
            umUserinfo.setAreaCode(no);
        }
        umUserinfo.setGmtModified(date);
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoCode())) {
            String userinfoCode = this.getUserinfoCode(umUserinfo);
            umUserinfo.setUserinfoCode(userinfoCode);
        }
        umUserinfo.setMemo(null);
    }

    private String getUserinfoCode(UmUserinfo umUserinfo) {
        String userinfoCode = "";
        userinfoCode = userinfoCode + umUserinfo.getUserinfoType();
        userinfoCode = userinfoCode + umUserinfo.getAreaCode();
        String[] params = UserConstants.PARAMS_NO;
        userinfoCode = userinfoCode + this.getNo(params[0], params[1], params[2], umUserinfo.getTenantCode());
        userinfoCode = userinfoCode + RandomUtils.generateRandom((int)1, (Integer)0);
        return userinfoCode;
    }

    public int getMaxUserinfoCode() {
        int code = 0;
        try {
            return this.umUserinfoMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setUserinfoUpdataDefault(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            return;
        }
        String qualityCode = umUserinfo.getUserinfoQuality();
        String tenantCode = umUserinfo.getTenantCode();
        if (StringUtils.isBlank((String)qualityCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        String[] qualityCodeStr = qualityCode.split("\\,");
        if (null == qualityCodeStr) {
            return;
        }
        String qualityRole = umUserinfo.getRoleCode();
        if (null == qualityRole) {
            qualityRole = "";
        }
        for (String string : qualityCodeStr) {
            UmQuality umQuality = this.getRsGoodsClassService().getQualityByCode(tenantCode, string);
            if (umQuality == null || StringUtils.isBlank((String)umQuality.getQualityCode())) {
                umQuality = this.getRsGoodsClassService().getQualityByCode("00000000", string);
            }
            if (null == umQuality || !StringUtils.isNotBlank((String)umQuality.getQualityRole()) || qualityRole.indexOf(umQuality.getQualityRole()) >= 0) continue;
            if (StringUtils.isNotBlank((String)qualityRole)) {
                qualityRole = qualityRole + ",";
            }
            qualityRole = qualityRole + umQuality.getQualityRole();
        }
        umUserinfo.setRoleCode(qualityRole);
    }

    private int saveUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        int i = 0;
        if (null == umUserinfo) {
            return 0;
        }
        try {
            i = this.umUserinfoMapper.insert(umUserinfo);
            if (i < 0) {
                this.logger.error("um.USER.UserBaseServiceImpl.saveUserinfoModel=================", (Object)"\u63d2\u5165\u5931\u8d25!");
            }
            return i;
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserinfoModel.ex", (Throwable)e);
        }
    }

    private int updateUserinfoDataStateByCode(String userinfoCode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        if (MapUtil.isEmpty(map)) {
            return 0;
        }
        try {
            return this.umUserinfoMapper.updateUserinfoDataStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoDataStateByCode.ex", (Throwable)e);
        }
    }

    private boolean updateUcodeModelByCode(String userinfoUcode, String userinfoCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return false;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoUcode", userinfoUcode);
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        if (MapUtil.isEmpty(map)) {
            return false;
        }
        try {
            int i = this.umUserinfoMapper.updateUcodeByCode(map);
            if (i > 0) {
                return true;
            }
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUcodeModelByCode.ex", ((Object)map).toString(), (Throwable)e);
        }
        return false;
    }

    private int updateUserinfoQualityCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return 0;
        }
        try {
            return this.umUserinfoMapper.updateUserinfoQualityCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoQualityCode.ex", (Throwable)e);
        }
    }

    private int updateUserQualityCode(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return 0;
        }
        try {
            return this.umUserMapper.updateUserQualityCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserQualityCode.ex", (Throwable)e);
        }
    }

    private UmUserinfo getUserinfoModelById(Integer userinfoId) {
        if (null == userinfoId) {
            return null;
        }
        try {
            return this.umUserinfoMapper.selectByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserinfoModelById", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo getUserinfoModelByCode(String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            List<UmUserinfo> list = this.umUserinfoMapper.query(map);
            if (null == list || list.isEmpty()) {
                return null;
            }
            return list.get(0);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserinfoModelByCode", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByName(String userName, String tenantCode) {
        if (null == userName) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userName", userName);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByName(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByName", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByNameAndPhone(String userName, String phone, String tenantCode) {
        if (null == userName) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPhone", phone);
        map.put("userName", userName);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByNameAndPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByNameAndPhone", (Throwable)e);
            return null;
        }
    }

    private UmUserinfo selectUserInfoByPhone(String userInfoPhone, String tenantCode) {
        if (null == userInfoPhone) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userInfoPhone", userInfoPhone);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserinfoMapper.selectUserInfoByPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByNameAndPhone", (Throwable)e);
            return null;
        }
    }

    private UmUser getByOcode(String userOcode, String tenantCode) {
        if (StringUtils.isBlank((String)userOcode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userOcode", userOcode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.getByOcode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getByOcode", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByPhone(String userPhone, String tenantCode) {
        if (null == userPhone) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userPhone", userPhone);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByPhone", (Throwable)e);
            return null;
        }
    }

    private UmUser selectByEmail(String userEmial, String tenantCode) {
        if (null == userEmial) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userEmial", userEmial);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserMapper.selectByPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByEmail", (Throwable)e);
            return null;
        }
    }

    @Override
    public UmUserinfo getUserinfoModelByUserCode(String userinfoCode, String tenantCode) {
        if (null == userinfoCode) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserinfoModelByUserCode", (Throwable)e);
            return null;
        }
    }

    @Override
    public UmUserinfo getUserinfoByTenCode(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserinfoByQualty", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return null;
        }
        String quality = "plat";
        List<UmUserinfo> userinfos = this.umUserinfoMapper.query(this.getQueryMapParam("tenantCode,userinfoQuality", new Object[]{tenantCode, quality}));
        return null == userinfos ? null : userinfos.get(0);
    }

    private void deleteUserinfoModel(Integer userinfoId) throws ApiException {
        if (null == userinfoId) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.deleteByPrimaryKey(userinfoId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.deleteUserinfoModel.ex");
        }
        if (1 != i) {
            throw new ApiException("um.USER.UserBaseServiceImpl.deleteUserinfoModel.num");
        }
    }

    private void updateUserinfoModel(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            return;
        }
        try {
            this.umUserinfoMapper.updateByPrimaryKeySelective(umUserinfo);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateUserinfoModel.e", (Throwable)e);
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoModel.ex");
        }
    }

    private void updateUserOcodeModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            this.umUserMapper.updateUserOcode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserOcodeModel.ex", map.toString());
        }
    }

    private void updateUserinfoOrgModel(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            return;
        }
        try {
            this.umUserinfoMapper.updateUserinfoOrg(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoOrgModel.ex", map.toString());
        }
    }

    private void updateStateUserinfoModel(Integer userinfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    @Override
    public UmUsersend updateCompanyCodeByCode(String userinfoCode, String tenantCode, String companyCode) throws ApiException {
        if (userinfoCode.equals("") || companyCode.equals("")) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("companyCode", companyCode);
        this.updateCompanyCode(map);
        UmUserinfo umUserinfo = this.getUserinfoByCode(userinfoCode, tenantCode);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(umUserinfo.getTenantCode());
        this.updateUserInfoCache(tenantCode, userinfoCode);
        return this.umUsersendBaseService.sendUsersend(umUsersendDomain);
    }

    private void updateCompanyCode(Map<String, Object> map) throws ApiException {
        if (null == map.get("userinfoCode") || null == map.get("companyCode")) {
            return;
        }
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateStateUserinfoCodeModel(String userinfoCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoCodeModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoCodeModel.null");
        }
    }

    private void updateStateAndMemoUserinfoModel(Integer userinfoId, Integer dataState, Integer oldDataState, String memo) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateSyncUserinfoModel(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoTestsync", userinfoTestsync);
        map.put("userinfoProdsync", userinfoProdsync);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateSyncByUserCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateFeeUserinfoModel(String userCode, Integer userinfoFeestatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        if (null == userCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("userinfoFeestatus", userinfoFeestatus);
        map.put("userinfoFeeEdate", DateUtil.getDateToString((String)userinfoFeeEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserBaseServiceImpl.updateFeeUserinfoModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateFeeByUserCode(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserBaseServiceImpl.updateFeeUserinfoModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserBaseServiceImpl.updateFeeUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    private void updateUserinfoRealnameModel(String userinfoCode, String userinfoEdate, Integer dataState) throws ApiException {
        if (null == userinfoCode) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("userinfoEdate", DateUtil.getDateToString((String)userinfoEdate, (String)"yyyy-MM-dd hh:mm:ss"));
        map.put("dataState", dataState);
        this.logger.debug("um.USER.UserBaseServiceImpl.updateUserinfoRealnameModel", (Object)JsonUtil.buildNormalBinder().toJson(map));
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateUserinfoRealname(map);
        }
        catch (Exception e) {
            this.logger.debug("um.USER.UserBaseServiceImpl.updateUserinfoRealnameModel", (Object)e.getMessage());
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoRealnameModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoRealnameModel.null");
        }
    }

    private UmUserinfo makeUserinfo(UmUserinfoDomainBean umUserinfoDomainBean, UmUserinfo umUserinfo) {
        if (null == umUserinfoDomainBean) {
            return null;
        }
        if (null == umUserinfo) {
            umUserinfo = new UmUserinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfo, (Object)umUserinfoDomainBean);
            umUserinfo.setDataState(umUserinfoDomainBean.getUserinfoDataState());
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.makeUserinfo", (Throwable)e);
        }
        return umUserinfo;
    }

    private UmUserinfoReDomainBean makeUserinfoReDomain(UmUserinfo umUserinfo, boolean falg) {
        if (null == umUserinfo) {
            return null;
        }
        UmUserinfoReDomainBean umUserinfoReDomainBean = new UmUserinfoReDomainBean();
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoReDomainBean, (Object)umUserinfo);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.makeUserinfoReDomain", (Throwable)e);
        }
        if (!falg) {
            umUserinfoReDomainBean.setUmUserinfoQuaDomainList(this.umUserinfoQuaService.queryUserinfoQuaRe(this.getQueryMapParam("userinfoCode,tenantCode", new Object[]{umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode()})));
        }
        return umUserinfoReDomainBean;
    }

    private List<UmUserinfoReDomainBean> makeListUserinfoReDomain(List<UmUserinfo> umUserinfoList, boolean falg) {
        if (ListUtil.isEmpty(umUserinfoList)) {
            return null;
        }
        ArrayList<UmUserinfoReDomainBean> beanList = new ArrayList<UmUserinfoReDomainBean>();
        for (UmUserinfo umUserinfo : umUserinfoList) {
            beanList.add(this.makeUserinfoReDomain(umUserinfo, falg));
        }
        return beanList;
    }

    private List<UmUserinfo> queryUserinfoModelPage(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfo> queryUserinfoModelList(Map<String, Object> parammap) {
        try {
            return this.umUserinfoMapper.queryUserinfoList(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserinfoModel", (Throwable)e);
            return null;
        }
    }

    private int countUserinfo(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserinfoMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.countUserinfo", (Throwable)e);
        }
        return i;
    }

    private int countPage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umUserinfoMapper.countPage(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.countUserinfo", (Throwable)e);
        }
        return i;
    }

    @Override
    public UmUser saveUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUser.checkUser", msg);
        }
        UmUser umUser = this.makeUser(umUserDomainBean, null);
        this.setUserDefault(umUser);
        String old = umUser.getUserPwsswd();
        if (null == old) {
            int i = (int)((Math.random() * 9.0 + 1.0) * 100000.0);
            old = i + "";
        }
        if ("-1".equals(old)) {
            old = null;
            umUser.setUserPwsswd(null);
        } else {
            umUser.setUserPwsswd(this.getMd5(old));
        }
        int result = this.saveUserModel(umUser);
        if (result == 1) {
            umUser.setUserPwsswd(old);
            return umUser;
        }
        return null;
    }

    @Override
    public UserSendBean saveSendUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUser umUser = this.saveUser(umUserDomainBean);
        if (null == umUser) {
            return null;
        }
        UserSendBean userSendBean = new UserSendBean();
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("u-insert");
        umUsersendDomain.setUserinfoCode(umUser.getUserCode());
        umUsersendDomain.setUserinfoType(umUser.getUserType());
        umUsersendDomain.setTenantCode(umUser.getTenantCode());
        UmUsersend umUsersend = this.umUsersendBaseService.sendUsersend(umUsersendDomain);
        userSendBean.setUmUser(umUser);
        userSendBean.setUmUsersend(umUsersend);
        return userSendBean;
    }

    @Override
    public void updateUserState(Integer userId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserModel(userId, dataState, oldDataState, null);
    }

    @Override
    public void updateUserStateByMap(Integer userId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateUserModel(userId, dataState, oldDataState, map);
    }

    @Override
    public void updateUser(UmUserDomainBean umUserDomainBean) throws ApiException {
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUser.checkUser", msg);
        }
        UmUser oldUmUser = this.getUserModelById(umUserDomainBean.getUserId());
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == umUserDomainBean.getUserType()) {
            umUserDomainBean.setUserType(oldUmUser.getUserType());
        }
        String userPcode = oldUmUser.getUserPcode();
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        umUserDomainBean.setUserPcode(userPcode);
        this.setUserUpdataDefault(umUser);
        this.updateUserModel(umUser);
    }

    @Override
    public void updateUserByCode(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUser oldUmUser;
        String msg = this.checkUser(umUserDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUser.checkUser", msg);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserPwsswd())) {
            umUserDomainBean.setUserPwsswd(this.getMd5(umUserDomainBean.getUserPwsswd()));
        }
        if (null == (oldUmUser = this.getUserModelByCode(umUserDomainBean.getUserCode(), umUserDomainBean.getTenantCode()))) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUser umUser = this.makeUser(umUserDomainBean, oldUmUser);
        this.setUserUpdataDefault(umUser);
        this.updateUserModelByCode(umUser);
    }

    @Override
    public void updateUserRegister(Integer userId, Integer dataState, String memo) throws ApiException {
        if (null == userId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userId", userId);
        map.put("dataState", dataState);
        map.put("memo", memo);
        int i = 0;
        try {
            i = this.umUserMapper.updateUserCheck(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.checkUserRegister.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.checkUserRegister.null");
        }
    }

    @Override
    public UmUser getUser(Integer userId) {
        return this.getUserModelById(userId);
    }

    @Override
    public UmUser getUserByCode(String userCode, String tenantCode) {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        return this.getUserModelByCode(map);
    }

    @Override
    public UmUser getUserByUnique(UmUser umUserSearch) {
        try {
            Objects.requireNonNull(umUserSearch);
            return this.umUserMapper.getUserByUnqiue(umUserSearch);
        }
        catch (Exception e) {
            this.logger.error("getUserByUnique.ERROR", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteUser(Integer userId) throws ApiException {
        this.deleteUserModel(userId);
    }

    @Override
    public QueryResult<UmUser> queryUserPage(Map<String, Object> map) {
        List<UmUser> umUserList = this.queryUserModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserList);
        return queryResult;
    }

    @Override
    public List<UmUser> queryUserList(Map<String, Object> map) {
        return this.queryUserModelPage(map);
    }

    @Override
    public String saveUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        return this.saveUserinfoCode(umUserinfoDomainBean);
    }

    private String saveUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveUserinfoReModel(umUserinfoDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        return umUserInfoSaveBean.getUmUserinfo().getUserinfoCode();
    }

    private UmUserInfoSaveBean saveUserinfoReModel(UmUserinfoDomainBean umUserinfoDomainBean) {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserinfo.checkUserinfo", msg);
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, null);
        this.setUserinfoDefault(umUserinfo);
        this.saveUserinfoModel(umUserinfo);
        if (ListUtil.isNotEmpty(umUserinfoDomainBean.getUmUserinfoQuaDomainList())) {
            this.saveOrUpdate(umUserinfo, umUserinfoDomainBean.getUmUserinfoQuaDomainList());
        }
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("insert");
        umUsersendDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(umUserinfo.getTenantCode());
        UmUsersend umUsersend = this.umUsersendBaseService.sendUsersend(umUsersendDomain);
        UmUserInfoSaveBean umUserInfoSaveBean = new UmUserInfoSaveBean();
        if (null != umUsersend) {
            ArrayList<UmUsersend> umUsersendList = new ArrayList<UmUsersend>();
            umUsersendList.add(umUsersend);
            umUserInfoSaveBean.setUmUsersendList(umUsersendList);
        }
        umUserInfoSaveBean.setUmUserinfo(umUserinfo);
        return umUserInfoSaveBean;
    }

    public UmUserinfoQuaService getUmUserinfoQuaService() {
        return this.umUserinfoQuaService;
    }

    public void setUmUserinfoQuaService(UmUserinfoQuaService umUserinfoQuaService) {
        this.umUserinfoQuaService = umUserinfoQuaService;
    }

    private void saveOrUpdate(UmUserinfo umUserinfo, List<UmUserinfoQuaDomain> umUserinfoQuaDomainList) {
        if (null == umUserinfo || ListUtil.isEmpty(umUserinfoQuaDomainList)) {
            return;
        }
        this.umUserinfoQuaService.deleteUserinfoQuaByUserinfoCode(umUserinfo.getTenantCode(), umUserinfoQuaDomainList.get(0).getQualityCode(), umUserinfo.getUserinfoCode());
        for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoQuaDomainList) {
            try {
                BeanUtils.copyAllPropertys((Object)umUserinfoQuaDomain, (Object)umUserinfo);
            }
            catch (Exception e) {}
        }
        this.umUserinfoQuaService.saveUserinfoQuaBatch(umUserinfoQuaDomainList);
    }

    @Override
    public UmUsersend updateUserinfoState(Integer userinfoId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        this.updateStateUserinfoModel(userinfoId, dataState, oldDataState, expmap);
        UmUserinfo umUserinfo = this.getUserinfo(userinfoId);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        String newDataState = String.valueOf(dataState).equals("0") ? "start" : "down";
        umUsersendDomain.setUsersendType(newDataState);
        umUsersendDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(umUserinfo.getTenantCode());
        this.updateUserInfoCache(umUserinfo.getTenantCode(), umUserinfo.getUserinfoCode());
        return this.umUsersendBaseService.sendUsersend(umUsersendDomain);
    }

    @Override
    public UmUsersend updateUserinfoStateByCode(String userinfoCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateUserinfoCodeModel(userinfoCode, tenantCode, dataState, oldDataState);
        UmUserinfo umUserinfo = this.getUserinfoByCode(userinfoCode, tenantCode);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        String newDataState = String.valueOf(dataState).equals("0") ? "start" : "down";
        umUsersendDomain.setUsersendType(newDataState);
        umUsersendDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(umUserinfo.getTenantCode());
        this.updateUserInfoCache(tenantCode, userinfoCode);
        return this.umUsersendBaseService.sendUsersend(umUsersendDomain);
    }

    @Override
    public void updateUserinfoSync(String userCode, Integer userinfoTestsync, Integer userinfoProdsync) throws ApiException {
        this.updateSyncUserinfoModel(userCode, userinfoTestsync, userinfoProdsync);
    }

    @Override
    public void updateUserinfoFeeStatus(String userCode, Integer userinfoFeeStatus, String userinfoFeeEdate, Integer dataState) throws ApiException {
        this.updateFeeUserinfoModel(userCode, userinfoFeeStatus, userinfoFeeEdate, dataState);
    }

    @Override
    public void updateUserinfoRealname(String userinfoCode, String userinfoEdate, Integer dataState) throws ApiException {
        this.updateUserinfoRealnameModel(userinfoCode, userinfoEdate, dataState);
    }

    @Override
    public void updateUserinfoByGroupToUser(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoByCode(umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getTenantCode());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoByGroupToUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo parentUmUserinfo = this.getUserinfoByCode(umUserinfoDomainBean.getUserinfoParentCode(), umUserinfoDomainBean.getTenantCode());
        if (null == parentUmUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoByGroupToUser.parentUmUserinfo", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        umUserinfo.setUserinfoParentName(parentUmUserinfo.getUserinfoParentName());
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public UmUsersend updateUserinfo(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        QueryResult<UmUser> umUserQueryResult;
        String newrole;
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(umUserinfoDomainBean.getUserinfoId());
        UmUserinfo umUserinfo = new UmUserinfo();
        String userinfoCode = umUserinfoDomainBean.getUserinfoCode();
        String tenantCode = umUserinfoDomainBean.getTenantCode();
        boolean flag = false;
        String newqua = umUserinfoDomainBean.getUserinfoQuality();
        if (null == newqua) {
            newqua = "";
        }
        if (null == (newrole = umUserinfoDomainBean.getRoleCode())) {
            newrole = "";
        }
        if (null == oldUmUserinfo) {
            oldUmUserinfo = this.getUserinfoByCode(umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getTenantCode());
            if (null == oldUmUserinfo) {
                throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
            }
            try {
                BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)oldUmUserinfo);
                BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)umUserinfoDomainBean);
            }
            catch (Exception e) {}
        } else {
            String oldrole;
            String oldqua = oldUmUserinfo.getUserinfoQuality();
            if (null == oldqua) {
                oldqua = "";
            }
            if (null == (oldrole = oldUmUserinfo.getRoleCode())) {
                oldrole = "";
            }
            if (!oldqua.equals(newqua)) {
                flag = true;
            }
            if (!newrole.equals(oldrole)) {
                flag = true;
            }
            umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
            Integer userinfoType = oldUmUserinfo.getUserinfoType();
            umUserinfo.setUserinfoType(userinfoType);
        }
        this.setUserinfoUpdataDefault(umUserinfo);
        this.updateUserinfoModel(umUserinfo);
        this.saveOrUpdate(umUserinfo, umUserinfoDomainBean.getUmUserinfoQuaDomainList());
        UmUser umUser = null;
        if (StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserName()) || StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserRelName())) {
            umUserQueryResult = this.queryUserPage(this.getQueryParamMap("tenantCode,userPcode", new Object[]{tenantCode, userinfoCode}));
            if (null != umUserQueryResult && ListUtil.isEmpty((Collection)umUserQueryResult.getList())) {
                throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.updateUser", "umUser\u4e3a\u7a7a");
            }
            umUser = (UmUser)umUserQueryResult.getList().get(0);
            umUser.setUserName(umUserinfoDomainBean.getUserName());
            umUser.setUserRelname(umUserinfoDomainBean.getUserRelName());
        } else {
            umUserQueryResult = this.queryUserPage(this.getQueryParamMap("tenantCode,userPcode,userType", new Object[]{tenantCode, userinfoCode, 0}));
            if (null != umUserQueryResult && ListUtil.isNotEmpty((Collection)umUserQueryResult.getList())) {
                umUser = (UmUser)umUserQueryResult.getList().get(0);
            }
        }
        if (null != umUser) {
            umUser.setUserinfoQuality(umUserinfo.getUserinfoQuality());
            umUser.setRoleCode(umUserinfo.getRoleCode());
            this.updateUserModel(umUser);
        }
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("update");
        umUsersendDomain.setUserinfoCode(userinfoCode);
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(tenantCode);
        if (flag) {
            this.updateUserInfoCache(tenantCode, userinfoCode);
        }
        return this.umUsersendBaseService.sendUsersend(umUsersendDomain);
    }

    @Override
    public void updateUserinfoByUserinfoCode(UmUserinfoDomainBean umUserinfoDomainBean) throws ApiException {
        UmUserinfo umUserinfo;
        String msg = this.checkUserinfo(umUserinfoDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoByUserinfoCode.checkUserinfo", msg);
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelByCode(umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getTenantCode());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoByUserinfoCode.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if ("2020050600004084".equals(umUserinfoDomainBean.getTenantCode()) && StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserCode()) && StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserinfoOcode())) {
            umUserinfo = oldUmUserinfo;
            umUserinfo.setUserCode(umUserinfoDomainBean.getUserCode());
            umUserinfo.setUserinfoOcode(umUserinfoDomainBean.getUserinfoOcode());
        } else {
            umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
        }
        this.setUserinfoUpdataDefault(umUserinfo);
        this.logger.error("umUserinfo\u7684\u6570\u636e\u4e3a====================", (Object)umUserinfo);
        this.updateUserinfoModel(umUserinfo);
    }

    @Override
    public UmUserinfo getUserinfo(Integer userinfoId) {
        return this.getUserinfoModelById(userinfoId);
    }

    @Override
    public UmUserinfo getUserinfoByUserCode(String userinfoCode, String tenantCode) {
        return this.getUserinfoModelByUserCode(userinfoCode, tenantCode);
    }

    @Override
    public void deleteUserinfo(Integer userinfoId) throws ApiException {
        this.deleteUserinfoModel(userinfoId);
    }

    @Override
    public QueryResult<UmUserinfoReDomainBean> queryUserinfoPage(Map<String, Object> map) {
        boolean childFlag = null != map && map.get("childFlag") != null;
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelPage(map);
        List<UmUserinfoReDomainBean> beanList = this.makeListUserinfoReDomain(umUserinfoList, childFlag);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(beanList);
        return queryResult;
    }

    @Override
    public QueryResult<UmUserinfoReDomainBean> queryBFQuality(Map<String, Object> map) {
        boolean childFlag = null != map && map.get("childFlag") != null;
        List<UmUserinfo> umUserinfoList = this.umUserinfoMapper.queryBFQuality(map);
        List<UmUserinfoReDomainBean> beanList = this.makeListUserinfoReDomain(umUserinfoList, childFlag);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(beanList);
        return queryResult;
    }

    public QueryResult<UmUserinfo> queryUserinfoReModelPage(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countUserinfo(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umUserinfoList);
        return queryResult;
    }

    @Override
    public List<UmUserinfo> queryUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> umUserinfoList = this.queryUserinfoModelList(map);
        return umUserinfoList;
    }

    @Override
    public void updateUserPwsswd(int userId, String userPwsswd) throws ApiException {
        if (StringUtils.isBlank((String)userPwsswd)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserPwsswd.", "\u5bc6\u7801\u4e3a\u7a7a");
        }
        UmUser oldUmUser = this.getUserModelById(userId);
        if (null == oldUmUser) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUser.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUser.setUserPwsswd(this.getMd5(userPwsswd));
        this.updateUserModel(oldUmUser);
        this.updateUserCache(oldUmUser.getTenantCode(), oldUmUser.getUserCode());
    }

    @Override
    public void updateUserinfoConPhone(int userinfoId, String userinfoConPhone) throws ApiException {
        if (StringUtils.isBlank((String)userinfoConPhone)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoConPhone.", "\u624b\u673a\u53f7\u4e3a\u7a7a");
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelById(userinfoId);
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoConPhone.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        oldUmUserinfo.setUserinfoConPhone(userinfoConPhone);
        this.updateUserinfoModel(oldUmUserinfo);
    }

    @Override
    public UmUser getUserByName(String userName, String tenantCode) {
        return this.selectByName(userName, tenantCode);
    }

    public void InvalidateUserinfModel() {
        try {
            List<UmUserinfo> userInfoList = this.umUserinfoMapper.queryInvalidUserinfoList();
            if (CollectionUtils.isNotEmpty(userInfoList)) {
                for (UmUserinfo umUserinfo : userInfoList) {
                    HashMap<String, Object> mapUserinfo = new HashMap<String, Object>();
                    mapUserinfo.put("userinfoId", umUserinfo.getUserinfoId());
                    mapUserinfo.put("dataState", "2");
                    mapUserinfo.put("oldDataState", "1");
                    this.umUserinfoMapper.updateStateByPrimaryKey(mapUserinfo);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.InvalidateUserinfModel", (Throwable)e);
        }
    }

    private List<UmUserinfo> getUserinfoList(Map<String, Object> map) {
        return this.umUserinfoMapper.queryInvalidUserinfoListWeek(map);
    }

    private void queryInvalidateUserinfoList(Map<String, Object> map) {
        try {
            String mnsExp;
            ArrayList<UmUser> userList = new ArrayList<UmUser>();
            List<UmUserinfo> userinfoList = this.getUserinfoList(map);
            if (CollectionUtils.isNotEmpty(userinfoList)) {
                for (UmUserinfo umUserinfo : userinfoList) {
                    String userCode = umUserinfo.getUserCode();
                    if (!StringUtils.isNotBlank((String)userCode)) continue;
                    userList.add(this.getUserModelByCode(userCode, umUserinfo.getTenantCode()));
                }
            }
            this.logger.debug("um.USER.UserBaseServiceImpl_queryInvalidateUserinfoList", (Object)("list size is-->" + userList.size()));
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "00013", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "00013");
                paramsMap.put("mnslistBusName", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u7528\u6237\u5b9e\u540d\u6709\u6548\u671f\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryInvalidateUserinfoList", (Throwable)e);
        }
    }

    private String getMnsExp(List<UmUser> userList, String businessType, String theme) {
        if (CollectionUtils.isEmpty(userList)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        map.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        ArrayList listReceiver = new ArrayList();
        for (UmUser umUser : userList) {
            HashMap<String, String> mapReceiver = new HashMap<String, String>();
            mapReceiver.put("code", umUser.getUserCode());
            mapReceiver.put("name", umUser.getUserName());
            mapReceiver.put("email", umUser.getUserEmial());
            mapReceiver.put("telphone", umUser.getUserPhone());
            listReceiver.add(mapReceiver);
        }
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(listReceiver));
        map.put("theme", theme);
        map.put("businessType", businessType);
        HashMap<String, String> paramMap1 = new HashMap<String, String>();
        paramMap1.put("proName", "\u7ef4\u91d1SaaS");
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap1));
        return JsonUtil.buildNonDefaultBinder().toJson(map);
    }

    @Override
    public void updateInvalidateUserinfo() throws ApiException {
        this.InvalidateUserinfModel();
    }

    @Override
    public void sendMnsInvalidateUserinfo() throws ApiException {
        String openRemindTime = this.getSysParam("OPEN_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        this.queryInvalidateUserinfoList(map);
    }

    @Override
    public void executeOverdueRemind() {
        List<UmUser> userList = this.getOverdueUserList();
        this.logger.debug("um.USER.UserBaseServiceImpl_executeOverdueRemind", (Object)("list size is-->" + userList.size()));
        if (CollectionUtils.isNotEmpty(userList)) {
            this.sendOverdueMns(userList);
        }
    }

    @Override
    public void executeOverdueUpdate() {
        this.updateFeeOverdueStatus();
    }

    private void updateFeeOverdueStatus() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", "0");
        map.put("userinfoFeestatus", "0");
        try {
            this.umUserinfoMapper.updateFeeStatus(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateFeeOverdueStatus", (Throwable)e);
        }
    }

    private List<UmUser> getOverdueUserList() {
        String openRemindTime = this.getSysParam("SAAS_REMIND_TIME", "00", "00");
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (null != openRemindTime) {
            map.put("userinfoFeeEdate", this.getDayValid(Integer.parseInt(openRemindTime)));
        } else {
            map.put("userinfoFeeEdate", this.getDayValid(UserConstants.SAAS_REMIND_TIME_DEFAULT));
        }
        ArrayList<UmUser> userList = new ArrayList<UmUser>();
        List<UmUserinfo> userinfoList = this.getOverdueUserinfoList(map);
        this.logger.debug("um.USER.UserBaseServiceImpl_getOverdueUserList", (Object)("list size is-->" + userinfoList.size()));
        if (CollectionUtils.isNotEmpty(userinfoList)) {
            for (UmUserinfo umUserinfo : userinfoList) {
                String userCode = umUserinfo.getUserCode();
                this.logger.debug("um.USER.UserBaseServiceImpl_getOverdueUserList", (Object)("userCode is-->" + userCode));
                if (!StringUtils.isNotBlank((String)userCode)) continue;
                userList.add(this.getUserModelByCode(userCode, umUserinfo.getTenantCode()));
            }
        }
        return userList;
    }

    private List<UmUserinfo> getOverdueUserinfoList(Map<String, Object> map) {
        List<UmUserinfo> userinfoList = null;
        try {
            userinfoList = this.umUserinfoMapper.queryOverdueUserinfoList(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getOverdueUserinfoList", (Throwable)e);
        }
        return userinfoList;
    }

    private void sendOverdueMns(List<UmUser> userList) {
        try {
            String mnsExp;
            if (CollectionUtils.isNotEmpty(userList) && null != (mnsExp = this.getMnsExp(userList, "10016", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192"))) {
                ConcurrentHashMap<String, String> sendMap = new ConcurrentHashMap<String, String>();
                ConcurrentHashMap<String, String> paramsMap = new ConcurrentHashMap<String, String>();
                paramsMap.put("mnslistBusType", "10016");
                paramsMap.put("mnslistBusName", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistSubject", "\u4ea7\u54c1\u7f34\u8d39\u5230\u671f\u63d0\u9192");
                paramsMap.put("mnslistExp", mnsExp);
                paramsMap.put("mnslistSource", "0");
                sendMap.put("umMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(paramsMap));
                this.getInternalRouter().inInvoke("um.mns.saveMnslist", "1.0", "0", sendMap);
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.sendOverdueMns", (Throwable)e);
        }
    }

    @Override
    public UmUserBean queryUmuserCheck(String userName, String password, String appmanageIcode, String tenantCode, String isValid) {
        QueryResult<UmGroupList> qmem;
        TmTenant tmTenant;
        UmUserBean umUserBean = new UmUserBean();
        String phone = "0";
        UmUser muser = null;
        if (userName.indexOf("@") > 0) {
            phone = "2";
        } else if (!PhoneFormatCheckUtils.isPhoneLegal((String)userName)) {
            phone = "1";
        }
        if (StringUtils.isBlank((String)isValid)) {
            isValid = "1";
        }
        if (phone.equals("2") && null == (muser = this.selectByEmail(userName, tenantCode))) {
            muser = this.selectByName(userName, tenantCode);
        }
        if (phone.equals("0")) {
            muser = this.selectByPhone(userName, tenantCode);
            if (null == muser) {
                muser = this.selectByName(userName, tenantCode);
            }
        } else if ("3".equals(isValid)) {
            if (null == muser) {
                muser = this.getByOcode(userName, tenantCode);
            }
            if (null == muser) {
                muser = this.selectByName(userName, tenantCode);
            }
        } else {
            if (null == muser) {
                muser = this.selectByName(userName, tenantCode);
            }
            if (null == muser) {
                muser = this.selectByPhone(userName, tenantCode);
            }
        }
        if (null == muser) {
            muser = this.getUserByUserCode(userName, tenantCode);
        }
        if (null == muser) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck", (Object)(userName + " | " + tenantCode));
            return umUserBean;
        }
        if (!"0".equals(isValid) && !"3".equals(isValid) && StringUtils.isNotBlank((String)password) && StringUtils.isBlank((String)muser.getUserPwsswd())) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("empty");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck2", (Object)(userName + " | " + tenantCode));
            return umUserBean;
        }
        if (!("0".equals(isValid) || "3".equals(isValid) || !StringUtils.isBlank((String)password) && !StringUtils.isBlank((String)muser.getUserPwsswd()) && MD5Util.saltMD5Verify((String)password, (String)muser.getUserPwsswd()))) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            if (!MD5Util.saltMD5Verify((String)password, (String)muser.getUserPwsswd())) {
                umUserBean.setMsg("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            }
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck1", (Object)(userName + " | " + tenantCode));
            return umUserBean;
        }
        if (muser.getDataState() != 0) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return umUserBean;
        }
        UmUserinfo umUserinfo = this.getUserinfoModelByCode(muser.getUserPcode(), muser.getTenantCode());
        if (null == umUserinfo) {
            this.logger.error("um.USER.UserBaseServiceImpl.umUserinfo.muser", (Object)JsonUtil.buildNormalBinder().toJson((Object)muser));
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u4fe1\u606f\u4e0d\u5b58\u5728!");
            return umUserBean;
        }
        if (umUserinfo.getDataState() == -1) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return umUserBean;
        }
        if (umUserinfo.getDataState() == 1) {
            umUserBean.setFlag(false);
            umUserBean.setMsg("\u7528\u6237\u672a\u5ba1\u6838,\u8bf7\u8054\u7cfb\u5ba2\u670d!");
            return umUserBean;
        }
        HashMap<String, String> userinfoParentMap = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)umUserinfo.getUserinfoParentCode())) {
            this.makeUserinfoTree(userinfoParentMap, umUserinfo.getUserinfoParentCode(), tenantCode);
        }
        if ((tmTenant = (TmTenant)DisUtil.getMapJson((String)"tmtenant-code", (String)muser.getTenantCode(), TmTenant.class)) != null) {
            if (tmTenant.getDataState() == -1) {
                umUserBean.setFlag(false);
                umUserBean.setMsg("\u5e73\u53f0\u767b\u5f55\u88ab\u9650\u5236\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
                return umUserBean;
            }
            muser.setTenantCode(tmTenant.getTenantCode());
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserBean, (Object)umUserinfo);
            BeanUtils.copyAllPropertys((Object)umUserBean, (Object)muser);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (umUserinfo.getDataState() == 3 || umUserinfo.getDataState() == 2) {
            umUserBean.setDataState(1);
        }
        if (umUserinfo.getDataState() == 4) {
            umUserBean.setDataState(4);
        }
        if (null != umUserinfo.getUserinfoBtate() && umUserinfo.getUserinfoBtate() != 0) {
            umUserBean.setDataState(2);
        }
        if (null != (qmem = this.umGroupService.queryGroupListPage(this.getQueryMapParam("userinfoCode,tenantCode,order", new Object[]{umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), true}))) && ListUtil.isNotEmpty((Collection)qmem.getList())) {
            umUserBean.setGroupCode(((UmGroupList)qmem.getList().get(0)).getGroupCode());
            umUserBean.setGroupName(((UmGroupList)qmem.getList().get(0)).getGroupName());
        }
        umUserBean.setUserinfoQuality(umUserinfo.getUserinfoQuality());
        umUserBean.setMerberCompname(StringUtils.isBlank((String)umUserinfo.getUserinfoCompname()) ? muser.getUserName() : umUserinfo.getUserinfoCompname());
        umUserBean.setOpenId(muser.getUserOpenid());
        umUserBean.setUserinfoParentCode(umUserinfo.getUserinfoParentCode());
        umUserBean.setUserinfoParentName(umUserinfo.getUserinfoParentName());
        umUserBean.setUserinfoParentMap(userinfoParentMap);
        umUserBean.setUserOcode(muser.getUserOcode());
        umUserBean.setUserinfoOcode(umUserinfo.getUserinfoOcode());
        umUserBean.setFlag(true);
        umUserBean.setUserinfoType(umUserinfo.getUserinfoType());
        umUserBean.setCompanyType(umUserinfo.getCompanyType());
        return umUserBean;
    }

    private void makeUserinfoTree(Map<String, String> map, String userinfoCode, String tenantCode) {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || null == map || map.isEmpty()) {
            return;
        }
        UmUserinfo umUserinfo = this.getUserinfoModelByCode(userinfoCode, tenantCode);
        if (null == umUserinfo) {
            return;
        }
        if (StringUtils.isNotBlank((String)umUserinfo.getUserinfoParentCode())) {
            map.put(userinfoCode, umUserinfo.getUserinfoParentCode());
            this.makeUserinfoTree(map, umUserinfo.getUserinfoParentCode(), tenantCode);
        } else {
            map.put(userinfoCode, userinfoCode);
        }
    }

    @Override
    public UmUser saveUmuserAll(UmUserDomainBean umUserDomainBean) {
        UmUser user = this.saveAll(umUserDomainBean);
        return user;
    }

    private UmUser saveAll(UmUserDomainBean umUserDomainBean) {
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        umUserinfoDomainBean.setTenantCode(umUserDomainBean.getTenantCode());
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveUserinfoReModel(umUserinfoDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        String infoCode = umUserInfoSaveBean.getUmUserinfo().getUserinfoCode();
        umUserDomainBean.setUserPcode(infoCode);
        UmUser user = this.saveUser(umUserDomainBean);
        return user;
    }

    @Override
    public UmUserinfo saveAllReInfoStop(UmUserDomainBean umUserDomainBean) {
        umUserDomainBean.setUserinfoDataState(-1);
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveAllReInfo(umUserDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        return umUserInfoSaveBean.getUmUserinfo();
    }

    @Override
    public String saveOpenUserinfoStop(UmUserDomainBean umUserDomainBean) throws ApiException {
        umUserDomainBean.setUserinfoDataState(-1);
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveAllReInfo(umUserDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        return umUserInfoSaveBean.getUmUserinfo().getUserinfoCode();
    }

    @Override
    public String updateUserStateBack(String userinfoCode, String tenantCode, Integer dataState, Integer olddataState) {
        UmUserinfo userinfo = this.getUserinfoByCode(userinfoCode, tenantCode);
        if (null == userinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserStateBack.userinfo", userinfoCode + " = " + tenantCode);
        }
        Integer userinfoId = userinfo.getUserinfoId();
        this.updateUserinfoState(userinfoId, dataState, olddataState, null);
        String userinfoPhone = userinfo.getUserinfoPhone();
        String name = userinfo.getUserinfoCompname();
        return this.sendMnsToUser(userinfoCode, tenantCode, userinfoPhone, name);
    }

    private String sendMnsToUser(String userinfoCode, String tenantCode, String userinfoPhone, String name) {
        String dataTenant = DisUtil.getMap((String)"tmtenant-mem-code", (String)userinfoCode);
        if (dataTenant == null) {
            return "um.USER.UserBaseServiceImplsendMnsToUserdataTenant is null";
        }
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnschannelType(0);
        mnsMnslistDomainBean.setMnslistBustype("umOn");
        mnsMnslistDomainBean.setMnslistBusname("\u7528\u6237\u5f00\u901a\u901a\u77e5");
        mnsMnslistDomainBean.setMemberCode(userinfoCode);
        mnsMnslistDomainBean.setDataTenant(dataTenant);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> mape = new HashMap<String, String>();
        mape.put("telphone", userinfoPhone);
        mape.put("name", name);
        receiverList.add(mape);
        HashMap<String, String> contentMap = new HashMap<String, String>();
        contentMap.put("phone", userinfoPhone);
        contentMap.put("userinfoCompname", name);
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(contentMap));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        String params = JsonUtil.buildNonDefaultBinder().toJson(expMap);
        mnsMnslistDomainBean.setMnslistExp(params);
        mnsMnslistDomainBean.setTenantCode(tenantCode);
        HashMap<String, String> mnsMap = new HashMap<String, String>();
        mnsMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson((Object)mnsMnslistDomainBean));
        String json = this.internalInvoke(this.sendMnsApi, mnsMap);
        if (StringUtils.isBlank((String)json)) {
            this.logger.error("um.USER.UserBaseServiceImpl.sendMnsToUser", (Object)"sendMns is blank!");
            return "um.USER.UserBaseServiceImplsendMnsToUsersendMns is blank!";
        }
        return "success";
    }

    private void makeOrg(UmUserDomainBean umUserDomainBean) {
        List<UmUserinfo> ulist;
        if (null == umUserDomainBean || StringUtils.isBlank((String)umUserDomainBean.getUserinfoQuality())) {
            return;
        }
        if ("retailer".equals(umUserDomainBean.getUserinfoQuality()) || "company".equals(umUserDomainBean.getUserinfoQuality())) {
            List<UmUserinfo> ulist2;
            if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoDischannelcode()) && !"-1".equals(umUserDomainBean.getUserinfoDischannelcode())) {
                List<UmUserinfo> ulist3 = this.queryUserinfoModelList(this.getQueryMapParam("companyCode,tenantCode", new Object[]{umUserDomainBean.getUserinfoDischannelcode(), umUserDomainBean.getTenantCode()}));
                if (ListUtil.isNotEmpty(ulist3)) {
                    umUserDomainBean.setUserinfoDischannelcode(ulist3.get(0).getUserinfoCode());
                    umUserDomainBean.setUserinfoDischannelname(ulist3.get(0).getUserinfoCompname());
                }
            } else if ("-1".equals(umUserDomainBean.getUserinfoDischannelcode()) && ListUtil.isNotEmpty(ulist2 = this.queryUserinfoModelList(this.getQueryMapParam("userinfoQuality,tenantCode", new Object[]{"plat", umUserDomainBean.getTenantCode()})))) {
                umUserDomainBean.setUserinfoParentCode(ulist2.get(0).getUserinfoCode());
                umUserDomainBean.setUserinfoParentName(ulist2.get(0).getUserinfoCompname());
                umUserDomainBean.setUserinfoDischannelcode(ulist2.get(0).getUserinfoCode());
                umUserDomainBean.setUserinfoDischannelname(ulist2.get(0).getUserinfoCompname());
            }
        } else if ("depart".equals(umUserDomainBean.getUserinfoQuality())) {
            List<UmUserinfo> ulist4;
            if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoDischannelcode()) && !"-1".equals(umUserDomainBean.getUserinfoDischannelcode())) {
                List<UmUserinfo> ulist5 = this.queryUserinfoModelList(this.getQueryMapParam("userinfoQuality,departCode,tenantCode", new Object[]{"depart", umUserDomainBean.getUserinfoDischannelcode(), umUserDomainBean.getTenantCode()}));
                if (ListUtil.isNotEmpty(ulist5)) {
                    umUserDomainBean.setUserinfoDischannelcode(ulist5.get(0).getUserinfoCode());
                    umUserDomainBean.setUserinfoDischannelname(ulist5.get(0).getUserinfoCompname());
                }
            } else if (StringUtils.isNotBlank((String)umUserDomainBean.getCompanyCode()) && ListUtil.isNotEmpty(ulist4 = this.queryUserinfoModelList(this.getQueryMapParam("userinfoQuality,companyCode,tenantCode", new Object[]{"company", umUserDomainBean.getCompanyCode(), umUserDomainBean.getTenantCode()})))) {
                umUserDomainBean.setUserinfoDischannelcode(ulist4.get(0).getUserinfoCode());
                umUserDomainBean.setUserinfoDischannelname(ulist4.get(0).getUserinfoCompname());
            }
        } else if (umUserDomainBean.getUserinfoQuality().indexOf("dealer") >= 0 && StringUtils.isBlank((String)umUserDomainBean.getUserinfoDischannelcode()) && ListUtil.isNotEmpty(ulist = this.queryUserinfoModelList(this.getQueryMapParam("userinfoQuality,departCode,tenantCode", new Object[]{"depart", umUserDomainBean.getDepartCode(), umUserDomainBean.getTenantCode()})))) {
            umUserDomainBean.setUserinfoDischannelcode(ulist.get(0).getUserinfoCode());
            umUserDomainBean.setUserinfoDischannelname(ulist.get(0).getUserinfoCompname());
        }
    }

    @Override
    public UmUserInfoSaveBean saveAllReInfo(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveAllReInfo.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String qualityRole = null;
        String infoCode = null;
        if (StringUtils.isBlank((String)umUserDomainBean.getUserPhone())) {
            umUserDomainBean.setUserPhone(umUserDomainBean.getUserinfoPhone());
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoPhone())) {
            umUserDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserName())) {
            umUserDomainBean.setUserName(umUserDomainBean.getUserPhone());
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserEmial())) {
            umUserDomainBean.setUserEmial(umUserDomainBean.getUserinfoEmail());
        }
        if (StringUtils.isBlank((String)umUserDomainBean.getUserinfoEmail())) {
            umUserDomainBean.setUserinfoEmail(umUserDomainBean.getUserEmial());
        }
        if (umUserDomainBean.getUserEmial() != null && "".equals(umUserDomainBean.getUserEmial().trim())) {
            umUserDomainBean.setUserEmial(null);
        }
        if (umUserDomainBean.getUserinfoEmail() != null && "".equals(umUserDomainBean.getUserinfoEmail().trim())) {
            umUserDomainBean.setUserinfoEmail(null);
        }
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        this.makeOrg(umUserDomainBean);
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveAllReInfo.e", (Throwable)e);
        }
        if (StringUtils.isBlank((String)umUserinfoDomainBean.getUserinfoPhone())) {
            umUserinfoDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        }
        if (StringUtils.isBlank((String)umUserinfoDomainBean.getUserinfoCompname())) {
            if (StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserinfoPhone())) {
                umUserinfoDomainBean.setUserinfoCompname(umUserDomainBean.getUserinfoPhone());
            } else if (StringUtils.isNotBlank((String)umUserinfoDomainBean.getUserinfoParentName())) {
                umUserinfoDomainBean.setUserinfoCompname(umUserDomainBean.getUserinfoParentName());
            }
            umUserinfoDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        }
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        umUserinfoDomainBean.setTenantCode(umUserDomainBean.getTenantCode());
        umUserinfoDomainBean.setUserinfoPhone(umUserDomainBean.getUserPhone());
        umUserinfoDomainBean.setUserinfoInvite(umUserDomainBean.getUserinfoInvite());
        umUserinfoDomainBean.setUserinfoDiscode(umUserDomainBean.getUserinfoDiscode());
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoQuality()) && StringUtils.isEmpty((String)umUserDomainBean.getRoleCode())) {
            qualityRole = this.getQualityCode(umUserDomainBean.getTenantCode(), umUserDomainBean.getUserinfoQuality());
            umUserinfoDomainBean.setRoleCode(qualityRole);
        }
        umUserinfoDomainBean.setUmUserinfoQuaDomainList(umUserDomainBean.getUmUserinfoQuaDomainList());
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveUserinfoReModel(umUserinfoDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        UmUserinfo umUserinfo = umUserInfoSaveBean.getUmUserinfo();
        if (StringUtils.isBlank((String)umUserinfo.getUserinfoCode()) || null == umUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.umUserinfo.umUserinfo");
        }
        infoCode = umUserinfo.getUserinfoCode();
        umUserDomainBean.setUserinfoCode(infoCode);
        umUserDomainBean.setUserPcode(infoCode);
        if (StringUtils.isBlank((String)umUserDomainBean.getUserName())) {
            umUserDomainBean.setUserName(umUserDomainBean.getUserPhone());
        }
        if (StringUtils.isNotBlank((String)qualityRole)) {
            umUserDomainBean.setRoleCode(qualityRole);
        }
        umUserDomainBean.setMemo(null);
        UmUser user = this.saveUser(umUserDomainBean);
        umUserinfo.setUserCode(user.getUserCode());
        umUserinfo.setMemo(user.getUserPwsswd());
        umUserDomainBean.setUserinfoCode(infoCode);
        this.saveApply(umUserDomainBean, user);
        return umUserInfoSaveBean;
    }

    @Override
    public String saveUserinfoApply(UmUserDomainBean umUserDomainBean) throws ApiException {
        this.logger.error("um.USER.UserBaseServiceImpl.saveUserinfoApply", (Object)JsonUtil.buildNormalBinder().toJson((Object)umUserDomainBean));
        UmUserinfo umUserinfo = this.getUserinfoByCode(umUserDomainBean.getUserinfoCode(), umUserDomainBean.getTenantCode());
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserinfoApply.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.updateStateUserinfoCodeModel(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 4, umUserinfo.getDataState());
        UmUser user = null;
        if (null != umUserinfo.getUserCode()) {
            user = this.getUserByCode(umUserinfo.getUserCode(), umUserinfo.getTenantCode());
        }
        this.saveApply(umUserDomainBean, user);
        return umUserinfo.getUserinfoCode();
    }

    private void saveApply(UmUserDomainBean umUserDomainBean, UmUser user) {
        if (null == umUserDomainBean || ListUtil.isEmpty(umUserDomainBean.getUmUserinfoapplyDomainList())) {
            return;
        }
        for (UmUserinfoapplyDomain umUserinfoapplyDomain : umUserDomainBean.getUmUserinfoapplyDomainList()) {
            try {
                BeanUtils.copyAllPropertys((Object)umUserinfoapplyDomain, (Object)umUserDomainBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != user) {
                umUserinfoapplyDomain.setUserCode(user.getUserCode());
            }
            umUserinfoapplyDomain.setUmUserinfoapplyQuaList(this.makeQua(umUserDomainBean, user));
            umUserinfoapplyDomain.setUserinfoapplyRemark(umUserDomainBean.getUserinfoRemark());
        }
        this.getUmUserinfoapplyService().saveUserinfoapplyBatch(umUserDomainBean.getUmUserinfoapplyDomainList());
    }

    @Override
    public String saveUserinfoApplyBase(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUserinfo umUserinfo = this.getUserinfoByCode(umUserDomainBean.getUserinfoCode(), umUserDomainBean.getTenantCode());
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveUserinfoApply.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.updateStateUserinfoCodeModel(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 4, umUserinfo.getDataState());
        UmUser user = null;
        if (null != umUserinfo.getUserCode()) {
            user = this.getUserByCode(umUserinfo.getUserCode(), umUserinfo.getTenantCode());
        }
        this.saveApplyBase(umUserDomainBean, user);
        return umUserinfo.getUserinfoCode();
    }

    private void saveApplyBase(UmUserDomainBean umUserDomainBean, UmUser user) {
        if (null == umUserDomainBean || ListUtil.isEmpty(umUserDomainBean.getUmUserinfoapplyDomainList())) {
            return;
        }
        for (UmUserinfoapplyDomain umUserinfoapplyDomain : umUserDomainBean.getUmUserinfoapplyDomainList()) {
            try {
                BeanUtils.copyAllPropertys((Object)umUserinfoapplyDomain, (Object)umUserDomainBean);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (null != user) {
                umUserinfoapplyDomain.setUserCode(user.getUserCode());
            }
            umUserinfoapplyDomain.setUmUserinfoapplyQuaList(this.makeQua(umUserDomainBean, user));
            umUserinfoapplyDomain.setUserinfoapplyRemark(umUserDomainBean.getUserinfoRemark());
        }
        this.getUmUserinfoapplyService().saveBatchUserinfoapply(umUserDomainBean.getUmUserinfoapplyDomainList());
    }

    private List<UmUserinfoapplyQuaDomain> makeQua(UmUserDomainBean umUserDomainBean, UmUser user) {
        UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain;
        if (null == umUserDomainBean) {
            return null;
        }
        List<UmUserinfoQuaDomain> umUserinfoQuaDomainList = umUserDomainBean.getUmUserinfoQuaDomainList();
        ArrayList<UmUserinfoapplyQuaDomain> umUserinfoapplyQuaList = new ArrayList<UmUserinfoapplyQuaDomain>();
        if (ListUtil.isNotEmpty(umUserinfoQuaDomainList)) {
            for (UmUserinfoQuaDomain umUserinfoQuaDomain : umUserinfoQuaDomainList) {
                umUserinfoapplyQuaDomain = new UmUserinfoapplyQuaDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)umUserinfoapplyQuaDomain, (Object)umUserinfoQuaDomain);
                }
                catch (Exception e) {
                    // empty catch block
                }
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaKey(umUserinfoQuaDomain.getUserinfoQuaKey());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaUrl(umUserinfoQuaDomain.getUserinfoQuaUrl());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaUrl1(umUserinfoQuaDomain.getUserinfoQuaUrl1());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaUrl3(umUserinfoQuaDomain.getUserinfoQuaUrl3());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaUrl2(umUserinfoQuaDomain.getUserinfoQuaUrl2());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaUrl4(umUserinfoQuaDomain.getUserinfoQuaUrl4());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaVaule(umUserinfoQuaDomain.getUserinfoQuaVaule());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaVaule1(umUserinfoQuaDomain.getUserinfoQuaVaule1());
                umUserinfoapplyQuaDomain.setUserinfoapplyQuaVaule2(umUserinfoQuaDomain.getUserinfoQuaVaule2());
                umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain);
            }
        }
        if (null != user && StringUtils.isNotBlank((String)user.getUserRelname())) {
            umUserinfoapplyQuaDomain = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain.setUserinfoapplyQuaKey("user_userRelname");
            umUserinfoapplyQuaDomain.setUserinfoapplyQuaVaule(user.getUserRelname());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCorp())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain3 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain3.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain3.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain3.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain3.setUserinfoapplyQuaKey("userinfo_userinfoCorp");
            umUserinfoapplyQuaDomain3.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCorp());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain3);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCoid())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain4 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain4.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain4.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain4.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain4.setUserinfoapplyQuaKey("userinfo_userinfoCoid");
            umUserinfoapplyQuaDomain4.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCoid());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain4);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCertNo())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain5 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain5.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain5.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain5.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain5.setUserinfoapplyQuaKey("userinfo_userinfoCertNo");
            umUserinfoapplyQuaDomain5.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCertNo());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain5);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCert1No())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain6 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain6.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain6.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain6.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain6.setUserinfoapplyQuaKey("userinfo_userinfoCert1No");
            umUserinfoapplyQuaDomain6.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCert1No());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain6);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCertUrl())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain7 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain7.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain7.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain7.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain7.setUserinfoapplyQuaKey("userinfo_userinfoCertUrl");
            umUserinfoapplyQuaDomain7.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCertUrl());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain7);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCert1Url())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain8 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain8.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain8.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain8.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain8.setUserinfoapplyQuaKey("userinfo_userinfoCert1Url");
            umUserinfoapplyQuaDomain8.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCert1Url());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain8);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCert2No())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain9 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain9.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain9.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain9.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain9.setUserinfoapplyQuaKey("userinfo_userinfoCert2No");
            umUserinfoapplyQuaDomain9.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCert2No());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain9);
        }
        if (StringUtils.isNotBlank((String)umUserDomainBean.getUserinfoCert2Url())) {
            UmUserinfoapplyQuaDomain umUserinfoapplyQuaDomain10 = new UmUserinfoapplyQuaDomain();
            umUserinfoapplyQuaDomain10.setTenantCode(umUserDomainBean.getTenantCode());
            umUserinfoapplyQuaDomain10.setUserinfoCode(umUserDomainBean.getUserinfoCode());
            umUserinfoapplyQuaDomain10.setUserinfoCompname(umUserDomainBean.getUserinfoCompname());
            umUserinfoapplyQuaDomain10.setUserinfoapplyQuaKey("userinfo_userinfoCert2Url");
            umUserinfoapplyQuaDomain10.setUserinfoapplyQuaVaule(umUserDomainBean.getUserinfoCert2Url());
            umUserinfoapplyQuaList.add(umUserinfoapplyQuaDomain10);
        }
        return umUserinfoapplyQuaList;
    }

    private String getQualityCode(String tenantCode, String qualityCode) {
        if (StringUtils.isBlank((String)qualityCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        String[] qualityCodeStr = qualityCode.split("\\,");
        if (null == qualityCodeStr) {
            return null;
        }
        String qualityRole = "";
        for (String string : qualityCodeStr) {
            UmQuality umQuality = this.getRsGoodsClassService().getQualityByCode(tenantCode, string);
            if (umQuality == null || StringUtils.isBlank((String)umQuality.getQualityCode())) {
                umQuality = this.getRsGoodsClassService().getQualityByCode("00000000", string);
            }
            if (null == umQuality || !StringUtils.isNotBlank((String)umQuality.getQualityRole())) continue;
            if (StringUtils.isNotBlank((String)qualityRole)) {
                qualityRole = qualityRole + ",";
            }
            qualityRole = qualityRole + umQuality.getQualityRole();
        }
        return qualityRole;
    }

    @Override
    public UmUser saveUmuserAndInfo(UmUserDomainBean umUserDomainBean, UmUserinfoDomainBean umUserinfoDomainBean) {
        umUserinfoDomainBean.setUserinfoFeestatus(0);
        String infoCode = this.saveUserinfoCode(umUserinfoDomainBean);
        umUserDomainBean.setUserPcode(infoCode);
        return this.saveUser(umUserDomainBean);
    }

    private String getMd5(String password) {
        if (StringUtils.isNotBlank((String)password)) {
            return MD5Util.saltMD5((String)password);
        }
        return null;
    }

    @Override
    public UmUser getUserByNameOrPhone(Map<String, Object> map) {
        return this.selectByNameOrPhone(map);
    }

    private UmUser selectByNameOrPhone(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        try {
            return this.umUserMapper.selectByNameOrPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.selectByNameOrPhone", (Throwable)e);
            return null;
        }
    }

    @Override
    public Map<String, Object> saveInitUser(Map<String, Object> map) throws ApiException {
        HashMap<String, Object> succs = new HashMap<String, Object>();
        String relationType = "1";
        if (map != null && map.get("tenantCode") != null) {
            String tenantCode = (String)map.get("tenantCode");
            String companyCode = (String)map.get("companyCode");
            relationType = (String)map.get("relationType");
            List infos = (List)map.get("impUserInfo");
            HashMap<String, String> managerByTeamCode = new HashMap<String, String>();
            String teamCode = "";
            String createTeamUserCode = "";
            for (Map info : infos) {
                String roleInfo = this.convertRoleCode((String)info.get("userOffice"));
                if ("".equals(roleInfo)) {
                    try {
                        throw new Exception("\u6ca1\u6709\u5339\u914d\u89d2\u8272:" + info.get("userRelname"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String roleCode = roleInfo.split("\\|")[0];
                String manager = roleInfo.split("\\|")[1];
                UmUser umUser = this.buildUser(info, tenantCode, roleCode);
                this.setUserDefault(umUser);
                int result = this.saveUserModel(umUser);
                String groupCode = null;
                if (relationType.equals("2") && map.get("groupCode") != null) {
                    groupCode = (String)map.get("groupCode");
                }
                if (result > 0) {
                    UmRelationDomain umRelationDomain;
                    if ("teamLeader".equals(manager)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        teamCode = umTeam.getTeamCode();
                        createTeamUserCode = umTeam.getUserCode();
                        managerByTeamCode.put(umUser.getUserRelname(), teamCode);
                    }
                    if (!createTeamUserCode.equals(umUser.getUserCode())) {
                        umRelationDomain = this.buildRelation(umUser, teamCode, relationType);
                        if (!StringUtils.isEmpty((String)groupCode) && this.checkGroupHasExists(groupCode, tenantCode)) {
                            umRelationDomain.setRelationBillno2(groupCode);
                        }
                        this.umRelationService.saveInitRelation(umRelationDomain);
                        continue;
                    }
                    if (managerByTeamCode.get(info.get("managerName")) == null) continue;
                    umRelationDomain = this.buildRelation(umUser, (String)managerByTeamCode.get(info.get("managerName")), relationType);
                    if (!StringUtils.isEmpty((String)groupCode) && this.checkGroupHasExists(groupCode, tenantCode)) {
                        umRelationDomain.setRelationBillno2(groupCode);
                    }
                    this.umRelationService.saveInitRelation(umRelationDomain);
                    continue;
                }
                try {
                    throw new Exception("\u6570\u636e\u672a\u5f55\u5165\u6210\u529f,\u7ec8\u6b62\u5f55\u5165:" + umUser.getUserRelname());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            succs.put("succSize", infos.size());
        } else {
            succs.put("succSize", 0);
        }
        return succs;
    }

    public UmUser buildUser(Map<String, Object> info, String tenantCode, String roleCode) {
        UmUser umUser = new UmUser();
        umUser.setTenantCode(tenantCode);
        umUser.setUserName((String)info.get("userPhone"));
        umUser.setUserRelname((String)info.get("userRelname"));
        umUser.setUserNickname((String)info.get("userRelname"));
        umUser.setUserPhone((String)info.get("userPhone"));
        umUser.setUserPcode((String)info.get("userPcode"));
        umUser.setUserType(1);
        umUser.setUserPwsswd(this.getMd5((String)info.get("userPwsswd")));
        umUser.setRoleCode(roleCode);
        umUser.setUserSex(this.convertUserSex((String)info.get("userSex")));
        umUser.setDataState(0);
        return umUser;
    }

    public UmTeamDomain buildTeam(UmUser umUser, String companyCode) {
        UmTeamDomain umTeamDomain = new UmTeamDomain();
        umTeamDomain.setAppmanageIcode(ServletMain.getAppName());
        umTeamDomain.setCompanyCode(companyCode);
        umTeamDomain.setRoleCode(umUser.getRoleCode());
        umTeamDomain.setTeamName(umUser.getUserRelname() + "\u56e2\u961f");
        umTeamDomain.setUserCode(umUser.getUserCode());
        umTeamDomain.setUserName(umUser.getUserName());
        umTeamDomain.setTenantCode(umUser.getTenantCode());
        umTeamDomain.setAppmanageIcode(ServletMain.getAppName());
        return umTeamDomain;
    }

    public UmRelationDomain buildRelation(UmUser umUser, String teamCode, String relationType) {
        UmRelationDomain umRelationDomain = new UmRelationDomain();
        umRelationDomain.setAppmanageIcode(ServletMain.getAppName());
        umRelationDomain.setRelationBillno(teamCode);
        umRelationDomain.setRoleCode(umUser.getRoleCode());
        umRelationDomain.setRelationType(relationType);
        umRelationDomain.setUserCode(umUser.getUserCode());
        umRelationDomain.setUserName(umUser.getUserName());
        umRelationDomain.setTenantCode(umUser.getTenantCode());
        return umRelationDomain;
    }

    public String convertRoleCode(String officeName) {
        if (officeName != null) {
            if (UserConstants.RoleEnum.FZJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.FZJL.getRoleCode() + "|" + UserConstants.RoleEnum.FZJL.getManager();
            }
            if (UserConstants.RoleEnum.XSZJ.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XSZJ.getRoleCode() + "|" + UserConstants.RoleEnum.XSZJ.getManager();
            }
            if (UserConstants.RoleEnum.JD.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.JD.getRoleCode() + "|" + UserConstants.RoleEnum.JD.getManager();
            }
            if (UserConstants.RoleEnum.XSJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XSJL.getRoleCode() + "|" + UserConstants.RoleEnum.XSJL.getManager();
            }
            if (UserConstants.RoleEnum.ZYGW.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.ZYGW.getRoleCode() + "|" + UserConstants.RoleEnum.ZYGW.getManager();
            }
            if (UserConstants.RoleEnum.XXZJ.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZJ.getRoleCode() + "|" + UserConstants.RoleEnum.XXZJ.getManager();
            }
            if (UserConstants.RoleEnum.XXJL.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXJL.getRoleCode() + "|" + UserConstants.RoleEnum.XXJL.getManager();
            }
            if (UserConstants.RoleEnum.XXZG.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZG.getRoleCode() + "|" + UserConstants.RoleEnum.XXZG.getManager();
            }
            if (UserConstants.RoleEnum.XXZY.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.XXZY.getRoleCode() + "|" + UserConstants.RoleEnum.XXZY.getManager();
            }
            if (UserConstants.RoleEnum.TZZG.getRoleName().equals(officeName)) {
                return UserConstants.RoleEnum.TZZG.getRoleCode() + "|" + UserConstants.RoleEnum.TZZG.getManager();
            }
        }
        return "";
    }

    public String convertUserSex(String userSex) {
        String sex = "1";
        if ("\u5973".equals(userSex)) {
            sex = "2";
        }
        return sex;
    }

    @Override
    public Map<String, Object> saveUserOrTeam(Map<String, Object> map) throws ApiException {
        String newTeamCode = "";
        String newTeamName = "";
        boolean failure = false;
        String userCode = "";
        if (map != null) {
            String tenantCode = (String)map.get("tenantCode");
            String roleCode = (String)map.get("roleCode");
            String companyCode = (String)map.get("companyCode");
            String oldTeamCode = (String)map.get("teamCode");
            String addType = (String)map.get("addType");
            String relationType = "1";
            if (map.get("relationType") != null) {
                relationType = (String)map.get("relationType");
            }
            if (map.get("hasDel") != null && 0 == (Integer)map.get("hasDel")) {
                UmUser umUser = this.buildUser(map, tenantCode, roleCode);
                this.setUserDefault(umUser);
                int result = this.saveUserModel(umUser);
                userCode = umUser.getUserCode();
                if (result > 0) {
                    String groupCode;
                    if (addType != null && !"".equals(addType) && "addTeam".equals(addType)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        newTeamCode = umTeam.getTeamCode();
                        newTeamName = umTeam.getTeamName();
                    }
                    UmRelationDomain umRelationDomain = this.buildRelation(umUser, oldTeamCode, relationType);
                    if (relationType.equals("2") && map.get("groupCode") != null && !StringUtils.isEmpty((String)(groupCode = (String)map.get("groupCode"))) && this.checkGroupHasExists(groupCode, tenantCode)) {
                        umRelationDomain.setRelationBillno2(groupCode);
                    }
                    UmRelation umRelation = this.umRelationService.saveInitRelation(umRelationDomain);
                }
            } else if (map.get("hasDel") != null && 1 == (Integer)map.get("hasDel")) {
                UmUser umUser = this.buildUser(map, tenantCode, roleCode);
                if (map.get("userId") != null && !"".equals(map.get("userId"))) {
                    umUser.setUserId((Integer)map.get("userId"));
                }
                int i = this.updateUserModel(umUser);
                umUser = this.getUser(umUser.getUserId());
                if (i > 0) {
                    if (addType != null && !"".equals(addType) && "addTeam".equals(addType)) {
                        UmTeamDomain umTeamDomain = this.buildTeam(umUser, companyCode);
                        UmTeam umTeam = this.umTeamService.saveInitTeam(umTeamDomain);
                        newTeamCode = umTeam.getTeamCode();
                        newTeamName = umTeam.getTeamName();
                    }
                    HashMap<String, Object> relationMap = new HashMap<String, Object>();
                    relationMap.put("userCode", umUser.getUserCode());
                    relationMap.put("tenantCode", umUser.getTenantCode());
                    QueryResult<UmRelation> relationResult = this.umRelationService.queryRelationPage(relationMap);
                    List relations = relationResult.getList();
                    if (ListUtil.isNotEmpty((Collection)relations)) {
                        UmRelation ur = (UmRelation)relations.get(0);
                        ur.setDataState(0);
                        ur.setRelationBillno(oldTeamCode);
                        ur.setUserName(umUser.getUserName());
                        ur.setRoleCode(umUser.getRoleCode());
                        this.umRelationService.updateRelation(ur);
                    } else {
                        failure = true;
                    }
                } else {
                    failure = true;
                }
            }
        } else {
            failure = true;
        }
        HashMap<String, Object> team = new HashMap<String, Object>();
        if (failure) {
            team.put("succ", false);
        } else {
            team.put("succ", true);
        }
        team.put("userCode", userCode);
        team.put("teamCode", newTeamCode);
        team.put("teamName", newTeamName);
        return team;
    }

    @Override
    public List<UmUser> getUsersByRelnames(List<UmUserDomainBean> list) {
        ArrayList<UmUser> users = new ArrayList<UmUser>();
        for (UmUserDomainBean user : list) {
            UmUser uu = this.getUsersByRelnamesModel(user.getUserRelname(), user.getTenantCode());
            if (uu == null) {
                uu = new UmUser();
                uu.setUserRelname(user.getUserRelname());
                uu.setTenantCode(user.getTenantCode());
            }
            users.add(uu);
        }
        return users;
    }

    private UmUser getUsersByRelnamesModel(String userRelname, String tenantCode) {
        try {
            return this.umUserMapper.getUsersByRelnames(userRelname, tenantCode);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUsersByRelnamesModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public boolean updateUserValid(Map<String, Object> map) throws ApiException {
        int i = this.updateUserValidModel(map);
        if (i > 0) {
            this.umRelationService.updateRelationValid(map);
            return true;
        }
        throw new ApiException("um.USER.UserBaseServiceImpl.updateUserValid", "\u4fee\u6539\u7528\u6237\u5728\u804c\u72b6\u6001\u5931\u8d25");
    }

    private int updateUserValidModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.updateUserValid(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateUserValidModel", (Throwable)e);
            return 0;
        }
    }

    @Override
    public List<UmUser> getManagerByCode(Map<String, Object> map) throws ApiException {
        if (map.get("roleCode") == null) {
            return null;
        }
        return this.loopManager(map);
    }

    private List<UmUser> loopManager(Map<String, Object> map) {
        List<UmUser> manages = this.getManagerByCodeModel(map);
        if (manages != null && manages.size() > 0 && map.get("roleCode").equals(manages.get(0).getRoleCode())) {
            return manages;
        }
        String userCode = manages.get(0).getUserCode();
        map.put("userCode", userCode);
        return this.loopManager(map);
    }

    private List<UmUser> getManagerByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getManagerByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getManagerByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserBaseServiceImpl.getManagerByCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public Map<String, Object> getDirectManagerByCode(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        Map<String, Object> directManager = this.getDirectManagerByCodeModel(map);
        Boolean defaultQuery = false;
        if (map.get("defaultQuery") != null) {
            defaultQuery = (Boolean)map.get("defaultQuery");
        }
        if (MapUtil.isEmpty(directManager) && defaultQuery.booleanValue()) {
            directManager = this.getMyselftByCodeModel(map);
        }
        return directManager;
    }

    private Map<String, Object> getDirectManagerByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getDirectManagerByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getDirectManagerByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserBaseServiceImpl.getDirectManagerByCodeModel.ex", (Throwable)e);
        }
    }

    private Map<String, Object> getMyselftByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.getMyselftByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getMyselftByCodeModel", (Throwable)e);
            throw new ApiException("um.USER.UserBaseServiceImpl.getMyselftByCodeModel.ex", (Throwable)e);
        }
    }

    private UmUser validate(String userPhone, String tenantCode) {
        HashMap<String, Object> validateMap = new HashMap<String, Object>();
        validateMap.put("userPhone", userPhone);
        validateMap.put("tenantCode", tenantCode);
        UmUser user = this.getUserByNameOrPhone(validateMap);
        return user;
    }

    @Override
    public Map<String, Object> updateUserPhoneByUserPhone(Map<String, Object> map) throws ApiException {
        if (map == null) {
            return null;
        }
        map.put("successFlag", false);
        UmUser user = this.validate((String)map.get("newUserPhone"), (String)map.get("tenantCode"));
        if (user != null) {
            return map;
        }
        user = this.validate((String)map.get("oldUserPhone"), (String)map.get("tenantCode"));
        if (user == null) {
            return map;
        }
        map.put("userCode", user.getUserCode());
        int index = this.updateUserPhoneByUserPhoneModel(map);
        if (index > 0) {
            HashMap<String, Object> userinfomap = new HashMap<String, Object>();
            userinfomap.put("newUserinfoPhone", map.get("newUserPhone"));
            userinfomap.put("userinfoCode", user.getUserPcode());
            userinfomap.put("tenantCode", map.get("tenantCode"));
            this.updateUserinfoPhoneByCodeModel(userinfomap);
            map.put("successFlag", true);
            return map;
        }
        this.logger.error("\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25\uff0c\u539f\u624b\u673a\u53f7\u4e3a" + map.get("oldUserPhone"));
        return map;
    }

    private int updateUserPhoneByUserPhoneModel(Map<String, Object> map) {
        try {
            return this.umUserMapper.updateUserPhoneByUserPhone(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateUserPhoneByUserPhoneModel", (Object)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserPhoneByUserPhoneModel.ex", "\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
        }
    }

    private int updateUserinfoPhoneByCodeModel(Map<String, Object> map) {
        try {
            return this.umUserinfoMapper.updateUserinfoPhoneByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateUserinfoPhoneByCodeModel", (Object)"\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoPhoneByCodeModel.ex", "\u624b\u673a\u53f7\u4fee\u6539\u5931\u8d25");
        }
    }

    private boolean checkGroupHasExists(String groupCode, String tenantCode) {
        return true;
    }

    @Override
    public UmUserinfo getUserinfoByCode(String userinfoCode, String tenantCode) {
        UmUserinfo userinfoByCodeModel = this.getUserinfoByCodeModel(userinfoCode, tenantCode);
        if (null == userinfoByCodeModel) {
            return null;
        }
        QueryResult<UmUserinfoQua> umUserinfoQuaQueryResult = this.getUmUserinfoQuaService().queryUserinfoQuaPage(this.getQueryParamMap("userinfoCode,tenantCode", new Object[]{userinfoByCodeModel.getUserinfoCode(), userinfoByCodeModel.getTenantCode()}));
        userinfoByCodeModel.setUmUserinfoQuaDomainList(umUserinfoQuaQueryResult.getList());
        return userinfoByCodeModel;
    }

    private UmUserinfo getUserinfoByCodeModel(String userinfoCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        try {
            return this.umUserinfoMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserinfoByCodeModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<String> getAllManagerByCode(String userCode, String tenantCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        ArrayList<String> lists = new ArrayList<String>();
        this.loopManager(map, lists);
        if (ListUtil.isNotEmpty(lists)) {
            return lists;
        }
        return null;
    }

    private List<UmUser> loopManager(Map<String, Object> map, List<String> lists) {
        List<UmUser> manages = this.getManagerByCodeModel(map);
        if (ListUtil.isEmpty(manages)) {
            return manages;
        }
        String userCode = manages.get(0).getUserCode();
        map.put("userCode", userCode);
        lists.add(userCode);
        return this.loopManager(map, lists);
    }

    @Override
    public String getUserByNickName(String userNickname, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userNickname", userNickname);
        parammap.put("tenantCode", tenantCode);
        List<UmUser> list = this.queryUserModelPage(parammap);
        if (null == list || list.isEmpty()) {
            return "";
        }
        return list.get(0).getUserCode();
    }

    @Override
    public void updateUserLoginByCode(String userCode, String memo, String tenantCode) {
        this.updateUserModelByCode(memo, userCode, tenantCode);
    }

    @Override
    public int updateOpenUserinfoModelByCode(String userinfoCode, String tenantCode, Integer userinfoState, Integer oldUserinfoState) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode) || null == userinfoState) {
            return -1;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        map.put("userinfoState", userinfoState);
        map.put("oldUserinfoState", oldUserinfoState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateOpenByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateOpenUserinfoModelByCode.ex", (Throwable)e);
        }
        return i;
    }

    @Override
    public void sendUserinfo(UmUserinfo umUserinfo) throws ApiException {
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.sendUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        int i = this.updateOpenUserinfoModelByCode(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode(), 1, 0);
        if (i < 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.sendUserinfo.datastate");
        }
        if (i == 0) {
            return;
        }
        String apiCode = "vd.faccount.saveOpenFaccoun";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        VdFaccountOuterCtrlDomain vdFaccountOuterCtrlDomain = new VdFaccountOuterCtrlDomain();
        String batchcode = "0201";
        if (MerberType.PRE.getCode().equals(String.valueOf(umUserinfo.getUserinfoType()))) {
            batchcode = "0101";
        }
        vdFaccountOuterCtrlDomain.setFaccountDefBatchcode(batchcode);
        vdFaccountOuterCtrlDomain.setMerchantCode(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setMerchantName(null == umUserinfo.getUserinfoCompname() ? umUserinfo.getUserinfoPhone() : umUserinfo.getUserinfoCompname());
        vdFaccountOuterCtrlDomain.setTenantCode(umUserinfo.getTenantCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlExno(umUserinfo.getUserinfoCode());
        vdFaccountOuterCtrlDomain.setFaccountOuterCtrlCallurl("um.user.udateCallFaccount");
        paramMap.put("vdFaccountOuterCtrlDomain", JsonUtil.buildNormalBinder().toJson((Object)vdFaccountOuterCtrlDomain));
        this.getInternalRouter().inInvoke(apiCode, paramMap);
    }

    @Override
    public void loadUserinfoProcess() {
        this.loadSendDb();
    }

    private void loadSendDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("userinfoState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<UmUserinfo> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getUserinfoService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getUserinfoService().getPage());
                result = this.queryUserinfoReModelPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getUserinfoService().addPutPool(new UserinfoPutThread(this.getUserinfoService(), result.getRows()));
                    if (result.getRows().size() != this.getUserinfoService().getPage()) {
                        flag = false;
                    }
                } else {
                    flag = false;
                }
                Thread.sleep(5000L);
            } while (flag);
            this.getUserinfoService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.loadSendDb.e", (Throwable)e);
        }
    }

    @Override
    public String sendOpenUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveAllReInfo(umUserDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        UmUserinfo umUserinfo = umUserInfoSaveBean.getUmUserinfo();
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        umUserinfoList.add(umUserinfo);
        this.getUserinfoService().addPutPool(new UserinfoPutThread(this.getUserinfoService(), umUserinfoList));
        return umUserinfo.getUserinfoCode();
    }

    @Override
    public void udateCallFaccount(String faccountExno, String faccountCall, String tenantCode) {
        UmUserinfo umUserinfo = this.getUserinfoModelByCode(faccountExno, tenantCode);
        if (null == umUserinfo || 2 == umUserinfo.getUserinfoState()) {
            return;
        }
        int i = this.updateOpenUserinfoModelByCode(faccountExno, tenantCode, 2, 1);
        if (i < 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.udateCallFaccount.datastate");
        }
    }

    @Override
    public void sendBigDataForUser(Map<String, Object> map) {
        KafkaProducerUtil.sendProducerInfo((String)map.get("topic").toString(), (String)map.get("bigdata").toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserinfoService getUserinfoService() {
        Object object = lock;
        synchronized (object) {
            if (null == userinfoService) {
                userinfoService = new UserinfoService((UserService)SpringApplicationContextUtil.getBean((String)"userService"));
                userinfoService.putExecutor(50, 2000, 30L, TimeUnit.SECONDS, new SynchronousQueue(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
                for (int i = 0; i < 100; ++i) {
                    userinfoService.addPollPool(new UserinfoPollThread(userinfoService));
                }
            }
            return userinfoService;
        }
    }

    @Override
    public void updateUserPaywd(String userCode, String tenantCode, String userPaywd, String oldUserPaywd) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        UmUser umUser = this.getUserModelByCode(map);
        if (null == umUser) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserPaywd.null");
        }
        if (StringUtils.isNotBlank((String)oldUserPaywd) && !MD5Util.saltMD5Verify((String)oldUserPaywd, (String)umUser.getUserPaywd())) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserPaywd.no");
        }
        umUser.setUserPaywd(MD5Util.saltMD5((String)userPaywd));
        this.updateUserModel(umUser);
    }

    @Override
    public Map<String, Object> queryCheckPaywd(String userCode, String tenantCode, String userPaywd, String proappCode) throws ApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("type", "0");
        result.put("flag", true);
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userPaywd)) {
            result.put("flag", false);
            result.put("message", "\u53c2\u6570\u4e3a\u7a7a\uff01");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck.null");
            return result;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("userCode", userCode);
        UmUser umUser = this.getUserModelByCode(map);
        if (null == umUser) {
            result.put("flag", false);
            result.put("message", "\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck", (Object)(userCode + " | " + tenantCode));
            return result;
        }
        if (StringUtils.isBlank((String)umUser.getUserPaywd())) {
            result.put("flag", false);
            result.put("type", "1");
            result.put("message", "\u652f\u4ed8\u5bc6\u7801\u672a\u8bbe\u7f6e");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck.paywd", (Object)(userCode + " | " + tenantCode));
            return result;
        }
        if (!MD5Util.saltMD5Verify((String)userPaywd, (String)umUser.getUserPaywd())) {
            result.put("flag", false);
            result.put("message", "\u5bc6\u7801\u4e0d\u5339\u914d\uff01");
            this.logger.error("um.USER.UserBaseServiceImpl.queryUmuserCheck1", (Object)(userCode + " | " + tenantCode));
            return result;
        }
        if (umUser.getDataState() != 0) {
            result.put("flag", false);
            result.put("message", "\u7528\u6237\u767b\u5f55\u88ab\u9650\u5236,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!");
            return result;
        }
        return result;
    }

    @Override
    public void updateUserByUserPcode(String userinfoCode, String tenantCode) {
        int res = 0;
        try {
            res = this.umUserMapper.updateUserByUserPcode(userinfoCode, tenantCode);
            if (res == 0) {
                this.logger.error("um.USER.UserBaseServiceImplupdateUserByUserPcodeModel.umUserMapper", (Object)(userinfoCode + " " + tenantCode));
            }
            if ((res = this.umUserinfoMapper.updateUserByUserPcode(userinfoCode, tenantCode)) == 0) {
                this.logger.error("um.USER.UserBaseServiceImplupdateUserByUserPcodeModel.umUserinfoMapper", (Object)(userinfoCode + " " + tenantCode));
            }
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImplupdateUserByUserPcodeModel", (Object)(userinfoCode + " " + e));
            throw new ApiException("um.USER.UserBaseServiceImplupdateUserByUserPcode.ex");
        }
    }

    @Override
    public UmUser getUserByUserOcode(Map<String, Object> map) throws ApiException {
        return this.umUserMapper.getByOcode(map);
    }

    @Override
    public UmUser getUserByNameAndPhone(String userName, String phone, String tenantCode) {
        return this.selectByNameAndPhone(userName, phone, tenantCode);
    }

    @Override
    public UmUser getUserByUserPhone(String userPhone, String tenantCode) {
        return this.selectByPhone(userPhone, tenantCode);
    }

    @Override
    public void updateOcodeByUserName(String userOcode, String userName, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)userOcode) || StringUtils.isBlank((String)userName) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateOcodeModleByUserName(userOcode, userName, tenantCode);
    }

    @Override
    public String signCA(String userCode, String userPcode, String tenantCode) throws ApiException {
        UmUserinfo userinfoByCode = this.getUserinfoByCode(userPcode, tenantCode);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("update");
        umUsersendDomain.setUserinfoCode(userinfoByCode.getUserinfoCode());
        umUsersendDomain.setUserinfoType(userinfoByCode.getUserinfoType());
        umUsersendDomain.setTenantCode(userinfoByCode.getTenantCode());
        this.umUsersendBaseService.sendUsersend(umUsersendDomain);
        return "";
    }

    @Override
    public UmUserinfo getUserInfoByPhone(String userInfoPhone, String tenantCode) {
        return this.selectUserInfoByPhone(userInfoPhone, tenantCode);
    }

    @Override
    public void updateUserCacode(String userPhone, String userCacode, String tenantCode) {
        this.updateUserCacodeModel(userPhone, userCacode, tenantCode);
    }

    private void updateStoreStateByUserInfoId(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == userinfoId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoId", userinfoId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateStoreStateByUserInfoId(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateUserinfoModel.null");
        }
    }

    @Override
    public void updateStoreState(Integer userinfoId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStoreStateByUserInfoId(userinfoId, dataState, oldDataState);
    }

    private void updateOcodeModleByUserName(String userOcode, String userName, String tenantCode) {
        int i = 0;
        try {
            i = this.umUserMapper.updateOcodeByUserName(this.getQueryParamMap("userOcode,userName,tenantCode", new Object[]{userOcode, userName, tenantCode}));
            if (i > 0) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("userName", userName);
                map.put("tenantCode", tenantCode);
                UmUser umUser = this.umUserMapper.selectByName(map);
                if (null != umUser) {
                    this.umUserinfoMapper.updateOcodeByCode(this.getQueryParamMap("userinfoCode,userinfoOcode,tenantCode", new Object[]{umUser.getUserPcode(), userOcode, tenantCode}));
                }
            }
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateOcodeModleByUserName.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateOcodeModleByUserName.i");
        }
    }

    @Override
    public String saveOpenUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveAllReInfo(umUserDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        return umUserInfoSaveBean.getUmUserinfo().getUserinfoCode();
    }

    @Override
    public QueryResult<UmUsersend> queryUsersendPage(Map<String, Object> map) {
        return this.umUsersendBaseService.queryUsersendPage(map);
    }

    @Override
    public UmUser saveOperatorByMns(UmUserDomainBean umUserDomainBean) {
        if (null == umUserDomainBean) {
            throw new ApiException("um.USER.UserBaseServiceImpl.saveAllReInfo.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("um.USER.UserBaseServiceImpl.saveOperatorByMns ---------*********---------come" + umUserDomainBean.getTenantCode());
        UmUser user = this.saveUser(umUserDomainBean);
        this.logger.info("um.USER.UserBaseServiceImpl.saveAllReInfo ---------*********---------saveUser  end");
        return user;
    }

    @Override
    public void updateStateToApprove(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToApprove.map", "map\u4e3a\u7a7a");
        }
        String userinfoCode = (String)map.get("userinfoCode");
        String tenantCode = (String)map.get("tenantCode");
        String userCode = (String)map.get("userCode");
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToApprove.null", "userinfoCode\u4e3a\u7a7a");
        }
        this.updateUserinfoDataStateByCode(userinfoCode, tenantCode);
        UmUserinfo userinfo = this.getUserinfoByCodeModel(userinfoCode, tenantCode);
        if (null == userinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToApprove.userinfo", "userinfo\u4e3a\u7a7a");
        }
        String qualityStr = userinfo.getUserinfoQuality();
        String roleCodeStr = userinfo.getRoleCode();
        String userinfoQualityNew = (String)map.get("userinfoQuality");
        String roleCodeNew = (String)map.get("roleCode");
        if (StringUtils.isNotBlank((String)qualityStr) && StringUtils.isNotBlank((String)userinfoQualityNew) && !qualityStr.contains(userinfoQualityNew)) {
            qualityStr = qualityStr + ",";
            qualityStr = qualityStr + userinfoQualityNew;
        }
        if (StringUtils.isNotBlank((String)roleCodeStr) && StringUtils.isNotBlank((String)roleCodeNew) && !roleCodeStr.contains(roleCodeNew)) {
            roleCodeStr = roleCodeStr + ",";
            roleCodeStr = roleCodeStr + roleCodeNew;
        }
        map.put("userinfoQuality", qualityStr);
        map.put("roleCode", roleCodeStr);
        map.put("dataState", "0");
        this.updateUserinfoQualityCode(map);
        this.updateUserInfoCache(tenantCode, userinfoCode);
        this.logger.info("um.USER.UserBaseServiceImpl.updateStateToApprove.map", (Object)map.toString());
        if (StringUtils.isNotBlank((String)userCode)) {
            UmUser umUser = this.getUserByUserCode(userCode, tenantCode);
            if (null == umUser) {
                throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToApprove.umUser", "umUser\u4e3a\u7a7a");
            }
            map = new HashMap<String, Object>();
            map.put("userinfoQuality", qualityStr);
            map.put("roleCode", roleCodeStr);
            map.put("userCode", userCode);
            map.put("dataState", "0");
            map.put("tenantCode", tenantCode);
            this.updateUserQualityCode(map);
            this.updateUserCache(tenantCode, userCode);
        }
    }

    private void updateUserInfoCache(String tenantCode, String userinfoCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            return;
        }
        String upkey = tenantCode + "-" + userinfoCode;
        String xustr = DisUtil.getRemotMap((String)this.cacheInfokey, (String)upkey);
        if (StringUtils.isBlank((String)xustr)) {
            xustr = "0";
        }
        int xu = Integer.valueOf(xustr) + 1;
        DisUtil.setMap((String)this.cacheInfokey, (String)upkey, (String)String.valueOf(xu));
    }

    private void updateUserCache(String tenantCode, String userCode) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userCode)) {
            return;
        }
        String upkey = tenantCode + "-" + userCode;
        String xustr = DisUtil.getRemotMap((String)this.cacheUserkey, (String)upkey);
        if (StringUtils.isBlank((String)xustr)) {
            xustr = "0";
        }
        int xu = Integer.valueOf(xustr) + 1;
        DisUtil.setMap((String)this.cacheUserkey, (String)upkey, (String)String.valueOf(xu));
    }

    @Override
    public void updateStateToReApprove(UmUserDomainBean umUserDomainBean) throws ApiException {
        if (null == umUserDomainBean) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToReApprove", "umUserDomainBean\u4e3a\u7a7a");
        }
        UmUserinfoDomainBean umUserinfoDomainBean = new UmUserinfoDomainBean();
        UmUserinfo userinfo = this.getUserinfoByCode(umUserDomainBean.getUserinfoCode(), umUserDomainBean.getTenantCode());
        if (null == userinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToReApprove.userinfo", "umUserDomainBean\u4e3a\u7a7a");
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)userinfo);
            BeanUtils.copyAllPropertys((Object)umUserinfoDomainBean, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToReApprove.e", (Throwable)e);
        }
        umUserinfoDomainBean.setRoleCode(userinfo.getRoleCode());
        umUserinfoDomainBean.setUserinfoQuality(userinfo.getUserinfoQuality());
        umUserinfoDomainBean.setUserinfoType(userinfo.getUserinfoType());
        if (0 != userinfo.getDataState()) {
            umUserinfoDomainBean.setDataState(3);
        } else {
            umUserinfoDomainBean.setDataState(0);
        }
        this.updateUserinfo(umUserinfoDomainBean);
        QueryResult<UmUser> umUserQueryResult = this.queryUserPage(this.getQueryParamMap("tenantCode,userPcode", new Object[]{userinfo.getTenantCode(), userinfo.getUserinfoCode()}));
        if (ListUtil.isEmpty((Collection)umUserQueryResult.getList())) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToReApprove.userinfo", "umUser\u4e3a\u7a7a");
        }
        UmUser umUser = (UmUser)umUserQueryResult.getList().get(0);
        try {
            BeanUtils.copyAllPropertysNotNull((Object)umUser, (Object)umUserDomainBean);
        }
        catch (Exception e) {
            // empty catch block
        }
        this.updateUserModel(umUser);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", umUserinfoDomainBean.getUserinfoCode());
        map.put("tenantCode", umUserinfoDomainBean.getTenantCode());
        map.put("userinfoapplyType", "0");
        QueryResult<UmUserinfoapply> umUserinfoapplyQueryResult = this.getUmUserinfoapplyService().queryUserinfoapplyPage(map);
        if (ListUtil.isEmpty((Collection)umUserinfoapplyQueryResult.getList())) {
            UmUserinfoapplyDomain umUserinfoapplyDomain = new UmUserinfoapplyDomain();
            try {
                BeanUtils.copyAllPropertysNotNull((Object)umUserinfoapplyDomain, (Object)userinfo);
            }
            catch (Exception e) {
                this.logger.error(SYS_CODE, (Object)(".updateStateToReApprove" + e));
            }
            umUserinfoapplyDomain.setQualityCode(umUserDomainBean.getUserinfoQuality());
            umUserinfoapplyDomain.setDataState(0);
            umUserinfoapplyDomain.setUserinfoapplyType(0);
            umUserinfoapplyDomain.setUserCode(umUserDomainBean.getUserCode());
            this.getUmUserinfoapplyService().saveUserinfoapply(umUserinfoapplyDomain);
        } else {
            map = new HashMap();
            map.put("memo", "");
            this.getUmUserinfoapplyService().updateUserinfoapplyState(((UmUserinfoapply)umUserinfoapplyQueryResult.getList().get(0)).getUserinfoapplyId(), 0, 2, map);
        }
    }

    @Override
    public void updateToJoinBlackCommon(List<UmUserinfoblakDomain> umUserinfoblakDomainList) throws ApiException {
        if (ListUtil.isEmpty(umUserinfoblakDomainList)) {
            return;
        }
        for (UmUserinfoblakDomain umUserinfoblakDomain : umUserinfoblakDomainList) {
            this.updateUserinfoBtateModel(1, umUserinfoblakDomain.getUserinfoCode(), umUserinfoblakDomain.getTenantCode());
        }
        this.getUmUserinfoblakService().saveUserinfoblakBatch(umUserinfoblakDomainList);
    }

    @Override
    public void updateToRemoveBlacklist(String userinfoblakIdList) throws ApiException {
        if (StringUtils.isBlank((String)userinfoblakIdList)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateToRemoveBlacklist", "userinfoblakIdList \u4e3a\u7a7a");
        }
        String[] split = (userinfoblakIdList = userinfoblakIdList.replaceAll("\"", "")).split("\\,");
        if (null == split) {
            return;
        }
        for (String userinfoblakId : split) {
            UmUserinfoblak userinfoblak = this.getUmUserinfoblakService().getUserinfoblak(Integer.valueOf(userinfoblakId));
            if (null == userinfoblak) continue;
            try {
                userinfoblak.setUserinfoblakEdate(new Date());
                this.updateToRemoveBlackModel(userinfoblak);
            }
            catch (ApiException e) {
                this.logger.error("um.USER.UserBaseServiceImplupdateToRemoveBlacklist:\u9ed1\u540d\u5355\u6279\u91cf\u79fb\u9664\u5355\u6761\u8bb0\u5f55\u5931\u8d25,userinfoblakCode=" + userinfoblak.getUserinfoblakCode());
            }
        }
    }

    @Override
    public void updateToRemoveBlack(String userinfoblakId) throws ApiException {
        if (StringUtils.isBlank((String)userinfoblakId)) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateToRemoveBlack", "userinfoblakId \u4e3a\u7a7a");
        }
        UmUserinfoblak userinfoblak = this.getUmUserinfoblakService().getUserinfoblak(Integer.valueOf(userinfoblakId));
        if (null == userinfoblak) {
            return;
        }
        this.updateToRemoveBlackModel(userinfoblak);
    }

    @Override
    public void updateSendToRemoveBlack(UmUserinfoblak userinfoblak) throws ApiException {
        if (null == userinfoblak) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateSendToRemoveBlack", "userinfoblak \u4e3a\u7a7a");
        }
        this.updateToRemoveBlackModel(userinfoblak);
    }

    private void updateToRemoveBlackModel(UmUserinfoblak userinfoblak) throws ApiException {
        String tenantCode;
        if (null == userinfoblak) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateToRemoveBlack", "userinfoblakId \u4e3a\u7a7a");
        }
        String userInfoCode = userinfoblak.getUserinfoCode();
        UmUserinfo userinfo = this.getUserinfoByCode(userInfoCode, tenantCode = userinfoblak.getTenantCode());
        if (null == userinfo) {
            return;
        }
        Integer oldUserinfoBtate = userinfo.getUserinfoBtate();
        if (null == oldUserinfoBtate) {
            oldUserinfoBtate = 0;
        }
        this.updateUserinfoBtateModel(oldUserinfoBtate, userInfoCode, tenantCode);
        this.getUmUserinfoblakService().updateUserinfoblakState(userinfoblak.getUserinfoblakId(), -1, 0, null);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoCode", userInfoCode);
        map.put("tenantCode", userinfoblak.getTenantCode());
        map.put("dataState", "0");
        QueryResult<UmUserinfoblak> umUserinfoblakQueryResult = this.getUmUserinfoblakService().queryUserinfoblakPage(map);
        if (null == umUserinfoblakQueryResult || ListUtil.isEmpty((Collection)umUserinfoblakQueryResult.getList())) {
            oldUserinfoBtate = 0;
            this.updateUserinfoBtateModel(oldUserinfoBtate, userInfoCode, tenantCode);
        }
    }

    private void updateUserinfoBtateModel(Integer userinfoBtate, String userinfoCode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoBtate", userinfoBtate);
        map.put("userinfoCode", userinfoCode);
        map.put("tenantCode", tenantCode);
        int i = 0;
        try {
            i = this.umUserinfoMapper.updateUserinfoBtateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoBtateModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfoBtateModel.i");
        }
    }

    @Override
    public String sendStoreUserinfo(UmUserDomainBean umUserDomainBean) throws ApiException {
        String s;
        UmUserInfoSaveBean umUserInfoSaveBean = this.saveAllReInfo(umUserDomainBean);
        if (null == umUserInfoSaveBean || null == umUserInfoSaveBean.getUmUserinfo()) {
            return null;
        }
        UmUserinfo umUserinfo = umUserInfoSaveBean.getUmUserinfo();
        String userinfoCode = umUserinfo.getUserinfoCode();
        String tenantCode = "00000000";
        String userinfoPhone = umUserinfo.getUserinfoPhone();
        String randomNum = umUserinfo.getMemo();
        if (StringUtils.isBlank((String)umUserDomainBean.getUserPwsswd()) && StringUtils.isNotBlank((String)userinfoPhone) && !"success".equals(s = this.sendMnsToUser(userinfoCode, tenantCode, userinfoPhone, tenantCode))) {
            this.logger.error("um.USER.UserBaseServiceImplsendStoreUserinfo=randomNum=" + randomNum);
        }
        umUserinfo.setMemo(null);
        if (ListUtil.isEmpty(umUserDomainBean.getUmUserinfoQuaDomainList())) {
            this.logger.error("um.USER.UserBaseServiceImplsendStoreUserinfo.UmUserinfoQuaDomainList is null");
            return null;
        }
        ArrayList<UmUserinfo> umUserinfoList = new ArrayList<UmUserinfo>();
        umUserinfoList.add(umUserinfo);
        this.getUserinfoService().addPutPool(new UserinfoPutThread(this.getUserinfoService(), umUserinfoList));
        if (ListUtil.isNotEmpty(umUserInfoSaveBean.getUmUsersendList())) {
            UmUsersendServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(UmUsersendServiceImpl.getEsEngineService(), umUserInfoSaveBean.getUmUsersendList()));
        }
        return umUserinfo.getUserinfoCode();
    }

    @Override
    public List<UmUserinfoDataModel> queryUserinfoSaveNewBigData(Map<String, Object> map) throws ApiException {
        return this.queryUserinfoSaveNewBigDataModel(map);
    }

    @Override
    public List<UmUserinfoDataModel> queryUserinfoProvinceBigData(Map<String, Object> map) throws ApiException {
        return this.queryUserinfoProvinceBigDataModel(map);
    }

    @Override
    public List<UmUserinfoDataModel> queryUserinfoLevelBigData(Map<String, Object> map) throws ApiException {
        return this.queryUserinfoLevelBigDataModel(map);
    }

    private List<UmUserinfoDataModel> queryUserinfoSaveNewBigDataModel(Map<String, Object> map) throws ApiException {
        try {
            return this.umUserinfoMapper.queryUserinfoSaveNewBigData(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserinfoLevelBigDataModel", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfoDataModel> queryUserinfoProvinceBigDataModel(Map<String, Object> map) throws ApiException {
        try {
            return this.umUserinfoMapper.queryUserinfoProvinceBigData(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserinfoLevelBigDataModel", (Throwable)e);
            return null;
        }
    }

    private List<UmUserinfoDataModel> queryUserinfoLevelBigDataModel(Map<String, Object> map) throws ApiException {
        try {
            return this.umUserinfoMapper.queryUserinfoLevelBigData(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.queryUserinfoLevelBigDataModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public String updateUserUcode(String userinfoUcode, String userinfoCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        if (StringUtils.isBlank((String)userinfoUcode)) {
            userinfoUcode = this.createUUIDString();
        }
        this.updateUcodeModelByCode(userinfoUcode, userinfoCode, tenantCode);
        return userinfoUcode;
    }

    @Override
    public UmUserinfo getUserInfoByQualityAndStore(Map<String, Object> map) throws ApiException {
        if (MapUtil.isEmpty(map)) {
            this.logger.error("um.USER.UserBaseServiceImpl.getUserInfoByQualityAndStore", (Object)"map is null");
            return null;
        }
        return this.umUserinfoMapper.getUserInfoByQualityAndStore(map);
    }

    @Override
    public void updateParent(Map<String, Object> map) throws ApiException {
        this.updateUserinfoParentModel(map);
    }

    @Override
    public void updateLevel(Map<String, Object> map) throws ApiException {
        this.updateUserinfoLevel(map);
    }

    @Override
    public void updateUserinfoDiscode(Map<String, Object> map) throws ApiException {
        this.updateUserinfoDiscodeByCode(map);
    }

    public UmUserinfoapplyQuaService getUmUserinfoapplyQuaService() {
        if (null == this.umUserinfoapplyQuaService) {
            this.umUserinfoapplyQuaService = (UmUserinfoapplyQuaService)ApplicationContextUtil.getService((String)"umUserinfoapplyQuaService");
        }
        return this.umUserinfoapplyQuaService;
    }

    private UmUsersend updateUserinfoapplyQuaCom(UmUserinfoapply userinfoapply) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userinfoapplyCode", userinfoapply.getUserinfoapplyCode());
        map.put("tenantCode", userinfoapply.getTenantCode());
        QueryResult<UmUserinfoapplyQua> umUserinfoapplyQuaQueryResult = this.getUmUserinfoapplyQuaService().queryUserinfoapplyQuaPage(map);
        if (ListUtil.isEmpty((Collection)umUserinfoapplyQuaQueryResult.getList())) {
            return null;
        }
        String quaKey = null;
        String quaValue = null;
        String userinfoCode = userinfoapply.getUserinfoCode();
        String tenantCode = userinfoapply.getTenantCode();
        UmUserinfoDomainBean umUserinfoDomain = new UmUserinfoDomainBean();
        umUserinfoDomain.setUserinfoCode(userinfoCode);
        umUserinfoDomain.setTenantCode(tenantCode);
        umUserinfoDomain.setUserinfoQuality(userinfoapply.getQualityCode());
        ArrayList<UmUserinfoQuaDomain> umUserinfoQuaList = new ArrayList<UmUserinfoQuaDomain>();
        String userName = null;
        String userRelName = null;
        for (UmUserinfoapplyQua umUserinfoapplyQua : umUserinfoapplyQuaQueryResult.getList()) {
            String[] colS;
            quaKey = umUserinfoapplyQua.getUserinfoapplyQuaKey();
            quaValue = umUserinfoapplyQua.getUserinfoapplyQuaVaule();
            if (StringUtils.isBlank((String)quaKey) || quaKey.indexOf("_") <= 0 || null == (colS = quaKey.split("\\_")) || colS.length != 2) continue;
            if (colS[0].equals("userinfo")) {
                switch (colS[1]) {
                    case "userinfoCompname": {
                        umUserinfoDomain.setUserinfoCompname(quaValue);
                        userRelName = quaValue;
                        break;
                    }
                    case "userinfoCertUrl": {
                        umUserinfoDomain.setUserinfoCertUrl(quaValue);
                        break;
                    }
                    case "userinfoCert1Url": {
                        umUserinfoDomain.setUserinfoCert1Url(quaValue);
                        break;
                    }
                    case "userinfoCert2Url": {
                        umUserinfoDomain.setUserinfoCert2Url(quaValue);
                        break;
                    }
                    case "userinfoTaun": {
                        umUserinfoDomain.setUserinfoTaun(quaValue);
                        break;
                    }
                    case "companyAddress": {
                        umUserinfoDomain.setCompanyAddress(quaValue);
                        break;
                    }
                    case "userinfoConPhone": {
                        umUserinfoDomain.setUserinfoConPhone(quaValue);
                        break;
                    }
                    case "userinfoCertNo": {
                        umUserinfoDomain.setUserinfoCertNo(quaValue);
                        break;
                    }
                    case "userinfoCert1No": {
                        umUserinfoDomain.setUserinfoCert1No(quaValue);
                        break;
                    }
                    case "userinfoCert2No": {
                        umUserinfoDomain.setUserinfoCert2No(quaValue);
                        break;
                    }
                    case "userinfoCorp": {
                        umUserinfoDomain.setUserinfoCorp(quaValue);
                        break;
                    }
                    case "userName": {
                        userName = quaValue;
                        break;
                    }
                    default: {
                        BeanUtils.forceSetProperty((Object)umUserinfoDomain, (String)colS[1], (Object)quaValue);
                        break;
                    }
                }
                continue;
            }
            if (!colS[0].equals("userinfoQua")) continue;
            UmUserinfoQuaDomain umUserinfoQua = new UmUserinfoQuaDomain();
            umUserinfoQua.setQualityCode(userinfoapply.getQualityCode());
            switch (colS[1]) {
                case "CompanyLineCode": {
                    umUserinfoQua.setUserinfoQuaKey("CompanyLineCode");
                    umUserinfoQua.setUserinfoQuaVaule(quaValue);
                    break;
                }
                case "regCapital": {
                    umUserinfoQua.setUserinfoQuaKey("regCapital");
                    umUserinfoQua.setUserinfoQuaVaule(quaValue);
                    break;
                }
                case "CompanyProfile": {
                    umUserinfoQua.setUserinfoQuaKey("regCapital");
                    umUserinfoQua.setUserinfoQuaVaule(quaValue);
                    break;
                }
                default: {
                    umUserinfoQua.setUserinfoQuaKey(colS[1]);
                    umUserinfoQua.setUserinfoQuaVaule(quaValue);
                }
            }
            umUserinfoQuaList.add(umUserinfoQua);
        }
        umUserinfoDomain.setUserName(userName);
        umUserinfoDomain.setUserRelName(userRelName);
        umUserinfoDomain.setUmUserinfoQuaDomainList(umUserinfoQuaList);
        return this.updateUserinfo(umUserinfoDomain);
    }

    @Override
    public UmUsersend updateUserinfoapplyState(Integer userinfoapplyId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.getUmUserinfoapplyService().updateUserinfoapplyState(userinfoapplyId, dataState, oldDataState, map);
        UmUserinfoapply userinfoapply = this.getUmUserinfoapplyService().getUserinfoapply(userinfoapplyId);
        if (null == userinfoapply) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateStateToApproveToCheck.userinfoapply", "userinfoapply\u4e3a\u7a7a");
        }
        UmUsersend umUsersend = null;
        if (1 == dataState) {
            if (MapUtil.isEmpty(map)) {
                map = new HashMap<String, Object>();
            }
            map.put("userinfoCode", userinfoapply.getUserinfoCode());
            map.put("tenantCode", userinfoapply.getTenantCode());
            map.put("userCode", userinfoapply.getUserCode());
            map.put("userinfoQuality", userinfoapply.getQualityCode());
            map.put("roleCode", userinfoapply.getRoleCode());
            map.put("userinfoType", userinfoapply.getUserinfoType());
            map.put("userinfoParentCode", userinfoapply.getUserinfoParentCode());
            map.put("userinfoParentName", userinfoapply.getUserinfoParentName());
            map.put("userinfoCompname", userinfoapply.getUserinfoCompname());
            map.put("userinfoOpcode", userinfoapply.getUserinfoDiscode());
            if (StringUtils.isNotBlank((String)userinfoapply.getUserinfoChannelcode())) {
                map.put("userinfoChannelcode", userinfoapply.getUserinfoChannelcode());
                map.put("userinfoChannelname", userinfoapply.getUserinfoChannelname());
            }
            map.put("provinceCode", userinfoapply.getProvinceCode());
            map.put("provinceName", userinfoapply.getProvinceName());
            map.put("cityCode", userinfoapply.getCityCode());
            map.put("cityName", userinfoapply.getCityName());
            map.put("areaCode", userinfoapply.getAreaCode());
            map.put("areaName", userinfoapply.getAreaName());
            map.put("userinfoCon", userinfoapply.getUserNickname());
            map.put("userinfoSort", userinfoapply.getUserinfoSort());
            this.updateStateToApprove(map);
            umUsersend = this.updateUserinfoapplyQuaCom(userinfoapply);
            if (null == umUsersend) {
                UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
                umUsersendDomain.setUsersendType("update");
                umUsersendDomain.setUserinfoCode(userinfoapply.getUserinfoCode());
                umUsersendDomain.setUserinfoType(userinfoapply.getUserinfoType());
                umUsersendDomain.setTenantCode(userinfoapply.getTenantCode());
                umUsersendDomain.setUsersendData(JsonUtil.buildNormalBinder().toJson((Object)userinfoapply));
                return this.umUsersendBaseService.sendUsersend(umUsersendDomain);
            }
        } else if (2 == dataState) {
            UmUserinfo userinfoByCode = this.getUserinfoByCodeModel(userinfoapply.getUserinfoCode(), userinfoapply.getTenantCode());
            if (null == userinfoByCode) {
                return null;
            }
            if (1 != userinfoapply.getUserinfoapplyType()) {
                Integer state = 4;
                if ("2020050600004084".equals(userinfoapply.getTenantCode())) {
                    state = dataState;
                }
                umUsersend = this.updateUserinfoState(userinfoByCode.getUserinfoId(), state, userinfoByCode.getDataState(), null);
            }
        }
        return umUsersend;
    }

    @Override
    public UmUserDomain getUserByPcode(String userPcode, String tenantCode) {
        if (StringUtils.isBlank((String)userPcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userPcode", userPcode);
        map.put("tenantCode", tenantCode);
        UmUser umUser = this.umUserMapper.getByPcode(map);
        UmUserDomain umUserDomain = null;
        if (null != umUser) {
            umUserDomain = new UmUserDomain();
            try {
                BeanUtils.copyAllPropertys((Object)umUserDomain, (Object)umUser);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return umUserDomain;
    }

    @Override
    public void updateUserDatetime(Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)((String)map.get("userCode")))) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserDatetime.", "userCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String tenantCode = (String)map.get("tenantCode");
        UmUser umUser = this.getUserByUserCode((String)map.get("userCode"), tenantCode);
        if (null == umUser) {
            return;
        }
        Date sysDate = this.getSysDate();
        if (null == umUser.getUserinfoLoginf()) {
            umUser.setUserinfoLoginf(sysDate);
        }
        String openid = (String)map.get("openid");
        String unionid = (String)map.get("unionid ");
        if (StringUtils.isNotBlank((String)openid)) {
            umUser.setUserOpenid(openid);
        }
        if (StringUtils.isNotBlank((String)unionid)) {
            umUser.setUserUnionid(unionid);
        }
        umUser.setUserinfoLoginl(sysDate);
        this.updateUserModel(umUser);
        UmUserinfo userinfo = this.getUserinfoByCode(umUser.getUserPcode(), tenantCode);
        if (null == userinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUserDatetime.userinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (null == userinfo.getUserinfoLoginf()) {
            userinfo.setUserinfoLoginf(sysDate);
        }
        userinfo.setUserinfoLoginl(sysDate);
        this.updateUserinfoModel(userinfo);
    }

    @Override
    public String updateUserinfoOrder(String userinfoCode, String tenantCode, String num) throws ApiException {
        this.logger.error("um.USER.UserBaseServiceImpl.updateUserinfoOrder", (Object)(userinfoCode + "-" + tenantCode + "-" + num));
        if (StringUtils.isBlank((String)userinfoCode)) {
            return "error";
        }
        UmUserinfo userinfo = this.getUserinfoByCode(userinfoCode, tenantCode);
        if (null == userinfo) {
            return "error";
        }
        Integer integer = Integer.valueOf(num);
        if (null != userinfo.getUserinfoOrder()) {
            integer = userinfo.getUserinfoOrder() + integer;
        }
        userinfo.setUserinfoOrder(integer > 0 ? integer : 0);
        this.updateUserinfoModel(userinfo);
        return "success";
    }

    @Override
    public void saveUserBirthday(String tenantCode) throws ApiException {
        List<UmUsersend> umUsersends = this.saveUmUsersend(tenantCode);
        if (ListUtil.isNotEmpty(umUsersends)) {
            UmUsersendServiceImpl.getEsEngineService().addPutPool(new EsEnginePutThread(UmUsersendServiceImpl.getEsEngineService(), umUsersends));
        }
    }

    @Override
    public UmUserinfo getUserInfoByOcode(String userInfoOcode, String tenantCode) {
        return this.umUserinfoMapper.selectUserInfoByOcode(this.getQueryParamMap("userinfoOcode,tenantCode", new Object[]{userInfoOcode, tenantCode}));
    }

    @Override
    public void updateUserinfoParentCode(String userinfoCode, String userinfoParentCode, String tenantCode) {
        try {
            this.umUserinfoMapper.updateUserinfoParentCode(this.getQueryParamMap("userinfoCode,userinfoParentCode,tenantCode", new Object[]{userinfoCode, userinfoParentCode, tenantCode}));
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    @Override
    public void updateUmUserinfo(UmUserinfo umUserinfo) {
        if (null == umUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUmUserinfo.umUserinfo", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo oldUmUserinfo = this.getUserinfoModelByCode(umUserinfo.getUserinfoCode(), umUserinfo.getTenantCode());
        if (null == oldUmUserinfo) {
            throw new ApiException("um.USER.UserBaseServiceImpl.updateUmUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmUserinfo userinfo = this.makeUserinfo(umUserinfo, oldUmUserinfo);
        this.setUserinfoUpdataDefault(userinfo);
        this.updateUserinfoModel(userinfo);
    }

    @Override
    public Map<String, Object> saveOrupdateUserinfoBatch(List<UmUserinfoDomainBean> umUserinfoDomainBeanList) throws ApiException {
        HashMap<String, Object> userinfoCodeMap = new HashMap<String, Object>();
        for (UmUserinfoDomainBean umUserinfoDomainBean : umUserinfoDomainBeanList) {
            String newrole;
            String msg = this.checkUserinfo(umUserinfoDomainBean);
            if (StringUtils.isNotBlank((String)msg)) {
                throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.checkUserinfo", msg);
            }
            Integer userinfoId = umUserinfoDomainBean.getUserinfoId();
            if (userinfoId == null) {
                String userinfoCode = this.saveUserinfo(umUserinfoDomainBean);
                userinfoCodeMap.put(umUserinfoDomainBean.getUserRelName(), userinfoCode);
            }
            UmUserinfo oldUmUserinfo = this.getUserinfoModelById(umUserinfoDomainBean.getUserinfoId());
            UmUserinfo umUserinfo = new UmUserinfo();
            String newqua = umUserinfoDomainBean.getUserinfoQuality();
            if (null == newqua) {
                newqua = "";
            }
            if (null == (newrole = umUserinfoDomainBean.getRoleCode())) {
                newrole = "";
            }
            if (null == oldUmUserinfo) {
                oldUmUserinfo = this.getUserinfoByCode(umUserinfoDomainBean.getUserinfoCode(), umUserinfoDomainBean.getTenantCode());
                if (null == oldUmUserinfo) {
                    throw new ApiException("um.USER.UserBaseServiceImpl.updateUserinfo.null", "\u6570\u636e\u4e3a\u7a7a");
                }
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)oldUmUserinfo);
                    BeanUtils.copyAllPropertysNotNull((Object)umUserinfo, (Object)umUserinfoDomainBean);
                }
                catch (Exception e) {}
            } else {
                String oldrole;
                String oldqua = oldUmUserinfo.getUserinfoQuality();
                if (null == oldqua) {
                    oldqua = "";
                }
                if (null == (oldrole = oldUmUserinfo.getRoleCode())) {
                    oldrole = "";
                }
                umUserinfo = this.makeUserinfo(umUserinfoDomainBean, oldUmUserinfo);
                Integer userinfoType = oldUmUserinfo.getUserinfoType();
                umUserinfo.setUserinfoType(userinfoType);
            }
            this.setUserinfoUpdataDefault(umUserinfo);
            this.updateUserinfoModel(umUserinfo);
        }
        return userinfoCodeMap;
    }

    @Override
    public int getCountUserinfo(Map<String, Object> map) throws ApiException {
        return this.countUserinfo(map);
    }

    private UmUserinfo makeUserinfo(UmUserinfo newUserinfo, UmUserinfo umUserinfo) {
        if (null == newUserinfo) {
            return null;
        }
        if (null == umUserinfo) {
            umUserinfo = new UmUserinfo();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umUserinfo, (Object)newUserinfo);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UserBaseServiceImpl.makeUserinfo", (Throwable)e);
        }
        return umUserinfo;
    }

    private List<UmUsersend> saveUmUsersend(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("userBirthday", DateUtil.getDateString((Date)this.getSysDate(), (String)"MM-dd"));
        map.put("fuzzy", true);
        if (StringUtils.isNotBlank((String)tenantCode)) {
            map.put("tenantCode", tenantCode);
        }
        List<UmUser> umUsers = this.queryUserList(map);
        ArrayList<UmUsersend> umUsersendList = new ArrayList<UmUsersend>();
        for (UmUser umUser : umUsers) {
            UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
            umUsersendDomain.setUsersendType("birthday");
            umUsersendDomain.setUserinfoCode(umUser.getUserPcode());
            umUsersendDomain.setTenantCode(umUser.getTenantCode());
            UmUsersend umUsersend = this.umUsersendBaseService.sendUsersend(umUsersendDomain);
            if (null == umUsersend) continue;
            umUsersendList.add(umUsersend);
        }
        return umUsersendList;
    }

    @Override
    public UmUsersend updateUserinfoOrg(String userinfoCode, String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        UmUserinfo umUserinfo = this.getUserinfoByCodeModel(userinfoCode, tenantCode);
        if (null == umUserinfo) {
            return null;
        }
        this.updateUserinfoOrgModel(map);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("custupdate");
        umUsersendDomain.setUserinfoCode(umUserinfo.getUserinfoCode());
        umUsersendDomain.setUserinfoType(umUserinfo.getUserinfoType());
        umUsersendDomain.setTenantCode(umUserinfo.getTenantCode());
        UmUsersend umUsersend = this.umUsersendBaseService.sendUsersend(umUsersendDomain);
        return umUsersend;
    }

    @Override
    public UmUsersend updateUserOcode(String userCode, String tenantCode, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)userCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        map.put("userCode", userCode);
        map.put("tenantCode", tenantCode);
        this.updateUserOcodeModel(map);
        UmUsersendDomain umUsersendDomain = new UmUsersendDomain();
        umUsersendDomain.setUsersendType("u-ouser");
        umUsersendDomain.setUserinfoCode(userCode);
        umUsersendDomain.setUserinfoType(0);
        umUsersendDomain.setTenantCode(tenantCode);
        UmUsersend umUsersend = this.umUsersendBaseService.sendUsersend(umUsersendDomain);
        return umUsersend;
    }

    @Override
    public UmUsersend saveGroup(UmGroupDomain umGroupDomain) {
        if (null == umGroupDomain) {
            this.logger.error("um.USER.UserBaseServiceImpl.sendSaveGroup.umGroupDomain.null");
            return null;
        }
        UmUsersend umUsersend = this.umGroupService.saveGroupRe(umGroupDomain);
        return umUsersend;
    }

    @Override
    public UmUsersend deleteGroupByCodeRe(String tenantCode, String groupCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)groupCode)) {
            this.logger.error("um.USER.UserBaseServiceImpl.deleteGroupByCodeRe.groupCode.null");
            return null;
        }
        UmUsersend umUsersend = this.umGroupService.deleteGroupByCodeRe(tenantCode, groupCode);
        return umUsersend;
    }

    @Override
    public UmUsersend deleteGroupRe(Integer groupId) throws ApiException {
        if (null == groupId) {
            this.logger.error("um.USER.UserBaseServiceImpl.deleteGroupRe.umGroupDomain.null");
            return null;
        }
        UmUsersend umUsersend = this.umGroupService.deleteGroupRe(groupId);
        return umUsersend;
    }

    @Override
    public UmUsersend updateGroupRe(UmGroupDomain umGroupDomain) throws ApiException {
        if (null == umGroupDomain) {
            this.logger.error("um.USER.UserBaseServiceImpl.updateGroupRe.umGroupDomain.null");
            return null;
        }
        UmUsersend umUsersend = this.umGroupService.updateGroupRe(umGroupDomain);
        return umUsersend;
    }

    static {
        lock = new Object();
    }
}

