/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.user.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.user.dao.UmRoleMapper;
import com.yqbsoft.laser.service.user.domain.UmRoleDomain;
import com.yqbsoft.laser.service.user.domain.UmRoleReDomain;
import com.yqbsoft.laser.service.user.model.UmRole;
import com.yqbsoft.laser.service.user.service.UmRoleService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UmRoleServiceImpl
extends BaseServiceImpl
implements UmRoleService {
    private static final String SYS_CODE = "um.USER.UmRoleServiceImpl";
    private UmRoleMapper umRoleMapper;

    public void setUmRoleMapper(UmRoleMapper umRoleMapper) {
        this.umRoleMapper = umRoleMapper;
    }

    private Date getSysDate() {
        try {
            return this.umRoleMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRole(UmRoleDomain umRoleDomain) {
        if (null == umRoleDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)umRoleDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRoleDefault(UmRole umRole) {
        if (null == umRole) {
            return;
        }
        if (null == umRole.getDataState()) {
            umRole.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == umRole.getGmtCreate()) {
            umRole.setGmtCreate(date);
        }
        umRole.setGmtModified(date);
        if (StringUtils.isBlank((String)umRole.getRoleCode())) {
            umRole.setRoleCode(this.getNo(null, "UmRole", "umRole", umRole.getTenantCode()));
        }
    }

    private int getRoleMaxCode() {
        int code = 0;
        try {
            return this.umRoleMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.getRoleMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRoleUpdataDefault(UmRole umRole) {
        if (null == umRole) {
            return;
        }
        umRole.setGmtModified(this.getSysDate());
    }

    private void saveRoleModel(UmRole umRole) throws ApiException {
        if (null == umRole) {
            return;
        }
        try {
            this.umRoleMapper.insert(umRole);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.saveRoleModel.ex", (Throwable)e);
        }
    }

    private void saveRoleBatchModel(List<UmRole> umRoleList) throws ApiException {
        if (null == umRoleList || umRoleList.isEmpty()) {
            return;
        }
        try {
            this.umRoleMapper.insertBatch(umRoleList);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.saveRoleBatchModel.ex", (Throwable)e);
        }
    }

    private UmRole getRoleModelById(Integer roleId) {
        if (null == roleId) {
            return null;
        }
        try {
            return this.umRoleMapper.selectByPrimaryKey(roleId);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.getRoleModelById", (Throwable)e);
            return null;
        }
    }

    private UmRole getRoleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.umRoleMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.getRoleModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRoleModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.umRoleMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.delRoleModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRoleServiceImpl.delRoleModelByCode.num");
        }
    }

    private void deleteRoleModel(Integer roleId) throws ApiException {
        if (null == roleId) {
            return;
        }
        int i = 0;
        try {
            i = this.umRoleMapper.deleteByPrimaryKey(roleId);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.deleteRoleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRoleServiceImpl.deleteRoleModel.num");
        }
    }

    private void updateRoleModel(UmRole umRole) throws ApiException {
        if (null == umRole) {
            return;
        }
        int i = 0;
        try {
            i = this.umRoleMapper.updateByPrimaryKeySelective(umRole);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateRoleModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateRoleModel.num");
        }
    }

    private void updateStateRoleModel(Integer roleId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == roleId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("roleId", roleId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umRoleMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateStateRoleModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateStateRoleModel.null");
        }
    }

    private void updateStateRoleModelByCode(String tenantCode, String roleCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)roleCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("roleCode", roleCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.umRoleMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateStateRoleModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateStateRoleModelByCode.null");
        }
    }

    private UmRole makeRole(UmRoleDomain umRoleDomain, UmRole umRole) {
        if (null == umRoleDomain) {
            return null;
        }
        if (null == umRole) {
            umRole = new UmRole();
        }
        try {
            BeanUtils.copyAllPropertys((Object)umRole, (Object)umRoleDomain);
            return umRole;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.makeRole", (Throwable)e);
            return null;
        }
    }

    private UmRoleReDomain makeUmRoleReDomain(UmRole umRole) {
        if (null == umRole) {
            return null;
        }
        UmRoleReDomain umRoleReDomain = new UmRoleReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)umRoleReDomain, (Object)umRole);
            return umRoleReDomain;
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.makeUmRoleReDomain", (Throwable)e);
            return null;
        }
    }

    private List<UmRole> queryRoleModelPage(Map<String, Object> parammap) {
        try {
            return this.umRoleMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.queryRoleModel", (Throwable)e);
            return null;
        }
    }

    private int countRole(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.umRoleMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("um.USER.UmRoleServiceImpl.countRole", (Throwable)e);
        }
        return i;
    }

    private UmRole createUmRole(UmRoleDomain umRoleDomain) {
        String msg = this.checkRole(umRoleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRoleServiceImpl.saveRole.checkRole", msg);
        }
        UmRole umRole = this.makeRole(umRoleDomain, null);
        this.setRoleDefault(umRole);
        return umRole;
    }

    @Override
    public String saveRole(UmRoleDomain umRoleDomain) throws ApiException {
        UmRole umRole = this.createUmRole(umRoleDomain);
        this.saveRoleModel(umRole);
        return umRole.getRoleCode();
    }

    @Override
    public String saveRoleBatch(List<UmRoleDomain> umRoleDomainList) throws ApiException {
        if (null == umRoleDomainList || umRoleDomainList.isEmpty()) {
            return null;
        }
        ArrayList<UmRole> umRoleList = new ArrayList<UmRole>();
        String code = "";
        for (UmRoleDomain umRoleDomain : umRoleDomainList) {
            UmRole umRole = this.createUmRole(umRoleDomain);
            code = umRole.getRoleCode();
            umRoleList.add(umRole);
        }
        this.saveRoleBatchModel(umRoleList);
        return code;
    }

    @Override
    public void updateRoleState(Integer roleId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == roleId) {
            return;
        }
        this.updateStateRoleModel(roleId, dataState, oldDataState, map);
    }

    @Override
    public void updateRoleStateByCode(String tenantCode, String roleCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)roleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRoleModelByCode(tenantCode, roleCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRole(UmRoleDomain umRoleDomain) throws ApiException {
        String msg = this.checkRole(umRoleDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateRole.checkRole", msg);
        }
        UmRole oldUmRole = this.getRoleModelById(umRoleDomain.getRoleId());
        if (null == oldUmRole) {
            throw new ApiException("um.USER.UmRoleServiceImpl.updateRole.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        UmRole umRole = this.makeRole(umRoleDomain, oldUmRole);
        this.setRoleUpdataDefault(umRole);
        this.updateRoleModel(umRole);
    }

    @Override
    public UmRole getRole(Integer roleId) {
        if (null == roleId) {
            return null;
        }
        return this.getRoleModelById(roleId);
    }

    @Override
    public void deleteRole(Integer roleId) throws ApiException {
        if (null == roleId) {
            return;
        }
        this.deleteRoleModel(roleId);
    }

    @Override
    public QueryResult<UmRole> queryRolePage(Map<String, Object> map) {
        List<UmRole> umRoleList = this.queryRoleModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRole(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(umRoleList);
        return queryResult;
    }

    @Override
    public UmRole getRoleByCode(String tenantCode, String roleCode) throws ApiException {
        if (StringUtils.isBlank((String)roleCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("roleCode", roleCode);
        return this.getRoleModelByCode(map);
    }

    @Override
    public void deleteRoleByCode(String tenantCode, String roleCode) throws ApiException {
        if (StringUtils.isBlank((String)roleCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("roleCode", roleCode);
        this.delRoleModelByCode(map);
    }
}

