/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.ver.dao.VerUserMapper;
import com.yqbsoft.laser.service.ver.domain.VerUserDomain;
import com.yqbsoft.laser.service.ver.domain.VerUserReDomain;
import com.yqbsoft.laser.service.ver.model.VerUser;
import com.yqbsoft.laser.service.ver.service.VerUserService;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VerUserServiceImpl
extends BaseServiceImpl
implements VerUserService {
    private static final String SYS_CODE = "ver.VerUserServiceImpl";
    private VerUserMapper verUserMapper;

    public void setVerUserMapper(VerUserMapper verUserMapper) {
        this.verUserMapper = verUserMapper;
    }

    private Date getSysDate() {
        try {
            return this.verUserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private int getUserMaxCode() {
        int code = 0;
        try {
            return this.verUserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.getUserMaxCode", (Throwable)e);
            return code;
        }
    }

    private int countVerUser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.verUserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.countVerUser", (Throwable)e);
        }
        return i;
    }

    private void setUserUpdataDefault(VerUser verUser) {
        if (null == verUser) {
            return;
        }
        verUser.setGmtModified(this.getSysDate());
    }

    private void saveUserModel(VerUser verUser) throws ApiException {
        if (null == verUser) {
            return;
        }
        try {
            this.verUserMapper.insert(verUser);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerUserServiceImpl.saveUserModel.ex", (Throwable)e);
        }
    }

    private VerUser getUserModelById(Integer userID) {
        if (null == userID) {
            return null;
        }
        try {
            return this.verUserMapper.selectByPrimaryKey(userID);
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.getUserModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteUserModel(Integer userID) throws ApiException {
        if (null == userID) {
            return;
        }
        int i = 0;
        try {
            i = this.verUserMapper.deleteByPrimaryKey(userID);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerUserServiceImpl.deleteUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerUserServiceImpl.deleteUserModel.num");
        }
    }

    private void updateUserModel(VerUser verUser) throws ApiException {
        if (null == verUser) {
            return;
        }
        int i = 0;
        try {
            i = this.verUserMapper.updateByPrimaryKeySelective(verUser);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerUserServiceImpl.updateUserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerUserServiceImpl.updateUserModel.num");
        }
    }

    private VerUser makeUser(VerUserDomain verUserDomain, VerUser verUser) {
        if (null == verUserDomain) {
            return null;
        }
        if (null == verUser) {
            verUser = new VerUser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)verUser, (Object)verUserDomain);
            return verUser;
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.makeUser", (Throwable)e);
            return null;
        }
    }

    private VerUserReDomain makeVerUserReDomain(VerUser verUser) {
        if (null == verUser) {
            return null;
        }
        VerUserReDomain verUserReDomain = new VerUserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)verUserReDomain, (Object)verUser);
            return verUserReDomain;
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.makeVerUserReDomain", (Throwable)e);
            return null;
        }
    }

    private VerUser createVerUser(VerUserDomain verUserDomain) {
        VerUser verUser = this.makeUser(verUserDomain, null);
        return verUser;
    }

    private List<VerUser> queryUserModelPage(Map<String, Object> parammap) {
        try {
            return this.verUserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ver.VerUserServiceImpl.queryUserModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public VerUser getUser(Integer userID) {
        return this.getUserModelById(userID);
    }

    @Override
    public void deleteUser(Integer userID) throws ApiException {
        this.deleteUserModel(userID);
    }

    @Override
    public String saveUser(VerUserDomain verUserDomain) throws ApiException {
        VerUser verUser = this.createVerUser(verUserDomain);
        this.saveUserModel(verUser);
        return verUser.getUserName();
    }

    @Override
    public String saveUserBatch(List<VerUserDomain> verUserDomainList) throws ApiException {
        return null;
    }

    @Override
    public void updateUserState(Integer userID, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateUserStateByCode(String tenantCode, String userName, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateUser(VerUserDomain verUserDomain) throws ApiException {
        VerUser verUser = this.createVerUser(verUserDomain);
        this.updateUserModel(verUser);
    }

    @Override
    public QueryResult<VerUser> queryUserPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        queryResult.setList(this.verUserMapper.query(map));
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countVerUser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        return queryResult;
    }

    @Override
    public VerUser getUserByCode(String tenantCode, String userName) throws ApiException {
        return null;
    }

    @Override
    public void deleteUserByCode(String tenantCode, String userName) throws ApiException {
    }
}

