/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.ver.dao.VerVersionMapper;
import com.yqbsoft.laser.service.ver.domain.VerVersionDomain;
import com.yqbsoft.laser.service.ver.domain.VerVersionReDomain;
import com.yqbsoft.laser.service.ver.model.VerVersion;
import com.yqbsoft.laser.service.ver.service.VerVersionService;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VerVersionServiceImpl
extends BaseServiceImpl
implements VerVersionService {
    private static final String SYS_CODE = "ver.VerVersionServiceImpl";
    private VerVersionMapper verVersionMapper;

    public void setVerVersionMapper(VerVersionMapper verVersionMapper) {
        this.verVersionMapper = verVersionMapper;
    }

    private Date getSysDate() {
        try {
            return this.verVersionMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private int getVersionMaxCode() {
        int code = 0;
        try {
            return this.verVersionMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.getVersionMaxCode", (Throwable)e);
            return code;
        }
    }

    private int countVerVersion(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.verVersionMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.countVerVersion", (Throwable)e);
        }
        return i;
    }

    private void saveVersionModel(VerVersion verVersion) throws ApiException {
        if (null == verVersion) {
            return;
        }
        try {
            this.verVersionMapper.insert(verVersion);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerVersionServiceImpl.saveVersionModel.ex", (Throwable)e);
        }
    }

    private VerVersion getVersionModelById(Integer versionId) {
        if (null == versionId) {
            return null;
        }
        try {
            return this.verVersionMapper.selectByPrimaryKey(versionId);
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.getVersionModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteVersionModel(Integer versionId) throws ApiException {
        if (null == versionId) {
            return;
        }
        int i = 0;
        try {
            i = this.verVersionMapper.deleteByPrimaryKey(versionId);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerVersionServiceImpl.deleteVersionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerVersionServiceImpl.deleteVersionModel.num");
        }
    }

    private void updateVersionModel(VerVersion verVersion) throws ApiException {
        if (null == verVersion) {
            return;
        }
        int i = 0;
        try {
            i = this.verVersionMapper.updateByPrimaryKeySelective(verVersion);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerVersionServiceImpl.updateVersionModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerVersionServiceImpl.updateVersionModel.num");
        }
    }

    private VerVersion makeVersion(VerVersionDomain verVersionDomain, VerVersion verVersion) {
        if (null == verVersionDomain) {
            return null;
        }
        if (null == verVersion) {
            verVersion = new VerVersion();
        }
        try {
            BeanUtils.copyAllPropertys((Object)verVersion, (Object)verVersionDomain);
            return verVersion;
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.makeVersion", (Throwable)e);
            return null;
        }
    }

    private void setBatchmnsDefault(VerVersion verVersion) {
        if (null == verVersion) {
            return;
        }
        Date date = this.getSysDate();
        if (null == verVersion.getCheckTime()) {
            verVersion.setCheckTime(date);
        }
        if (null == verVersion.getSendversionTime()) {
            verVersion.setSendversionTime(date);
        }
        if (null == verVersion.getUpdateversionTime()) {
            verVersion.setUpdateversionTime(date);
        }
    }

    private VerVersionReDomain makeVerVersionReDomain(VerVersion verVersion) {
        if (null == verVersion) {
            return null;
        }
        VerVersionReDomain verVersionReDomain = new VerVersionReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)verVersionReDomain, (Object)verVersion);
            return verVersionReDomain;
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.makeVerVersionReDomain", (Throwable)e);
            return null;
        }
    }

    private VerVersion createVerVersion(VerVersionDomain verVersionDomain) {
        VerVersion verVersion = this.makeVersion(verVersionDomain, null);
        this.setBatchmnsDefault(verVersion);
        return verVersion;
    }

    @Override
    public QueryResult<VerVersion> queryVersionPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        try {
            queryResult.setList(this.verVersionMapper.query(map));
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(this.countVerVersion(map));
            queryResult.setPageTools((SupPageTools)pageTools);
            return queryResult;
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.queryVersionModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public VerVersion getVersion(Integer versionId) {
        return this.getVersionModelById(versionId);
    }

    @Override
    public void deleteVersion(Integer versionId) throws ApiException {
        this.deleteVersionModel(versionId);
    }

    @Override
    public String saveVersion(VerVersionDomain verVersionDomain) throws ApiException {
        VerVersion verVersion = this.createVerVersion(verVersionDomain);
        this.saveVersionModel(verVersion);
        return verVersion.getExcName();
    }

    @Override
    public String saveVersionBatch(List<VerVersionDomain> verVersionDomainList) throws ApiException {
        return null;
    }

    @Override
    public void updateVersionState(Integer versionId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateVersionStateByCode(String tenantCode, String versionName, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateVersion(VerVersionDomain verVersionDomain) throws ApiException {
        VerVersion verVersion = this.createVerVersion(verVersionDomain);
        this.updateVersionModel(verVersion);
    }

    @Override
    public VerVersion getVersionByCode(String tenantCode, String versionName) throws ApiException {
        return null;
    }

    @Override
    public void deleteVersionByCode(String tenantCode, String versionName) throws ApiException {
    }

    @Override
    public VerVersion getVersionByNumber(String versionNumber) throws ApiException {
        return this.getVersionModelByNumber(versionNumber);
    }

    private VerVersion getVersionModelByNumber(String versionNumber) {
        if (null == versionNumber) {
            return null;
        }
        try {
            return this.verVersionMapper.selectByNumber(versionNumber);
        }
        catch (Exception e) {
            this.logger.error("ver.VerVersionServiceImpl.getVersionModelByNumber", (Throwable)e);
            return null;
        }
    }
}

