/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.ver.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.ver.dao.VerOrguserMapper;
import com.yqbsoft.laser.service.ver.domain.VerOrguserDomain;
import com.yqbsoft.laser.service.ver.domain.VerOrguserReDomain;
import com.yqbsoft.laser.service.ver.model.VerOrguser;
import com.yqbsoft.laser.service.ver.service.VerOrguserService;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class VerOrguserServiceImpl
extends BaseServiceImpl
implements VerOrguserService {
    private static final String SYS_CODE = "ver.VerOrguserServiceImpl";
    private VerOrguserMapper verOrguserMapper;

    public void setVerOrguserMapper(VerOrguserMapper verOrguserMapper) {
        this.verOrguserMapper = verOrguserMapper;
    }

    private Date getSysDate() {
        try {
            return this.verOrguserMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private int getOrguserMaxCode() {
        int code = 0;
        try {
            return this.verOrguserMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.getOrguserMaxCode", (Throwable)e);
            return code;
        }
    }

    private int countVerOrguser(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.verOrguserMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.countVerOrguser", (Throwable)e);
        }
        return i;
    }

    private void saveOrguserModel(VerOrguser verOrguser) throws ApiException {
        if (null == verOrguser) {
            return;
        }
        try {
            this.verOrguserMapper.insert(verOrguser);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerOrguserServiceImpl.saveOrguserModel.ex", (Throwable)e);
        }
    }

    private VerOrguser getOrguserModelById(Integer orgId) {
        if (null == orgId) {
            return null;
        }
        try {
            return this.verOrguserMapper.selectByPrimaryKey(orgId);
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.getOrguserModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteOrguserModel(Integer orgId) throws ApiException {
        if (null == orgId) {
            return;
        }
        int i = 0;
        try {
            i = this.verOrguserMapper.deleteByPrimaryKey(orgId);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerOrguserServiceImpl.deleteOrguserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerOrguserServiceImpl.deleteOrguserModel.num");
        }
    }

    private void updateOrguserModel(VerOrguser verOrguser) throws ApiException {
        if (null == verOrguser) {
            return;
        }
        int i = 0;
        try {
            i = this.verOrguserMapper.updateByPrimaryKeySelective(verOrguser);
        }
        catch (Exception e) {
            throw new ApiException("ver.VerOrguserServiceImpl.updateOrguserModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ver.VerOrguserServiceImpl.updateOrguserModel.num");
        }
    }

    private VerOrguser makeOrguser(VerOrguserDomain verOrguserDomain, VerOrguser verOrguser) {
        if (null == verOrguserDomain) {
            return null;
        }
        if (null == verOrguser) {
            verOrguser = new VerOrguser();
        }
        try {
            BeanUtils.copyAllPropertys((Object)verOrguser, (Object)verOrguserDomain);
            return verOrguser;
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.makeOrguser", (Throwable)e);
            return null;
        }
    }

    private VerOrguserReDomain makeVerOrguserReDomain(VerOrguser verOrguser) {
        if (null == verOrguser) {
            return null;
        }
        VerOrguserReDomain verOrguserReDomain = new VerOrguserReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)verOrguserReDomain, (Object)verOrguser);
            return verOrguserReDomain;
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.makeVerOrguserReDomain", (Throwable)e);
            return null;
        }
    }

    private VerOrguser createVerOrguser(VerOrguserDomain verOrguserDomain) {
        VerOrguser verOrguser = this.makeOrguser(verOrguserDomain, null);
        return verOrguser;
    }

    private List<VerOrguser> queryOrguserModelPage(Map<String, Object> parammap) {
        try {
            return this.verOrguserMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ver.VerOrguserServiceImpl.queryOrguserModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public VerOrguser getOrguser(Integer orgId) {
        return this.getOrguserModelById(orgId);
    }

    @Override
    public void deleteOrguser(Integer orgId) throws ApiException {
        this.deleteOrguserModel(orgId);
    }

    @Override
    public String saveOrguser(VerOrguserDomain verOrguserDomain) throws ApiException {
        VerOrguser verOrguser = this.createVerOrguser(verOrguserDomain);
        this.saveOrguserModel(verOrguser);
        return verOrguser.getExName();
    }

    @Override
    public String saveOrguserBatch(List<VerOrguserDomain> verOrguserDomainList) throws ApiException {
        return null;
    }

    @Override
    public void updateOrguserState(Integer orgId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateOrguserStateByCode(String tenantCode, String orgName, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
    }

    @Override
    public void updateOrguser(VerOrguserDomain verOrguserDomain) throws ApiException {
        VerOrguser verOrguser = this.createVerOrguser(verOrguserDomain);
        this.updateOrguserModel(verOrguser);
    }

    @Override
    public QueryResult<VerOrguser> queryOrguserPage(Map<String, Object> map) {
        QueryResult queryResult = new QueryResult();
        queryResult.setList(this.verOrguserMapper.query(map));
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countVerOrguser(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        return queryResult;
    }

    @Override
    public VerOrguser getOrguserByCode(String tenantCode, String orgName) throws ApiException {
        return null;
    }

    @Override
    public void deleteOrguserByCode(String tenantCode, String orgName) throws ApiException {
    }
}

