/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.RandomUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.virtualdepositor.constant.VdFaccountDirectionEnum;
import com.yqbsoft.laser.service.virtualdepositor.constant.VdFaccountFundEnum;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountInnerDtMapper;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountInnerMapper;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountInnerSubsetMapper;
import com.yqbsoft.laser.service.virtualdepositor.dao.VdFaccountOuterDtMapper;
import com.yqbsoft.laser.service.virtualdepositor.domain.BalanceBean;
import com.yqbsoft.laser.service.virtualdepositor.domain.OrderBean;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDoDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountDtDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerDtDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerInfo;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerSubsetDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountInnerSubsetReDomain;
import com.yqbsoft.laser.service.virtualdepositor.domain.VdFaccountSubsetDomain;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountInner;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountInnerDt;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountInnerSubset;
import com.yqbsoft.laser.service.virtualdepositor.model.VdFaccountOuterDt;
import com.yqbsoft.laser.service.virtualdepositor.service.VdFaccountInnerService;
import com.yqbsoft.laser.service.virtualdepositor.service.impl.VdFaccountAbstractServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class VdFaccountInnerServiceImpl
extends VdFaccountAbstractServiceImpl
implements VdFaccountInnerService {
    public static final String SYS_CODE = "vd.VdFaccountInnerServiceImpl";
    private VdFaccountInnerMapper vdFaccountInnerMapper;
    private VdFaccountInnerSubsetMapper vdFaccountInnerSubsetMapper;
    private VdFaccountInnerDtMapper vdFaccountInnerDtMapper;
    private VdFaccountOuterDtMapper vdFaccountOuterDtMapper;

    public void setVdFaccountInnerMapper(VdFaccountInnerMapper vdFaccountInnerMapper) {
        this.vdFaccountInnerMapper = vdFaccountInnerMapper;
    }

    public void setVdFaccountInnerSubsetMapper(VdFaccountInnerSubsetMapper vdFaccountInnerSubsetMapper) {
        this.vdFaccountInnerSubsetMapper = vdFaccountInnerSubsetMapper;
    }

    public void setVdFaccountInnerDtMapper(VdFaccountInnerDtMapper vdFaccountInnerDtMapper) {
        this.vdFaccountInnerDtMapper = vdFaccountInnerDtMapper;
    }

    public void setVdFaccountOuterDtMapper(VdFaccountOuterDtMapper vdFaccountOuterDtMapper) {
        this.vdFaccountOuterDtMapper = vdFaccountOuterDtMapper;
    }

    private Date getSysDate() {
        try {
            return this.vdFaccountInnerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkFaccountInner(VdFaccountInnerDomain vdFaccountInnerDomain) {
        if (null == vdFaccountInnerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountInnerDefault(VdFaccountInner vdFaccountInner) {
        if (null == vdFaccountInner) {
            return;
        }
        if (null == vdFaccountInner.getDataState()) {
            vdFaccountInner.setDataState(0);
        }
        if (null == vdFaccountInner.getGmtCreate()) {
            vdFaccountInner.setGmtCreate(this.getSysDate());
        }
        vdFaccountInner.setGmtModified(this.getSysDate());
        String r = RandomUtils.generateRandom((int)1, (Integer)0);
        String codepix = vdFaccountInner.getFaccountTitileCode() + vdFaccountInner.getCurrencyCode() + vdFaccountInner.getFaccountType();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerNo", codepix);
        map.put("tenantCode", vdFaccountInner.getTenantCode());
        String maxCode = this.getMaxNo(map);
        String no = "001";
        if (StringUtils.isNotBlank((String)maxCode)) {
            maxCode = maxCode.substring(maxCode.length() - 4, maxCode.length() - 1);
            long nol = Long.valueOf(maxCode) + 1L;
            no = String.format("%03d", nol);
        }
        vdFaccountInner.setFaccountInnerNo(codepix + no + r);
    }

    private String getMaxNo(Map<String, Object> map) {
        String code = "";
        try {
            code = this.vdFaccountInnerMapper.getMaxNo(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getMaxNo", (Throwable)e);
        }
        return code;
    }

    private void setFaccountInnerUpdataDefault(VdFaccountInner vdFaccountInner) {
        if (null == vdFaccountInner) {
            return;
        }
        vdFaccountInner.setGmtModified(this.getSysDate());
    }

    private void saveFaccountInnerModel(VdFaccountInner vdFaccountInner) throws ApiException {
        if (null == vdFaccountInner) {
            return;
        }
        try {
            this.vdFaccountInnerMapper.insert(vdFaccountInner);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerModel.ex", (Throwable)e);
        }
    }

    private VdFaccountInner getFaccountInnerModelById(Integer faccountInnerId) {
        if (null == faccountInnerId) {
            return null;
        }
        try {
            return this.vdFaccountInnerMapper.selectByPrimaryKey(faccountInnerId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountInner getFaccountInnerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountInnerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountInnerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerModelByCode.num");
        }
    }

    private void deleteFaccountInnerModel(Integer faccountInnerId) throws ApiException {
        if (null == faccountInnerId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerMapper.deleteByPrimaryKey(faccountInnerId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerModel.num");
        }
    }

    private void updateFaccountInnerModel(VdFaccountInner vdFaccountInner) throws ApiException {
        if (null == vdFaccountInner) {
            return;
        }
        this.setFaccountInnerUpdataDefault(vdFaccountInner);
        try {
            this.vdFaccountInnerMapper.updateByPrimaryKeySelective(vdFaccountInner);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerModel.ex", (Throwable)e);
        }
    }

    private VdFaccountInner getFaccountInnerLockByCodeModel(String faccountInnerNo, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)faccountInnerNo)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerNo", faccountInnerNo);
        map.put("tenantCode", tenantCode);
        try {
            return this.vdFaccountInnerMapper.getLockByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.getFaccountInnerLockByCodeModel.ex", (Throwable)e);
        }
    }

    public void updateFaccountInnerByCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerMapper.updateByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountOuterByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountOuterByCodeModel.null");
        }
    }

    private void updateStateFaccountInnerModel(Integer faccountInnerId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountInnerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerId", faccountInnerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountInnerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerModel.null");
        }
    }

    private VdFaccountInner makeFaccountInner(VdFaccountInnerDomain vdFaccountInnerDomain, VdFaccountInner vdFaccountInner) {
        if (null == vdFaccountInnerDomain) {
            return null;
        }
        if (null == vdFaccountInner) {
            vdFaccountInner = new VdFaccountInner();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInner, (Object)vdFaccountInnerDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.makeFaccountInner", (Throwable)e);
        }
        return vdFaccountInner;
    }

    private VdFaccountInnerReDomain makeFaccountInnerReDomain(VdFaccountInner vdFaccountInner, VdFaccountInnerReDomain vdFaccountInnerReDomain) {
        if (null == vdFaccountInner) {
            return null;
        }
        if (null == vdFaccountInnerReDomain) {
            vdFaccountInnerReDomain = new VdFaccountInnerReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerReDomain, (Object)vdFaccountInner);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.makeFaccountInnerDomain", (Throwable)e);
        }
        return vdFaccountInnerReDomain;
    }

    private VdFaccountInnerSubsetReDomain makeFaccountInnerSubsetReDomain(VdFaccountInnerSubset vdFaccountInnerSubset, VdFaccountInnerSubsetReDomain vdFaccountInnerSubsetReDomain) {
        if (null == vdFaccountInnerSubset) {
            return null;
        }
        if (null == vdFaccountInnerSubsetReDomain) {
            vdFaccountInnerSubsetReDomain = new VdFaccountInnerSubsetReDomain();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerSubsetReDomain, (Object)vdFaccountInnerSubset);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.makeFaccountInnerSubsetReDomain", (Throwable)e);
        }
        return vdFaccountInnerSubsetReDomain;
    }

    private List<VdFaccountInner> queryFaccountInnerModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountInnerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.queryFaccountInnerModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountInner(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountInnerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.countFaccountInner", (Throwable)e);
        }
        return i;
    }

    private String checkFaccountInnerSubset(VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain) {
        if (null == vdFaccountInnerSubsetDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountInnerSubsetDefault(VdFaccountInnerSubset vdFaccountInnerSubset) {
        if (null == vdFaccountInnerSubset) {
            return;
        }
        if (null == vdFaccountInnerSubset.getDataState()) {
            vdFaccountInnerSubset.setDataState(0);
        }
        if (null == vdFaccountInnerSubset.getGmtCreate()) {
            vdFaccountInnerSubset.setGmtCreate(this.getSysDate());
        }
        vdFaccountInnerSubset.setGmtModified(this.getSysDate());
        vdFaccountInnerSubset.setFaccountInnerSubsetNo(vdFaccountInnerSubset.getFaccountInnerNo() + vdFaccountInnerSubset.getFundType());
        if (vdFaccountInnerSubset.getFaccountAmount() == null) {
            vdFaccountInnerSubset.setFaccountAmount(BigDecimal.ZERO);
        }
        if (vdFaccountInnerSubset.getFaccountPortion() == null) {
            vdFaccountInnerSubset.setFaccountPortion(BigDecimal.ZERO);
        }
        if (vdFaccountInnerSubset.getFaccountPrice() == null) {
            vdFaccountInnerSubset.setFaccountPrice(BigDecimal.ONE);
        }
    }

    private int getMaxSubsetCode() {
        int code = 0;
        try {
            return this.vdFaccountInnerSubsetMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getMaxSubsetCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountInnerSubsetUpdataDefault(VdFaccountInnerSubset vdFaccountInnerSubset) {
        if (null == vdFaccountInnerSubset) {
            return;
        }
        vdFaccountInnerSubset.setGmtModified(this.getSysDate());
    }

    private void saveFaccountInnerSubsetModel(VdFaccountInnerSubset vdFaccountInnerSubset) throws ApiException {
        if (null == vdFaccountInnerSubset) {
            return;
        }
        try {
            this.vdFaccountInnerSubsetMapper.insert(vdFaccountInnerSubset);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerSubsetModel.ex", (Throwable)e);
        }
    }

    private VdFaccountInnerSubset getFaccountInnerSubsetModelById(Integer faccountInnerSubsetId) {
        if (null == faccountInnerSubsetId) {
            return null;
        }
        try {
            return this.vdFaccountInnerSubsetMapper.selectByPrimaryKey(faccountInnerSubsetId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerSubsetModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountInnerSubset getFaccountInnerSubsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountInnerSubsetMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerSubsetModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountInnerSubsetModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerSubsetMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerSubsetModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerSubsetModelByCode.num");
        }
    }

    private void deleteFaccountInnerSubsetModel(Integer faccountInnerSubsetId) throws ApiException {
        if (null == faccountInnerSubsetId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerSubsetMapper.deleteByPrimaryKey(faccountInnerSubsetId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerSubsetModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerSubsetModel.num");
        }
    }

    private void updateFaccountInnerSubsetModel(VdFaccountInnerSubset vdFaccountInnerSubset) throws ApiException {
        if (null == vdFaccountInnerSubset) {
            return;
        }
        this.setFaccountInnerSubsetUpdataDefault(vdFaccountInnerSubset);
        try {
            this.vdFaccountInnerSubsetMapper.updateByPrimaryKeySelective(vdFaccountInnerSubset);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerSubsetModel.ex", (Throwable)e);
        }
    }

    private void updateBalanceFaccountInnerSubsetModel(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerSubsetModel.map");
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerSubsetMapper.updateByPrimaryCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerSubsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerSubsetModel.null");
        }
    }

    private void updateStateFaccountInnerSubsetModel(Integer faccountInnerSubsetId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountInnerSubsetId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerSubsetId", faccountInnerSubsetId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountInnerSubsetMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerSubsetModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerSubsetModel.null");
        }
    }

    private VdFaccountInnerSubset makeFaccountInnerSubset(VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain, VdFaccountInnerSubset vdFaccountInnerSubset) {
        if (null == vdFaccountInnerSubsetDomain) {
            return null;
        }
        if (null == vdFaccountInnerSubset) {
            vdFaccountInnerSubset = new VdFaccountInnerSubset();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerSubset, (Object)vdFaccountInnerSubsetDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.makeFaccountInnerSubset", (Throwable)e);
        }
        return vdFaccountInnerSubset;
    }

    private List<VdFaccountInnerSubset> queryFaccountInnerSubsetModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountInnerSubsetMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.queryFaccountInnerSubsetModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountInnerSubset(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountInnerSubsetMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.countFaccountInnerSubset", (Throwable)e);
        }
        return i;
    }

    private String checkFaccountInnerDt(VdFaccountInnerDtDomain vdFaccountInnerDtDomain) {
        if (null == vdFaccountInnerDtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setFaccountInnerDtDefault(VdFaccountInnerDt vdFaccountInnerDt) {
        if (null == vdFaccountInnerDt) {
            return;
        }
        if (null == vdFaccountInnerDt.getDataState()) {
            vdFaccountInnerDt.setDataState(0);
        }
        if (null == vdFaccountInnerDt.getGmtCreate()) {
            vdFaccountInnerDt.setGmtCreate(this.getSysDate());
        }
        vdFaccountInnerDt.setGmtModified(this.getSysDate());
    }

    private int getMaxInnerDtCode() {
        int code = 0;
        try {
            return this.vdFaccountInnerDtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getMaxInnerDtCode", (Throwable)e);
            return code;
        }
    }

    private void setFaccountInnerDtUpdataDefault(VdFaccountInnerDt vdFaccountInnerDt) {
        if (null == vdFaccountInnerDt) {
            return;
        }
        vdFaccountInnerDt.setGmtModified(this.getSysDate());
    }

    private void saveFaccountInnerDtModel(VdFaccountInnerDt vdFaccountInnerDt) throws ApiException {
        if (null == vdFaccountInnerDt) {
            return;
        }
        try {
            this.vdFaccountInnerDtMapper.insert(vdFaccountInnerDt);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerDtModel.ex", (Throwable)e);
        }
    }

    private void saveFaccountInnerDtListModel(List<VdFaccountInnerDt> vdFaccountInnerDtList) throws ApiException {
        if (null == vdFaccountInnerDtList || vdFaccountInnerDtList.isEmpty()) {
            return;
        }
        try {
            this.vdFaccountInnerDtMapper.insertBatch(vdFaccountInnerDtList);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerDtListModel.ex", (Throwable)e);
        }
    }

    private VdFaccountInnerDt getFaccountInnerDtModelById(Integer faccountInnerDtId) {
        if (null == faccountInnerDtId) {
            return null;
        }
        try {
            return this.vdFaccountInnerDtMapper.selectByPrimaryKey(faccountInnerDtId);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerDtModelById", (Throwable)e);
            return null;
        }
    }

    public VdFaccountInnerDt getFaccountInnerDtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.vdFaccountInnerDtMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.getFaccountInnerDtModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delFaccountInnerDtModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerDtMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerDtModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.delFaccountInnerDtModelByCode.num");
        }
    }

    private void deleteFaccountInnerDtModel(Integer faccountInnerDtId) throws ApiException {
        if (null == faccountInnerDtId) {
            return;
        }
        int i = 0;
        try {
            i = this.vdFaccountInnerDtMapper.deleteByPrimaryKey(faccountInnerDtId);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerDtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.deleteFaccountInnerDtModel.num");
        }
    }

    private void updateFaccountInnerDtModel(VdFaccountInnerDt vdFaccountInnerDt) throws ApiException {
        if (null == vdFaccountInnerDt) {
            return;
        }
        try {
            this.vdFaccountInnerDtMapper.updateByPrimaryKeySelective(vdFaccountInnerDt);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerDtModel.ex", (Throwable)e);
        }
    }

    private void updateStateFaccountInnerDtModel(Integer faccountInnerDtId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == faccountInnerDtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerDtId", faccountInnerDtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.vdFaccountInnerDtMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerDtModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateStateFaccountInnerDtModel.null");
        }
    }

    private VdFaccountInnerDt makeFaccountInnerDt(VdFaccountInnerDtDomain vdFaccountInnerDtDomain, VdFaccountInnerDt vdFaccountInnerDt) {
        if (null == vdFaccountInnerDtDomain) {
            return null;
        }
        if (null == vdFaccountInnerDt) {
            vdFaccountInnerDt = new VdFaccountInnerDt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerDt, (Object)vdFaccountInnerDtDomain);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.makeFaccountInnerDt", (Throwable)e);
        }
        return vdFaccountInnerDt;
    }

    private List<VdFaccountInnerDt> queryFaccountInnerDtModelPage(Map<String, Object> parammap) {
        try {
            return this.vdFaccountInnerDtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.queryFaccountInnerDtModel", (Throwable)e);
            return null;
        }
    }

    private int countFaccountInnerDt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.vdFaccountInnerDtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("vd.VdFaccountInnerServiceImpl.countFaccountInnerDt", (Throwable)e);
        }
        return i;
    }

    private List<VdFaccountInnerDt> makeInnerDt(List<VdFaccountDtDomain> vdFaccountDtDomainList) {
        if (null == vdFaccountDtDomainList || vdFaccountDtDomainList.isEmpty()) {
            return null;
        }
        ArrayList<VdFaccountInnerDt> vdFaccountInnerDtList = new ArrayList<VdFaccountInnerDt>();
        for (VdFaccountDtDomain vdFaccountDtDomain : vdFaccountDtDomainList) {
            vdFaccountInnerDtList.add(this.makeInnerDt(vdFaccountDtDomain));
        }
        return vdFaccountInnerDtList;
    }

    private VdFaccountInnerDt makeInnerDt(VdFaccountDtDomain vdFaccountDtDomain) {
        if (null == vdFaccountDtDomain) {
            return null;
        }
        VdFaccountInnerDt vdFaccountInnerDt = new VdFaccountInnerDt();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerDt, (Object)vdFaccountDtDomain);
            vdFaccountInnerDt.setFaccountInnerDtOsqeno(vdFaccountDtDomain.getFaccountDtOsqeno());
            vdFaccountInnerDt.setFaccountInnerDtSqeno(this.createUUIDString());
            vdFaccountInnerDt.setFaccountInnerNo(vdFaccountDtDomain.getFaccountNo());
            vdFaccountInnerDt.setFaccountInnerName(vdFaccountDtDomain.getFaccountName());
            vdFaccountInnerDt.setGmtModified(this.getSysDate());
            vdFaccountInnerDt.setDataState(0);
            return vdFaccountInnerDt;
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.makeInnerDt.e", (Throwable)e);
        }
    }

    @Override
    public void saveFaccountInner(VdFaccountInnerDomain vdFaccountInnerDomain) throws ApiException {
        String msg = this.checkFaccountInner(vdFaccountInnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInner.checkFaccountInner", msg);
        }
        VdFaccountInner vdFaccountInner = this.makeFaccountInner(vdFaccountInnerDomain, null);
        this.setFaccountInnerDefault(vdFaccountInner);
        this.saveFaccountInnerModel(vdFaccountInner);
        vdFaccountInnerDomain.setFaccountInnerNo(vdFaccountInner.getFaccountInnerNo());
        vdFaccountInnerDomain.setFaccountNo(vdFaccountInner.getFaccountInnerNo());
        vdFaccountInnerDomain.setFaccountName(vdFaccountInner.getFaccountInnerName());
        vdFaccountInnerDomain.setFaccountInnerName(vdFaccountInner.getFaccountInnerName());
    }

    @Override
    public void updateFaccountInnerState(Integer faccountInnerId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountInnerModel(faccountInnerId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountInner(VdFaccountInnerDomain vdFaccountInnerDomain) throws ApiException {
        String msg = this.checkFaccountInner(vdFaccountInnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInner.checkFaccountInner", msg);
        }
        VdFaccountInner oldVdFaccountInner = this.getFaccountInnerModelById(vdFaccountInnerDomain.getFaccountInnerId());
        if (null == oldVdFaccountInner) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInner.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountInner vdFaccountInner = this.makeFaccountInner(vdFaccountInnerDomain, oldVdFaccountInner);
        this.updateFaccountInnerModel(vdFaccountInner);
    }

    @Override
    public VdFaccountInner getFaccountInner(Integer faccountInnerId) {
        return this.getFaccountInnerModelById(faccountInnerId);
    }

    @Override
    public VdFaccountInnerReDomain getFaccountInnerByNo(String faccountInnerNo, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("faccountInnerNo", faccountInnerNo);
        map.put("tenantCode", tenantCode);
        VdFaccountInner vdFaccountInner = this.getFaccountInnerModelByCode(map);
        if (null == vdFaccountInner) {
            return null;
        }
        VdFaccountInnerReDomain vdFaccountInnerReDomain = this.makeFaccountInnerReDomain(vdFaccountInner, null);
        List<VdFaccountInnerSubset> subsetList = this.queryFaccountInnerSubsetModelPage(map);
        if (null != subsetList && !subsetList.isEmpty()) {
            ArrayList<VdFaccountInnerSubsetReDomain> subsetReList = new ArrayList<VdFaccountInnerSubsetReDomain>();
            for (VdFaccountInnerSubset vdFaccountInnerSubset : subsetList) {
                subsetReList.add(this.makeFaccountInnerSubsetReDomain(vdFaccountInnerSubset, null));
            }
            vdFaccountInnerReDomain.setSubsetReList(subsetReList);
            this.makeBanlce(vdFaccountInnerReDomain, subsetList);
        }
        return vdFaccountInnerReDomain;
    }

    private void makeBanlce(VdFaccountInnerReDomain vdFaccountInnerReDomain, List<VdFaccountInnerSubset> subsetList) {
        if (null == vdFaccountInnerReDomain || null == subsetList || subsetList.isEmpty()) {
            return;
        }
        for (VdFaccountInnerSubset vdFaccountInnerSubset : subsetList) {
            if (!vdFaccountInnerReDomain.getFaccountDirection().equals(vdFaccountInnerSubset.getFaccountDirection())) continue;
            vdFaccountInnerReDomain.setCurrencyDirection(vdFaccountInnerSubset.getCurrencyDirection());
            vdFaccountInnerReDomain.setCurrencyCode(vdFaccountInnerSubset.getCurrencyCode());
            vdFaccountInnerReDomain.setFaccountAmount(vdFaccountInnerSubset.getFaccountAmount());
            vdFaccountInnerReDomain.setFaccountPortion(vdFaccountInnerSubset.getFaccountPortion());
            vdFaccountInnerReDomain.setFaccountPrice(vdFaccountInnerSubset.getFaccountPrice());
        }
    }

    @Override
    public void deleteFaccountInner(Integer faccountInnerId) throws ApiException {
        this.deleteFaccountInnerModel(faccountInnerId);
    }

    @Override
    public QueryResult<VdFaccountInner> queryFaccountInnerPage(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        List<VdFaccountInner> vdFaccountInnerList = this.queryFaccountInnerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountInner(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountInnerList);
        return queryResult;
    }

    @Override
    public QueryResult<VdFaccountInnerInfo> queryFaccountInfoPage(Map<String, Object> map) {
        assert (map != null);
        QueryResult<VdFaccountInner> innerQueryResult = this.queryFaccountInnerPage(map);
        if (innerQueryResult == null || CollectionUtils.isEmpty((Collection)innerQueryResult.getList())) {
            return null;
        }
        QueryResult result = new QueryResult();
        org.springframework.beans.BeanUtils.copyProperties(innerQueryResult, (Object)result, (String[])new String[]{"rows,list"});
        ArrayList<VdFaccountInnerInfo> faccountInfos = new ArrayList<VdFaccountInnerInfo>();
        result.setRows(faccountInfos);
        List vdFaccountInnerList = innerQueryResult.getList();
        for (VdFaccountInner inner : vdFaccountInnerList) {
            faccountInfos.add(this.makeInfo(inner));
        }
        return result;
    }

    @Override
    public VdFaccountInnerInfo getFaccountInnerInfoByNo(String faccountInnerNo, String tenantCode) {
        VdFaccountInner inner = this.getFaccountInnerModelByCode(this.getQueryMapParam("faccountInnerNo,tenantCode", new Object[]{faccountInnerNo, tenantCode}));
        if (inner == null) {
            return null;
        }
        return this.makeInfo(inner);
    }

    private VdFaccountInnerInfo makeInfo(VdFaccountInner inner) {
        assert (inner != null);
        VdFaccountInnerInfo info = new VdFaccountInnerInfo().convertToVdFaccountInnerInfo(inner);
        List<VdFaccountInnerSubset> innerSubsetList = this.queryFaccountInnerSubsetModelPage(this.getQueryMapParam("tenantCode,faccountInnerNo", new Object[]{inner.getTenantCode(), inner.getFaccountInnerNo()}));
        info.setInfoValueWhenFundTypeEquals(innerSubsetList);
        return info;
    }

    @Override
    public void saveFaccountInnerSubset(VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain) throws ApiException {
        String msg = this.checkFaccountInnerSubset(vdFaccountInnerSubsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerSubset.checkFaccountInnerSubset", msg);
        }
        VdFaccountInnerSubset vdFaccountInnerSubset = this.makeFaccountInnerSubset(vdFaccountInnerSubsetDomain, null);
        this.setFaccountInnerSubsetDefault(vdFaccountInnerSubset);
        this.saveFaccountInnerSubsetModel(vdFaccountInnerSubset);
    }

    @Override
    public void updateFaccountInnerSubsetState(Integer faccountInnerSubsetId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountInnerSubsetModel(faccountInnerSubsetId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountInnerSubset(VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain) throws ApiException {
        String msg = this.checkFaccountInnerSubset(vdFaccountInnerSubsetDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerSubset.checkFaccountInnerSubset", msg);
        }
        VdFaccountInnerSubset oldVdFaccountInnerSubset = this.getFaccountInnerSubsetModelById(vdFaccountInnerSubsetDomain.getFaccountInnerSubsetId());
        if (null == oldVdFaccountInnerSubset) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerSubset.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountInnerSubset vdFaccountInnerSubset = this.makeFaccountInnerSubset(vdFaccountInnerSubsetDomain, oldVdFaccountInnerSubset);
        this.updateFaccountInnerSubsetModel(vdFaccountInnerSubset);
    }

    @Override
    public VdFaccountInnerSubset getFaccountInnerSubset(Integer faccountInnerSubsetId) {
        return this.getFaccountInnerSubsetModelById(faccountInnerSubsetId);
    }

    @Override
    public void deleteFaccountInnerSubset(Integer faccountInnerSubsetId) throws ApiException {
        this.deleteFaccountInnerSubsetModel(faccountInnerSubsetId);
    }

    @Override
    public QueryResult<VdFaccountInnerSubset> queryFaccountInnerSubsetPage(Map<String, Object> map) {
        List<VdFaccountInnerSubset> vdFaccountInnerSubsetList = this.queryFaccountInnerSubsetModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountInnerSubset(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountInnerSubsetList);
        return queryResult;
    }

    @Override
    public void saveFaccountInnerDt(VdFaccountInnerDtDomain vdFaccountInnerDtDomain) throws ApiException {
        String msg = this.checkFaccountInnerDt(vdFaccountInnerDtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountInnerDt.checkFaccountInnerDt", msg);
        }
        VdFaccountInnerDt vdFaccountInnerDt = this.makeFaccountInnerDt(vdFaccountInnerDtDomain, null);
        this.setFaccountInnerDtDefault(vdFaccountInnerDt);
        this.saveFaccountInnerDtModel(vdFaccountInnerDt);
    }

    @Override
    public void updateFaccountInnerDtState(Integer faccountInnerDtId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateFaccountInnerDtModel(faccountInnerDtId, dataState, oldDataState);
    }

    @Override
    public void updateFaccountInnerDt(VdFaccountInnerDtDomain vdFaccountInnerDtDomain) throws ApiException {
        String msg = this.checkFaccountInnerDt(vdFaccountInnerDtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerDt.checkFaccountInnerDt", msg);
        }
        VdFaccountInnerDt oldVdFaccountInnerDt = this.getFaccountInnerDtModelById(vdFaccountInnerDtDomain.getFaccountInnerDtId());
        if (null == oldVdFaccountInnerDt) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.updateFaccountInnerDt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        VdFaccountInnerDt vdFaccountInnerDt = this.makeFaccountInnerDt(vdFaccountInnerDtDomain, oldVdFaccountInnerDt);
        this.setFaccountInnerDtUpdataDefault(vdFaccountInnerDt);
        this.updateFaccountInnerDtModel(vdFaccountInnerDt);
    }

    @Override
    public VdFaccountInnerDt getFaccountInnerDt(Integer faccountInnerDtId) {
        return this.getFaccountInnerDtModelById(faccountInnerDtId);
    }

    @Override
    public void deleteFaccountInnerDt(Integer faccountInnerDtId) throws ApiException {
        this.deleteFaccountInnerDtModel(faccountInnerDtId);
    }

    @Override
    public QueryResult<VdFaccountInnerDt> queryFaccountInnerDtPage(Map<String, Object> map) {
        List<VdFaccountInnerDt> vdFaccountInnerDtList = this.queryFaccountInnerDtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countFaccountInnerDt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(vdFaccountInnerDtList);
        return queryResult;
    }

    @Override
    public void saveFaccountDt(List<VdFaccountDtDomain> vdFaccountDtDomainList) throws ApiException {
        List<VdFaccountInnerDt> vdFaccountInnerDtList = this.makeInnerDt(vdFaccountDtDomainList);
        if (null == vdFaccountInnerDtList || vdFaccountInnerDtList.isEmpty()) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountDt.null", "null");
        }
        this.saveFaccountInnerDtListModel(vdFaccountInnerDtList);
    }

    @Override
    public void saveFaccountDtOne(VdFaccountDtDomain vdFaccountDtDomain) throws ApiException {
        VdFaccountInnerDt vdFaccountInnerDt = this.makeInnerDt(vdFaccountDtDomain);
        if (null == vdFaccountInnerDt) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountDtOne.null", "null");
        }
        this.roundAmount(vdFaccountInnerDt);
        this.saveFaccountInnerDtModel(vdFaccountInnerDt);
    }

    private void roundAmount(VdFaccountInnerDt vdFaccountInnerDt) {
        if (vdFaccountInnerDt.getFaccountAfamount() != null) {
            vdFaccountInnerDt.setFaccountAfamount(vdFaccountInnerDt.getFaccountAfamount().setScale(6, 5));
        }
        if (vdFaccountInnerDt.getFaccountBfamount() != null) {
            vdFaccountInnerDt.setFaccountBfamount(vdFaccountInnerDt.getFaccountBfamount().setScale(6, 5));
        }
        if (vdFaccountInnerDt.getFaccountAfprice() != null) {
            vdFaccountInnerDt.setFaccountAfprice(vdFaccountInnerDt.getFaccountAfprice().setScale(6, 5));
        }
        if (vdFaccountInnerDt.getFaccountBfprice() != null) {
            vdFaccountInnerDt.setFaccountBfprice(vdFaccountInnerDt.getFaccountBfprice().setScale(6, 5));
        }
    }

    @Override
    public List<VdFaccountDtDomain> saveFaccountBalance(List<VdFaccountDoDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountBalance.null", "null");
        }
        Collections.sort(vdFaccountDoDomainList, new Comparator<VdFaccountDoDomain>(){

            @Override
            public int compare(VdFaccountDoDomain arg0, VdFaccountDoDomain arg1) {
                return arg0.getFaccountId().compareTo(arg1.getFaccountId());
            }
        });
        ArrayList<VdFaccountDtDomain> dtList = new ArrayList<VdFaccountDtDomain>();
        for (VdFaccountDoDomain vdFaccountDoDomain : vdFaccountDoDomainList) {
            dtList.add(this.saveBalance(vdFaccountDoDomain));
        }
        return dtList;
    }

    @Override
    public VdFaccountDtDomain saveFaccountBalanceOne(VdFaccountDoDomain vdFaccountDoDomain) throws ApiException {
        if (null == vdFaccountDoDomain) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveFaccountBalancOne.null", "null");
        }
        return this.saveBalance(vdFaccountDoDomain);
    }

    private void checkDo(VdFaccountDoDomain vdFaccountDoDomain) {
        String errMsg = null;
        if (null == vdFaccountDoDomain) {
            errMsg = "\u53c2\u6570\u4e3a\u7a7a";
        } else if (StringUtils.isBlank((String)vdFaccountDoDomain.getFaccountId())) {
            errMsg = "\u8d26\u6237\u4e3a\u7a7a;";
        } else if (StringUtils.isBlank((String)vdFaccountDoDomain.getOrderDc())) {
            errMsg = "\u501f\u8d37\u4e3a\u7a7a;";
        } else if (StringUtils.isBlank((String)vdFaccountDoDomain.getOrderCurrency())) {
            errMsg = "\u5e01\u79cd\u4e3a\u7a7a;";
        } else if (StringUtils.isBlank((String)vdFaccountDoDomain.getFundType())) {
            errMsg = "\u8d44\u91d1\u5c5e\u6027\u4e3a\u7a7a;";
        } else if (StringUtils.isBlank((String)vdFaccountDoDomain.getTenantCode())) {
            errMsg = "\u79df\u6237code\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (errMsg != null) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.checkDo", errMsg);
        }
    }

    private VdFaccountDtDomain saveBalance(VdFaccountDoDomain vdFaccountDoDomain) {
        this.checkDo(vdFaccountDoDomain);
        VdFaccountInner vdFaccountInner = this.getFaccountInnerLockByCodeModel(vdFaccountDoDomain.getFaccountId(), vdFaccountDoDomain.getTenantCode());
        if (null == vdFaccountInner) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveBalance.inner", "\u8d26\u6237\u5f02\u5e38");
        }
        VdFaccountInnerSubset vdFaccountInnerSubset = this.getSubset(vdFaccountDoDomain.getFaccountId(), vdFaccountDoDomain.getTenantCode(), vdFaccountDoDomain.getFundType());
        if (null == vdFaccountInnerSubset) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveBalance.subset", "\u5b50\u8d26\u6237\u5f02\u5e38");
        }
        VdFaccountDtDomain vdFaccountDtDomain = this.saveBalance(vdFaccountDoDomain, vdFaccountInnerSubset);
        if (null == vdFaccountDtDomain) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveBalance.save", "\u8d26\u6237\u5f02\u5e38");
        }
        vdFaccountDtDomain.setFaccountName(vdFaccountInner.getFaccountInnerName());
        return vdFaccountDtDomain;
    }

    private VdFaccountInnerSubset getSubset(String faccountInnerNo, String tenantCode, String fundType) {
        List<VdFaccountInnerSubset> subsetList = this.queryFaccountInnerSubsetModelPage(this.getQueryMapParam("faccountInnerNo,tenantCode,fundType", new Object[]{faccountInnerNo, tenantCode, fundType}));
        if (null == subsetList || subsetList.isEmpty() || subsetList.size() != 1) {
            return null;
        }
        return subsetList.get(0);
    }

    private VdFaccountDtDomain saveBalance(VdFaccountDoDomain vdFaccountDoDomain, VdFaccountInnerSubset vdFaccountInnerSubset) {
        if (null == vdFaccountDoDomain || null == vdFaccountInnerSubset) {
            return null;
        }
        BalanceBean balanceBean = new BalanceBean();
        OrderBean orderBean = new OrderBean();
        try {
            BeanUtils.copyAllPropertys((Object)balanceBean, (Object)vdFaccountInnerSubset);
            BeanUtils.copyAllPropertys((Object)orderBean, (Object)vdFaccountDoDomain);
        }
        catch (Exception e) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveBalance.copy", "\u8d26\u6237\u5f02\u5e38");
        }
        balanceBean.operation(orderBean);
        VdFaccountDtDomain vdFaccountDtDomain = this.makeToDt(vdFaccountDoDomain, vdFaccountInnerSubset);
        if (null == vdFaccountDtDomain) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveBalance.makeToDt", "\u8d26\u6237\u5f02\u5e38");
        }
        if (balanceBean.isDirectionAllOrFaccountAmountGtZero()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("faccountInnerSubsetNo", vdFaccountInnerSubset.getFaccountInnerSubsetNo());
            map.put("tenantCode", vdFaccountInnerSubset.getTenantCode());
            map.put("currencyDirection", balanceBean.getCurrencyDirection());
            map.put("faccountAmount", balanceBean.getFaccountAmount());
            map.put("faccountPortion", balanceBean.getFaccountPortion());
            map.put("faccountPrice", balanceBean.getFaccountPrice());
            this.updateBalanceFaccountInnerSubsetModel(map);
        }
        vdFaccountDtDomain.setCont(balanceBean.isDirectionAllOrFaccountAmountGtZero());
        vdFaccountDtDomain.setFaccountAfamount(balanceBean.getFaccountAmount());
        vdFaccountDtDomain.setFaccountAfportion(balanceBean.getFaccountPortion());
        vdFaccountDtDomain.setFaccountAfprice(balanceBean.getFaccountPrice());
        vdFaccountDtDomain.setCurrencyAfdirection(balanceBean.getCurrencyDirection());
        vdFaccountDtDomain.setFaccountingDate(DateUtil.getDateString((Date)new Date(), (String)"yyyyMMdd"));
        return vdFaccountDtDomain;
    }

    private VdFaccountDtDomain makeToDt(VdFaccountDoDomain vdFaccountDoDomain, VdFaccountInnerSubset vdFaccountInnerSubset) {
        if (null == vdFaccountDoDomain || null == vdFaccountInnerSubset) {
            return null;
        }
        VdFaccountDtDomain vdFaccountDtDomain = new VdFaccountDtDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountDtDomain, (Object)vdFaccountDoDomain);
            vdFaccountDtDomain.setGmtCreate(this.getSysDate());
            vdFaccountDtDomain.setFaccountNo(vdFaccountInnerSubset.getFaccountInnerNo());
            vdFaccountDtDomain.setFaccountTitileCode(vdFaccountInnerSubset.getFaccountTitileCode());
            vdFaccountDtDomain.setFaccountBfamount(vdFaccountInnerSubset.getFaccountAmount());
            vdFaccountDtDomain.setFaccountBfportion(vdFaccountInnerSubset.getFaccountPortion());
            vdFaccountDtDomain.setFaccountBfprice(vdFaccountInnerSubset.getFaccountPrice());
            vdFaccountDtDomain.setCurrencyBfdirection(vdFaccountInnerSubset.getFaccountDirection());
            vdFaccountDtDomain.setCurrencyCode(vdFaccountInnerSubset.getCurrencyCode());
            return vdFaccountDtDomain;
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public List<VdFaccountDomain> saveOpenFaccount(List<VdFaccountDomain> vdFaccountDomainList) throws ApiException {
        if (null == vdFaccountDomainList || vdFaccountDomainList.isEmpty()) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveOpenFaccount.null", "null");
        }
        VdFaccountInnerDomain vdFaccountInnerDomain = null;
        for (VdFaccountDomain vdFaccountDomain : vdFaccountDomainList) {
            vdFaccountInnerDomain = this.makeFaccountToInner(vdFaccountDomain);
            if (null == vdFaccountInnerDomain) {
                throw new ApiException("vd.VdFaccountInnerServiceImpl.makeFaccountToInner.null", "null");
            }
            this.saveFaccountInner(vdFaccountInnerDomain);
            vdFaccountDomain.setFaccountNo(vdFaccountInnerDomain.getFaccountInnerNo());
            this.saveSubsetList(vdFaccountInnerDomain, vdFaccountDomain.getSubsetList());
            vdFaccountDomain.setSubsetList(null);
        }
        return vdFaccountDomainList;
    }

    private void saveSubsetList(VdFaccountInnerDomain vdFaccountInnerDomain, List<VdFaccountSubsetDomain> subsetList) {
        if (null == subsetList || subsetList.isEmpty() || null == vdFaccountInnerDomain) {
            throw new ApiException("vd.VdFaccountInnerServiceImpl.saveSubsetList.null", "null");
        }
        for (VdFaccountSubsetDomain vdFaccountSubsetDomain : subsetList) {
            VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain = this.makeFaccountToInnerSubset(vdFaccountSubsetDomain);
            vdFaccountInnerSubsetDomain.setFaccountNo(vdFaccountInnerDomain.getFaccountNo());
            vdFaccountInnerSubsetDomain.setFaccountInnerNo(vdFaccountInnerDomain.getFaccountNo());
            vdFaccountInnerSubsetDomain.setFaccountName(vdFaccountInnerDomain.getFaccountName());
            this.saveFaccountInnerSubset(vdFaccountInnerSubsetDomain);
        }
    }

    private VdFaccountInnerSubsetDomain makeFaccountToInnerSubset(VdFaccountSubsetDomain vdFaccountSubsetDomain) {
        if (null == vdFaccountSubsetDomain) {
            return null;
        }
        VdFaccountInnerSubsetDomain vdFaccountInnerSubsetDomain = new VdFaccountInnerSubsetDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerSubsetDomain, (Object)vdFaccountSubsetDomain);
        }
        catch (Exception e) {
            return null;
        }
        return vdFaccountInnerSubsetDomain;
    }

    private VdFaccountInnerDomain makeFaccountToInner(VdFaccountDomain vdFaccountDomain) {
        if (null == vdFaccountDomain) {
            return null;
        }
        VdFaccountInnerDomain vdFaccountInnerDomain = new VdFaccountInnerDomain();
        try {
            BeanUtils.copyAllPropertys((Object)vdFaccountInnerDomain, (Object)vdFaccountDomain);
            vdFaccountInnerDomain.setFaccountInnerName(vdFaccountDomain.getFaccountName());
        }
        catch (Exception e) {
            return null;
        }
        return vdFaccountInnerDomain;
    }

    @Override
    public Map<String, Object> faccountUnionQuery(Map<String, Object> map) {
        List<VdFaccountInnerDt> vdFaccountInnerDtList = this.vdFaccountInnerDtMapper.query(map);
        List<VdFaccountOuterDt> vdFaccountOuterDtList = this.vdFaccountOuterDtMapper.query(map);
        map.clear();
        map.put("inner", vdFaccountInnerDtList);
        map.put("out", vdFaccountOuterDtList);
        return map;
    }

    @Override
    public List<VdFaccountInner> queryFaccountInnerList(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return null;
        }
        return this.queryFaccountInnerModelPage(map);
    }

    @Override
    public void updateDirection(String faccountInnerNo, String directionCode, String tenantCode) {
        VdFaccountInnerInfo info = this.getFaccountInnerInfoByNo(faccountInnerNo, tenantCode);
        if (info == null) {
            throw new ApiException("ITEM.NOT.FOUND", "\u672a\u67e5\u8be2\u5230\u76f8\u5173\u8bb0\u5f55");
        }
        if (!VdFaccountDirectionEnum.DIRECTION_TWO_WAY.getCode().equals(info.getFaccountDirection())) {
            throw new ApiException("ILLEGAL.OPERATION", "\u65e0\u6548\u7684\u64cd\u4f5c\uff0cfaccountDirection \u4e0d\u5408\u6cd5");
        }
        if (!VdFaccountFundEnum.DEBIT.getFundCode().equals(info.getFundType())) {
            throw new ApiException("ILLEGAL.OPERATION", "\u65e0\u6548\u7684\u64cd\u4f5c, fundType \u4e0d\u5408\u6cd5");
        }
        List<VdFaccountInnerSubset> innerSubsetList = this.queryFaccountInnerSubsetModelPage(this.getQueryMapParam("tenantCode,faccountInnerNo,faccountDirection,fundType", new Object[]{tenantCode, faccountInnerNo, VdFaccountDirectionEnum.DIRECTION_TWO_WAY.getCode(), info.getFundType()}));
        if (CollectionUtils.isEmpty(innerSubsetList)) {
            this.logger.debug("innerSubsetList is empty");
            return;
        }
        for (VdFaccountInnerSubset subset : innerSubsetList) {
            subset.setCurrencyDirection(directionCode);
            this.updateFaccountInnerSubsetModel(subset);
        }
    }
}

