/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.virtualdepositor.domain;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.virtualdepositor.constant.VdFaccountDirectionEnum;
import com.yqbsoft.laser.service.virtualdepositor.domain.OrderBean;
import java.math.BigDecimal;

public class BalanceBean {
    private static final String SYS_CODE = "vd.BalanceBean";
    private static final String DC_DE = VdFaccountDirectionEnum.DIRECTION_DEBIT.getCode();
    private static final String DC_CR = VdFaccountDirectionEnum.DIRECTION_CREDIT.getCode();
    private static final String DC_ALL = VdFaccountDirectionEnum.DIRECTION_TWO_WAY.getCode();
    private String currencyCode;
    private String currencyDirection;
    private String faccountDirection;
    private BigDecimal faccountAmount;
    private BigDecimal faccountPortion;
    private BigDecimal faccountPrice;

    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    public String getCurrencyDirection() {
        return this.currencyDirection;
    }

    public void setCurrencyDirection(String currencyDirection) {
        this.currencyDirection = currencyDirection;
    }

    public String getFaccountDirection() {
        return this.faccountDirection;
    }

    public void setFaccountDirection(String faccountDirection) {
        this.faccountDirection = faccountDirection;
    }

    public BigDecimal getFaccountAmount() {
        return this.faccountAmount;
    }

    public void setFaccountAmount(BigDecimal faccountAmount) {
        this.faccountAmount = faccountAmount;
    }

    public BigDecimal getFaccountPortion() {
        return this.faccountPortion;
    }

    public void setFaccountPortion(BigDecimal faccountPortion) {
        this.faccountPortion = faccountPortion;
    }

    public BigDecimal getFaccountPrice() {
        return this.faccountPrice;
    }

    public void setFaccountPrice(BigDecimal faccountPrice) {
        this.faccountPrice = faccountPrice;
    }

    private void checkAndmakeValueSafe(OrderBean orderBean) {
        boolean isNotDirectionAllAndNotEqualsCurrency;
        if (StringUtils.isBlank((String)this.faccountDirection)) {
            throw new ApiException("vd.BalanceBean.operation.checkAndmakeValueSafe", "faccountDirection can`t be null");
        }
        if (orderBean == null) {
            throw new ApiException("vd.BalanceBean.operation.checkAndmakeValueSafe", "orderBean can`t be null");
        }
        if (StringUtils.isBlank((String)orderBean.getOrderDc())) {
            throw new ApiException("vd.BalanceBean.operation.checkAndmakeValueSafe", "\u8d26\u6237\u5f02\u5e38,orderDc can`t be null");
        }
        if (StringUtils.isBlank((String)this.currencyDirection)) {
            this.currencyDirection = DC_ALL.equals(this.faccountDirection) ? DC_DE : this.faccountDirection;
        } else if (DC_ALL.equals(this.currencyDirection)) {
            throw new ApiException("vd.BalanceBean.operation.checkAndmakeValueSafe", "currencyDirection can`t be zero (two-way)");
        }
        boolean bl = isNotDirectionAllAndNotEqualsCurrency = !DC_ALL.equals(this.faccountDirection) && !this.currencyDirection.equals(this.faccountDirection);
        if (isNotDirectionAllAndNotEqualsCurrency) {
            throw new ApiException("vd.BalanceBean.operation.checkAndmakeValueSafe", "\u8d26\u6237\u5f02\u5e38, \u8d44\u91d1\u65b9\u5411\u6709\u8bef, faccountDirection is not two_way(code is 0), and not equals currencyDirection");
        }
        if (this.faccountPortion == null) {
            this.faccountPortion = BigDecimal.ZERO;
        }
        if (this.faccountPrice == null) {
            this.faccountPrice = BigDecimal.ONE;
        }
        if (this.faccountAmount == null) {
            this.faccountAmount = BigDecimal.ZERO;
        }
        if (orderBean.getOrderAmount() == null) {
            orderBean.setOrderAmount(BigDecimal.ZERO);
        }
        if (orderBean.getOrderPortion() == null) {
            orderBean.setOrderPortion(BigDecimal.ZERO);
        }
        if (null == orderBean.getOrderPrice() || BigDecimal.ZERO.compareTo(orderBean.getOrderPrice()) == 0) {
            orderBean.setOrderPrice(BigDecimal.ONE);
        }
    }

    public void operation(OrderBean orderBean) {
        this.checkAndmakeValueSafe(orderBean);
        int faccountDc = 1;
        if (!DC_ALL.equals(this.faccountDirection) && !this.faccountDirection.equals(this.currencyDirection)) {
            faccountDc = -1;
        }
        this.faccountPortion = this.faccountPortion.multiply(new BigDecimal(faccountDc));
        this.faccountAmount = this.faccountAmount.multiply(new BigDecimal(faccountDc));
        if (!BigDecimal.ZERO.equals(orderBean.getOrderAmount())) {
            if (!this.faccountPrice.equals(orderBean.getOrderPrice()) && !BigDecimal.ONE.equals(orderBean.getOrderPrice())) {
                this.faccountPrice = orderBean.getOrderPrice();
            }
            this.faccountAmount = this.getCurrencyDirection().equals(orderBean.getOrderDc()) ? this.faccountAmount.subtract(orderBean.getOrderAmount()) : this.faccountAmount.add(orderBean.getOrderAmount());
            this.faccountPortion = this.faccountAmount.divide(this.faccountPrice);
        } else if (!BigDecimal.ZERO.equals(orderBean.getOrderPortion())) {
            if (!this.faccountPrice.equals(orderBean.getOrderPrice()) && !BigDecimal.ONE.equals(orderBean.getOrderPrice())) {
                this.faccountPrice = orderBean.getOrderPrice();
            }
            this.faccountPortion = this.getCurrencyDirection().equals(orderBean.getOrderDc()) ? this.faccountAmount.subtract(orderBean.getOrderPortion()) : this.faccountAmount.add(orderBean.getOrderPortion());
            this.faccountAmount = this.faccountPortion.multiply(this.faccountPrice);
        } else if (!BigDecimal.ONE.equals(orderBean.getOrderPrice())) {
            this.faccountPrice = orderBean.getOrderPrice();
            this.faccountPortion = this.faccountAmount.divide(orderBean.getOrderPrice());
        } else {
            throw new ApiException("vd.BalanceBean.saveBalance.amount", "\u91d1\u989d\u5f02\u5e38");
        }
        if (DC_ALL.equals(this.faccountDirection) && !this.faccountAmountGtZero()) {
            this.setFaccountAmount(this.getFaccountAmount().abs());
            this.setFaccountPortion(this.getFaccountPortion().abs());
            if (DC_DE.equals(this.getCurrencyDirection())) {
                this.setCurrencyDirection(DC_CR);
            } else {
                this.setCurrencyDirection(DC_DE);
            }
        }
    }

    public boolean isDirectionAllOrFaccountAmountGtZero() {
        if (DC_ALL.equals(this.getFaccountDirection())) {
            return true;
        }
        return this.faccountAmountGtZero();
    }

    public boolean faccountAmountGtZero() {
        return this.getFaccountAmount().compareTo(BigDecimal.ZERO) >= 0;
    }
}

