/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.wa.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.wa.Util;
import com.yqbsoft.laser.service.wa.dao.WaWaiterMapper;
import com.yqbsoft.laser.service.wa.domain.OcContractDomain;
import com.yqbsoft.laser.service.wa.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterGoodsDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiterReDomain;
import com.yqbsoft.laser.service.wa.domain.WaWaiteruserItDomain;
import com.yqbsoft.laser.service.wa.model.WaWaiter;
import com.yqbsoft.laser.service.wa.model.WaWaiteruser;
import com.yqbsoft.laser.service.wa.model.WaWaiteruserIt;
import com.yqbsoft.laser.service.wa.model.WaWaiteruserSc;
import com.yqbsoft.laser.service.wa.service.WaWaiterGoodsService;
import com.yqbsoft.laser.service.wa.service.WaWaiterService;
import com.yqbsoft.laser.service.wa.service.WaWaiteruserItService;
import com.yqbsoft.laser.service.wa.service.WaWaiteruserScService;
import com.yqbsoft.laser.service.wa.service.WaWaiteruserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WaWaiterServiceImpl
extends BaseServiceImpl
implements WaWaiterService {
    private static final String SYS_CODE = "wa.WaWaiterServiceImpl";
    private WaWaiterMapper waWaiterMapper;
    WaWaiterGoodsService waWaiterGoodsService;
    WaWaiteruserService waWaiteruserService;
    WaWaiteruserScService waWaiteruserScService;
    WaWaiteruserItService waWaiteruserItService;

    public void setWaWaiterMapper(WaWaiterMapper waWaiterMapper) {
        this.waWaiterMapper = waWaiterMapper;
    }

    public void setWaWaiterGoodsService(WaWaiterGoodsService waWaiterGoodsService) {
        this.waWaiterGoodsService = waWaiterGoodsService;
    }

    public void setWaWaiteruserService(WaWaiteruserService waWaiteruserService) {
        this.waWaiteruserService = waWaiteruserService;
    }

    public void setWaWaiteruserScService(WaWaiteruserScService waWaiteruserScService) {
        this.waWaiteruserScService = waWaiteruserScService;
    }

    public void setWaWaiteruserItService(WaWaiteruserItService waWaiteruserItService) {
        this.waWaiteruserItService = waWaiteruserItService;
    }

    private Date getSysDate() {
        try {
            return this.waWaiterMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWaiter(WaWaiterDomain waWaiterDomain) {
        if (null == waWaiterDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)waWaiterDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWaiterDefault(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return;
        }
        if (null == waWaiter.getDataState()) {
            waWaiter.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == waWaiter.getGmtCreate()) {
            waWaiter.setGmtCreate(date);
        }
        waWaiter.setGmtModified(date);
        if (StringUtils.isBlank((String)waWaiter.getWaiterCode())) {
            waWaiter.setWaiterCode(this.getNo(null, "WaWaiter", "waWaiter", waWaiter.getTenantCode()));
        }
    }

    private int getWaiterMaxCode() {
        int code = 0;
        try {
            return this.waWaiterMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWaiterUpdataDefault(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return;
        }
        waWaiter.setGmtModified(this.getSysDate());
    }

    private void saveWaiterModel(WaWaiter waWaiter) throws ApiException {
        if (null == waWaiter) {
            return;
        }
        try {
            this.waWaiterMapper.insert(waWaiter);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiterModel.ex", (Throwable)e);
        }
    }

    private void saveWaiterBatchModel(List<WaWaiter> waWaiterList) throws ApiException {
        if (null == waWaiterList || waWaiterList.isEmpty()) {
            return;
        }
        try {
            this.waWaiterMapper.insertBatch(waWaiterList);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiterBatchModel.ex", (Throwable)e);
        }
    }

    private WaWaiter getWaiterModelById(Integer waiterId) {
        if (null == waiterId) {
            return null;
        }
        try {
            return this.waWaiterMapper.selectByPrimaryKey(waiterId);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterModelById", (Throwable)e);
            return null;
        }
    }

    private WaWaiter getWaiterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.waWaiterMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.getWaiterModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delWaiterModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.delWaiterModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.delWaiterModelByCode.num");
        }
    }

    private void deleteWaiterModel(Integer waiterId) throws ApiException {
        if (null == waiterId) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.deleteByPrimaryKey(waiterId);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.deleteWaiterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.deleteWaiterModel.num");
        }
    }

    private void updateWaiterModel(WaWaiter waWaiter) throws ApiException {
        if (null == waWaiter) {
            return;
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateByPrimaryKey(waWaiter);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiterModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiterModel.num");
        }
    }

    private void updateStateWaiterModel(Integer waiterId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == waiterId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("waiterId", waiterId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModel.null");
        }
    }

    private void updateStateWaiterModelByCode(String tenantCode, String waiterCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.waWaiterMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateStateWaiterModelByCode.null");
        }
    }

    private WaWaiter makeWaiter(WaWaiterDomain waWaiterDomain, WaWaiter waWaiter) {
        if (null == waWaiterDomain) {
            return null;
        }
        if (null == waWaiter) {
            waWaiter = new WaWaiter();
        }
        try {
            BeanUtils.copyAllPropertys((Object)waWaiter, (Object)waWaiterDomain);
            return waWaiter;
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.makeWaiter", (Throwable)e);
            return null;
        }
    }

    private WaWaiterReDomain makeWaWaiterReDomain(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return null;
        }
        WaWaiterReDomain waWaiterReDomain = new WaWaiterReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)waWaiterReDomain, (Object)waWaiter);
            return waWaiterReDomain;
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.makeWaWaiterReDomain", (Throwable)e);
            return null;
        }
    }

    private List<WaWaiter> queryWaiterModelPage(Map<String, Object> parammap) {
        try {
            return this.waWaiterMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.queryWaiterModel", (Throwable)e);
            return null;
        }
    }

    private int countWaiter(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.waWaiterMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.countWaiter", (Throwable)e);
        }
        return i;
    }

    private WaWaiter createWaWaiter(WaWaiterDomain waWaiterDomain) {
        String msg = this.checkWaiter(waWaiterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wa.WaWaiterServiceImpl.saveWaiter.checkWaiter", msg);
        }
        WaWaiter waWaiter = this.makeWaiter(waWaiterDomain, null);
        this.setWaiterDefault(waWaiter);
        return waWaiter;
    }

    @Override
    public String saveWaiter(WaWaiterDomain waWaiterDomain) throws ApiException {
        WaWaiter waWaiter = this.createWaWaiter(waWaiterDomain);
        this.saveWaiterModel(waWaiter);
        return waWaiter.getWaiterCode();
    }

    @Override
    public String saveWaiterBatch(List<WaWaiterDomain> waWaiterDomainList) throws ApiException {
        if (null == waWaiterDomainList || waWaiterDomainList.isEmpty()) {
            return null;
        }
        ArrayList<WaWaiter> waWaiterList = new ArrayList<WaWaiter>();
        String code = "";
        for (WaWaiterDomain waWaiterDomain : waWaiterDomainList) {
            WaWaiter waWaiter = this.createWaWaiter(waWaiterDomain);
            code = waWaiter.getWaiterCode();
            waWaiterList.add(waWaiter);
        }
        this.saveWaiterBatchModel(waWaiterList);
        return code;
    }

    @Override
    public void updateWaiterState(Integer waiterId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == waiterId) {
            return;
        }
        this.updateStateWaiterModel(waiterId, dataState, oldDataState, map);
    }

    @Override
    public void updateWaiterStateByCode(String tenantCode, String waiterCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateWaiterModelByCode(tenantCode, waiterCode, dataState, oldDataState, map);
    }

    @Override
    public void updateWaiter(WaWaiterDomain waWaiterDomain) throws ApiException {
        String msg = this.checkWaiter(waWaiterDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiter.checkWaiter", msg);
        }
        WaWaiter oldWaWaiter = this.getWaiterModelById(waWaiterDomain.getWaiterId());
        if (null == oldWaWaiter) {
            throw new ApiException("wa.WaWaiterServiceImpl.updateWaiter.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WaWaiter waWaiter = this.makeWaiter(waWaiterDomain, oldWaWaiter);
        this.setWaiterUpdataDefault(waWaiter);
        this.updateWaiterModel(waWaiter);
    }

    @Override
    public WaWaiter getWaiter(Integer waiterId) {
        if (null == waiterId) {
            return null;
        }
        return this.getWaiterModelById(waiterId);
    }

    @Override
    public void deleteWaiter(Integer waiterId) throws ApiException {
        if (null == waiterId) {
            return;
        }
        this.deleteWaiterModel(waiterId);
    }

    @Override
    public QueryResult<WaWaiter> queryWaiterPage(Map<String, Object> map) {
        List<WaWaiter> waWaiterList = this.queryWaiterModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWaiter(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(waWaiterList);
        return queryResult;
    }

    @Override
    public WaWaiter getWaiterByCode(String tenantCode, String waiterCode) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        return this.getWaiterModelByCode(map);
    }

    @Override
    public void deleteWaiterByCode(String tenantCode, String waiterCode) throws ApiException {
        if (StringUtils.isBlank((String)waiterCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("waiterCode", waiterCode);
        this.delWaiterModelByCode(map);
    }

    @Override
    public String sendOrderServiceTicket(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return null;
        }
        WaWaiterDomain waWaiterDomain = new WaWaiterDomain();
        try {
            BeanUtils.copyAllPropertys((Object)waWaiterDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket", (Throwable)e);
        }
        waWaiterDomain.setWaiterVaildate(ocContractDomain.getContractValidate());
        waWaiterDomain.setWaiterGddate(ocContractDomain.getContractEffectivedate());
        String s = this.saveWaiter(waWaiterDomain);
        ArrayList<WaWaiterGoodsDomain> waWaiterGoodsDomainList = new ArrayList<WaWaiterGoodsDomain>();
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            WaWaiterGoodsDomain waWaiterGoodsDomain = new WaWaiterGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)waWaiterGoodsDomain, (Object)ocContractGoodsDomain);
                waWaiterGoodsDomain.setWaiterCode(s);
            }
            catch (Exception e) {
                this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket", (Throwable)e);
            }
            waWaiterGoodsDomainList.add(waWaiterGoodsDomain);
        }
        this.waWaiterGoodsService.saveWaiterGoodsBatch(waWaiterGoodsDomainList);
        WaWaiter waiterByCode = this.getWaiterByCode(ocContractDomain.getTenantCode(), s);
        this.updateDistributeLeafletsByWaWaiter(waiterByCode);
        return "success";
    }

    public void updateDistributeLeafletsByWaWaiter(WaWaiter waWaiter) {
        if (null == waWaiter) {
            return;
        }
        WaWaiteruser waWaiteruser = this.checkOrderForPmu(DateUtil.getDateString((Date)waWaiter.getWaiterVaildate(), (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.getDateString((Date)waWaiter.getWaiterGddate(), (String)"yyyy-MM-dd HH:mm:ss"), waWaiter.getAreaCode(), waWaiter.getTenantCode());
        if (waWaiter == null) {
            return;
        }
        String dateString = DateUtils.getDateString((Date)waWaiter.getWaiterVaildate(), (String)"yyyy-MM-dd");
        long datePoor = Util.getDatePoor(waWaiter.getWaiterGddate(), waWaiter.getWaiterVaildate());
        int serviceDate = 0;
        if (datePoor <= 4L) {
            serviceDate = Util.getDateisAm(waWaiter.getWaiterVaildate()) != false ? 1 : 2;
        }
        waWaiter.setGoodsSupplierCode(waWaiteruser.getMemberBcode());
        waWaiter.setGoodsSupplierName(waWaiteruser.getMemberBname());
        waWaiter.setDataState(1);
        this.updateWaiterModel(waWaiter);
        this.saveWaiteruserItBatch(waWaiteruser.getWaiteruserCode(), dateString, serviceDate, waWaiter.getTenantCode());
    }

    @Override
    public void updateDistributeLeaflets(String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 0);
        map.put("tenantCode", tenantCode);
        QueryResult<WaWaiter> waWaiterQueryResult = this.queryWaiterPage(map);
        if (null == waWaiterQueryResult || ListUtil.isEmpty((Collection)waWaiterQueryResult.getList())) {
            this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket.waWaiterQueryResult.null");
            return;
        }
        for (WaWaiter waWaiter : waWaiterQueryResult.getList()) {
            WaWaiteruser waWaiteruser;
            String areaCode = waWaiter.getAreaCode();
            Date waiterVaildate = waWaiter.getWaiterVaildate();
            Date waiterGddate = waWaiter.getWaiterGddate();
            String dateString = DateUtils.getDateString((Date)waiterVaildate, (String)"yyyy-MM-dd");
            long datePoor = Util.getDatePoor(waiterGddate, waiterVaildate);
            int serviceDate = 0;
            if (datePoor <= 4L) {
                serviceDate = Util.getDateisAm(waiterVaildate) != false ? 1 : 2;
            }
            if (null == (waWaiteruser = this.checkOrderForPmu(DateUtil.getDateString((Date)waiterVaildate, (String)"yyyy-MM-dd HH:mm:ss"), DateUtil.getDateString((Date)waiterGddate, (String)"yyyy-MM-dd HH:mm:ss"), areaCode, tenantCode))) continue;
            waWaiter.setGoodsSupplierCode(waWaiteruser.getMemberBcode());
            waWaiter.setGoodsSupplierName(waWaiteruser.getMemberBname());
            waWaiter.setDataState(1);
            this.updateWaiterModel(waWaiter);
            this.saveWaiteruserItBatch(waWaiteruser.getWaiteruserCode(), dateString, serviceDate, tenantCode);
        }
    }

    @Override
    public WaWaiteruser checkOrderForPmu(String waiterVaildateStr, String waiterGddateStr, String areaCode, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)waiterVaildateStr) || StringUtils.isBlank((String)waiterGddateStr)) {
            this.logger.error("wa.WaWaiterServiceImpl.checkOrderForPmu1.null", (Object)(waiterVaildateStr + "=" + waiterGddateStr + "=" + areaCode));
            return null;
        }
        Date waiterVaildate = DateUtils.getDateToString((String)waiterVaildateStr, (String)"yyyy-MM-dd HH:mm:ss");
        Date waiterGddate = DateUtils.getDateToString((String)waiterGddateStr, (String)"yyyy-MM-dd HH:mm:ss");
        if (null == waiterVaildate || null == waiterGddate || StringUtils.isBlank((String)areaCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("wa.WaWaiterServiceImpl.checkOrderForPmu.null", (Object)(waiterVaildate + "=" + waiterGddate + "=" + areaCode));
            return null;
        }
        long datePoor = Util.getDatePoor(waiterGddate, waiterVaildate);
        int serviceDate = 0;
        if (datePoor <= 4L) {
            serviceDate = Util.getDateisAm(waiterVaildate) != false ? 1 : 2;
        }
        HashMap<String, Object> userScMap = new HashMap<String, Object>();
        userScMap.put("dataState", 0);
        userScMap.put("waiteruserScTvalue", areaCode);
        userScMap.put("tenantCode", tenantCode);
        QueryResult<WaWaiteruserSc> waWaiteruserScQueryResult = this.waWaiteruserScService.queryWaiteruserScPage(userScMap);
        if (null == waWaiteruserScQueryResult && ListUtil.isEmpty((Collection)waWaiteruserScQueryResult.getList())) {
            this.logger.error("wa.WaWaiterServiceImpl.sendOrderServiceTicket.waWaiteruserScQueryResult.null", (Object)"\u8ba2\u5355\u6ca1\u6709\u7b26\u5408\u7684\u6444\u5f71\u5e08");
            return null;
        }
        for (WaWaiteruserSc waWaiteruserSc : waWaiteruserScQueryResult.getList()) {
            WaWaiteruserIt waWaiteruserIt;
            HashMap userItMap = new HashMap();
            userScMap.put("tenantCode", waWaiteruserSc.getTenantCode());
            userScMap.put("waiteruserCode", waWaiteruserSc.getWaiteruserCode());
            String dateString = DateUtils.getDateString((Date)waiterVaildate, (String)"yyyy-MM-dd");
            userScMap.put("waiteruserItStartt", dateString);
            userScMap.put("order", true);
            userScMap.put("fuzzy", true);
            QueryResult<WaWaiteruserIt> waWaiteruserItQueryResult = this.waWaiteruserItService.queryWaiteruserItPage(userScMap);
            if (null != waWaiteruserItQueryResult && ListUtil.isEmpty((Collection)waWaiteruserItQueryResult.getList())) {
                WaWaiteruser waiteruserByCode = this.waWaiteruserService.getWaiteruserByCode(waWaiteruserSc.getTenantCode(), waWaiteruserSc.getWaiteruserCode());
                if (null == waiteruserByCode) {
                    this.logger.error("wa.WaWaiterServiceImpl.updateDistributeLeaflets.waiteruserByCode.null", (Object)waWaiteruserSc.getWaiteruserCode());
                    return null;
                }
                return waiteruserByCode;
            }
            if (waWaiteruserItQueryResult.getList().size() >= 2 || 0 == serviceDate || (Util.getDateisAm(DateUtil.getDateToString((String)(waWaiteruserIt = (WaWaiteruserIt)waWaiteruserItQueryResult.getList().get(0)).getWaiteruserItStartt(), (String)"yyyy-MM-dd HH:mm:ss")) != false ? 1 == serviceDate : 2 == serviceDate)) continue;
            WaWaiteruser waiteruserByCode = this.waWaiteruserService.getWaiteruserByCode(waWaiteruserSc.getTenantCode(), waWaiteruserSc.getWaiteruserCode());
            return waiteruserByCode;
        }
        return null;
    }

    public void saveWaiteruserItBatch(String waiteruserCode, String dateString, int serviceDate, String tenantCode) {
        ArrayList<WaWaiteruserItDomain> waWaiteruserItDomainList = new ArrayList<WaWaiteruserItDomain>();
        WaWaiteruserItDomain amWaWaiteruserItDomain = new WaWaiteruserItDomain();
        amWaWaiteruserItDomain.setWaiteruserItStartt(dateString + " 08:00:00");
        amWaWaiteruserItDomain.setWaiteruserItEndt(dateString + " 12:00:00");
        amWaWaiteruserItDomain.setWaiteruserItSort("2");
        amWaWaiteruserItDomain.setTenantCode(tenantCode);
        amWaWaiteruserItDomain.setWaiteruserCode(waiteruserCode);
        WaWaiteruserItDomain pmWaWaiteruserItDomain = new WaWaiteruserItDomain();
        pmWaWaiteruserItDomain.setWaiteruserItStartt(dateString + " 02:00:00");
        pmWaWaiteruserItDomain.setWaiteruserItEndt(dateString + " 18:00:00");
        pmWaWaiteruserItDomain.setWaiteruserItSort("2");
        pmWaWaiteruserItDomain.setTenantCode(tenantCode);
        pmWaWaiteruserItDomain.setWaiteruserCode(waiteruserCode);
        if (1 == serviceDate) {
            waWaiteruserItDomainList.add(amWaWaiteruserItDomain);
        } else if (2 == serviceDate) {
            waWaiteruserItDomainList.add(pmWaWaiteruserItDomain);
        } else {
            waWaiteruserItDomainList.add(amWaWaiteruserItDomain);
            waWaiteruserItDomainList.add(pmWaWaiteruserItDomain);
        }
        this.waWaiteruserItService.saveWaiteruserItBatch(waWaiteruserItDomainList);
    }

    public static void main(String[] args) {
    }
}

