/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.workflow.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.workflow.WorkflowConstants;
import com.yqbsoft.laser.service.workflow.dao.WfApproveMapper;
import com.yqbsoft.laser.service.workflow.dao.WfInstanceMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeStepMapper;
import com.yqbsoft.laser.service.workflow.domain.WfApproveDomain;
import com.yqbsoft.laser.service.workflow.model.WfApprove;
import com.yqbsoft.laser.service.workflow.model.WfInstance;
import com.yqbsoft.laser.service.workflow.model.WfNodeStep;
import com.yqbsoft.laser.service.workflow.service.WFApproveService;
import com.yqbsoft.laser.service.workflow.service.WFEngineService;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WFApproveServiceImpl
extends BaseServiceImpl
implements WFApproveService {
    public static final String SYS_CODE = "wf.WORKFLOW.WFApproveServiceImpl";
    private WfApproveMapper wfWFApproveMapper;
    private WfInstanceMapper wfWFInstanceMapper;
    private WfNodeStepMapper wfWFNodeStepMapper;
    private WFEngineService wFEngineService;

    public void setWfWFNodeStepMapper(WfNodeStepMapper wfWFNodeStepMapper) {
        this.wfWFNodeStepMapper = wfWFNodeStepMapper;
    }

    public void setWfWFInstanceMapper(WfInstanceMapper wfWFInstanceMapper) {
        this.wfWFInstanceMapper = wfWFInstanceMapper;
    }

    public void setwFEngineService(WFEngineService wFEngineService) {
        this.wFEngineService = wFEngineService;
    }

    public void setWfWFApproveMapper(WfApproveMapper wfWFApproveMapper) {
        this.wfWFApproveMapper = wfWFApproveMapper;
    }

    private Date getSysDate() {
        try {
            return this.wfWFApproveMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkApprove(WfApproveDomain wfWFApproveDomain) {
        if (null == wfWFApproveDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setApproveDefault(WfApprove wfWFApprove) {
        if (null == wfWFApprove) {
            return;
        }
        if (null == wfWFApprove.getDataState()) {
            wfWFApprove.setDataState(0);
        }
        if (null == wfWFApprove.getGmtCreate()) {
            wfWFApprove.setGmtCreate(this.getSysDate());
        }
        wfWFApprove.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wfWFApprove.getApproveCode())) {
            int code = this.getMaxCode();
            wfWFApprove.setApproveCode(this.makeMaxCode8(++code));
        }
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.wfWFApproveMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setApproveUpdataDefault(WfApprove wfWFApprove) {
        if (null == wfWFApprove) {
            return;
        }
        wfWFApprove.setGmtModified(this.getSysDate());
    }

    private void saveApproveModel(WfApprove wfWFApprove) throws ApiException {
        if (null == wfWFApprove) {
            return;
        }
        try {
            this.wfWFApproveMapper.insert(wfWFApprove);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.saveFtpserverModel.ex");
        }
    }

    private WfApprove getApproveModelById(Integer approveId) {
        if (null == approveId) {
            return null;
        }
        try {
            return this.wfWFApproveMapper.selectByPrimaryKey(approveId);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.getApproveModelById", (Throwable)e);
            return null;
        }
    }

    private void deleteApproveModel(Integer approveId) throws ApiException {
        if (null == approveId) {
            return;
        }
        int i = 0;
        try {
            i = this.wfWFApproveMapper.deleteByPrimaryKey(approveId);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.deleteApproveModel.ex");
        }
        if (1 != i) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.deleteApproveModel.num");
        }
    }

    private void updateApproveModel(WfApprove wfWFApprove) throws ApiException {
        if (null == wfWFApprove) {
            return;
        }
        try {
            this.wfWFApproveMapper.updateByPrimaryKeySelective(wfWFApprove);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateApproveModel.ex");
        }
    }

    private void updateStateApproveModel(Integer approveId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == approveId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approveId", approveId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wfWFApproveMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateStateApproveModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateStateApproveModel.null");
        }
    }

    private void updateDataBillstateApproveModel(Integer approveId, Integer dataState, Integer oldDataState, Integer oldDataState2) throws ApiException {
        if (null == approveId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approveId", approveId);
        map.put("dataBillstate", dataState);
        map.put("oldDataBillstate", oldDataState);
        map.put("oldDataBillstate2", oldDataState2);
        int i = 0;
        try {
            i = this.wfWFApproveMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateDataBillstateApproveModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateDataBillstateApproveModel.null");
        }
    }

    private void updateInstanceStateApproveModel(String instanceCode, Integer instanceState, Integer oldInstanceState) throws ApiException {
        if (null == instanceCode || null == instanceState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceCode", instanceCode);
        map.put("instanceState", instanceState);
        map.put("oldInstanceState", oldInstanceState);
        int i = 0;
        try {
            i = this.wfWFApproveMapper.updateInstanceStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateInstanceStateApproveModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateInstanceStateApproveModel.null");
        }
    }

    private WfApprove makeApprove(WfApproveDomain wfWFApproveDomain, WfApprove wfWFApprove) {
        if (null == wfWFApproveDomain) {
            return null;
        }
        if (null == wfWFApprove) {
            wfWFApprove = new WfApprove();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)wfWFApprove, (Object)wfWFApproveDomain);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.makeApprove", (Throwable)e);
        }
        return wfWFApprove;
    }

    private List<WfApprove> queryApproveModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFApproveMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.queryApproveModel", (Throwable)e);
            return null;
        }
    }

    private int countApprove(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wfWFApproveMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.countApprove", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveApprove(WfApproveDomain wfWFApproveDomain) throws ApiException {
        String msg = this.checkApprove(wfWFApproveDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.saveApprove.checkApprove", msg);
        }
        WfApprove wfWFApprove = this.makeApprove(wfWFApproveDomain, null);
        this.setApproveDefault(wfWFApprove);
        this.saveApproveModel(wfWFApprove);
        this.sendMsg(wfWFApprove);
    }

    @Override
    public void updateApproveState(Integer approveId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateApproveModel(approveId, dataState, oldDataState);
    }

    @Override
    public void updateApproveInstanceState(String instanceCode, Integer instanceState, Integer oldInstanceState) throws ApiException {
        this.updateInstanceStateApproveModel(instanceCode, instanceState, oldInstanceState);
    }

    @Override
    public void updateApprove(WfApproveDomain wfWFApproveDomain) throws ApiException {
        String msg = this.checkApprove(wfWFApproveDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateApprove.checkApprove", msg);
        }
        WfApprove oldWfWFApprove = this.getApproveModelById(wfWFApproveDomain.getApproveId());
        if (null == oldWfWFApprove) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.updateApprove.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WfApprove wfWFApprove = this.makeApprove(wfWFApproveDomain, oldWfWFApprove);
        this.setApproveUpdataDefault(wfWFApprove);
        this.updateApproveModel(wfWFApprove);
    }

    private void sendMsg(WfApprove wfWFApprove) {
        Map<String, Object> objMap = this.wFEngineService.getObjectMapByInstanceCode(wfWFApprove.getInstanceCode(), wfWFApprove.getTenantCode());
        String receiverCode = wfWFApprove.getUserAcode();
        String receiverName = wfWFApprove.getUserAname();
        String senderCode = wfWFApprove.getUserCode();
        String senderName = wfWFApprove.getUserName();
        String subject = wfWFApprove.getNodeStepName();
        this.wFEngineService.sendMsg(wfWFApprove, objMap, receiverCode, receiverName, senderCode, senderName, subject);
    }

    @Override
    public WfApprove getApprove(Integer approveId) {
        return this.getApproveModelById(approveId);
    }

    @Override
    public void deleteApprove(Integer approveId) throws ApiException {
        this.deleteApproveModel(approveId);
    }

    @Override
    public QueryResult<WfApprove> queryApprovePage(Map<String, Object> map) {
        List<WfApprove> wfWFApproveList = this.queryApproveModelPage(map);
        this.getInstanceMes(wfWFApproveList, map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countApprove(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wfWFApproveList);
        return queryResult;
    }

    private void getInstanceMes(List<WfApprove> wfWFApproveList) {
        if (null != wfWFApproveList && wfWFApproveList.size() > 0) {
            for (WfApprove wfWFApprove : wfWFApproveList) {
                String instanceCode = wfWFApprove.getInstanceCode();
                WfInstance wfWFInstance = this.wfWFInstanceMapper.selectByInstanceCode(this.getQueryParamMap("instanceCode,tenantCode", new Object[]{instanceCode, wfWFApprove.getTenantCode()}));
                if (null == wfWFInstance) continue;
                String instanceOthercode = wfWFInstance.getInstanceOthercode();
                String opRemark = wfWFInstance.getOpRemark();
                wfWFApprove.setInstanceOthercode(instanceOthercode);
                wfWFApprove.setOpRemark(opRemark);
            }
        }
    }

    private void getInstanceMes(List<WfApprove> wfWFApproveList, Map<String, Object> map) {
        if (map.containsKey("instanceOthercode") && null != map.get("instanceOthercode") && StringUtils.isNotBlank((String)map.get("instanceOthercode").toString())) {
            ArrayList<WfApprove> limitWfWFApproves = new ArrayList<WfApprove>();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put("instanceOthercode", String.valueOf(map.get("instanceOthercode")));
            if (ListUtil.isNotEmpty(wfWFApproveList)) {
                for (WfApprove wfWFApprove : wfWFApproveList) {
                    String instanceCode = wfWFApprove.getInstanceCode();
                    parameters.put("instanceCode", instanceCode);
                    List<WfInstance> wfWFInstances = this.wfWFInstanceMapper.query(parameters);
                    if (!ListUtil.isNotEmpty(wfWFInstances)) continue;
                    WfInstance wfWFInstance = wfWFInstances.get(0);
                    if (null != wfWFInstance) {
                        String instanceOthercode = wfWFInstance.getInstanceOthercode();
                        String opRemark = wfWFInstance.getOpRemark();
                        wfWFApprove.setInstanceOthercode(instanceOthercode);
                        wfWFApprove.setOpRemark(opRemark);
                    }
                    limitWfWFApproves.add(wfWFApprove);
                }
                wfWFApproveList.clear();
                wfWFApproveList.addAll(limitWfWFApproves);
            }
        } else {
            this.getInstanceMes(wfWFApproveList);
        }
    }

    @Override
    public List<WfApprove> queryApproveList(Map<String, Object> map) {
        List<WfApprove> wfWFApproveList = this.queryApproveModelPage(map);
        return wfWFApproveList;
    }

    @Override
    public WfApprove executeWFApprove(WfApproveDomain wfWFApproveDomain) {
        WfApprove wFApprove = this.getApproveModelById(wfWFApproveDomain.getApproveId());
        if (wFApprove == null) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.executeWFApprove.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        wFApprove = this.makeApprove(wfWFApproveDomain, wFApprove);
        wFApprove.setApproveRemark(wfWFApproveDomain.getApproveRemark());
        wFApprove.setApproveState(wfWFApproveDomain.getApproveState());
        wFApprove.setDataBillstate(wfWFApproveDomain.getDataBillstate());
        wFApprove.setApproveTime(this.getSysDate());
        wFApprove.setDataOpdate(this.getSysDate());
        wFApprove.setDataState(WorkflowConstants.STATE_WAIT_START);
        this.updateApproveModel(wFApprove);
        return wFApprove;
    }

    @Override
    public void executeCallbackWFApprove(String approveCode) {
        WfApprove wfWFApprove = this.getWfWFApprove(approveCode);
        if (wfWFApprove == null) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.executeCallbackWFApprove.null", "\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        wfWFApprove.setDataBillstate(WorkflowConstants.APPROVE_STATE_PASS);
        wfWFApprove.setApproveTime(this.getSysDate());
        wfWFApprove.setDataOpdate(this.getSysDate());
        this.updateDataBillstateApproveModel(wfWFApprove.getApproveId(), WorkflowConstants.APPROVE_STATE_PASS, WorkflowConstants.APPROVE_STATE_WAIT, WorkflowConstants.APPROVE_STATE_NEXT);
        this.wFEngineService.updateWFEngine(wfWFApprove, null);
    }

    private WfApprove getWfWFApprove(String approveCode) {
        try {
            return this.wfWFApproveMapper.selectByCode(approveCode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private WfNodeStep getWFNodeStep(String nodeStepCode, String tenantCode) {
        try {
            return this.wfWFNodeStepMapper.selectByCode(nodeStepCode, tenantCode);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void autoWaitStartApprove() {
        List<WfApprove> approves = this.queryApproveModelPage(this.getQueryParamMap("dataState", new Object[]{WorkflowConstants.STATE_WAIT_START}));
        if (ListUtil.isNotEmpty(approves)) {
            for (WfApprove wfWFApprove : approves) {
                this.wFEngineService.updateWFEngine(wfWFApprove, null);
            }
        }
    }

    @Override
    public void executeWFApproveSync(WfApproveDomain wfWFApproveDomain) {
        WfApprove wFApprove = this.executeWFApprove(wfWFApproveDomain);
        this.wFEngineService.updateWFEngine(wFApprove, wfWFApproveDomain.getNodeSlineCode());
    }

    @Override
    public void executeStartNextWFApprove(String approveCode) {
        WfApprove wfWFApprove = this.getWfWFApprove(approveCode);
        if (wfWFApprove == null) {
            throw new ApiException("wf.WORKFLOW.WFApproveServiceImpl.executeCallbackWFApprove.null", "\u6570\u636e\u4e0d\u5b58\u5728!");
        }
        wfWFApprove.setDataBillstate(WorkflowConstants.APPROVE_STATE_NEXT);
        wfWFApprove.setApproveTime(this.getSysDate());
        wfWFApprove.setDataOpdate(this.getSysDate());
        this.updateDataBillstateApproveModel(wfWFApprove.getApproveId(), WorkflowConstants.APPROVE_STATE_NEXT, WorkflowConstants.APPROVE_STATE_WAIT, null);
        this.wFEngineService.updateWFEngine(wfWFApprove, null);
    }

    @Override
    public List<WfApprove> queryApproveListByBillNo(String instanceOthercode, String instanceOthertype) {
        List<WfInstance> instanceList = this.queryInstanceModelPage(this.getQueryParamMap("instanceOthercode,instanceOthertype,order", new Object[]{instanceOthercode, instanceOthertype, true}));
        if (ListUtil.isEmpty(instanceList)) {
            return null;
        }
        List<WfApprove> wfApproveList = this.queryApproveModelPage(this.getQueryParamMap("instanceCode", new Object[]{instanceList.get(0).getInstanceCode()}));
        return wfApproveList;
    }

    private List<WfInstance> queryInstanceModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFInstanceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFApproveServiceImpl.queryInstanceModel", (Throwable)e);
            return null;
        }
    }
}

