/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.workflow.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.flow.InvokeParamUtil;
import com.yqbsoft.laser.service.esb.core.flow.SoaUtil;
import com.yqbsoft.laser.service.esb.core.flow.UddiUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.core.OutMessage;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.workflow.WorkflowConstants;
import com.yqbsoft.laser.service.workflow.dao.WfApproveMapper;
import com.yqbsoft.laser.service.workflow.dao.WfInstanceMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeSlineMapper;
import com.yqbsoft.laser.service.workflow.dao.WfNodeStepMapper;
import com.yqbsoft.laser.service.workflow.model.WfApprove;
import com.yqbsoft.laser.service.workflow.model.WfInstance;
import com.yqbsoft.laser.service.workflow.model.WfNode;
import com.yqbsoft.laser.service.workflow.model.WfNodeSline;
import com.yqbsoft.laser.service.workflow.model.WfNodeStep;
import com.yqbsoft.laser.service.workflow.service.WFEngineService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WFEngineServiceImpl
extends BaseServiceImpl
implements WFEngineService {
    public static final String SYS_CODE = "wf.WORKFLOW.WFEngineServiceImpl";
    private WfNodeMapper wfWFNodeMapper;
    private WfNodeStepMapper wfWFNodeStepMapper;
    private WfNodeSlineMapper wfWFNodeSlineMapper;
    private WfInstanceMapper wfWFInstanceMapper;
    private WfApproveMapper wfWFApproveMapper;
    private static final String ROLE_CODE_KEY = "roleCode";
    private static final String TENANT_CODE_KEY = "tenantCode";
    private static final String USER_CODE_KEY = "userCode";

    public void setWfWFNodeMapper(WfNodeMapper wfWFNodeMapper) {
        this.wfWFNodeMapper = wfWFNodeMapper;
    }

    public void setWfWFNodeStepMapper(WfNodeStepMapper wfWFNodeStepMapper) {
        this.wfWFNodeStepMapper = wfWFNodeStepMapper;
    }

    public void setWfWFNodeSlineMapper(WfNodeSlineMapper wfWFNodeSlineMapper) {
        this.wfWFNodeSlineMapper = wfWFNodeSlineMapper;
    }

    public void setWfWFInstanceMapper(WfInstanceMapper wfWFInstanceMapper) {
        this.wfWFInstanceMapper = wfWFInstanceMapper;
    }

    public void setWfWFApproveMapper(WfApproveMapper wfWFApproveMapper) {
        this.wfWFApproveMapper = wfWFApproveMapper;
    }

    @Override
    public void insertWFEngine(WfInstance wfInstance) {
        this.updateInstanceState(wfInstance.getInstanceId(), WorkflowConstants.STATE_WAIT_AUDIT, WorkflowConstants.STATE_WAIT_START);
        Integer dataState = 0;
        List<WfNodeStep> wfWFNodeStepList = this.queryWfWFNodeStep(wfInstance.getNodeCode(), wfInstance.getTenantCode(), dataState);
        List<WfNodeSline> wfWFNodeSlineList = this.queryWfWFNodeSline(wfInstance.getNodeCode(), wfInstance.getTenantCode(), dataState);
        WfNodeStep startNodeStep = null;
        if (wfWFNodeStepList == null || wfWFNodeStepList.isEmpty()) {
            wfInstance.setDataState(WorkflowConstants.APPROVE_STATE_PASS);
            this.saveCallBack(wfInstance, null);
        }
        for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
            if (!WorkflowConstants.NODE_STEP_TYPE_0.equals(wfWFNodeStep.getNodeStepType())) continue;
            startNodeStep = wfWFNodeStep;
            break;
        }
        Map<String, Object> objMap = this.getObjectMap(wfInstance);
        this.saveAllWfWFApprove(startNodeStep, wfWFNodeStepList, wfWFNodeSlineList, wfInstance, objMap);
    }

    public Map<String, Object> getObjectMap(WfInstance wfInstance) {
        HashMap<String, Object> objMap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)wfInstance.getDataVcallurl()) && StringUtils.isNotBlank((String)wfInstance.getDataVparam())) {
            Object obj = UddiUtil.invokeUrl((String)wfInstance.getDataVcalltype(), (String)wfInstance.getDataVcallurl(), (String)wfInstance.getDataVparam(), null);
            OutMessage outMessage = null;
            if (obj instanceof OutMessage) {
                outMessage = (OutMessage)obj;
                String json = outMessage.getReObj().toString();
                objMap.put("ReObject", JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class));
            } else {
                objMap.put("ReObject", obj);
            }
        }
        if (StringUtils.isNotBlank((String)wfInstance.getDataSource())) {
            objMap.put("DataSource", JsonUtil.buildNormalBinder().getJsonToObject(wfInstance.getDataSource(), Object.class));
        }
        return objMap;
    }

    private void saveAllWfWFApprove(WfNodeStep wfWFNodeStep, List<WfNodeStep> wfWFNodeStepList, List<WfNodeSline> wfWFNodeSlineList, WfInstance wfInstance, Map<String, Object> objMap) {
        ArrayList<String> approveUserList = null;
        HashMap<String, String> approveUserMap = new HashMap<String, String>();
        ArrayList<WfNodeStep> nextNodeStepList = new ArrayList<WfNodeStep>();
        for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
            if (!wfWFNodeStep.getNodeStepCode().equals(wfWFNodeSline.getNodeFstepCode())) continue;
            String slineCondition = wfWFNodeSline.getSlineCondition();
            String rs = SoaUtil.checkReturn((String)slineCondition, objMap);
            if (!StringUtils.isBlank((String)slineCondition) && !StringUtils.isBlank((String)rs)) continue;
            for (WfNodeStep tempWfWFNodeStep : wfWFNodeStepList) {
                if (!wfWFNodeSline.getNodeTstepCode().equals(tempWfWFNodeStep.getNodeStepCode())) continue;
                nextNodeStepList.add(tempWfWFNodeStep);
            }
        }
        if (ListUtil.isEmpty(nextNodeStepList)) {
            return;
        }
        for (WfNodeStep next : nextNodeStepList) {
            approveUserList = new ArrayList<String>();
            Integer NODE_STEP_TYPE = next.getNodeStepType();
            if (WorkflowConstants.NODE_STEP_TYPE_1.equals(NODE_STEP_TYPE)) {
                approveUserList.add(next.getNodeStepAcode());
                approveUserMap.put(next.getNodeStepAcode(), next.getNodeStepAname());
            } else if (WorkflowConstants.NODE_STEP_TYPE_2.equals(NODE_STEP_TYPE)) {
                if (StringUtils.isBlank((String)next.getGetuserApicode())) {
                    approveUserList.add(next.getNodeStepAcode());
                    approveUserMap.put(next.getNodeStepAcode(), next.getNodeStepAname());
                } else {
                    List userList;
                    ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
                    objMap.put(ROLE_CODE_KEY, next.getNodeStepAcode());
                    objMap.put(TENANT_CODE_KEY, wfInstance.getTenantCode());
                    objMap.put(USER_CODE_KEY, wfInstance.getUserCode());
                    paramMap.put("map", JsonUtil.buildNormalBinder().toJson(objMap));
                    Object object = this.getInternalRouter().inInvoke(next.getGetuserApicode(), "1.0", "0", paramMap);
                    if (object != null && ListUtil.isNotEmpty((Collection)(userList = (List)JsonUtil.buildNormalBinder().getJsonToList(object.toString(), Map.class)))) {
                        for (Map map : userList) {
                            approveUserList.add(map.get(USER_CODE_KEY) == null ? next.getNodeStepAcode() : map.get(USER_CODE_KEY).toString());
                            approveUserMap.put(map.get(USER_CODE_KEY) == null ? next.getNodeStepAcode() : map.get(USER_CODE_KEY).toString(), map.get("userRelname") == null ? next.getNodeStepAname() : map.get("userRelname").toString());
                        }
                    }
                }
            } else if (!WorkflowConstants.NODE_STEP_TYPE_3.equals(NODE_STEP_TYPE) && WorkflowConstants.NODE_STEP_TYPE_4.equals(NODE_STEP_TYPE)) {
                this.saveAllWfWFApprove(next, wfWFNodeStepList, wfWFNodeSlineList, wfInstance, objMap);
            }
            if (WorkflowConstants.NODE_STEP_TYPE_5.equals(NODE_STEP_TYPE)) {
                approveUserList.add(wfInstance.getUserCode());
                approveUserMap.put(wfInstance.getUserCode(), wfInstance.getUserName());
            }
            if (approveUserList == null || approveUserList.isEmpty()) continue;
            for (String approveUser : approveUserList) {
                WfApprove wfWFApprove = new WfApprove();
                this.setDefault(wfInstance, next, wfWFApprove, approveUser, (String)approveUserMap.get(approveUser), wfWFNodeStep);
                boolean saveFlag = this.saveApprove(wfWFApprove);
                if (!saveFlag) continue;
                wfWFApprove = this.getApproveByCode(wfWFApprove);
                this.handlerActiveApprove(wfInstance, next, wfWFApprove, objMap);
            }
            this.saveAllWfWFApprove(next, wfWFNodeStepList, wfWFNodeSlineList, wfInstance, objMap);
        }
    }

    public boolean checkRule(String ruleCode, Map<String, Object> objMap) {
        if (StringUtils.isBlank((String)ruleCode)) {
            return true;
        }
        objMap.put("ruleCode", ruleCode);
        Map<String, Object> reObjMap = this.exeRule(objMap);
        if (MapUtil.isEmpty(reObjMap)) {
            return false;
        }
        int result = (Integer)reObjMap.get("resultNum");
        return result > 0;
    }

    private Map<String, Object> exeRule(Map<String, Object> objMap) {
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(objMap));
        Object json = this.getInternalRouter().inInvoke("wf.ruleengine.execute", "1.0", "0", paramMap);
        if (json == null) {
            return null;
        }
        Map reObjMap = new HashMap();
        reObjMap = json instanceof String ? (Map)JsonUtil.buildNormalBinder().getJsonToMap(json.toString(), String.class, Object.class) : (Map)json;
        return reObjMap;
    }

    private boolean saveApprove(WfApprove wfWFApprove) {
        try {
            List<WfApprove> oldList = this.wfWFApproveMapper.query(this.getQueryParamMap("userAcode,nodeStepCode,nodeCode,instanceCode", new Object[]{wfWFApprove.getUserAcode(), wfWFApprove.getNodeStepCode(), wfWFApprove.getNodeCode(), wfWFApprove.getInstanceCode()}));
            if (ListUtil.isEmpty(oldList)) {
                this.wfWFApproveMapper.insert(wfWFApprove);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveApprove.ex", (Throwable)e);
        }
    }

    private WfApprove getApproveByCode(WfApprove wfWFApprove) {
        return this.wfWFApproveMapper.getByCodeTenant(this.getQueryParamMap("approveCode,tenantCode", new Object[]{wfWFApprove.getApproveCode(), wfWFApprove.getTenantCode()}));
    }

    @Override
    public void updateWFEngine(WfApprove wfApprove, String nodeSlineCode) {
        WfInstance wFInstance;
        if (wfApprove.getDataState().equals(WorkflowConstants.STATE_WAIT_START)) {
            this.updateStateApproveModel(wfApprove.getApproveId(), WorkflowConstants.STATE_WAIT_AUDIT, WorkflowConstants.STATE_WAIT_START);
        } else {
            this.updateApproveModel(wfApprove);
        }
        Integer dataState = 0;
        List<WfNodeSline> wfWFNodeSlineList = this.queryWfWFNodeSline(wfApprove.getNodeCode(), wfApprove.getTenantCode(), dataState);
        List<WfApprove> wfWFApproveList = this.querySystemApprove(this.getQueryParamMap("userCode,nodeCode,instanceCode,nodeStepCode,tenantCode", new Object[]{wfApprove.getUserCode(), wfApprove.getNodeCode(), wfApprove.getInstanceCode(), wfApprove.getNodeStepCode(), wfApprove.getTenantCode()}));
        boolean approveIsEnd = this.checkOhterApproveState(wfApprove, wfWFApproveList);
        if (wfWFApproveList.size() <= 0) {
            approveIsEnd = true;
        } else if (WorkflowConstants.APPROVE_STATE_NEXT.equals(wfApprove.getDataBillstate())) {
            approveIsEnd = true;
        }
        if (approveIsEnd) {
            ArrayList<WfNodeStep> nextNodeStepList = new ArrayList<WfNodeStep>();
            List<WfNodeStep> wfWFNodeStepList = this.queryWfWFNodeStep(wfApprove.getNodeCode(), wfApprove.getTenantCode(), dataState);
            Map<String, WfNodeStep> wfWFNodeStepMap = this.makeWfWFNodeStepMap(wfWFNodeStepList);
            WfNodeStep toNodeStep = null;
            if (StringUtils.isBlank((String)nodeSlineCode)) {
                if (WorkflowConstants.APPROVE_STATE_NOPASS.equals(wfApprove.getDataBillstate())) {
                    WfInstance wfWFInstance = this.getWfWFInstanceByCode(wfApprove.getInstanceCode(), wfApprove.getTenantCode());
                    wfWFInstance.setDataState(WorkflowConstants.APPROVE_STATE_NOPASS);
                    wfWFInstance.setInstanceDate(this.getSysDate());
                    this.updateInstanceModel(wfWFInstance);
                } else if (WorkflowConstants.APPROVE_STATE_NEXT.equals(wfApprove.getDataBillstate())) {
                    WfNodeStep currentWFNodeStep = wfWFNodeStepMap.get(wfApprove.getNodeStepCode());
                    String nodeNextCode = currentWFNodeStep.getNodeNextCode();
                    if (StringUtils.isBlank((String)nodeNextCode)) {
                        throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateWFEngine.nodeNextCode is null");
                    }
                    WfInstance wfWFInstance = this.getWfWFInstanceByCode(wfApprove.getInstanceCode(), wfApprove.getTenantCode());
                    this.saveNextInstance(wfWFInstance, nodeNextCode, wfApprove.getApproveCode());
                    return;
                }
                for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
                    if (!wfWFNodeSline.getNodeFstepCode().equals(wfApprove.getNodeStepCode())) continue;
                    for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
                        if (!wfWFNodeSline.getNodeTstepCode().equals(wfWFNodeStep.getNodeStepCode()) || wfWFNodeSline.getSlineState() != wfApprove.getDataBillstate()) continue;
                        nextNodeStepList.add(wfWFNodeStep);
                    }
                }
            } else {
                for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
                    if (!nodeSlineCode.equals(wfWFNodeSline.getNodeSlineCode())) continue;
                    for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
                        if (!wfWFNodeSline.getNodeTstepCode().equals(wfWFNodeStep.getNodeStepCode())) continue;
                        nextNodeStepList.add(wfWFNodeStep);
                    }
                }
            }
            if (nextNodeStepList == null || nextNodeStepList.isEmpty()) {
                throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateWFEngine.nextNodeStepList is null");
            }
            toNodeStep = (WfNodeStep)nextNodeStepList.get(0);
            Integer NODE_STEP_TYPE = toNodeStep.getNodeStepType();
            WfInstance wfWFInstance = this.getWfWFInstanceByCode(wfApprove.getInstanceCode(), wfApprove.getTenantCode());
            if (WorkflowConstants.NODE_STEP_TYPE_3.equals(NODE_STEP_TYPE)) {
                this.executeNodeStep3(wfWFApproveList, wfWFInstance);
            } else if (WorkflowConstants.NODE_STEP_TYPE_4.equals(NODE_STEP_TYPE)) {
                this.executeNodeStep4(wfApprove, wfWFNodeSlineList, wfWFApproveList, wfWFNodeStepList, toNodeStep, wfWFInstance, dataState);
            } else {
                this.executeNextNodeStep(wfApprove, wfWFNodeSlineList, nextNodeStepList, wfWFNodeStepList, wfWFInstance, dataState);
            }
        }
        if (null == (wFInstance = this.wfWFInstanceMapper.getByCode(this.getQueryParamMap("instanceCode,tenantCode", new Object[]{wfApprove.getInstanceCode(), wfApprove.getTenantCode()})))) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveCallBack.null", "\u914d\u7f6e\u6d41\u7a0b\u6587\u4ef6\u5f02\u5e38");
        }
        this.saveCallBack(wFInstance, wfApprove);
    }

    private void executeNodeStep3(List<WfApprove> wfWFApproveList, WfInstance wfWFInstance) {
        boolean approveState = true;
        for (WfApprove approveObj : wfWFApproveList) {
            if (!WorkflowConstants.APPROVE_STATE_NOPASS.equals(approveObj.getDataBillstate())) continue;
            approveState = false;
        }
        if (approveState) {
            wfWFInstance.setDataState(WorkflowConstants.APPROVE_STATE_PASS);
        } else {
            wfWFInstance.setDataState(WorkflowConstants.APPROVE_STATE_NOPASS);
        }
        wfWFInstance.setInstanceDate(this.getSysDate());
        this.updateInstanceModel(wfWFInstance);
    }

    private void executeNodeStep4(WfApprove wfApprove, List<WfNodeSline> wfWFNodeSlineList, List<WfApprove> wfWFApproveList, List<WfNodeStep> wfWFNodeStepList, WfNodeStep toNodeStep, WfInstance wfWFInstance, Integer dataState) {
        ArrayList<WfNodeStep> nextNodeStepList = new ArrayList<WfNodeStep>();
        Map<String, Object> objMap = this.makeObjAndApproveMap(wfApprove, wfWFInstance);
        if (StringUtils.isBlank((String)toNodeStep.getNodeSubmitRule())) {
            boolean approveIsEnd;
            List<WfApprove> afterWfWFApproveList;
            List<WfApprove> levelWfWFApproveList;
            if (StringUtils.isNotBlank((String)wfApprove.getNodeUpStepCode()) && ListUtil.isNotEmpty(levelWfWFApproveList = this.querySystemApprove(this.getQueryParamMap("nodeCode,instanceCode,nodeUpStepCode,tenantCode", new Object[]{wfApprove.getNodeCode(), wfApprove.getInstanceCode(), wfApprove.getNodeUpStepCode(), wfApprove.getTenantCode()})))) {
                wfWFApproveList.addAll(levelWfWFApproveList);
            }
            if (ListUtil.isNotEmpty(afterWfWFApproveList = this.getNextStepAfterApproveList(wfApprove, wfWFNodeSlineList))) {
                wfWFApproveList.addAll(afterWfWFApproveList);
            }
            if (approveIsEnd = this.checkOhterApproveState(wfApprove, wfWFApproveList)) {
                this.executeDirectNextNode(wfApprove, wfWFNodeSlineList, wfWFNodeStepList, toNodeStep, wfWFInstance, nextNodeStepList, dataState);
            }
        } else {
            boolean checkFlag = this.checkRule(toNodeStep.getNodeSubmitRule(), objMap);
            if (checkFlag) {
                this.executeDirectNextNode(wfApprove, wfWFNodeSlineList, wfWFNodeStepList, toNodeStep, wfWFInstance, nextNodeStepList, dataState);
            }
        }
    }

    private void executeDirectNextNode(WfApprove wfApprove, List<WfNodeSline> wfWFNodeSlineList, List<WfNodeStep> wfWFNodeStepList, WfNodeStep toNodeStep, WfInstance wfWFInstance, List<WfNodeStep> nextNodeStepList, Integer dataState) {
        this.addNextNodeStepListBy4(wfApprove, wfWFNodeSlineList, wfWFNodeStepList, toNodeStep, nextNodeStepList);
        ArrayList<WfApprove> wfWFApproveList = new ArrayList<WfApprove>();
        wfWFApproveList.add(wfApprove);
        toNodeStep = nextNodeStepList.get(0);
        if (WorkflowConstants.NODE_STEP_TYPE_3.equals(toNodeStep.getNodeStepType())) {
            this.executeNodeStep3(wfWFApproveList, wfWFInstance);
        } else {
            this.executeNextNodeStep(wfApprove, wfWFNodeSlineList, nextNodeStepList, wfWFNodeStepList, wfWFInstance, dataState);
        }
    }

    private void addNextNodeStepListBy4(WfApprove wfApprove, List<WfNodeSline> wfWFNodeSlineList, List<WfNodeStep> wfWFNodeStepList, WfNodeStep toNodeStep, List<WfNodeStep> nextNodeStepList) {
        for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
            if (!wfWFNodeSline.getNodeFstepCode().equals(toNodeStep.getNodeStepCode())) continue;
            for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
                if (!wfWFNodeSline.getNodeTstepCode().equals(wfWFNodeStep.getNodeStepCode()) || wfWFNodeSline.getSlineState() != wfApprove.getDataBillstate()) continue;
                nextNodeStepList.add(wfWFNodeStep);
            }
        }
    }

    private boolean checkOhterApproveState(WfApprove wfApprove, List<WfApprove> wfWFApproveList) {
        for (WfApprove approveObj : wfWFApproveList) {
            if (!WorkflowConstants.APPROVE_STATE_WAIT.equals(approveObj.getDataBillstate()) && !WorkflowConstants.APPROVE_STATE_NEXT.equals(approveObj.getDataBillstate()) && !WorkflowConstants.APPROVE_STATE_NEW.equals(approveObj.getDataBillstate()) || approveObj.getApproveCode().equals(wfApprove.getApproveCode())) continue;
            return false;
        }
        return true;
    }

    private void executeNextNodeStep(WfApprove wfApprove, List<WfNodeSline> wfWFNodeSlineList, List<WfNodeStep> nextNodeStepList, List<WfNodeStep> wfWFNodeStepList, WfInstance wfWFInstance, Integer dataState) {
        for (WfNodeStep nextNodeStep : nextNodeStepList) {
            List<WfApprove> nextWfWFApproveList = this.querySystemApprove(this.getQueryParamMap("nodeCode,instanceCode,nodeStepCode,tenantCode", new Object[]{wfApprove.getNodeCode(), wfApprove.getInstanceCode(), nextNodeStep.getNodeStepCode(), wfApprove.getTenantCode()}));
            if (ListUtil.isEmpty(nextWfWFApproveList)) {
                WfNodeStep currentNodeStep = this.getWfWFNodeStep(wfApprove.getNodeStepCode(), wfApprove.getTenantCode(), dataState);
                Map<String, Object> objMap = this.getObjectMap(wfWFInstance);
                this.saveAllWfWFApprove(currentNodeStep, wfWFNodeStepList, wfWFNodeSlineList, wfWFInstance, objMap);
                nextWfWFApproveList = this.querySystemApprove(this.getQueryParamMap("nodeCode,instanceCode,nodeStepCode,tenantCode", new Object[]{wfApprove.getNodeCode(), wfApprove.getInstanceCode(), nextNodeStep.getNodeStepCode(), wfApprove.getTenantCode()}));
            }
            for (WfApprove wfWFApprove : nextWfWFApproveList) {
                this.setDefault(wfWFApprove);
                this.updateApproveModel(wfWFApprove);
                this.handlerActiveApprove(wfWFInstance, nextNodeStep, wfWFApprove, null);
            }
        }
    }

    private Map<String, Object> makeObjAndApproveMap(WfApprove wfApprove, WfInstance wfWFInstance) {
        Map objMap = this.getObjectMap(wfWFInstance);
        Map approveMap = MapUtil.castMapByObject((Object)wfApprove);
        if (objMap == null) {
            objMap = approveMap;
        } else {
            objMap.putAll(approveMap);
        }
        return objMap;
    }

    public void handlerActiveApprove(WfInstance wfWFInstance, WfNodeStep nextNodeStep, WfApprove wfWFApprove, Map<String, Object> objMap) {
        if (MapUtil.isEmpty(objMap)) {
            objMap = this.getObjectMap(wfWFInstance);
        }
        if ("1".equals(nextNodeStep.getNodeBeginType()) && this.checkRule(nextNodeStep.getNodeBeginRule(), objMap)) {
            if (StringUtils.isNotBlank((String)nextNodeStep.getNodeNextCode())) {
                wfWFApprove.setDataBillstate(WorkflowConstants.APPROVE_STATE_NEXT);
            } else {
                wfWFApprove.setDataBillstate(WorkflowConstants.APPROVE_STATE_PASS);
                wfWFApprove.setApproveState("1");
                wfWFApprove.setApproveRemark("system execute");
                wfWFApprove.setApproveTime(this.getSysDate());
                wfWFApprove.setDataOpdate(this.getSysDate());
            }
            this.updateWFEngine(wfWFApprove, null);
        }
        if (WorkflowConstants.APPROVE_STATE_WAIT.equals(wfWFApprove.getDataBillstate())) {
            String receiverCode = wfWFApprove.getUserAcode();
            String receiverName = wfWFApprove.getUserAname();
            String senderCode = wfWFApprove.getUserCode();
            String senderName = wfWFApprove.getUserName();
            String subject = wfWFApprove.getNodeStepName();
            this.sendMsg(wfWFApprove, objMap, receiverCode, receiverName, senderCode, senderName, subject);
        }
    }

    @Override
    public void sendMsg(WfApprove wfWFApprove, Map<String, Object> objMap, String receiverCode, String receiverName, String senderCode, String senderName, String subject) {
        if (StringUtils.isBlank((String)wfWFApprove.getMnschannelCode()) || StringUtils.isBlank((String)wfWFApprove.getMnstemplateCode())) {
            return;
        }
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("manualmsgCode", wfWFApprove.getApproveCode());
        map.put("mnslistSubject", subject);
        map.put(TENANT_CODE_KEY, wfWFApprove.getTenantCode());
        if (MapUtil.isNotEmpty(objMap)) {
            map.putAll(objMap);
        }
        this.assembleImsg(wfWFApprove, map, receiverCode, receiverName, senderCode, senderName);
        paramMap.put("mnschannelCode", wfWFApprove.getMnschannelCode());
        paramMap.put("mnstemplateCode", wfWFApprove.getMnstemplateCode());
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        paramMap.put("sendflag", "true");
        this.getInternalRouter().inInvoke("mns.mns.saveMnslistByCode", "1.0", "0", paramMap);
    }

    private void assembleImsg(WfApprove wfWFApprove, Map<String, Object> map, String receiverCode, String receiverName, String senderCode, String senderName) {
        String mnslistBusType = "10";
        String pushmsgType = "0";
        String pushmsgJpushType = "0";
        this.assembleImsg(receiverCode, receiverName, senderCode, senderName, mnslistBusType, pushmsgType, pushmsgJpushType, map, wfWFApprove);
    }

    private void assembleImsg(String receiverCode, String receiverName, String senderCode, String senderName, String mnslistBusType, String pushmsgType, String pushmsgJpushType, Map<String, Object> map, WfApprove wfWFApprove) {
        map.put("mnslistBusType", mnslistBusType);
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("code", receiverCode);
        tempMap.put("name", receiverName);
        receiverList.add(tempMap);
        map.put("receiverList", JsonUtil.buildNormalBinder().toJson(receiverList));
        tempMap.clear();
        tempMap.put("code", senderCode);
        tempMap.put("name", senderName);
        map.put("sender", JsonUtil.buildNormalBinder().toJson(tempMap));
        map.put("pushmsgType", pushmsgType);
        map.put("pushmsgSenddate", DateUtils.getDateStr((String)"yyyy-MM-dd HH:mm:ss"));
        map.put("pushmsgJpushType", pushmsgJpushType);
        tempMap.clear();
        tempMap.put("flowType", wfWFApprove.getNodeName());
        tempMap.put("nodeName", wfWFApprove.getNodeName());
        if (map != null && map.get("DataSource") != null) {
            Map dataSourceMap = (Map)map.get("DataSource");
            if (dataSourceMap.get("redirectMark") != null && "transactionAudit".equals(dataSourceMap.get("redirectMark"))) {
                tempMap.put("type", (String)dataSourceMap.get("type"));
                tempMap.put("code", (String)dataSourceMap.get("code"));
                tempMap.put("redirectMark", (String)dataSourceMap.get("redirectMark"));
                tempMap.put("url", (String)dataSourceMap.get("url"));
                map.put("DataSource", "");
            } else {
                map.put("DataSource", JsonUtil.buildNormalBinder().toJson(map.get("DataSource")));
            }
        }
        map.put("dataBillstate", wfWFApprove.getDataBillstate());
        map.put("approveId", wfWFApprove.getApproveId());
        map.put("paramMap", JsonUtil.buildNormalBinder().toJson(tempMap));
    }

    private void saveCallBack(WfInstance wFInstance, WfApprove wFApprove) {
        if (null == wFInstance) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveCallBack.null", "\u914d\u7f6e\u6d41\u7a0b\u6587\u4ef6\u5f02\u5e38");
        }
        if (!WorkflowConstants.NODE_STEP_TYPE_0.equals(wFInstance.getDataState()) && wFInstance.getDataState() != null) {
            String paramStr;
            InvokeParamUtil invokeParamUtil = new InvokeParamUtil();
            if (WorkflowConstants.APPROVE_STATE_PASS.equals(wFInstance.getDataState())) {
                if (StringUtils.isNotBlank((String)wFInstance.getDataParam())) {
                    paramStr = SoaUtil.transferParam((String)wFInstance.getDataParam());
                    invokeParamUtil.setDataParam(paramStr);
                }
                invokeParamUtil.setDataUrl(wFInstance.getDataCallurl());
                invokeParamUtil.setDataType(wFInstance.getDataCalltype());
                invokeParamUtil.setDataSueccs(wFInstance.getDataFlag());
            } else if (WorkflowConstants.APPROVE_STATE_NOPASS.equals(wFInstance.getDataState())) {
                if (StringUtils.isNotBlank((String)wFInstance.getDataFparam())) {
                    paramStr = SoaUtil.transferParam((String)wFInstance.getDataFparam());
                    invokeParamUtil.setDataParam(this.changeFParam(paramStr, wFApprove));
                }
                invokeParamUtil.setDataUrl(wFInstance.getDataFcallurl());
                invokeParamUtil.setDataType(wFInstance.getDataFcalltype());
                invokeParamUtil.setDataSueccs(wFInstance.getDataFflag());
            }
            if (StringUtils.isBlank((String)invokeParamUtil.getDataUrl()) || StringUtils.isBlank((String)invokeParamUtil.getDataParam())) {
                return;
            }
            try {
                boolean flag;
                String opBillcode;
                if (wFApprove != null && StringUtils.isNotBlank((String)(opBillcode = wFApprove.getOpBillcode()))) {
                    DisUtil.setJson((String)(opBillcode + wFApprove.getNodeCode()), (Object)JsonUtil.buildNonNullBinder().toJson((Object)wFApprove), (int)60);
                }
                Object reObject = UddiUtil.invokeUrl((InvokeParamUtil)invokeParamUtil);
                if (StringUtils.isNotBlank((String)invokeParamUtil.getDataSueccs()) && !(flag = UddiUtil.checkSucess((Object)reObject, (String)invokeParamUtil.getDataSueccs(), (String)invokeParamUtil.getDataCharset()))) {
                    throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveCallBack.ex", "\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38\uff01");
                }
                Map<String, Object> objMap = this.getObjectMap(wFInstance);
                if (wFApprove == null) {
                    return;
                }
                String receiverCode = wFApprove.getUserAcode();
                String receiverName = wFApprove.getUserAname();
                String senderCode = wFApprove.getUserCode();
                String senderName = wFApprove.getUserName();
                String subject = wFApprove.getNodeName();
                this.sendMsg(wFApprove, objMap, senderCode, senderName, receiverCode, receiverName, subject);
            }
            catch (Exception e) {
                throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveCallBack.ex", "\u56de\u8c03\u4e1a\u52a1\u7cfb\u7edf\u5f02\u5e38\uff01");
            }
        }
    }

    public String changeFParam(String fParam, WfApprove wFApprove) {
        if (StringUtils.isEmpty((String)fParam) || null == wFApprove || StringUtils.isEmpty((String)wFApprove.getApproveRemark())) {
            return fParam;
        }
        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(fParam, String.class, Object.class);
        if (!MapUtil.isEmpty((Map)map) && map.containsKey("refuseInfo")) {
            map.put("refuseInfo", wFApprove.getApproveRemark());
        }
        return JsonUtil.buildNormalBinder().toJson((Object)map);
    }

    public List<WfNodeStep> queryWfWFNodeStep(String nodeCode, String tenantCode, Integer dataState) {
        List<WfNodeStep> list = this.wfWFNodeStepMapper.query(this.getQueryParamMap("nodeCode,tenantCode,dataState", new Object[]{nodeCode, tenantCode, dataState}));
        return list;
    }

    public WfNodeStep getWfWFNodeStep(String nodeStepCode, String tenantCode, Integer dataState) {
        try {
            return this.wfWFNodeStepMapper.selectByCodeAndTenant(this.getQueryParamMap("nodeStepCode,tenantCode,dataState", new Object[]{nodeStepCode, tenantCode, dataState}));
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    public List<WfNodeSline> queryWfWFNodeSline(String nodeCode, String tenantCode, Integer dataState) {
        List<WfNodeSline> list = this.wfWFNodeSlineMapper.query(this.getQueryParamMap("nodeCode,tenantCode,dataState", new Object[]{nodeCode, tenantCode, dataState}));
        return list;
    }

    public WfInstance getWfWFInstanceByCode(String instanceCode, String tenantCode) {
        try {
            return this.wfWFInstanceMapper.getByCode(this.getQueryParamMap("instanceCode,tenantCode", new Object[]{instanceCode, tenantCode}));
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    public List<WfApprove> querySystemApprove(String nodeCode, String instanceCode, String nodeStepCode) {
        List<WfApprove> list = this.wfWFApproveMapper.query(this.getQueryParamMap("nodeCode,instanceCode,nodeStepCode", new Object[]{nodeCode, instanceCode, nodeStepCode}));
        return list;
    }

    public List<WfApprove> querySystemApprove(Map<String, Object> param) {
        List<WfApprove> list = this.wfWFApproveMapper.query(param);
        return list;
    }

    private void setDefault(WfApprove wfWFApprove) {
        if (wfWFApprove == null) {
            return;
        }
        wfWFApprove.setApproveTime(this.getSysDate());
        wfWFApprove.setDataState(WorkflowConstants.APPROVE_STATE_WAIT);
        wfWFApprove.setDataBillstate(WorkflowConstants.STATE_WAIT_AUDIT);
    }

    private void setDefault(WfInstance wfWFInstance, WfNodeStep wfWFNodeStep, WfApprove wfWFApprove, String userAcode, String userAname, WfNodeStep upWfWFNodeStep) {
        if (wfWFApprove == null) {
            return;
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)wfWFApprove, (Object)wfWFNodeStep);
        }
        catch (Exception e) {
            // empty catch block
        }
        wfWFApprove.setApproveIsRead(0);
        wfWFApprove.setNodeCode(wfWFInstance.getNodeCode());
        wfWFApprove.setNodeName(wfWFInstance.getNodeName());
        wfWFApprove.setOpBillcode(wfWFInstance.getInstanceOthercode());
        wfWFApprove.setOpBillcode2(wfWFInstance.getInstanceOthercode2());
        wfWFApprove.setNodeVersion(wfWFInstance.getNodeVersion());
        wfWFApprove.setNodeStepCode(wfWFNodeStep.getNodeStepCode());
        wfWFApprove.setNodeStepName(wfWFNodeStep.getNodeStepName());
        wfWFApprove.setInstanceCode(wfWFInstance.getInstanceCode());
        wfWFApprove.setInstanceState(0);
        wfWFApprove.setApproveType(wfWFNodeStep.getNodeStepType().toString());
        wfWFApprove.setApproveState("0");
        wfWFApprove.setDataState(0);
        wfWFApprove.setNodeUpStepCode(upWfWFNodeStep.getNodeStepCode());
        wfWFApprove.setTenantCode(wfWFInstance.getTenantCode());
        if (WorkflowConstants.NODE_STEP_TYPE_0.equals(upWfWFNodeStep.getNodeStepType())) {
            wfWFApprove.setDataBillstate(0);
        } else {
            wfWFApprove.setDataBillstate(3);
        }
        wfWFApprove.setUserCode(wfWFInstance.getUserCode());
        wfWFApprove.setUserName(wfWFInstance.getUserName());
        wfWFApprove.setUserAcode(userAcode);
        wfWFApprove.setUserAname(userAname);
        if (StringUtils.isBlank((String)wfWFApprove.getApproveCode())) {
            int code = this.getMaxCode();
            wfWFApprove.setApproveCode(this.makeMaxCode8(++code));
        }
        wfWFApprove.setApproveTime(this.getSysDate());
        wfWFApprove.setGmtCreate(this.getSysDate());
        wfWFApprove.setGmtModified(wfWFApprove.getGmtCreate());
    }

    private int getMaxCode() {
        int code = 0;
        try {
            return this.wfWFApproveMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFEngineServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private Date getSysDate() {
        Date date = null;
        try {
            date = this.wfWFApproveMapper.selectSysDate();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return date;
    }

    public void updateInstanceState(Integer instanceId, Integer instanceState, Integer oldInstanceState) throws ApiException {
        this.updateStateInstanceModel(instanceId, instanceState, oldInstanceState);
    }

    private void updateStateInstanceModel(Integer instanceId, Integer instanceState, Integer oldInstanceState) throws ApiException {
        if (null == instanceId || null == instanceState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceId", instanceId);
        map.put("instanceState", instanceState);
        map.put("oldInstanceState", oldInstanceState);
        int i = 0;
        try {
            i = this.wfWFInstanceMapper.updateInstanceStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateStateInstanceModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateStateInstanceModel.null");
        }
    }

    private void saveNextInstance(WfInstance wfWFInstance, String nodeNextCode, String approveCode) {
        WfInstance nextWfWFInstance = this.makeNextWfWFInstance(wfWFInstance);
        nextWfWFInstance.setNodeCode(nodeNextCode);
        nextWfWFInstance.setInstanceOthertype("nextnode");
        nextWfWFInstance.setInstanceOthercode(approveCode);
        this.setNextInstanceValue(nextWfWFInstance);
        this.setInstanceDefault(nextWfWFInstance);
        this.saveInstanceModel(nextWfWFInstance);
        this.insertWFEngine(nextWfWFInstance);
    }

    public void setNextInstanceValue(WfInstance nextWfWFInstance) {
        WfNode wfWFNode = this.getWfWFNode(nextWfWFInstance.getNodeCode());
        nextWfWFInstance.setInstanceCode(null);
        nextWfWFInstance.setDataCalltype("SPRING");
        nextWfWFInstance.setDataCallurl("wf.workflow.executeCallbackWFApprove");
        nextWfWFInstance.setDataParam("{\"approveCode\":\"" + nextWfWFInstance.getInstanceOthercode() + "\"}");
        nextWfWFInstance.setNodeName(wfWFNode.getNodeTitle());
    }

    private WfInstance makeNextWfWFInstance(WfInstance wfWFInstance) {
        WfInstance nextWfWFInstance = new WfInstance();
        try {
            BeanUtils.copyAllPropertys((Object)nextWfWFInstance, (Object)wfWFInstance);
            nextWfWFInstance.setInstanceId(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return nextWfWFInstance;
    }

    private Map<String, WfNodeStep> makeWfWFNodeStepMap(List<WfNodeStep> wfWFNodeStepList) {
        if (ListUtil.isEmpty(wfWFNodeStepList)) {
            return null;
        }
        HashMap<String, WfNodeStep> map = new HashMap<String, WfNodeStep>();
        for (WfNodeStep wfWFNodeStep : wfWFNodeStepList) {
            map.put(wfWFNodeStep.getNodeStepCode(), wfWFNodeStep);
        }
        return map;
    }

    private void setInstanceDefault(WfInstance wfWFInstance) {
        if (null == wfWFInstance) {
            return;
        }
        if (null == wfWFInstance.getDataState()) {
            wfWFInstance.setDataState(0);
        }
        if (null == wfWFInstance.getGmtCreate()) {
            wfWFInstance.setGmtCreate(this.getSysDate());
        }
        if (null == wfWFInstance.getInstanceDate()) {
            wfWFInstance.setInstanceDate(this.getSysDate());
        }
        wfWFInstance.setInstanceState(WorkflowConstants.STATE_WAIT_START);
        wfWFInstance.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wfWFInstance.getInstanceCode())) {
            int code = this.getWFInstancMaxCode();
            wfWFInstance.setInstanceCode(this.makeMaxCode8(++code));
        }
    }

    private int getWFInstancMaxCode() {
        int code = 0;
        try {
            return this.wfWFInstanceMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFEngineServiceImpl.getMaxCode", (Throwable)e);
            return code;
        }
    }

    private void saveInstanceModel(WfInstance wfWFInstance) throws ApiException {
        if (null == wfWFInstance) {
            return;
        }
        try {
            this.wfWFInstanceMapper.insert(wfWFInstance);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.saveInstanceModel.ex");
        }
    }

    private WfNode getWfWFNode(String nodeCode) {
        try {
            return this.wfWFNodeMapper.selectByCode(nodeCode);
        }
        catch (Exception e) {
            this.logger.info("wf.WORKFLOW.WFEngineServiceImpl.getMaxCode", (Object)e);
            return null;
        }
    }

    private List<WfApprove> getNextStepAfterApproveList(WfApprove wfApprove, List<WfNodeSline> wfWFNodeSlineList) {
        String cnodeStepCode = wfApprove.getNodeStepCode();
        String nnodeStepCode = null;
        ArrayList<String> afterStepNodeCodes = new ArrayList<String>();
        ArrayList<WfApprove> afterApproveList = new ArrayList<WfApprove>();
        for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
            if (!wfWFNodeSline.getNodeFstepCode().equals(cnodeStepCode)) continue;
            nnodeStepCode = wfWFNodeSline.getNodeTstepCode();
            break;
        }
        for (WfNodeSline wfWFNodeSline : wfWFNodeSlineList) {
            if (!wfWFNodeSline.getNodeTstepCode().equals(nnodeStepCode)) continue;
            afterStepNodeCodes.add(wfWFNodeSline.getNodeFstepCode());
        }
        for (String nodeStepCode : afterStepNodeCodes) {
            List<WfApprove> wfWFApproveList = this.querySystemApprove(this.getQueryParamMap("nodeCode,instanceCode,nodeStepCode,tenantCode", new Object[]{wfApprove.getNodeCode(), wfApprove.getInstanceCode(), nodeStepCode, wfApprove.getTenantCode()}));
            if (!ListUtil.isNotEmpty(wfWFApproveList)) continue;
            afterApproveList.addAll(wfWFApproveList);
        }
        return afterApproveList;
    }

    @Override
    public void executeUserBinding(String approveCode, String userCode, String userName) {
        WfApprove wfWFApprove = this.getWfWFApprove(approveCode);
        wfWFApprove.setUserAcode(userCode);
        wfWFApprove.setUserAname(userName);
        wfWFApprove.setApproveType(WorkflowConstants.NODE_STEP_TYPE_1.toString());
        wfWFApprove.setApproveIsRead(1);
        this.updateApproveModel(wfWFApprove);
        WfInstance wfWFInstance = this.getWfWFInstanceByCode(wfWFApprove.getInstanceCode(), wfWFApprove.getTenantCode());
        Map<String, Object> objMap = this.getObjectMap(wfWFInstance);
        String receiverCode = wfWFApprove.getUserAcode();
        String receiverName = wfWFApprove.getUserAname();
        String senderCode = wfWFApprove.getUserCode();
        String senderName = wfWFApprove.getUserName();
        String subject = wfWFApprove.getNodeStepName();
        this.sendMsg(wfWFApprove, objMap, receiverCode, receiverName, senderCode, senderName, subject);
    }

    private WfApprove getWfWFApprove(String approveCode) {
        try {
            return this.wfWFApproveMapper.selectByCode(approveCode);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private void updateApproveModel(WfApprove wfWFApprove) throws ApiException {
        if (null == wfWFApprove) {
            return;
        }
        try {
            this.wfWFApproveMapper.updateByPrimaryKeySelective(wfWFApprove);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateApproveModel.ex");
        }
    }

    private void updateStateApproveModel(Integer approveId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == approveId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("approveId", approveId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wfWFApproveMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateStateApproveModel.ex");
        }
        if (i <= 0) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateStateApproveModel.null");
        }
    }

    private void updateInstanceModel(WfInstance wfWFInstance) throws ApiException {
        if (null == wfWFInstance) {
            return;
        }
        try {
            this.wfWFInstanceMapper.updateByPrimaryKeySelective(wfWFInstance);
        }
        catch (Exception e) {
            throw new ApiException("wf.WORKFLOW.WFEngineServiceImpl.updateInstanceModel.ex");
        }
    }

    @Override
    public Map<String, String> getViewCodeAndOtherCode(String approveCode, Map<String, Object> map) {
        WfApprove wfWFApprove = this.getWfWFApprove(approveCode);
        if (wfWFApprove == null) {
            return null;
        }
        HashMap<String, String> remap = new HashMap<String, String>();
        WfInstance wfWFInstance = this.getWfWFInstanceByCode(wfWFApprove.getInstanceCode(), wfWFApprove.getTenantCode());
        if ("nextnode".equals(wfWFInstance.getInstanceOthertype())) {
            WfApprove upWfWFApprove = this.getWfWFApprove(wfWFInstance.getInstanceOthercode());
            wfWFInstance = this.getWfWFInstanceByCode(upWfWFApprove.getInstanceCode(), upWfWFApprove.getTenantCode());
        }
        if (MapUtil.isEmpty(map)) {
            map = new HashMap<String, Object>();
        }
        Map<String, Object> objMap = this.makeObjAndApproveMap(wfWFApprove, wfWFInstance);
        objMap.put("ruleCode", wfWFApprove.getNodeViewRule());
        map.putAll(objMap);
        Map<String, Object> reObjMap = this.exeRule(map);
        if (MapUtil.isNotEmpty(reObjMap)) {
            remap.put("dataViewCode", reObjMap.get("dataViewCode") == null ? wfWFApprove.getNodeViewRule() : reObjMap.get("dataViewCode").toString());
        }
        remap.put("instanceOthercode", wfWFInstance.getInstanceOthercode());
        remap.put("instanceOthertype", wfWFInstance.getInstanceOthertype());
        remap.put("nodeStepName", wfWFApprove.getNodeStepName());
        return remap;
    }

    @Override
    public Map<String, Object> getObjectMapByInstanceCode(String instanceCode, String tenantCode) {
        if (StringUtils.isBlank((String)instanceCode)) {
            return null;
        }
        WfInstance wfWFInstance = this.getWfWFInstanceByCode(instanceCode, tenantCode);
        return this.getObjectMap(wfWFInstance);
    }

    private List<WfInstance> queryInstanceModelPage(Map<String, Object> parammap) {
        try {
            return this.wfWFInstanceMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wf.WORKFLOW.WFEngineServiceImpl.queryInstanceModel", (Throwable)e);
            return null;
        }
    }

    @Override
    public List<WfApprove> queryNextApproveListByCode(String instanceOthercode, String instanceOthertype) {
        List<WfInstance> wfInstances = this.queryInstanceModelPage(this.getQueryParamMap("instanceOthercode,instanceOthertype", new Object[]{instanceOthercode, instanceOthertype}));
        if (ListUtil.isEmpty(wfInstances)) {
            return null;
        }
        WfInstance wfWFInstance = wfInstances.get(0);
        List<WfApprove> approveList = this.querySystemApprove(this.getQueryParamMap("instanceCode", new Object[]{wfWFInstance.getInstanceCode()}));
        if (ListUtil.isEmpty(approveList)) {
            return null;
        }
        ArrayList<WfApprove> reApproveList = new ArrayList<WfApprove>();
        Map<String, Object> objMap = this.getObjectMap(wfWFInstance);
        for (WfApprove wfWFApprove : approveList) {
            if (StringUtils.isBlank((String)wfWFApprove.getNodeNextCode()) || wfWFApprove.getDataBillstate().equals(WorkflowConstants.APPROVE_STATE_PASS) || wfWFApprove.getDataBillstate().equals(WorkflowConstants.APPROVE_STATE_NOPASS) || wfWFApprove.getDataBillstate().equals(WorkflowConstants.APPROVE_STATE_NEXT) || !StringUtils.isBlank((String)wfWFApprove.getNodeBeginRuleFlag()) && !"0".equals(wfWFApprove.getNodeBeginRuleFlag())) continue;
            if (StringUtils.isNotBlank((String)wfWFApprove.getNodeBeginRule())) {
                objMap.put("ruleCode", wfWFApprove.getNodeBeginRule());
                Map<String, Object> reMap = this.exeRule(objMap);
                int result = (Integer)reMap.get("resultNum");
                if (result <= 0) continue;
                reApproveList.add(wfWFApprove);
                continue;
            }
            reApproveList.add(wfWFApprove);
        }
        return reApproveList;
    }
}

