/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.workteam.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.workteam.dao.WtTeamProjMapper;
import com.yqbsoft.laser.service.workteam.domain.WtTeamProjDomain;
import com.yqbsoft.laser.service.workteam.model.WtTeamProj;
import com.yqbsoft.laser.service.workteam.service.WtTeamProjService;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WtTeamProjServiceImpl
extends BaseServiceImpl
implements WtTeamProjService {
    private static final String SYS_CODE = "wt.team.WtTeamProjServiceImpl";
    private WtTeamProjMapper wtTeamProjMapper;

    public void setWtTeamProjMapper(WtTeamProjMapper wtTeamProjMapper) {
        this.wtTeamProjMapper = wtTeamProjMapper;
    }

    private Date getSysDate() {
        try {
            return this.wtTeamProjMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkTeamProj(WtTeamProjDomain wtTeamProjDomain) {
        if (null == wtTeamProjDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)wtTeamProjDomain.getTeamProjName())) {
            msg = msg + "TeamProjName\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)wtTeamProjDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setTeamProjDefault(WtTeamProj wtTeamProj) {
        if (null == wtTeamProj) {
            return;
        }
        if (null == wtTeamProj.getDataState()) {
            wtTeamProj.setDataState(0);
        }
        if (null == wtTeamProj.getGmtCreate()) {
            wtTeamProj.setGmtCreate(this.getSysDate());
        }
        wtTeamProj.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)wtTeamProj.getTeamProjCode())) {
            wtTeamProj.setTeamProjCode(this.createUUIDString());
        }
    }

    private int getTeamProjMaxCode() {
        int code = 0;
        try {
            return this.wtTeamProjMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.getTeamProjMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setTeamProjUpdataDefault(WtTeamProj wtTeamProj) {
        if (null == wtTeamProj) {
            return;
        }
        wtTeamProj.setGmtModified(this.getSysDate());
    }

    private void saveTeamProjModel(WtTeamProj wtTeamProj) throws ApiException {
        if (null == wtTeamProj) {
            return;
        }
        try {
            this.wtTeamProjMapper.insert(wtTeamProj);
        }
        catch (Exception e) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.saveTeamProjModel.ex", (Throwable)e);
        }
    }

    private WtTeamProj getTeamProjModelById(Integer teamProjId) {
        if (null == teamProjId) {
            return null;
        }
        try {
            return this.wtTeamProjMapper.selectByPrimaryKey(teamProjId);
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.getTeamProjModelById", (Throwable)e);
            return null;
        }
    }

    public WtTeamProj getTeamProjModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.wtTeamProjMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.getTeamProjModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delTeamProjModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.wtTeamProjMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.delTeamProjModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.delTeamProjModelByCode.num");
        }
    }

    private void deleteTeamProjModel(Integer teamProjId) throws ApiException {
        if (null == teamProjId) {
            return;
        }
        int i = 0;
        try {
            i = this.wtTeamProjMapper.deleteByPrimaryKey(teamProjId);
        }
        catch (Exception e) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.deleteTeamProjModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.deleteTeamProjModel.num");
        }
    }

    private void updateTeamProjModel(WtTeamProj wtTeamProj) throws ApiException {
        if (null == wtTeamProj) {
            return;
        }
        try {
            this.wtTeamProjMapper.updateByPrimaryKeySelective(wtTeamProj);
        }
        catch (Exception e) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.updateTeamProjModel.ex", (Throwable)e);
        }
    }

    private void updateStateTeamProjModel(Integer teamProjId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == teamProjId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("teamProjId", teamProjId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.wtTeamProjMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.updateStateTeamProjModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.updateStateTeamProjModel.null");
        }
    }

    private WtTeamProj makeTeamProj(WtTeamProjDomain wtTeamProjDomain, WtTeamProj wtTeamProj) {
        if (null == wtTeamProjDomain) {
            return null;
        }
        if (null == wtTeamProj) {
            wtTeamProj = new WtTeamProj();
        }
        try {
            BeanUtils.copyAllPropertys((Object)wtTeamProj, (Object)wtTeamProjDomain);
            return wtTeamProj;
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.makeTeamProj", (Throwable)e);
            return null;
        }
    }

    private List<WtTeamProj> queryTeamProjModelPage(Map<String, Object> parammap) {
        try {
            return this.wtTeamProjMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.queryTeamProjModel", (Throwable)e);
            return null;
        }
    }

    private int countTeamProj(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.wtTeamProjMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("wt.team.WtTeamProjServiceImpl.countTeamProj", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveTeamProj(WtTeamProjDomain wtTeamProjDomain) throws ApiException {
        String msg = this.checkTeamProj(wtTeamProjDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.saveTeamProj.checkTeamProj", msg);
        }
        WtTeamProj wtTeamProj = this.makeTeamProj(wtTeamProjDomain, null);
        this.setTeamProjDefault(wtTeamProj);
        this.saveTeamProjModel(wtTeamProj);
        return wtTeamProj.getTeamProjCode();
    }

    @Override
    public void updateTeamProjState(Integer teamProjId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateTeamProjModel(teamProjId, dataState, oldDataState);
    }

    @Override
    public void updateTeamProj(WtTeamProjDomain wtTeamProjDomain) throws ApiException {
        String msg = this.checkTeamProj(wtTeamProjDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.updateTeamProj.checkTeamProj", msg);
        }
        WtTeamProj oldWtTeamProj = this.getTeamProjModelById(wtTeamProjDomain.getTeamProjId());
        if (null == oldWtTeamProj) {
            throw new ApiException("wt.team.WtTeamProjServiceImpl.updateTeamProj.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        WtTeamProj wtTeamProj = this.makeTeamProj(wtTeamProjDomain, oldWtTeamProj);
        this.setTeamProjUpdataDefault(wtTeamProj);
        this.updateTeamProjModel(wtTeamProj);
    }

    @Override
    public WtTeamProj getTeamProj(Integer teamProjId) {
        return this.getTeamProjModelById(teamProjId);
    }

    @Override
    public void deleteTeamProj(Integer teamProjId) throws ApiException {
        this.deleteTeamProjModel(teamProjId);
    }

    @Override
    public QueryResult<WtTeamProj> queryTeamProjPage(Map<String, Object> map) {
        List<WtTeamProj> wtTeamProjList = this.queryTeamProjModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countTeamProj(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(wtTeamProjList);
        return queryResult;
    }

    @Override
    public WtTeamProj getTeamProjByCode(Map<String, Object> map) {
        return this.getTeamProjModelByCode(map);
    }

    @Override
    public void delTeamProjByCode(Map<String, Object> map) throws ApiException {
        this.delTeamProjModelByCode(map);
    }
}

