/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCo;
import com.sap.conn.jco.JCoClassMetaData;
import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoFunctionTemplate;
import com.sap.conn.jco.JCoListMetaData;
import com.sap.conn.jco.JCoParameterList;
import com.sap.conn.jco.JCoRecord;
import com.sap.conn.jco.JCoRecordMetaData;
import com.sap.conn.jco.JCoRepositoryQueryResult;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.JCoStructure;
import com.sap.conn.jco.JCoTable;
import com.sap.conn.jco.monitor.JCoDestinationMonitor;
import com.sap.conn.jco.rt.AbapExceptionModel;
import com.sap.conn.jco.rt.AbapFunctionTemplate;
import com.sap.conn.jco.rt.AbstractMetaData;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ConnectionAttributes;
import com.sap.conn.jco.rt.ConnectionManager;
import com.sap.conn.jco.rt.DefaultClassMetaData;
import com.sap.conn.jco.rt.DefaultDestinationManager;
import com.sap.conn.jco.rt.DefaultListMetaData;
import com.sap.conn.jco.rt.DefaultRecordMetaData;
import com.sap.conn.jco.rt.DestinationList;
import com.sap.conn.jco.rt.DynamicRecordMetaData;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.util.Jarm;
import com.sap.conn.jco.util.ObjectList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbapRepository
extends BasicRepository {
    protected static final DefaultRecordMetaData funint_v2 = new DefaultRecordMetaData("RFC_FUNINT", 12);
    protected static final DefaultRecordMetaData fields_v2 = new DefaultRecordMetaData("RFC_FIELDS", 7);
    protected static final DefaultRecordMetaData funint_v3 = new DefaultRecordMetaData("RFC_FUNINT", 11);
    protected static final DefaultRecordMetaData fields_v3 = new DefaultRecordMetaData("RFC_FIELDS", 7);
    protected static final DefaultRecordMetaData rsimp_v3 = new DefaultRecordMetaData("RSIMP", 8);
    protected static final DefaultRecordMetaData rstbl_v3 = new DefaultRecordMetaData("RSTBL", 5);
    protected static final DefaultRecordMetaData x030l_v4 = new DefaultRecordMetaData("X030L", 25);
    protected static final DefaultRecordMetaData dfies_v4 = new DefaultRecordMetaData("DFIES", 42);
    protected static final DefaultRecordMetaData ddtypelist_v4 = new DefaultRecordMetaData("DDTYPELIST", 3);
    protected static final DefaultRecordMetaData dfies_v5 = new DefaultRecordMetaData("DFIES", 44);
    protected static final DefaultRecordMetaData x030l_v5 = new DefaultRecordMetaData("X030L", 27);
    protected static final DefaultRecordMetaData ddtypelist_v5 = new DefaultRecordMetaData("DDTYPELIST", 3);
    protected static final DefaultRecordMetaData typeSEO_ATTRIBUTES_REMOTE = new DefaultRecordMetaData("SEO_ATTRIBUTES_REMOTE", 13);
    protected static final DefaultRecordMetaData typeSEO_CLSKEYS = new DefaultRecordMetaData("SEO_CLSKEYS", 1);
    protected static final DefaultRecordMetaData typeDDNTABTMSTS = new DefaultRecordMetaData("DDNTABTMSTS", 3);
    protected static final DefaultListMetaData getFunctionInterfaceImports = new DefaultListMetaData("FUNINTIMP", 2);
    protected static final DefaultListMetaData getFunctionInterfaceExports = new DefaultListMetaData("FUNINTEXP", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v2 = new DefaultListMetaData("FUNINTTAB", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v3 = new DefaultListMetaData("FUNINTTAB", 1);
    protected static final DefaultListMetaData getFunctionInterfaceTables_v4;
    protected static final DefaultListMetaData getFunctionInterfaceTables_v5;
    protected static final DefaultListMetaData getStructureDefinitionImports_v2;
    protected static final DefaultListMetaData getStructureDefinitionImports_v3;
    protected static final DefaultListMetaData getStructureDefinitionExports;
    protected static final DefaultListMetaData getStructureDefinitionTables_v2;
    protected static final DefaultListMetaData getStructureDefinitionTables_v3;
    protected static final DefaultListMetaData ddifFieldInfoGetImports;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v4;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v462;
    protected static final DefaultListMetaData ddifFieldInfoGetExports_v5;
    protected static final DefaultListMetaData ddifFieldInfoGetTables_v4;
    protected static final DefaultListMetaData ddifFieldInfoGetTables_v5;
    protected static final byte[] ddifFieldInfoGetNUC;
    protected static final byte[] ddifFieldInfoGetUC;
    protected static final DefaultListMetaData functionImportInterfaceImports;
    protected static final DefaultListMetaData functionImportInterfaceTables;
    protected static final DefaultListMetaData seoGetClifRemoteImports;
    protected static final DefaultListMetaData seoGetClifRemoteExports;
    protected static final DefaultListMetaData ddGetClidepStructImports;
    protected static final DefaultListMetaData ddGetClidepStructExports;
    protected static final String[] ABAP_TYPES;
    protected static final char[] ABAP_EXIDS;
    private static QueryClassHierarchy queryClassHierarchy;
    protected int repositoryVersion = 0;
    JCoFunctionTemplate getFunctionInterfaceTemplate;
    JCoFunctionTemplate functionImportInterfaceTemplate;
    JCoFunctionTemplate getStructureDefinitionTemplate;
    JCoFunctionTemplate ddifFieldInfoGetTemplate;
    JCoFunctionTemplate seoGetClifRemoteTemplate;
    JCoFunctionTemplate ddGetClidepStructTemplate;
    JCoFunctionTemplate rfcMetadataGetTemplate;
    String partnerRelease = null;
    private AbapRepositoryMonitor monitor = null;
    long lastRemoteQueryTimestamp = 0L;
    DestinationList<InternalDestination> destinationList;
    Object semaphore = new Object();
    DDICHelper ddicHelper = null;

    protected AbapRepository(String name) {
        super(name, true);
        this.destinationList = new DestinationList<Object>(null);
    }

    protected AbapRepository(String name, JCoDestination destination) throws JCoException {
        this(name, (InternalDestination)destination);
    }

    protected AbapRepository(String name, InternalDestination destination) throws JCoException {
        super(name, false);
        this.destinationList = new DestinationList<InternalDestination>(destination);
        this.getVersion();
        this.ddicHelper = this.initDDICHelper();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DDICHelper initDDICHelper() throws JCoException {
        ClientConnection client;
        void var1_6;
        Object var1_1 = null;
        if ("0".equals(JCoRuntimeFactory.getRuntime().getPropertyValue("jco.use_repository_roundtrip_optimization"))) {
            return new DDICHelper();
        }
        InternalDestination destination = this.destinationList.getCurrentDestination();
        if (destination == null) return var1_6;
        Boolean supportsTurboRepository = destination.supportsTurboRepository();
        if (supportsTurboRepository != null) {
            if (supportsTurboRepository.booleanValue()) {
                TurboDDICHelper turboDDICHelper = new TurboDDICHelper();
                return var1_6;
            } else {
                DDICHelper dDICHelper = new DDICHelper();
            }
            return var1_6;
        } else {
            DDICHelper dDICHelper;
            client = null;
            JCoFunction f = this.getRfcGetFunctionInterfaceTemplate().getFunction();
            f.getImportParameterList().setValue(0, "RFC_METADATA_GET");
            client = this.getClient(destination, true);
            client.execute(f, (RepositoryProvider)this);
            JCoTable params = f.getTableParameterList().getTable(0);
            boolean isValidRfcMetadataGet = false;
            for (int i = 0; i < params.getNumRows(); ++i) {
                params.setRow(i);
                if (!"INDIRECTTYPES".equals(params.getString("PARAMETER"))) continue;
                isValidRfcMetadataGet = true;
                break;
            }
            DDICHelper dDICHelper2 = dDICHelper = isValidRfcMetadataGet ? new TurboDDICHelper() : new DDICHelper();
            if (client == null) return var1_6;
            try {
                this.releaseClient(client, destination);
                return var1_6;
            }
            catch (JCoException je) {}
        }
        return var1_6;
        catch (AbapException ae) {
            try {
                DDICHelper dDICHelper = new DDICHelper();
                if (client == null) return var1_6;
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                try {
                    this.releaseClient(client, destination);
                    throw throwable;
                }
                catch (JCoException je) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.releaseClient(client, destination);
                return var1_6;
            }
            catch (JCoException je) {}
            return var1_6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final int getVersion() {
        if (this.repositoryVersion == 0) {
            Object object = this.semaphore;
            synchronized (object) {
                InternalDestination destination;
                if (this.repositoryVersion == 0 && (destination = this.destinationList.getCurrentDestination()) != null) {
                    ClientConnection client = null;
                    try {
                        client = this.getClient(destination, true);
                        ConnectionAttributes attributes = client.getAttributes();
                        this.partnerRelease = attributes.getPartnerRelease();
                        this.repositoryVersion = attributes.getPartnerReleaseNumber();
                        this.containsUnicodeInfo = this.repositoryVersion > 463 || this.repositoryVersion == 0;
                    }
                    catch (Throwable t) {
                    }
                    finally {
                        if (client != null) {
                            try {
                                this.releaseClient(client, destination);
                            }
                            catch (JCoException je) {}
                        }
                    }
                }
            }
        }
        return this.repositoryVersion;
    }

    public final JCoFunctionTemplate queryFunctionTemplate(String functionName) throws JCoException {
        JCoException originException = null;
        JCoFunctionTemplate meta = null;
        InternalDestination currentDestination = this.destinationList.getCurrentDestination();
        try {
            meta = this.queryFunctionTemplate(functionName, currentDestination, true);
        }
        catch (JCoException ex) {
            switch (ex.getGroup()) {
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 180: {
                    if (this.destinationList.size() > 1) {
                        originException = ex;
                        break;
                    }
                    throw ex;
                }
                default: {
                    throw ex;
                }
            }
        }
        if (originException != null) {
            ArrayList<JCoException> excList = new ArrayList<JCoException>();
            excList.add(originException);
            boolean throwException = true;
            Iterator<InternalDestination> it = this.destinationList.iterator();
            block10: while (it.hasNext()) {
                InternalDestination destination = it.next();
                if (destination == currentDestination) continue;
                try {
                    meta = this.queryFunctionTemplate(functionName, destination, true);
                }
                catch (JCoException ex2) {
                    switch (ex2.getGroup()) {
                        case 102: 
                        case 103: 
                        case 104: 
                        case 106: 
                        case 180: {
                            excList.add(ex2);
                            continue block10;
                        }
                    }
                    throw ex2;
                }
                throwException = false;
                this.destinationList.replaceCurrentDestination(currentDestination, destination);
            }
            if (throwException) {
                StringBuilder buf = new StringBuilder("Unable to query function template, caused by");
                Iterator it2 = excList.iterator();
                while (it2.hasNext()) {
                    buf.append(JCoRuntime.CRLF).append(((JCoException)it2.next()).toString());
                }
                throw new JCoException(originException.getGroup(), originException.getKey(), buf.toString());
            }
        }
        return meta;
    }

    protected DefaultRecordMetaData queryRecordMetaData(String structureName) throws JCoException {
        JCoException originException = null;
        DefaultRecordMetaData meta = null;
        InternalDestination currentDestination = this.destinationList.getCurrentDestination();
        try {
            meta = this.queryRecordMetaData(structureName, currentDestination, true);
        }
        catch (JCoException ex) {
            switch (ex.getGroup()) {
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 180: {
                    if (this.destinationList.size() > 1) {
                        originException = ex;
                        break;
                    }
                    throw ex;
                }
                default: {
                    throw ex;
                }
            }
        }
        if (originException != null) {
            ArrayList<JCoException> excList = new ArrayList<JCoException>();
            excList.add(originException);
            boolean throwException = true;
            Iterator<InternalDestination> it = this.destinationList.iterator();
            block10: while (it.hasNext()) {
                InternalDestination destination = it.next();
                if (destination == currentDestination) continue;
                try {
                    meta = this.queryRecordMetaData(structureName, destination, true);
                }
                catch (JCoException ex2) {
                    switch (ex2.getGroup()) {
                        case 102: 
                        case 103: 
                        case 104: 
                        case 106: 
                        case 180: {
                            excList.add(ex2);
                            continue block10;
                        }
                    }
                    throw ex2;
                }
                throwException = false;
                this.destinationList.replaceCurrentDestination(currentDestination, destination);
            }
            if (throwException) {
                StringBuilder buf = new StringBuilder("Unable to query record meta data, caused by");
                Iterator it2 = excList.iterator();
                while (it2.hasNext()) {
                    buf.append(JCoRuntime.CRLF).append(((JCoException)it2.next()).toString());
                }
                throw new JCoException(originException.getGroup(), originException.getKey(), buf.toString());
            }
        }
        return meta;
    }

    protected DefaultClassMetaData queryClassMetaData(String className) throws JCoException {
        JCoException originException = null;
        DefaultClassMetaData meta = null;
        InternalDestination currentDestination = this.destinationList.getCurrentDestination();
        try {
            meta = this.queryClassMetaData(className, currentDestination, true);
        }
        catch (JCoException ex) {
            switch (ex.getGroup()) {
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 180: {
                    if (this.destinationList.size() > 1) {
                        originException = ex;
                        break;
                    }
                    throw ex;
                }
                default: {
                    throw ex;
                }
            }
        }
        if (originException != null) {
            ArrayList<JCoException> excList = new ArrayList<JCoException>();
            excList.add(originException);
            boolean throwException = true;
            Iterator<InternalDestination> it = this.destinationList.iterator();
            block10: while (it.hasNext()) {
                InternalDestination destination = it.next();
                if (destination == currentDestination) continue;
                try {
                    meta = this.queryClassMetaData(className, destination, true);
                }
                catch (JCoException ex2) {
                    switch (ex2.getGroup()) {
                        case 102: 
                        case 103: 
                        case 104: 
                        case 106: 
                        case 180: {
                            excList.add(ex2);
                            continue block10;
                        }
                    }
                    throw ex2;
                }
                throwException = false;
                this.destinationList.replaceCurrentDestination(currentDestination, destination);
            }
            if (throwException) {
                StringBuilder buf = new StringBuilder("Unable to query class meta data, caused by");
                Iterator it2 = excList.iterator();
                while (it2.hasNext()) {
                    buf.append(JCoRuntime.CRLF).append(((JCoException)it2.next()).toString());
                }
                throw new JCoException(originException.getGroup(), originException.getKey(), buf.toString());
            }
        }
        return meta;
    }

    @Override
    public JCoFunctionTemplate getFunctionTemplate(String functionName) throws JCoException {
        AbapException exc;
        JCoFunctionTemplate template;
        block6: {
            this.lastAccessTimestamp = System.currentTimeMillis();
            template = super.getFunctionTemplate(functionName);
            if (template != null) {
                return template;
            }
            exc = null;
            try {
                template = this.queryFunctionTemplate(functionName);
            }
            catch (AbapException ae) {
                if ("FU_NOT_FOUND".equalsIgnoreCase(ae.getKey())) break block6;
                exc = ae;
            }
        }
        if (template != null) {
            super.addFunctionTemplate(template);
            template = super.getFunctionTemplate(functionName);
        } else if (exc != null) {
            throw exc;
        }
        return template;
    }

    @Override
    public DefaultRecordMetaData getRecordMetaData(String recordName) throws JCoException {
        AbapException exc;
        DefaultRecordMetaData meta;
        block7: {
            this.lastAccessTimestamp = System.currentTimeMillis();
            meta = super.getRecordMetaData(recordName);
            if (meta != null) {
                return meta;
            }
            exc = null;
            try {
                meta = this.queryRecordMetaData(recordName);
            }
            catch (AbapException ae) {
                if ("NOT_FOUND".equalsIgnoreCase(ae.getKey()) || "TABLE_NOT_ACTIVE".equalsIgnoreCase(ae.getKey())) break block7;
                exc = ae;
            }
        }
        if (meta != null) {
            DefaultRecordMetaData saved = super.getRecordMetaDataFromCache(recordName);
            if (saved != meta) {
                super.addRecordMetaData(meta);
            }
        } else if (exc != null) {
            throw exc;
        }
        return meta;
    }

    @Override
    public DefaultClassMetaData getClassMetaData(String className) throws JCoException {
        AbapException exc;
        DefaultClassMetaData meta;
        block7: {
            this.lastAccessTimestamp = System.currentTimeMillis();
            meta = super.getClassMetaData(className);
            if (meta != null) {
                return meta;
            }
            exc = null;
            try {
                meta = this.queryClassMetaData(className);
            }
            catch (AbapException ae) {
                if ("CLASS_NOT_FOUND".equals(ae.getKey())) break block7;
                exc = ae;
            }
        }
        if (meta != null) {
            DefaultClassMetaData saved;
            if (!meta.isInRecursiveQuery() && (saved = super.getClassMetaDataFromCache(className)) != meta) {
                super.addClassMetaData(meta);
            }
        } else if (exc != null) {
            throw exc;
        }
        return meta;
    }

    ClientConnection getClient(InternalDestination dest, boolean useRepositoryPool) throws JCoException {
        return ConnectionManager.getConnectionManager().getClient(dest, useRepositoryPool, false);
    }

    void releaseClient(ClientConnection client, InternalDestination destination) throws JCoException {
        ConnectionManager.getConnectionManager().releaseClient(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JCoFunctionTemplate queryFunctionTemplate(String functionName, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
        JCoFunctionTemplate functionTemplate;
        Jarm.Monitor jarm_monitor;
        block13: {
            int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
            jarm_monitor = null;
            if (Trace.isOn(8, true)) {
                Trace.fireTrace(8, new StringBuilder(150).append("[JCoAPI] JCoRepository.queryFunctionTemplate(").append(functionName).append(") for repository ").append(this.name).append(" using ").append(useRepositoryPool ? "repository destination " : "destination ").append(destForQueries != null ? destForQueries.getDestinationName() : "null").toString());
            }
            if ((mode & 1) != 0) {
                try {
                    jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.AbapRepository");
                    if (jarm_monitor != null) {
                        jarm_monitor.startComponent();
                    }
                }
                catch (Throwable th) {
                    if (!Trace.isOn(2)) break block13;
                    Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                }
            }
        }
        try {
            functionTemplate = this.ddicHelper.queryFunctionTemplate(functionName, destForQueries, useRepositoryPool);
        }
        finally {
            block15: {
                if (jarm_monitor != null) {
                    try {
                        jarm_monitor.compAction(functionName);
                        jarm_monitor.endComponent();
                        jarm_monitor.endRequest();
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(2)) break block15;
                        Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                    }
                }
            }
            this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }
        return functionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultRecordMetaData queryRecordMetaData(String recordName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
        Jarm.Monitor jarm_monitor;
        block13: {
            int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
            jarm_monitor = null;
            if (destination == null) {
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Invalid destination reference encountered (destination is null)");
            }
            if ((mode & 1) != 0) {
                try {
                    jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.AbapRepository");
                    if (jarm_monitor != null) {
                        jarm_monitor.startComponent();
                    }
                }
                catch (Throwable th) {
                    if (!Trace.isOn(2)) break block13;
                    Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                }
            }
        }
        DefaultRecordMetaData meta = null;
        try {
            meta = this.ddicHelper.queryRecordMetaData(recordName, destination, useRepositoryPool);
        }
        finally {
            block15: {
                if (jarm_monitor != null) {
                    try {
                        jarm_monitor.compAction(recordName);
                        jarm_monitor.endComponent();
                        jarm_monitor.endRequest();
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(2)) break block15;
                        Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                    }
                }
            }
            this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }
        return meta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DefaultClassMetaData queryClassMetaData(String className, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
        Jarm.Monitor jarm_monitor;
        int version;
        block34: {
            version = this.getVersion();
            if (version < 720) {
                return null;
            }
            ObjectList currentAncestors = (ObjectList)queryClassHierarchy.get();
            for (int i = 0; i < currentAncestors.size(); ++i) {
                DefaultClassMetaData ancestorClassMetaData = (DefaultClassMetaData)currentAncestors.get(i);
                if (!ancestorClassMetaData.getName().equals(className)) continue;
                ancestorClassMetaData.setInRecursiveQuery(true);
                return ancestorClassMetaData;
            }
            int mode = JCoRuntimeFactory.getRuntime().getInternalMode();
            jarm_monitor = null;
            if (destForQueries == null) {
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Invalid destination reference encountered (destination is null)");
            }
            if ((mode & 1) != 0) {
                try {
                    jarm_monitor = Jarm.getRequestMonitor(null, "com.sap.conn.jco.AbapRepository");
                    if (jarm_monitor != null) {
                        jarm_monitor.startComponent();
                    }
                }
                catch (Throwable th) {
                    if (!Trace.isOn(2)) break block34;
                    Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                }
            }
        }
        DefaultClassMetaData meta = null;
        ClientConnection client = this.getClient(destForQueries, useRepositoryPool);
        try {
            int i;
            int i2;
            if (Trace.isOn(8)) {
                Trace.fireTrace(8, new StringBuilder(150).append("[JCoAPI] JCoRepository.queryClassMetaData(").append(className).append(") for repository ").append(this.name).append(" version ").append(version).append(" using ").append(useRepositoryPool ? "repository destination " : "destination ").append(destForQueries.getDestinationName()).toString());
            }
            String commentInfo = client.getAttributes().getSystemID();
            JCoFunction seoGetClifRemote = this.getSeoGetClifRemoteTemplate().getFunction();
            JCoParameterList seoRemoteImports = seoGetClifRemote.getImportParameterList();
            seoRemoteImports.setValue(0, className);
            seoRemoteImports.setValue(1, 'X');
            client.execute(seoGetClifRemote, (RepositoryProvider)this);
            JCoParameterList seoRemoteExports = seoGetClifRemote.getExportParameterList();
            JCoTable parentClassesTable = seoRemoteExports.getTable(2);
            JCoTable implementedInterfacesTable = seoRemoteExports.getTable(1);
            JCoTable attributes = seoRemoteExports.getTable(0);
            String[] parentClasses = new String[parentClassesTable.getNumRows()];
            String[] implementedInterfaces = new String[implementedInterfacesTable.getNumRows()];
            for (i2 = 0; i2 < parentClasses.length; ++i2) {
                parentClassesTable.setRow(i2);
                parentClasses[i2] = parentClassesTable.getString(0);
            }
            for (i2 = 0; i2 < implementedInterfaces.length; ++i2) {
                implementedInterfacesTable.setRow(i2);
                implementedInterfaces[i2] = implementedInterfacesTable.getString(0);
            }
            int attributesCount = attributes.getNumRows();
            int publicAttributesCount = 0;
            for (i = 0; i < attributesCount; ++i) {
                attributes.setRow(i);
                if (attributes.getChar(2) != '2' || attributes.getChar(3) == '2') continue;
                ++publicAttributesCount;
            }
            meta = new DefaultClassMetaData(className, parentClasses, implementedInterfaces, publicAttributesCount);
            for (i = 0; i < attributesCount; ++i) {
                JCoClassMetaData.JCoAttributeKind kind;
                attributes.setRow(i);
                if (attributes.getInt(2) != 2 || attributes.getChar(3) == '2') continue;
                String declaringClass = attributes.getString(0);
                String attributeName = attributes.getString(1);
                String typeName = attributes.getString(7);
                int jcoType = AbstractMetaData.getJCOType(attributes.getChar(6));
                switch (attributes.getChar(3)) {
                    case '0': {
                        kind = JCoClassMetaData.JCoAttributeKind.INSTANCE;
                        break;
                    }
                    case '1': {
                        kind = JCoClassMetaData.JCoAttributeKind.CLASS;
                        break;
                    }
                    case '2': {
                        kind = JCoClassMetaData.JCoAttributeKind.CONSTANT;
                        break;
                    }
                    default: {
                        throw new JCoException(128, "JCO_ERROR_NOT_SUPPORTED", "Unknown attribute kind '" + attributes.getChar(3) + "' for attribute " + declaringClass + "->" + attributeName + " in class " + className);
                    }
                }
                AbstractMetaData childMetaData = null;
                switch (jcoType) {
                    case 17: 
                    case 31: 
                    case 99: {
                        childMetaData = this.getRecordMetaData(typeName);
                        break;
                    }
                    case 16: {
                        ObjectList recursionQuery = (ObjectList)queryClassHierarchy.get();
                        recursionQuery.push(meta);
                        try {
                            childMetaData = this.getClassMetaData(typeName);
                            ((DefaultClassMetaData)childMetaData).setInRecursiveQuery(false);
                            break;
                        }
                        finally {
                            recursionQuery.pop();
                        }
                    }
                }
                String description = attributes.getString(12);
                String defaultValue = attributes.getString(11);
                if (defaultValue.length() == 0) {
                    defaultValue = null;
                }
                int length = attributes.getInt(9);
                int decimals = attributes.getInt(10);
                boolean readOnly = 'X' == attributes.getChar(4);
                meta.add(declaringClass, attributeName, jcoType, length, decimals, description, childMetaData, null, kind, readOnly, defaultValue);
            }
            meta.comment = commentInfo;
        }
        finally {
            block36: {
                if (client != null) {
                    this.releaseClient(client, destForQueries);
                }
                if (jarm_monitor != null) {
                    try {
                        jarm_monitor.compAction(className);
                        jarm_monitor.endComponent();
                        jarm_monitor.endRequest();
                    }
                    catch (Throwable th) {
                        if (!Trace.isOn(2)) break block36;
                        Trace.fireTrace(2, "[JCoAPI] Exception within JARM component: " + th.toString());
                    }
                }
            }
            this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }
        meta.lock();
        return meta;
    }

    JCoRepositoryQueryResult lookupMetadata(List<String> functions, List<String> types, List<String> classes) throws JCoException {
        JCoException originException = null;
        RepositoryLoadResult result = null;
        InternalDestination currentDestination = this.destinationList.getCurrentDestination();
        try {
            result = this.ddicHelper.lookupMetadata(null, functions, null, types, null, classes, currentDestination, true);
        }
        catch (JCoException ex) {
            switch (ex.getGroup()) {
                case 102: 
                case 103: 
                case 104: 
                case 106: 
                case 180: {
                    if (this.destinationList.size() > 1) {
                        originException = ex;
                        break;
                    }
                    throw ex;
                }
                default: {
                    throw ex;
                }
            }
        }
        if (originException != null) {
            ArrayList<JCoException> excList = new ArrayList<JCoException>();
            excList.add(originException);
            Iterator<InternalDestination> it = this.destinationList.iterator();
            block10: while (it.hasNext()) {
                InternalDestination destination = it.next();
                if (destination == currentDestination) continue;
                try {
                    result = this.ddicHelper.lookupMetadata(null, functions, null, types, null, classes, destination, true);
                }
                catch (JCoException ex2) {
                    switch (ex2.getGroup()) {
                        case 102: 
                        case 103: 
                        case 104: 
                        case 106: 
                        case 180: {
                            excList.add(ex2);
                            continue block10;
                        }
                    }
                    throw ex2;
                }
                this.destinationList.replaceCurrentDestination(currentDestination, destination);
            }
            StringBuilder buf = new StringBuilder("Unable to query function template, caused by");
            Iterator it2 = excList.iterator();
            while (it2.hasNext()) {
                buf.append(JCoRuntime.CRLF).append(((JCoException)it2.next()).toString());
            }
            throw new JCoException(originException.getGroup(), originException.getKey(), buf.toString());
        }
        return result;
    }

    JCoFunctionTemplate getRfcGetFunctionInterfaceTemplate() {
        if (this.getFunctionInterfaceTemplate == null) {
            int version = this.getVersion();
            if (version >= 702 || version == 0) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, (JCoListMetaData)getFunctionInterfaceExports, null, (JCoListMetaData)getFunctionInterfaceTables_v5, (AbapExceptionModel[])null, false);
            } else if (version >= 500) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v5, (AbapExceptionModel[])null, false);
            } else if (version >= 400) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v4, (AbapExceptionModel[])null, false);
            } else if (version >= 300) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v3, (AbapExceptionModel[])null, false);
            } else if (version >= 200) {
                this.getFunctionInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_FUNCTION_INTERFACE", (JCoListMetaData)getFunctionInterfaceImports, null, null, (JCoListMetaData)getFunctionInterfaceTables_v2, (AbapExceptionModel[])null, false);
            }
        }
        return this.getFunctionInterfaceTemplate;
    }

    JCoFunctionTemplate getDdifFieldInfoGetTemplate() {
        if (this.ddifFieldInfoGetTemplate == null) {
            DefaultListMetaData exp = null;
            DefaultListMetaData tab = null;
            int version = this.getVersion();
            if (version < 462) {
                exp = ddifFieldInfoGetExports_v4;
                tab = ddifFieldInfoGetTables_v4;
            } else if (version < 500) {
                exp = ddifFieldInfoGetExports_v462;
                tab = ddifFieldInfoGetTables_v5;
            } else {
                exp = ddifFieldInfoGetExports_v5;
                tab = ddifFieldInfoGetTables_v5;
            }
            this.ddifFieldInfoGetTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("DDIF_FIELDINFO_GET", (JCoListMetaData)ddifFieldInfoGetImports, (JCoListMetaData)exp, null, (JCoListMetaData)tab, (AbapExceptionModel[])null, false);
        }
        return this.ddifFieldInfoGetTemplate;
    }

    JCoFunctionTemplate getFunctionImportInterfaceTemplate() {
        if (this.functionImportInterfaceTemplate == null) {
            this.functionImportInterfaceTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("FUNCTION_IMPORT_INTERFACE", (JCoListMetaData)functionImportInterfaceImports, null, null, (JCoListMetaData)functionImportInterfaceTables, (AbapExceptionModel[])null, false);
        }
        return this.functionImportInterfaceTemplate;
    }

    JCoFunctionTemplate getRfcGetStructureDefinitionTemplate() {
        if (this.getStructureDefinitionTemplate == null) {
            int version = this.getVersion();
            if (version >= 200 && version < 300) {
                this.getStructureDefinitionTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_STRUCTURE_DEFINITION", (JCoListMetaData)getStructureDefinitionImports_v2, (JCoListMetaData)getStructureDefinitionExports, null, (JCoListMetaData)getStructureDefinitionTables_v2, (AbapExceptionModel[])null, false);
            } else if (version >= 300 && version < 400) {
                this.getStructureDefinitionTemplate = JCoRuntimeFactory.getRuntime().createFunctionTemplate("RFC_GET_STRUCTURE_DEFINITION", (JCoListMetaData)getStructureDefinitionImports_v3, (JCoListMetaData)getStructureDefinitionExports, null, (JCoListMetaData)getStructureDefinitionTables_v3, (AbapExceptionModel[])null, false);
            }
        }
        return this.getStructureDefinitionTemplate;
    }

    JCoFunctionTemplate getSeoGetClifRemoteTemplate() {
        if (this.seoGetClifRemoteTemplate == null) {
            this.seoGetClifRemoteTemplate = new AbapFunctionTemplate("SEO_GET_CLIF_REMOTE", seoGetClifRemoteImports, seoGetClifRemoteExports, null, null, new AbapExceptionModel[]{new AbapExceptionModel("CLASS_NOT_FOUND", "class not found")}, false);
        }
        return this.seoGetClifRemoteTemplate;
    }

    JCoFunctionTemplate getDdGetClidepStructTemplate() {
        if (this.ddGetClidepStructTemplate == null) {
            this.ddGetClidepStructTemplate = new AbapFunctionTemplate("DD_GET_CLIDEP_STRUCT_REMOTE", ddGetClidepStructImports, ddGetClidepStructExports, null, null, new AbapExceptionModel[]{new AbapExceptionModel("NO_GENERIC_BOX_EXISTS", "structure does not contain any generic boxes"), new AbapExceptionModel("WRONG_STATE_OF_CI", "WRONG_STATE_OF_CI"), new AbapExceptionModel("WRONG_STATE_OF_STRUCT", "WRONG_STATE_OF_STRUCT"), new AbapExceptionModel("NO_STRUC_IN_THIS_CLIENT", "no generic boxes defined in the current client")}, false);
        }
        return this.ddGetClidepStructTemplate;
    }

    JCoFunctionTemplate getRfcMetadataGetTemplate() {
        if (this.rfcMetadataGetTemplate == null) {
            DefaultRecordMetaData RFCFUNCTIONNAME = new DefaultRecordMetaData("RFCFUNCTIONNAME", 4);
            RFCFUNCTIONNAME.add("FUNCTIONNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFCFUNCTIONNAME.add("BASXML_SUPPORTED", 0, 1, 30, 2, 60, 0, null, null, null);
            RFCFUNCTIONNAME.add("UDAT", 1, 8, 31, 16, 62, 0, null, null, null);
            RFCFUNCTIONNAME.add("UTIME", 3, 6, 39, 12, 78, 0, null, null, null);
            RFCFUNCTIONNAME.setRecordLength(45, 96);
            RFCFUNCTIONNAME.lock();
            DefaultRecordMetaData RFC_MD_DDIC_NAME = new DefaultRecordMetaData("RFC_MD_DDIC_NAME", 2);
            RFC_MD_DDIC_NAME.add("TABNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_MD_DDIC_NAME.add("FIELDNAME", 0, 30, 30, 60, 60, 0, null, null, null);
            RFC_MD_DDIC_NAME.setRecordLength(60, 120);
            RFC_MD_DDIC_NAME.lock();
            DefaultRecordMetaData RFC_METADATA_PARAMS = new DefaultRecordMetaData("RFC_METADATA_PARAMS", 13);
            RFC_METADATA_PARAMS.add("FUNCNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_METADATA_PARAMS.add("PARAMCLASS", 0, 1, 32, 2, 60, 0, null, null, null);
            RFC_METADATA_PARAMS.add("PARAMETER", 0, 30, 33, 60, 62, 0, null, null, null);
            RFC_METADATA_PARAMS.add("TABNAME", 0, 30, 63, 60, 122, 0, null, null, null);
            RFC_METADATA_PARAMS.add("FIELDNAME", 0, 30, 93, 60, 182, 0, null, null, null);
            RFC_METADATA_PARAMS.add("EXID", 0, 1, 123, 2, 242, 0, null, null, null);
            RFC_METADATA_PARAMS.add("POSITION", 8, 4, 124, 4, 244, 0, null, null, null);
            RFC_METADATA_PARAMS.add("OFFSET", 8, 4, 128, 4, 248, 0, null, null, null);
            RFC_METADATA_PARAMS.add("INTLENGTH", 8, 4, 132, 4, 252, 0, null, null, null);
            RFC_METADATA_PARAMS.add("DECIMALS", 8, 4, 136, 4, 256, 0, null, null, null);
            RFC_METADATA_PARAMS.add("DEFAULT", 0, 21, 140, 42, 260, 0, null, null, null);
            RFC_METADATA_PARAMS.add("PARAMTEXT", 0, 79, 161, 158, 302, 0, null, null, null);
            RFC_METADATA_PARAMS.add("OPTIONAL", 0, 1, 240, 2, 460, 0, null, null, null);
            RFC_METADATA_PARAMS.setRecordLength(244, 464);
            RFC_METADATA_PARAMS.lock();
            DefaultRecordMetaData RFC_METADATA_DDIC = new DefaultRecordMetaData("RFC_METADATA_DDIC", 15);
            RFC_METADATA_DDIC.add("TYPENAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_METADATA_DDIC.add("FIELDNAME", 0, 30, 30, 60, 60, 0, null, null, null);
            RFC_METADATA_DDIC.add("COMPTYPE", 0, 1, 60, 2, 120, 0, null, null, null);
            RFC_METADATA_DDIC.add("FIELDTYPE", 0, 30, 61, 60, 122, 0, null, null, null);
            RFC_METADATA_DDIC.add("DATATYPE", 0, 4, 91, 8, 182, 0, null, null, null);
            RFC_METADATA_DDIC.add("TABLENGTH", 6, 6, 95, 12, 190, 0, null, null, null);
            RFC_METADATA_DDIC.add("TABLENGTH_UC", 6, 6, 101, 12, 202, 0, null, null, null);
            RFC_METADATA_DDIC.add("DESCRIPTION", 0, 60, 107, 120, 214, 0, null, null, null);
            RFC_METADATA_DDIC.add("DECIMALS", 6, 6, 167, 12, 334, 0, null, null, null);
            RFC_METADATA_DDIC.add("INTTYPE", 0, 1, 173, 2, 346, 0, null, null, null);
            RFC_METADATA_DDIC.add("OFFSET", 0, 6, 174, 12, 348, 0, null, null, null);
            RFC_METADATA_DDIC.add("OFFSET_UC", 0, 6, 180, 12, 360, 0, null, null, null);
            RFC_METADATA_DDIC.add("INTLEN", 0, 6, 186, 12, 372, 0, null, null, null);
            RFC_METADATA_DDIC.add("INTLEN_UC", 0, 6, 192, 12, 384, 0, null, null, null);
            RFC_METADATA_DDIC.add("TIMESTAMP", 0, 14, 198, 28, 396, 0, null, null, null);
            RFC_METADATA_DDIC.setRecordLength(212, 424);
            RFC_METADATA_DDIC.lock();
            DefaultRecordMetaData RFC_METADATA_DDIC_INDIRECT = new DefaultRecordMetaData("RFC_METADATA_DDIC_INDIRECT", 3);
            RFC_METADATA_DDIC_INDIRECT.add("TABNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_METADATA_DDIC_INDIRECT.add("FIELDNAME", 0, 30, 30, 60, 60, 0, null, null, null);
            RFC_METADATA_DDIC_INDIRECT.add("FIELDTYPE", 0, 30, 60, 60, 120, 0, null, null, null);
            RFC_METADATA_DDIC_INDIRECT.setRecordLength(90, 180);
            RFC_METADATA_DDIC_INDIRECT.lock();
            DefaultRecordMetaData RFC_FUNC_ERROR = new DefaultRecordMetaData("RFC_FUNC_ERROR", 3);
            RFC_FUNC_ERROR.add("FUNCNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_FUNC_ERROR.add("EXCEPTION", 0, 30, 30, 60, 60, 0, null, null, null);
            RFC_FUNC_ERROR.add("EXCEPTION_TEXT", 0, 255, 60, 510, 120, 0, null, null, null);
            RFC_FUNC_ERROR.setRecordLength(315, 630);
            RFC_FUNC_ERROR.lock();
            DefaultRecordMetaData RFC_DD_ERROR = new DefaultRecordMetaData("RFC_DD_ERROR", 4);
            RFC_DD_ERROR.add("TABNAME", 0, 30, 0, 60, 0, 0, null, null, null);
            RFC_DD_ERROR.add("FIELDNAME", 0, 30, 30, 60, 60, 0, null, null, null);
            RFC_DD_ERROR.add("EXCEPTION", 0, 30, 60, 60, 120, 0, null, null, null);
            RFC_DD_ERROR.add("EXCEPTION_TEXT", 0, 255, 90, 510, 180, 0, null, null, null);
            RFC_DD_ERROR.setRecordLength(345, 690);
            RFC_DD_ERROR.lock();
            DefaultListMetaData imports = new DefaultListMetaData("IMPORTS", 4);
            imports.add("DEEP", 0, 1, 2, 0, null, null, 3, null, null);
            imports.add("EVALUATE_LINKS", 0, 1, 2, 0, null, null, 3, null, null);
            imports.add("LANGUAGE", 0, 1, 2, 0, null, null, 3, null, null);
            imports.add("GET_CLIENT_DEP_FIELDS", 0, 1, 2, 0, null, null, 3, null, null);
            imports.add("GET_TIMESTAMPS", 0, 1, 2, 0, null, null, 3, null, null);
            imports.add("DO_NOT_RESOLVE_SIMPLE_TYPES", 0, 1, 2, 0, null, null, 3, null, null);
            imports.lock();
            DefaultListMetaData tables = new DefaultListMetaData("TABLES", 8);
            tables.add("FUNCTIONNAMES", 17, 0, 0, 0, null, null, 0, RFCFUNCTIONNAME, null);
            tables.add("DATATYPES", 17, 0, 0, 0, null, null, 0, RFC_MD_DDIC_NAME, null);
            tables.add("KNOWN_DATATYPES", 17, 0, 0, 0, null, null, 0, RFC_MD_DDIC_NAME, null);
            tables.add("PARAMETERS", 17, 0, 0, 0, null, null, 0, RFC_METADATA_PARAMS, null);
            tables.add("DATATYPESCONT", 17, 0, 0, 0, null, null, 0, RFC_METADATA_DDIC, null);
            tables.add("INDIRECTTYPES", 17, 0, 0, 0, null, null, 0, RFC_METADATA_DDIC_INDIRECT, null);
            tables.add("FUNC_ERRORS", 17, 0, 0, 0, null, null, 0, RFC_FUNC_ERROR, null);
            tables.add("DD_ERRORS", 17, 0, 0, 0, null, null, 0, RFC_DD_ERROR, null);
            tables.lock();
            this.rfcMetadataGetTemplate = new AbapFunctionTemplate("RFC_METADATA_GET", imports, null, null, tables, new AbapExceptionModel[]{new AbapExceptionModel("INVALID_MODE", null), new AbapExceptionModel("INTERNAL_ERROR", null)}, false);
        }
        return this.rfcMetadataGetTemplate;
    }

    @Override
    public String getMetaDataRelease() {
        return this.partnerRelease;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbapRepositoryMonitor getMonitor() {
        if (this.monitor == null) {
            Object object = this.semaphore;
            synchronized (object) {
                if (this.monitor == null) {
                    this.monitor = new AbapRepositoryMonitor();
                }
            }
        }
        return this.monitor;
    }

    static /* synthetic */ DefaultRecordMetaData access$001(AbapRepository x0, String x1) throws JCoException {
        return super.getRecordMetaData(x1);
    }

    static /* synthetic */ DefaultRecordMetaData access$101(AbapRepository x0, String x1) throws JCoException {
        return super.getRecordMetaData(x1);
    }

    static {
        getFunctionInterfaceTables_v5 = getFunctionInterfaceTables_v4 = getFunctionInterfaceTables_v2;
        getStructureDefinitionImports_v2 = new DefaultListMetaData("STRDEFIMP", 1);
        getStructureDefinitionImports_v3 = new DefaultListMetaData("STRDEFIMP", 1);
        getStructureDefinitionExports = new DefaultListMetaData("STRDEFEXP", 1);
        getStructureDefinitionTables_v2 = new DefaultListMetaData("STRDEFTAB", 1);
        getStructureDefinitionTables_v3 = new DefaultListMetaData("STRDEFTAB", 1);
        ddifFieldInfoGetImports = new DefaultListMetaData("DDIFIMP", 4);
        ddifFieldInfoGetExports_v4 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetExports_v462 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetExports_v5 = new DefaultListMetaData("DDIFEXP", 4);
        ddifFieldInfoGetTables_v4 = new DefaultListMetaData("DDIFTAB", 1);
        ddifFieldInfoGetTables_v5 = new DefaultListMetaData("DDIFTAB", 1);
        ddifFieldInfoGetNUC = new byte[]{1};
        ddifFieldInfoGetUC = new byte[]{2};
        functionImportInterfaceImports = new DefaultListMetaData("FUNIMPINTIMP", 1);
        functionImportInterfaceTables = new DefaultListMetaData("FUNIMPINTTAB", 2);
        seoGetClifRemoteImports = new DefaultListMetaData("IMPORTS", 2);
        seoGetClifRemoteExports = new DefaultListMetaData("EXPORTS", 3);
        ddGetClidepStructImports = new DefaultListMetaData("IMPORTS", 2);
        ddGetClidepStructExports = new DefaultListMetaData("EXPORTS", 3);
        ABAP_TYPES = new String[]{"b", "I", "P", "D", "N", "T", "C", "F", "s", "X", "STRING", "XSTRING", "u", "v", "h", "DECFLOAT16", "DECFLOAT34", "BREF", "BRFG", "INT8"};
        ABAP_EXIDS = new char[]{'b', 'I', 'P', 'D', 'N', 'T', 'C', 'F', 's', 'X', 'g', 'y', 'u', 'v', 'h', 'a', 'e', 'j', 'k', '8'};
        funint_v2.add("PARAMCLASS", 0, 1, 0, 2, 0);
        funint_v2.add("PARAMETER", 0, 30, 1, 60, 2);
        funint_v2.add("TABNAME", 0, 30, 31, 60, 62);
        funint_v2.add("FIELDNAME", 0, 30, 61, 60, 122);
        funint_v2.add("EXID", 0, 1, 91, 2, 182);
        funint_v2.add("POSITION", 8, 4, 92, 4, 184);
        funint_v2.add("OFFSET", 8, 4, 96, 4, 188);
        funint_v2.add("INTLENGTH", 8, 4, 100, 4, 192);
        funint_v2.add("DECIMALS", 8, 4, 104, 4, 196);
        funint_v2.add("DEFAULT", 0, 21, 108, 42, 200);
        funint_v2.add("PARAMTEXT", 0, 79, 129, 158, 242);
        funint_v2.add("OPTIONAL", 0, 1, 208, 2, 400);
        funint_v2.setRecordLength(216, 404);
        funint_v2.lock();
        fields_v2.add("TABNAME", 0, 30, 0, 0, 0);
        fields_v2.add("FIELDNAME", 0, 30, 30, 0, 0);
        fields_v2.add("POSITION", 8, 4, 60, 0, 0);
        fields_v2.add("OFFSET", 8, 4, 64, 0, 0);
        fields_v2.add("INTLENGTH", 8, 4, 68, 0, 0);
        fields_v2.add("DECIMALS", 8, 4, 72, 0, 0);
        fields_v2.add("EXID", 0, 1, 76, 0, 0);
        fields_v2.setRecordLength(77, 0);
        fields_v2.lock();
        funint_v3.add("PARAMCLASS", 0, 1, 0, 0, 0);
        funint_v3.add("PARAMETER", 0, 30, 1, 0, 0);
        funint_v3.add("TABNAME", 0, 10, 31, 0, 0);
        funint_v3.add("FIELDNAME", 0, 10, 41, 0, 0);
        funint_v3.add("EXID", 0, 1, 51, 0, 0);
        funint_v3.add("POSITION", 8, 4, 52, 0, 0);
        funint_v3.add("OFFSET", 8, 4, 56, 0, 0);
        funint_v3.add("INTLENGTH", 8, 4, 60, 0, 0);
        funint_v3.add("DECIMALS", 8, 4, 64, 0, 0);
        funint_v3.add("DEFAULT", 0, 21, 68, 0, 0);
        funint_v3.add("PARAMTEXT", 0, 79, 89, 0, 0);
        funint_v3.setRecordLength(168, 0);
        funint_v3.lock();
        fields_v3.add("TABNAME", 0, 10, 0, 0, 0);
        fields_v3.add("FIELDNAME", 0, 10, 10, 0, 0);
        fields_v3.add("POSITION", 8, 4, 20, 0, 0);
        fields_v3.add("OFFSET", 8, 4, 24, 0, 0);
        fields_v3.add("INTLENGTH", 8, 4, 28, 0, 0);
        fields_v3.add("DECIMALS", 8, 4, 32, 0, 0);
        fields_v3.add("EXID", 0, 1, 36, 0, 0);
        fields_v3.setRecordLength(40, 0);
        fields_v3.lock();
        rsimp_v3.add("PARAMETER", 0, 30, 0, 0, 0);
        rsimp_v3.add("DBFIELD", 0, 26, 30, 0, 0);
        rsimp_v3.add("DEFAULT", 0, 21, 56, 0, 0);
        rsimp_v3.add("TYPES", 0, 1, 77, 0, 0);
        rsimp_v3.add("OPTIONAL", 0, 1, 78, 0, 0);
        rsimp_v3.add("REFERENCE", 0, 1, 79, 0, 0);
        rsimp_v3.add("CHANGING", 0, 1, 80, 0, 0);
        rsimp_v3.add("TYP", 0, 30, 81, 0, 0);
        rsimp_v3.setRecordLength(112, 0);
        rsimp_v3.lock();
        rstbl_v3.add("PARAMETER", 0, 30, 0, 0, 0);
        rstbl_v3.add("DBSTRUCT", 0, 26, 30, 0, 0);
        rstbl_v3.add("TYPES", 0, 1, 56, 0, 0);
        rstbl_v3.add("OPTIONAL", 0, 1, 57, 0, 0);
        rstbl_v3.add("TYP", 0, 30, 58, 0, 0);
        rstbl_v3.setRecordLength(88, 0);
        rstbl_v3.lock();
        x030l_v4.add("TABNAME", 0, 30, 0, 0, 0);
        x030l_v4.add("DBASE", 0, 1, 30, 0, 0);
        x030l_v4.add("UUID", 4, 16, 31, 0, 0);
        x030l_v4.add("CRSTAMP", 0, 14, 47, 0, 0);
        x030l_v4.add("ABSTAMP", 0, 14, 61, 0, 0);
        x030l_v4.add("DYSTAMP", 0, 14, 75, 0, 0);
        x030l_v4.add("FLDCNT", 4, 2, 89, 0, 0);
        x030l_v4.add("TABLEN", 4, 2, 91, 0, 0);
        x030l_v4.add("KEYCNT", 4, 1, 93, 0, 0);
        x030l_v4.add("KEYLEN", 4, 1, 94, 0, 0);
        x030l_v4.add("CLPOS", 4, 1, 95, 0, 0);
        x030l_v4.add("TABTYPE", 0, 1, 96, 0, 0);
        x030l_v4.add("TABFORM", 0, 1, 97, 0, 0);
        x030l_v4.add("REFNAME", 0, 30, 98, 0, 0);
        x030l_v4.add("FLAGBYTE", 4, 1, 128, 0, 0);
        x030l_v4.add("EXROUT", 4, 1, 129, 0, 0);
        x030l_v4.add("FLAG3", 4, 1, 130, 0, 0);
        x030l_v4.add("FLAG4", 4, 1, 131, 0, 0);
        x030l_v4.add("FLAG5", 4, 1, 132, 0, 0);
        x030l_v4.add("FLAG6", 4, 1, 133, 0, 0);
        x030l_v4.add("BUFSTATE", 0, 1, 134, 0, 0);
        x030l_v4.add("BUFPARM", 4, 2, 135, 0, 0);
        x030l_v4.add("ALIGN", 4, 1, 137, 0, 0);
        x030l_v4.add("POINTERLG", 4, 1, 138, 0, 0);
        x030l_v4.add("UNICODELG", 4, 1, 139, 0, 0);
        x030l_v4.setRecordLength(140, 0);
        x030l_v4.lock();
        dfies_v4.add("TABNAME", 0, 30, 0, 60, 0);
        dfies_v4.add("FIELDNAME", 0, 30, 30, 60, 60);
        dfies_v4.add("LANGU", 0, 1, 60, 2, 120);
        dfies_v4.add("POSITION", 6, 4, 61, 8, 122);
        dfies_v4.add("OFFSET", 6, 6, 65, 12, 130);
        dfies_v4.add("DOMNAME", 0, 30, 71, 60, 142);
        dfies_v4.add("ROLLNAME", 0, 30, 101, 60, 202);
        dfies_v4.add("CHECKTABLE", 0, 30, 131, 60, 262);
        dfies_v4.add("LENG", 6, 6, 161, 12, 322);
        dfies_v4.add("INTLEN", 6, 6, 167, 12, 334);
        dfies_v4.add("OUTPUTLEN", 6, 6, 173, 12, 346);
        dfies_v4.add("DECIMALS", 6, 6, 179, 12, 358);
        dfies_v4.add("DATATYPE", 0, 4, 185, 8, 370);
        dfies_v4.add("INTTYPE", 0, 1, 189, 2, 378);
        dfies_v4.add("REFTABLE", 0, 30, 190, 60, 380);
        dfies_v4.add("REFFIELD", 0, 30, 220, 60, 440);
        dfies_v4.add("PRECFIELD", 0, 30, 250, 60, 500);
        dfies_v4.add("AUTHORID", 0, 3, 280, 6, 560);
        dfies_v4.add("MEMORYID", 0, 20, 283, 40, 566);
        dfies_v4.add("LOGFLAG", 0, 1, 303, 2, 606);
        dfies_v4.add("MASK", 0, 20, 304, 40, 608);
        dfies_v4.add("MASKLEN", 6, 4, 324, 8, 648);
        dfies_v4.add("CONVEXIT", 0, 5, 328, 10, 656);
        dfies_v4.add("HEADLEN", 6, 2, 333, 4, 666);
        dfies_v4.add("SCRLEN1", 6, 2, 335, 4, 670);
        dfies_v4.add("SCRLEN2", 6, 2, 337, 4, 674);
        dfies_v4.add("SCRLEN3", 6, 2, 339, 4, 678);
        dfies_v4.add("FIELDTEXT", 0, 60, 341, 120, 682);
        dfies_v4.add("REPTEXT", 0, 55, 401, 110, 802);
        dfies_v4.add("SCRTEXT_S", 0, 10, 456, 20, 912);
        dfies_v4.add("SCRTEXT_M", 0, 20, 466, 40, 932);
        dfies_v4.add("SCRTEXT_L", 0, 40, 486, 80, 972);
        dfies_v4.add("KEYFLAG", 0, 1, 526, 2, 1052);
        dfies_v4.add("LOWERCASE", 0, 1, 527, 2, 1054);
        dfies_v4.add("MAC", 0, 1, 528, 2, 1056);
        dfies_v4.add("GENKEY", 0, 1, 529, 2, 1058);
        dfies_v4.add("NOFORKEY", 0, 1, 530, 2, 1060);
        dfies_v4.add("VALEXI", 0, 1, 531, 2, 1062);
        dfies_v4.add("NOAUTHCH", 0, 1, 532, 2, 1064);
        dfies_v4.add("SIGN", 0, 1, 533, 2, 1066);
        dfies_v4.add("DYNPFLD", 0, 1, 534, 2, 1068);
        dfies_v4.add("F4AVAILABL", 0, 1, 535, 2, 1070);
        dfies_v4.setRecordLength(536, 1072);
        dfies_v4.lock();
        ddtypelist_v4.add("TYPENAME", 0, 30, 0, 60, 0);
        ddtypelist_v4.add("TYPEKIND", 0, 4, 30, 8, 60);
        ddtypelist_v4.add("FIELDS", 99, 8, 34, 8, 72, 0, null, dfies_v4, null);
        ddtypelist_v4.setRecordLength(48, 80);
        ddtypelist_v4.lock();
        x030l_v5.add("TABNAME", 0, 30, 0, 60, 0);
        x030l_v5.add("DBASE", 0, 1, 30, 2, 60);
        x030l_v5.add("UUID", 4, 16, 31, 16, 62);
        x030l_v5.add("CRSTAMP", 0, 14, 47, 28, 78);
        x030l_v5.add("ABSTAMP", 0, 14, 61, 28, 106);
        x030l_v5.add("DYSTAMP", 0, 14, 75, 28, 134);
        x030l_v5.add("FLDCNT", 4, 2, 89, 2, 162);
        x030l_v5.add("TABLEN", 4, 4, 91, 4, 164);
        x030l_v5.add("KEYCNT", 4, 1, 95, 1, 168);
        x030l_v5.add("KEYLEN", 4, 2, 96, 2, 169);
        x030l_v5.add("CLPOS", 4, 1, 98, 1, 171);
        x030l_v5.add("TABTYPE", 0, 1, 99, 2, 172);
        x030l_v5.add("TABFORM", 0, 1, 100, 2, 174);
        x030l_v5.add("REFNAME", 0, 30, 101, 60, 176);
        x030l_v5.add("FLAGBYTE", 4, 1, 131, 1, 236);
        x030l_v5.add("EXROUT", 4, 1, 132, 1, 237);
        x030l_v5.add("FLAG3", 4, 1, 133, 1, 238);
        x030l_v5.add("FLAG4", 4, 1, 134, 1, 239);
        x030l_v5.add("FLAG5", 4, 1, 135, 1, 240);
        x030l_v5.add("FLAG6", 4, 1, 136, 1, 241);
        x030l_v5.add("BUFSTATE", 0, 1, 137, 2, 242);
        x030l_v5.add("BUFPARM", 4, 2, 138, 2, 244);
        x030l_v5.add("ALIGN", 4, 1, 140, 1, 246);
        x030l_v5.add("POINTERLG", 4, 1, 141, 1, 247);
        x030l_v5.add("UNICODELG", 4, 1, 142, 1, 248);
        x030l_v5.add("COMPCNT", 4, 2, 143, 2, 249);
        x030l_v5.add("LEAFCNT", 4, 2, 145, 2, 251);
        x030l_v5.setRecordLength(147, 254);
        x030l_v5.lock();
        dfies_v5.copy(dfies_v4);
        dfies_v5.add("COMPTYPE", 0, 1, 536, 2, 1072);
        dfies_v5.add("LFIELDNAME", 0, 132, 537, 264, 1074);
        dfies_v5.setRecordLength(669, 1338);
        dfies_v5.lock();
        ddtypelist_v5.add("TYPENAME", 0, 30, 0, 60, 0);
        ddtypelist_v5.add("TYPEKIND", 0, 4, 30, 8, 60);
        ddtypelist_v5.add("FIELDS", 99, 8, 34, 8, 72, 0, null, dfies_v5, null);
        ddtypelist_v5.setRecordLength(48, 80);
        ddtypelist_v5.lock();
        typeSEO_ATTRIBUTES_REMOTE.add("CLIF_NAME", 0, 30, 0, 60, 0);
        typeSEO_ATTRIBUTES_REMOTE.add("ATTRIBUTE_NAME", 0, 30, 30, 60, 60);
        typeSEO_ATTRIBUTES_REMOTE.add("VISIBILITY", 6, 1, 60, 2, 120);
        typeSEO_ATTRIBUTES_REMOTE.add("ATTRIBUTE_KIND", 6, 1, 61, 2, 122);
        typeSEO_ATTRIBUTES_REMOTE.add("READ_ONLY", 0, 1, 62, 2, 124);
        typeSEO_ATTRIBUTES_REMOTE.add("RTTI_TYPE", 29, 8, 64, 8, 128);
        typeSEO_ATTRIBUTES_REMOTE.add("DATA_TYPE", 0, 1, 72, 2, 136);
        typeSEO_ATTRIBUTES_REMOTE.add("TYPE_NAME", 29, 8, 76, 8, 140);
        typeSEO_ATTRIBUTES_REMOTE.add("FIELD_NAME", 0, 30, 84, 60, 148);
        typeSEO_ATTRIBUTES_REMOTE.add("LENGTH", 8, 4, 116, 4, 208);
        typeSEO_ATTRIBUTES_REMOTE.add("DECIMALS", 8, 4, 120, 4, 212);
        typeSEO_ATTRIBUTES_REMOTE.add("DEFAULT_VALUE", 0, 132, 124, 264, 216);
        typeSEO_ATTRIBUTES_REMOTE.add("DESCRIPTION", 0, 60, 256, 120, 480);
        typeSEO_ATTRIBUTES_REMOTE.setRecordLength(316, 600);
        typeSEO_ATTRIBUTES_REMOTE.lock();
        typeSEO_CLSKEYS.add("CLSNAME", 0, 30, 0, 60, 0);
        typeSEO_CLSKEYS.setRecordLength(30, 60);
        typeSEO_CLSKEYS.lock();
        typeDDNTABTMSTS.add("CLSNAME", 0, 14, 0, 28, 0);
        typeDDNTABTMSTS.add("CLSNAME", 0, 14, 14, 28, 28);
        typeDDNTABTMSTS.add("CLSNAME", 0, 14, 28, 28, 56);
        typeDDNTABTMSTS.setRecordLength(42, 84);
        typeDDNTABTMSTS.lock();
        getStructureDefinitionImports_v2.add("TABNAME", 0, 30, 60, 2);
        getStructureDefinitionImports_v2.lock();
        getStructureDefinitionImports_v3.add("TABNAME", 0, 10, 20, 2);
        getStructureDefinitionImports_v3.lock();
        getStructureDefinitionExports.add("TABLENGTH", 8, 4, 4, 4);
        getStructureDefinitionExports.lock();
        getStructureDefinitionTables_v2.add("FIELDS", 17, fields_v2, 0);
        getStructureDefinitionTables_v2.lock();
        getStructureDefinitionTables_v3.add("FIELDS", 17, fields_v3, 0);
        getStructureDefinitionTables_v3.lock();
        getFunctionInterfaceImports.add("FUNCNAME", 0, 30, 60, 2);
        getFunctionInterfaceImports.add("NONE_UNICODE_LENGTH", 0, 1, 2, 3);
        getFunctionInterfaceImports.lock();
        getFunctionInterfaceExports.add("REMOTE_BASXML_SUPPORTED", 0, 1, 2, 4);
        getFunctionInterfaceExports.lock();
        getFunctionInterfaceTables_v2.add("PARAMS", 17, funint_v2, 0);
        getFunctionInterfaceTables_v2.lock();
        getFunctionInterfaceTables_v3.add("PARAMS", 17, funint_v3, 0);
        getFunctionInterfaceTables_v3.lock();
        functionImportInterfaceImports.add("FUNCNAME", 0, 30, 0, 2);
        functionImportInterfaceImports.lock();
        functionImportInterfaceTables.add("IMPORT_PARAMETER", 17, rsimp_v3, 0);
        functionImportInterfaceTables.add("TABLES_PARAMETER", 17, rstbl_v3, 0);
        functionImportInterfaceTables.lock();
        ddifFieldInfoGetImports.add("TABNAME", 0, 30, 60, 2);
        ddifFieldInfoGetImports.add("ALL_TYPES", 0, 1, 2, 3);
        ddifFieldInfoGetImports.add("LFIELDNAME", 0, 132, 264, 3);
        ddifFieldInfoGetImports.add("UCLEN", 4, 1, 1, 3);
        ddifFieldInfoGetImports.lock();
        ddifFieldInfoGetExports_v4.add("DFIES_WA", 17, dfies_v4, 4);
        ddifFieldInfoGetExports_v4.add("X030L_WA", 17, x030l_v4, 4);
        ddifFieldInfoGetExports_v4.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v4.add("LINES_DESCR", 99, ddtypelist_v4, 4);
        ddifFieldInfoGetExports_v4.lock();
        ddifFieldInfoGetExports_v462.add("DFIES_WA", 17, dfies_v5, 4);
        ddifFieldInfoGetExports_v462.add("X030L_WA", 17, x030l_v4, 4);
        ddifFieldInfoGetExports_v462.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v462.add("LINES_DESCR", 99, ddtypelist_v5, 4);
        ddifFieldInfoGetExports_v462.lock();
        ddifFieldInfoGetTables_v4.add("DFIES_TAB", 17, dfies_v4, 0);
        ddifFieldInfoGetTables_v4.lock();
        ddifFieldInfoGetExports_v5.add("DFIES_WA", 17, dfies_v5, 4);
        ddifFieldInfoGetExports_v5.add("X030L_WA", 17, x030l_v5, 4);
        ddifFieldInfoGetExports_v5.add("DDOBJTYPE", 0, 31, 62, 4);
        ddifFieldInfoGetExports_v5.add("LINES_DESCR", 99, ddtypelist_v5, 4);
        ddifFieldInfoGetExports_v5.lock();
        ddifFieldInfoGetTables_v5.add("DFIES_TAB", 17, dfies_v5, 0);
        ddifFieldInfoGetTables_v5.lock();
        seoGetClifRemoteImports.add("CLASS_KEY", 0, 30, 60, 2);
        seoGetClifRemoteImports.add("INCLUDE_INHERITED_ELEMENTS", 0, 1, 2, 3);
        seoGetClifRemoteImports.lock();
        seoGetClifRemoteExports.add("ATTRIBUTES", 99, typeSEO_ATTRIBUTES_REMOTE, 5);
        seoGetClifRemoteExports.add("IMPLEMENTED_INTERFACES", 99, typeSEO_CLSKEYS, 5);
        seoGetClifRemoteExports.add("PARENT_CLASSES", 99, typeSEO_CLSKEYS, 5);
        seoGetClifRemoteExports.lock();
        queryClassHierarchy = new QueryClassHierarchy();
        ddGetClidepStructImports.add("MAIN_STRUCTURE", 0, 30, 60, 2);
        ddGetClidepStructImports.lock();
        ddGetClidepStructExports.add("CLIDEP_STRUCTURE", 0, 30, 60, 5);
        ddGetClidepStructExports.add("CLIDEP_STRUCT_TMSTS", 17, typeDDNTABTMSTS, 5);
        ddGetClidepStructExports.add("NTAB_HDR", 17, x030l_v5, 5);
        ddGetClidepStructExports.add("NTAB_FIELDS", 99, dfies_v5, 5);
        ddGetClidepStructExports.lock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class AbapRepositoryMonitor
    extends BasicRepository.BasicRepositoryMonitor {
        AbapRepositoryMonitor() {
            super(AbapRepository.this);
        }

        @Override
        public long getLastRemoteQueryTimestamp() {
            return AbapRepository.this.lastRemoteQueryTimestamp;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<String> getDestinationIDs() {
            ArrayList<String> ids = new ArrayList<String>(AbapRepository.this.destinationList.size());
            DestinationList<InternalDestination> destinationList = AbapRepository.this.destinationList;
            synchronized (destinationList) {
                Iterator<InternalDestination> it = AbapRepository.this.destinationList.iterator();
                while (it.hasNext()) {
                    ids.add(it.next().getDestinationID());
                }
            }
            return ids;
        }

        @Override
        @Deprecated
        public JCoDestinationMonitor getRespositoryDestinationMonitor(String destinationID) {
            DefaultDestinationManager mgr = JCoRuntimeFactory.getRuntime().getDestinationManager();
            return mgr.getRepositoryDestinationMonitor(destinationID);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TurboDDICHelper
    extends DDICHelper {
        TurboDDICHelper() {
        }

        @Override
        JCoFunctionTemplate queryFunctionTemplate(String functionName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
            this.lookupMetadata(functionName, null, null, null, null, null, destination, useRepositoryPool);
            return AbapRepository.super.getFunctionTemplateFromCache(functionName);
        }

        @Override
        DefaultRecordMetaData queryRecordMetaData(String recordName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
            this.lookupMetadata(null, null, recordName, null, null, null, destination, useRepositoryPool);
            return AbapRepository.super.getRecordMetaDataFromCache(recordName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        RepositoryLoadResult lookupMetadata(String singleFunction, List<String> functions, String singleType, List<String> types, String singleClass, List<String> classes, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
            RepositoryLoadResult result = new RepositoryLoadResult();
            ClientConnection client = AbapRepository.this.getClient(destination, useRepositoryPool);
            try {
                JCoTable DD_ERRORS;
                JCoTable FUNC_ERRORS;
                String commentInfo = client.getAttributes().getSystemID() + "[TD]";
                JCoFunction rfcMdGet = AbapRepository.this.getRfcMetadataGetTemplate().getFunction();
                JCoTable FUNCTIONNAMES = rfcMdGet.getTableParameterList().getTable("FUNCTIONNAMES");
                if (singleFunction != null) {
                    FUNCTIONNAMES.appendRow();
                    FUNCTIONNAMES.setValue(0, singleFunction);
                }
                if (functions != null) {
                    for (String function : functions) {
                        FUNCTIONNAMES.appendRow();
                        FUNCTIONNAMES.setValue(0, function);
                    }
                }
                JCoTable DATATYPES = rfcMdGet.getTableParameterList().getTable("DATATYPES");
                if (singleType != null) {
                    DATATYPES.appendRow();
                    DATATYPES.setValue(0, singleType);
                }
                if (types != null) {
                    for (String type : types) {
                        DATATYPES.appendRow();
                        DATATYPES.setValue(0, type);
                    }
                }
                rfcMdGet.getImportParameterList().setValue("DEEP", "X");
                rfcMdGet.getImportParameterList().setValue("EVALUATE_LINKS", "X");
                rfcMdGet.getImportParameterList().setValue("GET_CLIENT_DEP_FIELDS", "X");
                rfcMdGet.getImportParameterList().setValue("DO_NOT_RESOLVE_SIMPLE_TYPES", "X");
                client.execute(rfcMdGet, (RepositoryProvider)AbapRepository.this);
                boolean isUnicode = client.getAttributes().getPartnerCodepage().startsWith("4");
                boolean requiresUnicode = client.getAttributes().getPartnerReleaseNumber() > 467;
                FUNCTIONNAMES = rfcMdGet.getTableParameterList().getTable("FUNCTIONNAMES");
                FUNCTIONNAMES.setRow(0);
                JCoTable PARAMS = rfcMdGet.getTableParameterList().getTable("PARAMETERS");
                JCoTable DATATYPESCONT = rfcMdGet.getTableParameterList().getTable("DATATYPESCONT");
                JCoTable INDIRECTTYPES = rfcMdGet.getTableParameterList().getTable("INDIRECTTYPES");
                Map<String, DefaultRecordMetaData> typesMap = this.processTypes(DATATYPESCONT, commentInfo);
                DATATYPES = rfcMdGet.getTableParameterList().getTable("DATATYPES");
                DATATYPES.setRow(0);
                ArrayList<String> allRequestedTypes = new ArrayList<String>();
                if (DATATYPES.getNumRows() > 0) {
                    DATATYPES.setRow(0);
                    do {
                        String tabName = DATATYPES.getString("TABNAME");
                        String fieldName = DATATYPES.getString("FIELDNAME");
                        if (fieldName.length() > 0) {
                            String findIndirectType = this.findIndirectType(tabName = tabName + "-" + fieldName, fieldName, INDIRECTTYPES);
                            if (findIndirectType != null) {
                                allRequestedTypes.add(findIndirectType);
                            }
                        } else {
                            allRequestedTypes.add(tabName);
                        }
                        result.add(RepositoryLoadResult.ElementType.TYPE, tabName, null);
                    } while (DATATYPES.nextRow());
                }
                this.addAllTypes(typesMap, allRequestedTypes);
                this.processFunctions(FUNCTIONNAMES, PARAMS, INDIRECTTYPES, typesMap, requiresUnicode, isUnicode, commentInfo);
                FUNCTIONNAMES = rfcMdGet.getTableParameterList().getTable("FUNCTIONNAMES");
                FUNCTIONNAMES.setRow(0);
                if (FUNCTIONNAMES.getNumRows() > 0) {
                    FUNCTIONNAMES.setRow(0);
                    do {
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, FUNCTIONNAMES.getString("FUNCTIONNAME"), null);
                    } while (FUNCTIONNAMES.nextRow());
                }
                if ((FUNC_ERRORS = rfcMdGet.getTableParameterList().getTable("FUNC_ERRORS")).getNumRows() > 0) {
                    FUNC_ERRORS.setRow(0);
                    do {
                        String error;
                        error = "FU_NOT_FOUND".equals(error = FUNC_ERRORS.getString("EXCEPTION")) ? "not found" : ("NO_RFC_FUNC".equals(error) ? "not RFC enabled" : "could not be queried. Caused by " + error + ": " + FUNC_ERRORS.getString("EXCEPTION_TEXT"));
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, FUNC_ERRORS.getString("FUNCNAME"), error);
                    } while (FUNC_ERRORS.nextRow());
                }
                if ((DD_ERRORS = rfcMdGet.getTableParameterList().getTable("DD_ERRORS")).getNumRows() > 0) {
                    DD_ERRORS.setRow(0);
                    do {
                        String error;
                        String typeName = DD_ERRORS.getString("TABNAME");
                        String field = DD_ERRORS.getString("FIELDNAME");
                        if (field.length() > 0) {
                            typeName = typeName + "-" + field;
                        }
                        error = "NOT_FOUND".equals(error = DD_ERRORS.getString("EXCEPTION")) ? "not found" : "could not be queried. Caused by " + error + ": " + DD_ERRORS.getString("EXCEPTION_TEXT");
                        result.add(RepositoryLoadResult.ElementType.TYPE, typeName, error);
                    } while (DD_ERRORS.nextRow());
                }
            }
            finally {
                if (client != null) {
                    AbapRepository.this.releaseClient(client, destination);
                }
            }
            if (singleClass != null) {
                try {
                    if (AbapRepository.this.queryClassMetaData(singleClass, destination, useRepositoryPool) != null) {
                        result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, null);
                    } else {
                        result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, "class not found");
                    }
                }
                catch (AbapException ae) {
                    result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, ae.getKey() + ": " + ae.getMessage());
                }
            }
            if (classes != null) {
                for (String aclass : classes) {
                    try {
                        if (AbapRepository.this.queryClassMetaData(aclass, destination, useRepositoryPool) != null) {
                            result.add(RepositoryLoadResult.ElementType.CLASS, aclass, null);
                            continue;
                        }
                        result.add(RepositoryLoadResult.ElementType.CLASS, aclass, "class not found");
                    }
                    catch (AbapException ae) {
                        result.add(RepositoryLoadResult.ElementType.CLASS, aclass, ae.getKey() + ": " + ae.getMessage());
                    }
                }
            }
            return result;
        }

        void processFunctions(JCoTable FUNCTIONNAMES, JCoTable PARAMS, JCoTable INDIRECTTYPES, Map<String, DefaultRecordMetaData> typesMap, boolean requiresUnicode, boolean isUnicode, String commentInfo) {
            String currentFunctionName = null;
            ArrayList<AbapExceptionModel> exceptionsList = null;
            JCoListMetaData imports = null;
            JCoListMetaData exports = null;
            JCoListMetaData changing = null;
            JCoListMetaData tables = null;
            boolean supportsASXML = false;
            block16: for (int f = 0; f < FUNCTIONNAMES.getNumRows(); ++f) {
                FUNCTIONNAMES.setRow(f);
                if (currentFunctionName != null) {
                    this.createFunctionTemplate(currentFunctionName, imports, exports, changing, tables, exceptionsList, supportsASXML, commentInfo, typesMap);
                }
                currentFunctionName = FUNCTIONNAMES.getString(0);
                imports = JCo.createListMetaData("INPUT");
                exports = JCo.createListMetaData("OUTPUT");
                changing = JCo.createListMetaData("CHANGING");
                tables = JCo.createListMetaData("TABLES");
                exceptionsList = new ArrayList<AbapExceptionModel>();
                boolean bl = supportsASXML = FUNCTIONNAMES.getChar("BASXML_SUPPORTED") == 'X';
                if (PARAMS.getRow() >= PARAMS.getNumRows()) continue;
                if (!currentFunctionName.equals(PARAMS.getString("FUNCNAME"))) {
                    for (int p = 0; p < PARAMS.getNumRows(); ++p) {
                        PARAMS.setRow(p);
                        if (currentFunctionName.equals(PARAMS.getString("FUNCNAME"))) break;
                    }
                }
                while (currentFunctionName.equals(PARAMS.getString("FUNCNAME"))) {
                    String description;
                    int nucByteLength;
                    char PARAMCLASS = PARAMS.getChar("PARAMCLASS");
                    String name = PARAMS.getString("PARAMETER");
                    String tabMetaData = PARAMS.getString("TABNAME");
                    Object tabMetaDataObject = tabMetaData;
                    String fieldName = PARAMS.getString("FIELDNAME");
                    int type = AbstractMetaData.getJCOType(PARAMS.getChar("EXID"));
                    if (type == -1) {
                        if (PARAMCLASS == 'X') {
                            type = 98;
                        } else if (PARAMCLASS == 'I' || PARAMCLASS == 'E' || PARAMCLASS == 'C') {
                            if (fieldName.length() != 0) {
                                String[] dataTypeName = new String[1];
                                type = this.getFieldRecordMetaData(typesMap.get(tabMetaData), fieldName, typesMap, dataTypeName);
                                tabMetaData = dataTypeName[0];
                            }
                            if (type == -1) {
                                for (int j = 0; j < ABAP_TYPES.length && type == -1; ++j) {
                                    if (!tabMetaData.equals(ABAP_TYPES[j])) continue;
                                    type = AbstractMetaData.getJCOType(ABAP_EXIDS[j]);
                                }
                            }
                        }
                    }
                    int ucByteLength = nucByteLength = PARAMS.getInt("INTLENGTH");
                    int decimals = PARAMS.getInt("DECIMALS");
                    String defaults = PARAMS.getString("DEFAULT");
                    if (defaults.length() == 0) {
                        defaults = null;
                    }
                    if ((description = PARAMS.getString("PARAMTEXT")).length() == 0) {
                        description = null;
                    }
                    char isOptional = PARAMS.getChar("OPTIONAL");
                    switch (type) {
                        case 0: 
                        case 1: 
                        case 3: 
                        case 6: {
                            if (isUnicode) {
                                nucByteLength = ucByteLength / 2;
                            } else {
                                ucByteLength = nucByteLength * 2;
                            }
                            if (requiresUnicode) break;
                            ucByteLength = 0;
                            break;
                        }
                        case 29: 
                        case 30: {
                            nucByteLength = 8;
                            ucByteLength = requiresUnicode ? nucByteLength : 0;
                            break;
                        }
                        case 16: 
                        case 17: 
                        case 31: 
                        case 32: 
                        case 99: {
                            DefaultRecordMetaData tabMD;
                            String realType;
                            if (fieldName.length() != 0 && (realType = this.findIndirectType(tabMetaData, fieldName, INDIRECTTYPES)) != null) {
                                tabMetaData = realType;
                            }
                            if ((tabMD = typesMap.get(tabMetaData)) != null) {
                                nucByteLength = tabMD.getRecordLength();
                                ucByteLength = requiresUnicode ? tabMD.getUnicodeRecordLength() : 0;
                                tabMetaDataObject = tabMD;
                                break;
                            }
                            throw new JCoRuntimeException(136, "Incomplete metadata returned by RFC_METADATA_GET. Missing data for " + tabMetaData + (fieldName.length() != 0 ? "-" + fieldName : ""));
                        }
                        case -1: {
                            throw new JCoRuntimeException(136, "Invalid type " + PARAMS.getChar("EXID") + " returned for parameter " + name + " by RFC_METADATA_GET");
                        }
                    }
                    switch (type) {
                        case -1: 
                        case 17: 
                        case 99: {
                            fieldName = null;
                            break;
                        }
                        default: {
                            if (fieldName.length() != 0) break;
                            fieldName = null;
                        }
                    }
                    int flags = 0;
                    switch (PARAMCLASS) {
                        case 'I': {
                            flags |= 2;
                            if (isOptional != ' ') {
                                flags |= 1;
                            }
                            imports.add(name, type, nucByteLength, ucByteLength, decimals, defaults, description, flags, tabMetaDataObject, fieldName, null);
                            break;
                        }
                        case 'E': {
                            exports.add(name, type, nucByteLength, ucByteLength, decimals, defaults, description, flags |= 5, tabMetaDataObject, fieldName, null);
                            break;
                        }
                        case 'C': {
                            flags |= 8;
                            if (isOptional != ' ') {
                                flags |= 1;
                            }
                            changing.add(name, type, nucByteLength, ucByteLength, decimals, defaults, description, flags, tabMetaDataObject, fieldName, null);
                            break;
                        }
                        case 'T': {
                            if (isOptional != ' ') {
                                flags |= 1;
                            }
                            tables.add(name, type, nucByteLength, ucByteLength, decimals, defaults, description, flags, tabMetaDataObject, null, null);
                            break;
                        }
                        case 'X': {
                            type = 98;
                            exceptionsList.add(new AbapExceptionModel(name, description));
                            break;
                        }
                    }
                    if (PARAMS.nextRow()) continue;
                    continue block16;
                }
            }
            if (currentFunctionName != null) {
                this.createFunctionTemplate(currentFunctionName, imports, exports, changing, tables, exceptionsList, supportsASXML, commentInfo, typesMap);
            }
        }

        JCoFunctionTemplate createFunctionTemplate(String functionName, JCoListMetaData imports, JCoListMetaData exports, JCoListMetaData changing, JCoListMetaData tables, List<AbapExceptionModel> exceptionsList, boolean supportsASXML, String commentInfo, Map<String, DefaultRecordMetaData> types) {
            AbapExceptionModel[] exceptions = null;
            int exceptionsLen = exceptionsList.size();
            if (exceptionsLen > 0) {
                exceptions = new AbapExceptionModel[exceptionsLen];
                exceptionsList.toArray(exceptions);
            }
            if (imports.getFieldCount() == 0) {
                imports = null;
            } else {
                if (imports instanceof DefaultListMetaData) {
                    ((DefaultListMetaData)imports).comment = commentInfo;
                }
                imports.lock();
            }
            if (exports.getFieldCount() == 0) {
                exports = null;
            } else {
                if (exports instanceof DefaultListMetaData) {
                    ((DefaultListMetaData)exports).comment = commentInfo;
                }
                exports.lock();
            }
            if (changing.getFieldCount() == 0) {
                changing = null;
            } else {
                if (changing instanceof DefaultListMetaData) {
                    ((DefaultListMetaData)changing).comment = commentInfo;
                }
                changing.lock();
            }
            if (tables.getFieldCount() == 0) {
                tables = null;
            } else {
                if (tables instanceof DefaultListMetaData) {
                    ((DefaultListMetaData)tables).comment = commentInfo;
                }
                tables.lock();
            }
            AbapFunctionTemplate template = new AbapFunctionTemplate(functionName, imports, exports, changing, tables, exceptions, supportsASXML);
            template.comment = commentInfo;
            AbapRepository.this.addFunctionTemplate(template);
            return template;
        }

        private void addAllTypes(Map<String, DefaultRecordMetaData> types, List<String> additionalTypes) {
            int i;
            DefaultRecordMetaData recordMetaData;
            if (additionalTypes != null) {
                for (String requestedType : additionalTypes) {
                    recordMetaData = types.get(requestedType);
                    if (recordMetaData != null) continue;
                    throw new JCoRuntimeException(136, "Type " + requestedType + " not found in returned metadata set");
                }
            }
            DefaultRecordMetaData[] allTypes = types.values().toArray(new DefaultRecordMetaData[0]);
            for (i = 0; i < allTypes.length; ++i) {
                for (int j = 0; j < allTypes[i].numFields; ++j) {
                    int type = allTypes[i].getType(j);
                    if (type != 17 && type != 99) continue;
                    if (allTypes[i].getRecordTypeName(j) == null) {
                        throw new JCoRuntimeException(136, allTypes[i].getName() + " field " + i + " (" + allTypes[i].getName(j) + ") is table or structure, but type name not found in returned metadata");
                    }
                    recordMetaData = types.get(allTypes[i].getRecordTypeName(j));
                    if (recordMetaData == null) {
                        throw new JCoRuntimeException(136, allTypes[i].getName() + " field " + i + " (" + allTypes[i].getName(j) + ") type " + allTypes[i].getRecordTypeName(j) + " not found in returned metadata set");
                    }
                    allTypes[i].tabMeta[j] = recordMetaData;
                }
            }
            for (i = 0; i < allTypes.length; ++i) {
                if (allTypes[i].numOdata <= 0 || !BasicRepository.checkType1(allTypes[i])) continue;
                allTypes[i].markAsNestedType1Structure();
            }
            for (i = 0; i < allTypes.length; ++i) {
                allTypes[i].lock();
                AbapRepository.this.addRecordMetaData(allTypes[i]);
            }
        }

        Map<String, DefaultRecordMetaData> processTypes(JCoTable DATATYPESCONT, String commentInfo) {
            Hashtable<String, DefaultRecordMetaData> types = new Hashtable<String, DefaultRecordMetaData>();
            ArrayList<DefaultRecordMetaData> likeTypes = new ArrayList<DefaultRecordMetaData>();
            DefaultRecordMetaData md = null;
            for (int i = 0; i < DATATYPESCONT.getNumRows(); ++i) {
                DATATYPESCONT.setRow(i);
                char compType = DATATYPESCONT.getChar("COMPTYPE");
                if (compType == '_') continue;
                String typeName = DATATYPESCONT.getString("TYPENAME");
                String name = DATATYPESCONT.getString("FIELDNAME");
                int typeT = AbstractMetaData.getJCOType(DATATYPESCONT.getChar("INTTYPE"));
                if (typeT == -1) {
                    throw new RuntimeException("Undefined comptype");
                }
                int nucByteLength = DATATYPESCONT.getInt("INTLEN");
                int ucByteLength = DATATYPESCONT.getInt("INTLEN_UC");
                int nucByteOffset = DATATYPESCONT.getInt("OFFSET");
                int ucByteOffset = DATATYPESCONT.getInt("OFFSET_UC");
                int decimals = DATATYPESCONT.getInt("DECIMALS");
                String description = DATATYPESCONT.getString("DESCRIPTION");
                String tabMetaData = DATATYPESCONT.getString("FIELDTYPE");
                if (md == null || !md.getName().equals(typeName)) {
                    md = new DefaultRecordMetaData(typeName);
                    md.comment = commentInfo;
                    int tabLength = DATATYPESCONT.getInt("TABLENGTH");
                    int tabLengthUc = DATATYPESCONT.getInt("TABLENGTH_UC");
                    md.setRecordLength(tabLength, tabLengthUc);
                    if (compType == 'T') {
                        if (tabMetaData.length() > 0) {
                            md.setLineType(tabMetaData);
                        }
                        if (typeT == 17) {
                            likeTypes.add(md);
                        } else {
                            types.put(typeName, md);
                        }
                    } else {
                        types.put(typeName, md);
                    }
                }
                md.add(name, typeT, nucByteLength, nucByteOffset, ucByteLength, ucByteOffset, decimals, description, tabMetaData, null);
            }
            for (DefaultRecordMetaData lT : likeTypes) {
                String newRecordName = lT.getName();
                md = new DefaultRecordMetaData(newRecordName);
                DefaultRecordMetaData type = types.get(lT.getRecordTypeName(0));
                md.copy(type);
                md.recName = newRecordName;
                md.comment = commentInfo;
                md.setLineType(type.getName());
                md.setRecordLength(type.getRecordLength(), type.getUnicodeRecordLength());
                types.put(md.getName(), md);
            }
            return types;
        }

        String findIndirectType(String tabName, String fieldName, JCoTable INDIRECTTYPES) {
            for (int i = 0; i < INDIRECTTYPES.getNumRows(); ++i) {
                if (!tabName.equals(INDIRECTTYPES.getString(0)) || !fieldName.equals(INDIRECTTYPES.getString(1))) continue;
                return INDIRECTTYPES.getString(2);
            }
            return null;
        }

        private int getFieldRecordMetaData(DefaultRecordMetaData containerRecordMetaData, String fieldName, Map<String, DefaultRecordMetaData> typesMap, String[] typeName) {
            int fieldType = -1;
            if (containerRecordMetaData != null) {
                int indexOfDash = fieldName.indexOf(45);
                int afterLastIndexOfDash = 0;
                while (indexOfDash > 0) {
                    String currentField = fieldName.substring(afterLastIndexOfDash, indexOfDash);
                    if (containerRecordMetaData.hasField(currentField)) {
                        DefaultRecordMetaData nestedContainerRecordMetaData = (DefaultRecordMetaData)containerRecordMetaData.getRecordMetaData(currentField);
                        if (nestedContainerRecordMetaData == null) {
                            nestedContainerRecordMetaData = typesMap.get(containerRecordMetaData.getRecordTypeName(currentField));
                        }
                        if (nestedContainerRecordMetaData == null) {
                            throw new JCoRuntimeException(136, "Incomplete metadata returned by RFC_METADATA_GET. Missing data for nested metadata " + containerRecordMetaData.getRecordTypeName(currentField));
                        }
                        containerRecordMetaData = nestedContainerRecordMetaData;
                    }
                    afterLastIndexOfDash = indexOfDash + 1;
                    indexOfDash = fieldName.indexOf(45, afterLastIndexOfDash);
                }
                String lastFieldName = fieldName.substring(afterLastIndexOfDash);
                fieldType = containerRecordMetaData.getType(lastFieldName);
                typeName[0] = containerRecordMetaData.getRecordTypeName(lastFieldName);
            }
            return fieldType;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class DDICHelper {
        DDICHelper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        JCoFunctionTemplate queryFunctionTemplate(String functionName, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
            if (destForQueries == null) {
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Invalid destination reference encountered (destination is null)");
            }
            AbapFunctionTemplate functionTemplate = null;
            ClientConnection client = null;
            try {
                String tabname;
                String pdflt;
                char pclass;
                int irow;
                int version = AbapRepository.this.getVersion();
                JCoFunction rfcGetFunctionInterface = AbapRepository.this.getRfcGetFunctionInterfaceTemplate().getFunction();
                rfcGetFunctionInterface.getImportParameterList().setValue(0, functionName);
                if (AbapRepository.this.containsUnicodeInfo) {
                    rfcGetFunctionInterface.getImportParameterList().setValue(1, "X");
                }
                client = AbapRepository.this.getClient(destForQueries, useRepositoryPool);
                String commentInfo = client.getAttributes().getSystemID();
                client.execute(rfcGetFunctionInterface, (RepositoryProvider)AbapRepository.this);
                JCoTable funint = rfcGetFunctionInterface.getTableParameterList().getTable(0);
                boolean supportsASXML = false;
                int changingCount = 0;
                int importCount = 0;
                int exportCount = 0;
                int tableCount = 0;
                int exceptionCount = 0;
                block23: for (irow = 0; irow < funint.getNumRows(); ++irow) {
                    funint.setRow(irow);
                    pclass = funint.getChar(0);
                    switch (pclass) {
                        case 'I': {
                            ++importCount;
                            continue block23;
                        }
                        case 'E': {
                            ++exportCount;
                            continue block23;
                        }
                        case 'C': {
                            ++changingCount;
                            continue block23;
                        }
                        case 'T': {
                            ++tableCount;
                            continue block23;
                        }
                        case 'X': {
                            ++exceptionCount;
                            continue block23;
                        }
                    }
                }
                DefaultListMetaData template_imports = null;
                DefaultListMetaData template_exports = null;
                DefaultListMetaData template_changing = null;
                DefaultListMetaData template_tables = null;
                AbapExceptionModel[] exceptions = null;
                if (importCount > 0) {
                    template_imports = new DefaultListMetaData("INPUT", importCount);
                }
                if (exportCount > 0) {
                    template_exports = new DefaultListMetaData("OUTPUT", exportCount);
                }
                if (changingCount > 0) {
                    template_changing = new DefaultListMetaData("CHANGING", changingCount);
                }
                if (tableCount > 0) {
                    template_tables = new DefaultListMetaData("TABLES", tableCount);
                }
                if (exceptionCount > 0) {
                    exceptions = new AbapExceptionModel[exceptionCount];
                    exceptionCount = 0;
                }
                block24: for (irow = 0; irow < funint.getNumRows(); ++irow) {
                    funint.setRow(irow);
                    pclass = funint.getChar(0);
                    pdflt = version > 200 && version < 460 ? funint.getString(9).trim() : funint.getString(11);
                    tabname = funint.getString(2);
                    String fieldname = funint.getString(3);
                    String stype = funint.getString(4);
                    int ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                    String sdefault = null;
                    String descript = funint.getString(10).trim();
                    String string = descript = descript.length() > 0 ? descript : null;
                    if (ptype == -1 && (pclass == 'I' || pclass == 'E' || pclass == 'C')) {
                        for (int j = 0; j < ABAP_TYPES.length && ptype == -1; ++j) {
                            if (!tabname.equals(ABAP_TYPES[j])) continue;
                            ptype = AbstractMetaData.getJCOType(ABAP_EXIDS[j]);
                        }
                    }
                    if (version >= 462 && pclass != 'X' && pclass != 'T' && (ptype == -1 || ptype == 17 || ptype == 99)) {
                        JCoFunction ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                        JCoStructure dfies_wa2 = null;
                        JCoParameterList ddifImports = ddifFieldInfoGet.getImportParameterList();
                        JCoParameterList ddifExports = ddifFieldInfoGet.getExportParameterList();
                        ddifImports.setValue(0, tabname);
                        ddifImports.setValue(1, "X");
                        if (fieldname.length() > 0) {
                            ddifImports.setValue(2, fieldname);
                            ddifImports.setActive(3, false);
                            ddifExports.setActive(1, false);
                            ddifExports.setActive(2, false);
                            ddifExports.setActive(3, false);
                            client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                            dfies_wa2 = ddifExports.getStructure(0);
                            stype = dfies_wa2.getString(13);
                            ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                            if (ptype == 17 || ptype == 99) {
                                tabname = dfies_wa2.getString(6);
                            }
                        } else if (ptype == -1 || ptype == 17) {
                            ddifImports.setActive(2, false);
                            ddifImports.setActive(3, false);
                            ddifExports.setActive(0, false);
                            ddifExports.setActive(1, false);
                            ddifExports.setActive(3, false);
                            client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                            String ddobjtype = ddifExports.getString(2);
                            ptype = ddobjtype.equalsIgnoreCase("INTTAB") || ddobjtype.equalsIgnoreCase("TRANSP") || ddobjtype.equalsIgnoreCase("POOL") || ddobjtype.equalsIgnoreCase("CLUSTER") ? 17 : (ddobjtype.equalsIgnoreCase("TTYP") ? 99 : -1);
                        }
                    }
                    switch (ptype) {
                        case -1: 
                        case 17: 
                        case 99: {
                            fieldname = null;
                            break;
                        }
                        default: {
                            if (fieldname.length() != 0) break;
                            fieldname = null;
                        }
                    }
                    int flags = 0;
                    switch (pclass) {
                        case 'I': {
                            flags |= 2;
                            if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                flags |= 1;
                            }
                            if (ptype == -1) {
                                ptype = 17;
                            }
                            sdefault = (sdefault = funint.getString(9)).length() > 0 ? sdefault : null;
                            template_imports.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                            continue block24;
                        }
                        case 'E': {
                            flags |= 5;
                            if (ptype == -1) {
                                ptype = 17;
                            }
                            template_exports.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                            continue block24;
                        }
                        case 'C': {
                            flags |= 8;
                            if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                flags |= 1;
                            }
                            if (ptype == -1) {
                                ptype = 17;
                            }
                            sdefault = (sdefault = funint.getString(9)).length() > 0 ? sdefault : null;
                            template_changing.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, fieldname, null);
                            continue block24;
                        }
                        case 'T': {
                            if (pdflt.length() > 0 && pdflt.charAt(0) != ' ') {
                                flags |= 1;
                            }
                            if (ptype == -1) {
                                ptype = 17;
                            }
                            template_tables.add(funint.getString(1), ptype, funint.getInt(7), 0, funint.getInt(8), sdefault, descript, flags, tabname.length() == 0 ? null : tabname, null, null);
                            continue block24;
                        }
                        case 'X': {
                            ptype = 98;
                            if (descript == null) {
                                descript = funint.getString(1);
                            }
                            AbapExceptionModel ae = new AbapExceptionModel(funint.getString(1), descript);
                            exceptions[exceptionCount++] = ae;
                            continue block24;
                        }
                    }
                }
                if (AbapRepository.this.containsUnicodeInfo) {
                    AbstractMetaData[] templates = new AbstractMetaData[]{template_imports, template_exports, template_changing, template_tables};
                    for (int tidx = 0; tidx < templates.length; ++tidx) {
                        if (templates[tidx] == null) continue;
                        int numFields = templates[tidx].numFields;
                        block27: for (int field = 0; field < numFields; ++field) {
                            switch (templates[tidx].type[field]) {
                                case 0: 
                                case 1: 
                                case 3: 
                                case 6: {
                                    templates[tidx].length[1][field] = templates[tidx].length[0][field] * 2;
                                    continue block27;
                                }
                                case 17: 
                                case 99: {
                                    DefaultRecordMetaData subRecord;
                                    if (client != null) {
                                        AbapRepository.this.releaseClient(client, destForQueries);
                                        client = null;
                                    }
                                    if ((subRecord = AbapRepository.this.getRecordMetaData(templates[tidx].getRecordTypeName(field))) != null) {
                                        templates[tidx].length[1][field] = subRecord.getUnicodeRecordLength();
                                        templates[tidx].length[0][field] = subRecord.getRecordLength();
                                        continue block27;
                                    }
                                    templates[tidx].length[1][field] = 0;
                                    templates[tidx].length[0][field] = 0;
                                    continue block27;
                                }
                                default: {
                                    templates[tidx].length[1][field] = templates[tidx].length[0][field];
                                }
                            }
                        }
                    }
                    if (version >= 702) {
                        JCoParameterList exports = rfcGetFunctionInterface.getExportParameterList();
                        boolean bl = supportsASXML = exports.getChar(0) == 'X';
                    }
                }
                if (version > 200 && version < 460) {
                    JCoFunction functionImportInterface = AbapRepository.this.getFunctionImportInterfaceTemplate().getFunction();
                    functionImportInterface.getImportParameterList().setValue(0, functionName);
                    client.execute(functionImportInterface, (RepositoryProvider)AbapRepository.this);
                    JCoTable rsimp = functionImportInterface.getTableParameterList().getTable(0);
                    block28: for (irow = 0; irow < rsimp.getNumRows(); ++irow) {
                        rsimp.setRow(irow);
                        pdflt = rsimp.getString(4).trim();
                        if (pdflt.length() == 0) continue;
                        tabname = rsimp.getString(0);
                        for (int i = 0; i < template_imports.name.length; ++i) {
                            if (!template_imports.name[i].equals(tabname)) continue;
                            int n = i;
                            template_imports.flags[n] = (byte)(template_imports.flags[n] | 1);
                            continue block28;
                        }
                    }
                    JCoTable rstbl = functionImportInterface.getTableParameterList().getTable(1);
                    block30: for (irow = 0; irow < rstbl.getNumRows(); ++irow) {
                        rstbl.setRow(irow);
                        pdflt = rstbl.getString(3).trim();
                        if (pdflt.length() == 0) continue;
                        tabname = rstbl.getString(0);
                        for (int i = 0; i < template_tables.name.length; ++i) {
                            if (!template_tables.name[i].equals(tabname)) continue;
                            int n = i;
                            template_tables.flags[n] = (byte)(template_tables.flags[n] | 1);
                            continue block30;
                        }
                    }
                }
                if (template_imports != null) {
                    template_imports.comment = commentInfo;
                    template_imports.lock();
                }
                if (template_exports != null) {
                    template_exports.comment = commentInfo;
                    template_exports.lock();
                }
                if (template_changing != null) {
                    template_changing.comment = commentInfo;
                    template_changing.lock();
                }
                if (template_tables != null) {
                    template_tables.comment = commentInfo;
                    template_tables.lock();
                }
                functionTemplate = new AbapFunctionTemplate(functionName, template_imports, template_exports, template_changing, template_tables, exceptions, supportsASXML);
                functionTemplate.comment = commentInfo;
                if (client == null) return functionTemplate;
            }
            catch (Throwable throwable) {
                if (client == null) throw throwable;
                AbapRepository.this.releaseClient(client, destForQueries);
                throw throwable;
            }
            AbapRepository.this.releaseClient(client, destForQueries);
            return functionTemplate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        DefaultRecordMetaData queryRecordMetaData(String recordName, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
            meta = null;
            client = null;
            try {
                version = AbapRepository.this.getVersion();
                if (Trace.isOn(8)) {
                    Trace.fireTrace(8, new StringBuilder(150).append("[JCoAPI] JCoRepository.queryRecordMetaData(").append(recordName).append(") for repository ").append(AbapRepository.this.name).append(" version ").append(version).append(" using ").append(useRepositoryPool != false ? "repository destination " : "destination ").append(destination != null ? destination.getDestinationName() : "null").toString());
                }
                client = AbapRepository.this.getClient(destination, useRepositoryPool);
                commentInfo = client.getAttributes().getSystemID();
                if (version >= 200 && version < 300) {
                    rfcGetStructureDefinition = AbapRepository.this.getRfcGetStructureDefinitionTemplate().getFunction();
                    rfcGetStructureDefinition.getImportParameterList().setValue(0, recordName);
                    client.execute(rfcGetStructureDefinition, (RepositoryProvider)AbapRepository.this);
                    fields = rfcGetStructureDefinition.getTableParameterList().getTable(0);
                    num_rows = fields.getNumRows();
                    meta = new DefaultRecordMetaData(recordName, num_rows);
                    for (irow = 0; irow < num_rows; ++irow) {
                        fields.setRow(irow);
                        stype = fields.getString(6);
                        ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : ' ');
                        meta.add(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), 0, 0, fields.getInt(5), null, null, null);
                    }
                    meta.setRecordLength(rfcGetStructureDefinition.getExportParameterList().getInt(0), 0);
                    fields.firstRow();
                } else if (version >= 300 && version < 400) {
                    rfcGetStructureDefinition = AbapRepository.this.getRfcGetStructureDefinitionTemplate().getFunction();
                    rfcGetStructureDefinition.getImportParameterList().setValue(0, recordName);
                    client.execute(rfcGetStructureDefinition, (RepositoryProvider)AbapRepository.this);
                    fields = rfcGetStructureDefinition.getTableParameterList().getTable(0);
                    num_rows = fields.getNumRows();
                    meta = new DefaultRecordMetaData(recordName, num_rows);
                    meta.setRecordLength(rfcGetStructureDefinition.getExportParameterList().getInt(0), 0);
                    for (irow = 0; irow < num_rows; ++irow) {
                        fields.setRow(irow);
                        stype = fields.getString(6);
                        ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : ' ');
                        meta.add(fields.getString(1), ptype, fields.getInt(4), fields.getInt(3), 0, 0, fields.getInt(5), null, null, null);
                    }
                    fields.firstRow();
                } else if (version >= 400 && version < 462) {
                    ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                    ddifImports.setValue(0, recordName);
                    ddifImports.setValue(1, "X");
                    ddifImports.setActive(2, false);
                    ddifImports.setActive(3, false);
                    ddifExports.setActive(2, false);
                    ddifExports.setActive(3, false);
                    client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                    x030l_wa = ddifExports.getStructure(1);
                    dfies_wa = ddifExports.getStructure(0);
                    dfies_tab = ddifFieldInfoGet.getTableParameterList().getTable(0);
                    num_rows = dfies_tab.getNumRows();
                    if (num_rows == 0) {
                        ddifImports.setValue(0, dfies_wa.getString(6));
                        client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                    }
                    num_rows = dfies_tab.getNumRows();
                    meta = new DefaultRecordMetaData(recordName, num_rows);
                    meta.setRecordLength(x030l_wa.getInt(7), 0);
                    for (irow = 0; irow < num_rows; ++irow) {
                        dfies_tab.setRow(irow);
                        stype = dfies_tab.getString(13);
                        ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : ' ');
                        meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4), 0, 0, dfies_tab.getInt(11), dfies_tab.getString(27), dfies_tab.getString(6), null);
                    }
                    dfies_tab.firstRow();
                } else if (version >= 462) {
                    dfies_tab = null;
                    dfies_tab_UC = null;
                    ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                    if (AbapRepository.this.containsUnicodeInfo) {
                        ddifImports.setValue(3, AbapRepository.ddifFieldInfoGetNUC);
                    } else {
                        ddifImports.setActive(3, false);
                    }
                    ddifImports.setValue(0, recordName);
                    ddifImports.setValue(1, "X");
                    ddifImports.setActive(2, false);
                    ddifExports.setActive(2, false);
                    client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                    dfies_wa = ddifExports.getStructure(0);
                    x030l_wa = ddifExports.getStructure(1);
                    lines_descr = ddifExports.getTable(3);
                    dfies_tab = ddifFieldInfoGet.getTableParameterList().getTable(0);
                    dfies_wa_UC = null;
                    x030l_wa_UC = null;
                    lines_descr_UC = null;
                    if (AbapRepository.this.containsUnicodeInfo) {
                        ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                        ddifImports = ddifFieldInfoGet.getImportParameterList();
                        ddifExports = ddifFieldInfoGet.getExportParameterList();
                        ddifImports.setValue(0, recordName);
                        ddifImports.setValue(1, "X");
                        ddifImports.setActive(2, false);
                        ddifImports.setValue(3, AbapRepository.ddifFieldInfoGetUC);
                        ddifExports.setActive(2, false);
                        client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                        dfies_wa_UC = ddifExports.getStructure(0);
                        x030l_wa_UC = ddifExports.getStructure(1);
                        lines_descr_UC = ddifExports.getTable(3);
                        dfies_tab_UC = ddifFieldInfoGet.getTableParameterList().getTable(0);
                    }
                    meta = new DefaultRecordMetaData(recordName);
                    isStructureLineType = false;
                    if (x030l_wa.getChar(11) == 'L') {
                        if (lines_descr.getNumRows() == 1 && "STRU".equals(lines_descr.getString(1))) {
                            dfies_tab = lines_descr.getTable(2);
                            if (lines_descr_UC != null) {
                                dfies_tab_UC = lines_descr_UC.getTable(2);
                            }
                            meta.typeName = lines_descr.getString(0);
                            isStructureLineType = true;
                        } else if (dfies_tab.getNumRows() == 0) {
                            dfies_tab.copyFrom(dfies_wa);
                            if (dfies_wa_UC != null) {
                                dfies_tab_UC.copyFrom(dfies_wa_UC);
                            }
                            if (lines_descr.getNumRows() == 0 && (rollName = dfies_wa.getString(6)).length() > 0) {
                                meta.typeName = rollName;
                            }
                        }
                    }
                    isNestedType1 = ((flag3 = x030l_wa.getByteArray(16)[0]) & 1) != 0 && (flag3 & 2) == 0;
                    meta.setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                    meta.type1MetaData = isNestedType1 ? new DefaultRecordMetaData.Type1MetaData((DefaultRecordMetaData)meta) : null;
                    meta = this.constructMetaData(client, version, dfies_tab, (JCoTable)dfies_tab_UC, lines_descr, (JCoTable)lines_descr_UC, (DefaultRecordMetaData)meta, null, 0, 0, 1);
                    if (meta.type1MetaData != null) {
                        meta.type1MetaData.constructMetaData();
                    }
                    if (isStructureLineType) {
                        meta_new = new DefaultRecordMetaData(meta.typeName);
                        meta_new.copy((JCoRecordMetaData)meta);
                        meta_new.recName = meta.typeName;
                        meta_new.typeName = null;
                        if (meta_new.numOdata > 0 && BasicRepository.checkType1(meta_new)) {
                            meta_new.type1MetaData = new DefaultRecordMetaData.Type1MetaData(meta_new);
                            meta_new.type1MetaData.constructMetaData();
                        }
                        if (!meta_new.equals(cached = AbapRepository.access$001(AbapRepository.this, meta_new.getName()))) {
                            AbapRepository.this.addRecordMetaData(meta_new);
                        }
                    }
                    meta.comment = commentInfo;
                    cached = AbapRepository.access$101(AbapRepository.this, meta.getName());
                    if (!meta.equals(cached)) {
                        AbapRepository.this.addRecordMetaData((JCoRecordMetaData)meta);
                    }
                }
                ** if (client == null) goto lbl-1000
            }
            catch (Throwable var28_47) {
                if (client != null) {
                    AbapRepository.this.releaseClient(client, destination);
                }
                throw var28_47;
            }
lbl-1000:
            // 1 sources

            {
                AbapRepository.this.releaseClient(client, destination);
            }
lbl-1000:
            // 2 sources

            {
            }
            meta.lock();
            return meta;
        }

        DefaultRecordMetaData constructMetaData(ClientConnection client, int version, JCoTable dfies_tab, JCoTable dfies_tab_UC, JCoTable lines_descr, JCoTable lines_descr_UC, DefaultRecordMetaData meta, String lfieldname, int base_offset, int base_offset_UC, int level) throws JCoException {
            int num_rows = dfies_tab.getNumRows();
            if (num_rows == 0 || dfies_tab.getRow() >= num_rows) {
                return meta;
            }
            do {
                if (lfieldname != null && !dfies_tab.getString(43).startsWith(lfieldname)) {
                    if (level <= 1) break;
                    dfies_tab.previousRow();
                    if (dfies_tab_UC == null) break;
                    dfies_tab_UC.previousRow();
                    break;
                }
                char comptype = dfies_tab.getChar(42);
                String stype = dfies_tab.getString(13);
                int ptype = AbstractMetaData.getJCOType(stype.length() > 0 ? stype.charAt(0) : (char)' ');
                if (ptype == -1) {
                    String datatype = dfies_tab.getString(12);
                    if (datatype.equals("STRU")) {
                        ptype = 17;
                    } else if (datatype.equals("TTYP")) {
                        ptype = 99;
                    }
                }
                if (ptype == 17 || ptype == 99) {
                    DefaultRecordMetaData meta_new;
                    String rollname = dfies_tab.getString(6);
                    if (comptype == 'S') {
                        meta_new = new DefaultRecordMetaData(rollname);
                        meta_new.setRecordLength(dfies_tab.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9));
                        meta_new.type1MetaData = meta.isNestedType1Structure() ? new DefaultRecordMetaData.Type1MetaData(meta_new) : null;
                        String lfieldname_new = dfies_tab.getString(43) + "-";
                        int offset_new = dfies_tab.getInt(4);
                        int offset_UC_new = dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4);
                        meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                        dfies_tab.nextRow();
                        if (dfies_tab_UC != null) {
                            dfies_tab_UC.nextRow();
                        }
                        this.constructMetaData(client, version, dfies_tab, dfies_tab_UC, lines_descr, lines_descr_UC, meta_new, lfieldname_new, offset_new, offset_UC_new, level + 1);
                        if (meta.isNestedType1Structure() && meta_new.numOdata > 0) {
                            meta_new.type1MetaData.constructMetaData();
                            continue;
                        }
                        if (meta_new.numOdata > 0) {
                            if (!BasicRepository.checkType1(meta_new)) continue;
                            meta_new.type1MetaData = new DefaultRecordMetaData.Type1MetaData(meta_new);
                            meta_new.type1MetaData.constructMetaData();
                            continue;
                        }
                        meta_new.type1MetaData = null;
                        continue;
                    }
                    if (comptype == 'L' || comptype == 'T') {
                        meta_new = null;
                        if (comptype == 'T') {
                            meta.typeName = rollname;
                        }
                        if (rollname.length() > 0 && AbapRepository.this.containsRecordMetaData(rollname)) {
                            meta_new = AbapRepository.this.getRecordMetaData(rollname);
                            if (comptype == 'L' || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12))) {
                                meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                                continue;
                            }
                            String curr_rec_name = meta.recName;
                            meta.copy(meta_new);
                            meta.recName = curr_rec_name;
                            meta.typeName = meta_new.recName;
                            continue;
                        }
                        if (rollname.length() > 0) {
                            DefaultRecordMetaData cached;
                            JCoRecord x030l_wa_UC;
                            JCoStructure x030l_wa;
                            JCoParameterList ddifExports;
                            JCoParameterList ddifImports;
                            JCoFunction ddifFieldInfoGet;
                            JCoTable dfies_tab_new = null;
                            JCoTable dfies_tab_UC_new = null;
                            String typeKindInLinesDescriptor = null;
                            String rollname_new = rollname;
                            int irow = 0;
                            String dataType = null;
                            String rollNameTemp = null;
                            while (irow < lines_descr.getNumRows() && dfies_tab_new == null) {
                                lines_descr.setRow(irow);
                                if (lines_descr_UC != null) {
                                    lines_descr_UC.setRow(irow);
                                }
                                ++irow;
                                if (rollname_new.length() <= 0 || !lines_descr.getString(0).equals(rollname_new)) continue;
                                dfies_tab_new = lines_descr.getTable(2);
                                dfies_tab_new.firstRow();
                                typeKindInLinesDescriptor = lines_descr.getString(1);
                                if (lines_descr_UC != null) {
                                    dfies_tab_UC_new = lines_descr_UC.getTable(2);
                                    dfies_tab_UC_new.firstRow();
                                }
                                dataType = dfies_tab_new.getString(12);
                                rollNameTemp = dfies_tab_new.getString(6);
                                if (dfies_tab_new.getNumRows() != 1 || !dfies_tab_new.getString(42).equals("T")) continue;
                                if (rollNameTemp.length() == 0) {
                                    rollname_new = null;
                                    continue;
                                }
                                if (rollNameTemp.equals(dfies_tab_new.getString(5))) {
                                    rollname_new = rollNameTemp;
                                    continue;
                                }
                                if ("STRU".equals(dataType)) {
                                    rollname_new = rollNameTemp;
                                    dfies_tab_new = null;
                                    dfies_tab_UC_new = null;
                                    irow = 0;
                                    continue;
                                }
                                if (!"TTYP".equals(dataType)) continue;
                                rollname_new = rollNameTemp;
                            }
                            if (dfies_tab_new != null && (comptype == 'L' || dfies_tab.getNumRows() == 1 && "TTYP".equals(dfies_tab.getString(12)))) {
                                meta_new = new DefaultRecordMetaData(rollname);
                                meta_new.typeName = rollname_new;
                                ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                                ddifImports = ddifFieldInfoGet.getImportParameterList();
                                ddifExports = ddifFieldInfoGet.getExportParameterList();
                                ddifImports.setValue(0, rollname);
                                ddifImports.setValue(1, "X");
                                ddifImports.setActive(2, false);
                                if (AbapRepository.this.containsUnicodeInfo) {
                                    ddifImports.setValue(3, ddifFieldInfoGetNUC);
                                } else {
                                    ddifImports.setActive(3, false);
                                }
                                ddifExports.setActive(0, false);
                                ddifExports.setActive(2, false);
                                ddifExports.setActive(3, false);
                                ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                                x030l_wa = ddifExports.getStructure(1);
                                x030l_wa_UC = null;
                                if (AbapRepository.this.containsUnicodeInfo) {
                                    ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                                    ddifImports.setValue(0, rollname);
                                    ddifImports.setValue(1, "X");
                                    ddifImports.setActive(2, false);
                                    ddifImports.setValue(3, ddifFieldInfoGetUC);
                                    ddifExports.setActive(0, false);
                                    ddifExports.setActive(2, false);
                                    ddifExports.setActive(3, false);
                                    ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                    client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                                    x030l_wa_UC = ddifExports.getStructure(1);
                                }
                                meta_new.setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                                this.constructMetaData(client, version, dfies_tab_new, dfies_tab_UC_new, lines_descr, lines_descr_UC, meta_new, null, 0, 0, level + 1);
                                if (rollname_new != null && rollname_new.length() > 0 && "STRU".equals(typeKindInLinesDescriptor) && (cached = AbapRepository.super.getRecordMetaData(rollname_new)) == null) {
                                    DefaultRecordMetaData lineType = new DefaultRecordMetaData(rollname_new);
                                    lineType.copy(meta_new);
                                    lineType.recName = rollname_new;
                                    lineType.typeName = null;
                                    if (lineType.numOdata > 0 && BasicRepository.checkType1(lineType)) {
                                        lineType.type1MetaData = new DefaultRecordMetaData.Type1MetaData(lineType);
                                        lineType.type1MetaData.constructMetaData();
                                    }
                                    lineType.comment = client.getAttributes().getSystemID();
                                    AbapRepository.this.addRecordMetaData(lineType);
                                }
                            } else {
                                if (dfies_tab_new != null && comptype == 'T') {
                                    ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                                    ddifImports = ddifFieldInfoGet.getImportParameterList();
                                    ddifExports = ddifFieldInfoGet.getExportParameterList();
                                    ddifImports.setValue(0, rollname);
                                    ddifImports.setValue(1, "X");
                                    ddifImports.setActive(2, false);
                                    if (AbapRepository.this.containsUnicodeInfo) {
                                        ddifImports.setValue(3, ddifFieldInfoGetNUC);
                                    } else {
                                        ddifImports.setActive(3, false);
                                    }
                                    ddifExports.setActive(0, false);
                                    ddifExports.setActive(2, false);
                                    ddifExports.setActive(3, false);
                                    ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                    client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                                    x030l_wa = ddifExports.getStructure(1);
                                    x030l_wa_UC = null;
                                    if (AbapRepository.this.containsUnicodeInfo) {
                                        ddifFieldInfoGet = AbapRepository.this.getDdifFieldInfoGetTemplate().getFunction();
                                        ddifImports = ddifFieldInfoGet.getImportParameterList();
                                        ddifExports = ddifFieldInfoGet.getExportParameterList();
                                        ddifImports.setValue(0, rollname);
                                        ddifImports.setValue(1, "X");
                                        ddifImports.setActive(2, false);
                                        ddifImports.setValue(3, ddifFieldInfoGetUC);
                                        ddifExports.setActive(0, false);
                                        ddifExports.setActive(2, false);
                                        ddifExports.setActive(3, false);
                                        ddifFieldInfoGet.getTableParameterList().setActive(0, false);
                                        client.execute(ddifFieldInfoGet, (RepositoryProvider)AbapRepository.this);
                                        x030l_wa_UC = ddifExports.getStructure(1);
                                    }
                                    meta.setRecordLength(x030l_wa.getInt(7), x030l_wa_UC == null ? 0 : x030l_wa_UC.getInt(7));
                                    this.constructMetaData(client, version, dfies_tab_new, dfies_tab_UC_new, lines_descr, lines_descr_UC, meta, null, 0, 0, level + 1);
                                    if (rollname_new == null || rollname_new.length() <= 0) continue;
                                    meta_new = new DefaultRecordMetaData(rollname_new);
                                    meta_new.copy(meta);
                                    meta_new.recName = rollname_new;
                                    meta_new.typeName = null;
                                    if (meta_new.numOdata > 0 && BasicRepository.checkType1(meta_new)) {
                                        meta_new.type1MetaData = new DefaultRecordMetaData.Type1MetaData(meta_new);
                                        meta_new.type1MetaData.constructMetaData();
                                    }
                                    meta_new.comment = client.getAttributes().getSystemID();
                                    cached = AbapRepository.super.getRecordMetaData(meta_new.getName());
                                    if (!meta_new.equals(cached)) {
                                        AbapRepository.this.addRecordMetaData(meta_new);
                                        continue;
                                    }
                                    meta_new = cached;
                                    continue;
                                }
                                String msg = new StringBuilder(200).append("Could not find referenced or embedded table/structure ").append(rollname).append(" which was requested by ").append(meta.getName()).append(", comptype=").append(comptype).toString();
                                Trace.fireTraceCritical("[JCoAPI] " + msg);
                                throw new JCoException(108, "JCO_ERROR_INTERNAL", msg);
                            }
                        }
                        meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), meta_new, null);
                        continue;
                    }
                    meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), dfies_tab.getString(6), null);
                    continue;
                }
                Object tabMetaData = null;
                if (ptype != 32) {
                    tabMetaData = dfies_tab.getString(6);
                    if (((String)tabMetaData).length() == 0) {
                        tabMetaData = null;
                    }
                } else {
                    tabMetaData = new DynamicRecordMetaData(dfies_tab.getString(14), meta.getName());
                }
                meta.add(dfies_tab.getString(1), ptype, dfies_tab.getInt(9), dfies_tab.getInt(4) - base_offset, dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(9), dfies_tab_UC == null ? 0 : dfies_tab_UC.getInt(4) - base_offset_UC, dfies_tab.getInt(11), dfies_tab.getString(27), tabMetaData, null);
            } while (dfies_tab.nextRow() && (dfies_tab_UC == null || dfies_tab_UC.nextRow()));
            meta.comment = client.getAttributes().getSystemID();
            DefaultRecordMetaData cached = AbapRepository.super.getRecordMetaData(meta.getName());
            if (!meta.equals(cached)) {
                AbapRepository.this.addRecordMetaData(meta);
            } else {
                meta = cached;
            }
            return meta;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void resolveDynamicRecordMetaData(DynamicRecordMetaData meta, InternalDestination destForQueries, boolean useRepositoryPool) throws JCoException {
            block6: {
                ClientConnection client = null;
                try {
                    JCoFunction ddGetClidepStruct = AbapRepository.this.getDdGetClidepStructTemplate().getFunction();
                    ddGetClidepStruct.getImportParameterList().setValue(0, meta.getParentStruct());
                    client = AbapRepository.this.getClient(destForQueries, useRepositoryPool);
                    client.execute(ddGetClidepStruct, (RepositoryProvider)AbapRepository.this);
                    JCoTable dfies_tab = ddGetClidepStruct.getExportParameterList().getTable("NTAB_FIELDS");
                    JCoTable lines_descr = null;
                    DefaultRecordMetaData rmd = new DefaultRecordMetaData(meta.getName());
                    this.constructMetaData(client, AbapRepository.this.getVersion(), dfies_tab, null, lines_descr, lines_descr, rmd, null, 0, 0, 1);
                    meta.merge(rmd);
                    meta.comment = meta.comment + "generic box " + destForQueries.getClient() + "/" + destForQueries.getAttributes().getSystemID();
                    meta.allTypesResolved = true;
                    AbapRepository.this.addRecordMetaData(meta);
                    if (client == null) break block6;
                }
                catch (AbapException aex) {
                    block7: {
                        try {
                            if (!"NO_STRUC_IN_THIS_CLIENT".equals(aex.getKey())) {
                                throw aex;
                            }
                            meta.allTypesResolved = true;
                            if (client == null) break block7;
                        }
                        catch (Throwable throwable) {
                            if (client != null) {
                                AbapRepository.this.releaseClient(client, destForQueries);
                            }
                            AbapRepository.this.lastRemoteQueryTimestamp = System.currentTimeMillis();
                            throw throwable;
                        }
                        AbapRepository.this.releaseClient(client, destForQueries);
                    }
                    AbapRepository.this.lastRemoteQueryTimestamp = System.currentTimeMillis();
                }
                AbapRepository.this.releaseClient(client, destForQueries);
            }
            AbapRepository.this.lastRemoteQueryTimestamp = System.currentTimeMillis();
        }

        RepositoryLoadResult lookupMetadata(String singleFunction, List<String> functions, String singleType, List<String> types, String singleClass, List<String> classes, InternalDestination destination, boolean useRepositoryPool) throws JCoException {
            RepositoryLoadResult result = new RepositoryLoadResult();
            if (singleFunction != null) {
                try {
                    if (this.queryFunctionTemplate(singleFunction, destination, useRepositoryPool) != null) {
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, singleFunction, null);
                    } else {
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, singleFunction, "function not found");
                    }
                }
                catch (AbapException ae) {
                    result.add(RepositoryLoadResult.ElementType.FUNCTION, singleFunction, ae.getKey() + ": " + ae.getMessage());
                }
            }
            if (functions != null) {
                for (String function : functions) {
                    try {
                        if (this.queryFunctionTemplate(function, destination, useRepositoryPool) != null) {
                            result.add(RepositoryLoadResult.ElementType.FUNCTION, function, null);
                            continue;
                        }
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, function, "function not found");
                    }
                    catch (AbapException ae) {
                        result.add(RepositoryLoadResult.ElementType.FUNCTION, function, ae.getKey() + ": " + ae.getMessage());
                    }
                }
            }
            if (singleType != null) {
                try {
                    if (this.queryRecordMetaData(singleType, destination, useRepositoryPool) != null) {
                        result.add(RepositoryLoadResult.ElementType.TYPE, singleType, null);
                    } else {
                        result.add(RepositoryLoadResult.ElementType.TYPE, singleType, "type not found");
                    }
                }
                catch (AbapException ae) {
                    result.add(RepositoryLoadResult.ElementType.TYPE, singleType, ae.getKey() + ": " + ae.getMessage());
                }
            }
            if (types != null) {
                for (String type : types) {
                    try {
                        if (this.queryRecordMetaData(type, destination, useRepositoryPool) != null) {
                            result.add(RepositoryLoadResult.ElementType.TYPE, type, null);
                            continue;
                        }
                        result.add(RepositoryLoadResult.ElementType.TYPE, type, "type not found");
                    }
                    catch (AbapException ae) {
                        result.add(RepositoryLoadResult.ElementType.TYPE, type, ae.getKey() + ": " + ae.getMessage());
                    }
                }
            }
            if (singleClass != null) {
                try {
                    if (AbapRepository.this.queryClassMetaData(singleClass, destination, useRepositoryPool) != null) {
                        result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, null);
                    } else {
                        result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, "class not found");
                    }
                }
                catch (AbapException ae) {
                    result.add(RepositoryLoadResult.ElementType.CLASS, singleClass, ae.getKey() + ": " + ae.getMessage());
                }
            }
            if (classes != null) {
                for (String aclass : classes) {
                    try {
                        if (AbapRepository.this.queryClassMetaData(aclass, destination, useRepositoryPool) != null) {
                            result.add(RepositoryLoadResult.ElementType.CLASS, aclass, null);
                            continue;
                        }
                        result.add(RepositoryLoadResult.ElementType.CLASS, aclass, "class not found");
                    }
                    catch (AbapException ae) {
                        result.add(RepositoryLoadResult.ElementType.CLASS, aclass, ae.getKey() + ": " + ae.getMessage());
                    }
                }
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RepositoryLoadResult
    implements JCoRepositoryQueryResult {
        Map<String, String> functions = null;
        Map<String, String> types = null;
        Map<String, String> classes = null;
        boolean querySuccessful = true;

        RepositoryLoadResult() {
        }

        void add(ElementType eType, String eName, String error) {
            switch (eType) {
                case FUNCTION: {
                    if (this.functions == null) {
                        this.functions = new HashMap<String, String>();
                    }
                    this.functions.put(eName, error);
                    break;
                }
                case TYPE: {
                    if (this.types == null) {
                        this.types = new HashMap<String, String>();
                    }
                    this.types.put(eName, error);
                    break;
                }
                case CLASS: {
                    if (this.classes == null) {
                        this.classes = new HashMap<String, String>();
                    }
                    this.classes.put(eName, error);
                    break;
                }
            }
            if (error != null) {
                this.querySuccessful = false;
            }
        }

        @Override
        public String getClassQueryError(String className) {
            if (this.classes != null && this.classes.containsKey(className)) {
                return this.classes.get(className);
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The class " + className + " was not requested.");
        }

        @Override
        public String getFunctionQueryError(String functionName) {
            if (this.functions != null && this.functions.containsKey(functionName)) {
                return this.functions.get(functionName);
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The function " + functionName + " was not requested.");
        }

        @Override
        public String getTypeQueryError(String typeName) {
            if (this.types != null && this.types.containsKey(typeName)) {
                return this.types.get(typeName);
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The type " + typeName + " was not requested.");
        }

        @Override
        public boolean isClassQuerySuccessful(String className) {
            if (this.classes != null && this.classes.containsKey(className)) {
                return this.getClassQueryError(className) == null;
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The class " + className + " was not requested.");
        }

        @Override
        public boolean isFunctionQuerySuccessful(String functionName) {
            if (this.functions != null && this.functions.containsKey(functionName)) {
                return this.getFunctionQueryError(functionName) == null;
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The function " + functionName + " was not requested.");
        }

        @Override
        public boolean isTypeQuerySuccessful(String typeName) {
            if (this.types != null && this.types.containsKey(typeName)) {
                return this.getTypeQueryError(typeName) == null;
            }
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "The type " + typeName + " was not requested.");
        }

        @Override
        public boolean isQuerySuccessful() {
            return this.querySuccessful;
        }

        private List<String> getFailedQueries(Map<String, String> list) {
            if (list != null) {
                ArrayList<String> result = new ArrayList<String>();
                for (String elem : list.keySet()) {
                    if (this.functions.get(elem) == null) continue;
                    result.add(elem);
                }
                if (result.size() > 0) {
                    return result;
                }
            }
            return null;
        }

        @Override
        public List<String> getFailedClassesQueries() {
            return this.getFailedQueries(this.classes);
        }

        @Override
        public List<String> getFailedFunctionQueries() {
            return this.getFailedQueries(this.functions);
        }

        @Override
        public List<String> getFailedTypesQueries() {
            return this.getFailedQueries(this.types);
        }

        public String toString() {
            StringBuilder out = new StringBuilder();
            this.toStringHelper(out, this.functions, "functions");
            this.toStringHelper(out, this.types, "types");
            this.toStringHelper(out, this.classes, "classes");
            return out.toString();
        }

        private void toStringHelper(StringBuilder out, Map<String, String> elems, String elemNamePl) {
            if (elems != null) {
                StringBuilder successOut = new StringBuilder();
                StringBuilder errorOut = new StringBuilder();
                for (String e : elems.keySet()) {
                    String error = elems.get(e);
                    if (error == null) {
                        if (successOut.length() == 0) {
                            successOut.append("The following ").append(elemNamePl).append(" were queried successfully: ");
                        } else {
                            successOut.append(", ");
                        }
                        successOut.append(e);
                        continue;
                    }
                    if (errorOut.length() == 0) {
                        errorOut.append("The query failed for the following ").append(elemNamePl).append(':');
                    } else {
                        errorOut.append(',');
                    }
                    errorOut.append(JCoRuntime.CRLF).append(e).append(" failed with error: '").append(error).append('\'');
                }
                if (out.length() > 0) {
                    out.append(JCoRuntime.CRLF);
                }
                if (successOut.length() > 0) {
                    out.append((CharSequence)successOut).append(JCoRuntime.CRLF);
                }
                if (errorOut.length() > 0) {
                    out.append((CharSequence)errorOut).append(JCoRuntime.CRLF);
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum ElementType {
            FUNCTION,
            TYPE,
            CLASS;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QueryClassHierarchy
    extends ThreadLocal<ObjectList<DefaultClassMetaData>> {
        QueryClassHierarchy() {
        }

        @Override
        protected ObjectList<DefaultClassMetaData> initialValue() {
            return new ObjectList<DefaultClassMetaData>();
        }
    }
}

