/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoDestination;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.ext.PasswordChangeHandler;
import com.sap.conn.jco.rt.ClientConnection;
import com.sap.conn.jco.rt.ClientFactory;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.MonitoredConnectionData;
import com.sap.conn.jco.rt.PoolingFactory;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.RuntimeEnvironment;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.rfc.engine.PasswordState;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class ConnectionManager {
    private static HashMap<String, ClientFactory> mFactories = new HashMap();
    private static HashMap<String, AtomicInteger> mCreationSemaphores = new HashMap();
    private static ArrayList<ClientConnection> mDetachedClients = new ArrayList();
    private static ArrayList<String> mDetachedClientDestinationIds = new ArrayList();
    private static ArrayList<String> mDetachedClientGroupNames = new ArrayList();
    private static final HashSet<String> friendlyClasses = ConnectionManager.getFriendlyClasses();
    private static ConnectionManager singleton;

    private static HashSet<String> getFriendlyClasses() {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.jco.rt.JCoJ2EERuntime");
        friends.add("com.sap.conn.jco.rt.DefaultJCoRuntime");
        friends.add("com.sap.conn.jco.rt.JCoVMCRuntime");
        friends.add("com.sap.conn.jco.rt.VMCConnectionManager");
        friends.add("com.sap.conn.jco.rt.DefaultConnectionManager");
        return friends;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ConnectionManager() {
        if (!JCoRuntime.checkAccess(friendlyClasses, "com.sap.conn.jco.rt.ConnectionManager")) {
            throw new UnsupportedOperationException("It is not allowed to extend the ConnectionManager class");
        }
        Class<ConnectionManager> clazz = ConnectionManager.class;
        synchronized (ConnectionManager.class) {
            if (singleton == null) {
                singleton = this;
                try {
                    Runtime.getRuntime().addShutdownHook(new Thread(JCoRuntime.jcoThreadGroup, new PoolFinalizer(), "JCoPoolFinalizerThread"));
                }
                catch (Throwable t) {
                    Trace.fireTraceCritical("[JCoAPI] Exception while adding ConnectionManager shutdown hook:", t);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static ConnectionManager getConnectionManager() {
        if (singleton == null) {
            JCoRuntimeFactory.getRuntime();
        }
        return singleton;
    }

    protected final void clearAllFactories() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] Clearing all connection pools");
        }
        List<ClientFactory> factories = this.getCopyOfAllFactories();
        for (ClientFactory factory : factories) {
            try {
                factory.clear();
            }
            catch (Exception exc) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void closeAllDetachedClients() {
        if (Trace.isOn(4)) {
            Trace.fireTrace(4, "[JCoAPI] Closing all detached clients");
        }
        if (mDetachedClients.size() > 0) {
            ClientConnection[] clients = null;
            ArrayList<ClientConnection> arrayList = mDetachedClients;
            synchronized (arrayList) {
                clients = mDetachedClients.toArray(new ClientConnection[mDetachedClients.size()]);
            }
            if (clients != null) {
                for (int i = 0; i < clients.length; ++i) {
                    try {
                        clients[i].disconnect(false);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    protected final ClientConnection getClient(JCoDestination destination) throws JCoException {
        return this.getClient((InternalDestination)destination, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final ClientConnection getClient(InternalDestination destination, boolean forRepository, boolean forChangePassword) throws JCoException {
        try {
            ClientFactory factory = this.getFactory(destination, forRepository, true);
            ClientConnection client = factory.getClient();
            PasswordState passwordState = client.rfcHandle.getPasswordState();
            if (passwordState != null && (passwordState == PasswordState.INITIAL || passwordState == PasswordState.EXPIRED || passwordState == PasswordState.RULES_ENFORCED)) {
                PasswordChangeHandler changeHandler = RuntimeEnvironment.getPasswordChangeHandler();
                if (changeHandler != null && !forRepository) {
                    destination.setInPasswordChangeHandler(true);
                    try {
                        if (this.doPasswortChangeWithHandler(changeHandler, destination, client)) {
                            ClientConnection clientConnection = client;
                            Object var10_11 = null;
                            destination.setInPasswordChangeHandler(false);
                            return clientConnection;
                        }
                        Object var10_12 = null;
                        destination.setInPasswordChangeHandler(false);
                    }
                    catch (Throwable throwable) {
                        Object var10_13 = null;
                        destination.setInPasswordChangeHandler(false);
                        throw throwable;
                    }
                }
                if ("1".equals(client.properties.getProperty("jco.client.deny_initial_password")) && !forChangePassword) {
                    StringBuilder message = new StringBuilder(134);
                    switch (passwordState) {
                        case INITIAL: {
                            message.append("The current password is initial.");
                            break;
                        }
                        case EXPIRED: {
                            message.append("The current password has expired.");
                            break;
                        }
                        case RULES_ENFORCED: {
                            message.append("The password rules have changed.");
                            break;
                        }
                    }
                    message.append(" Please change your password in the AS ABAP system as well as in the local destination configuration.");
                    throw new JCoException(138, message.toString());
                }
            }
            return client;
        }
        catch (ClassCastException cce) {
            throw new JCoRuntimeException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", new StringBuilder(130).append("Unsupported class ").append(destination.getClass().getName()).append(" encountered. Use the DestinationManager to obtain destination instances").toString(), cce);
        }
    }

    private boolean doPasswortChangeWithHandler(PasswordChangeHandler changeHandler, InternalDestination destination, ClientConnection client) {
        boolean successfulChange = false;
        Exception previous = null;
        for (int i = 0; i < 7; ++i) {
            if (i > 0 && !client.isValid()) {
                throw new JCoRuntimeException(136, "Connection was closed when trying to change password", previous);
            }
            String[] passwords = changeHandler.promptPassword(destination, previous);
            if (passwords == null || passwords.length < 2) break;
            try {
                client.changeBackendPassword(destination.getUser(), passwords[0], passwords[1]);
                successfulChange = true;
                break;
            }
            catch (Exception e) {
                previous = e;
                continue;
            }
        }
        return successfulChange;
    }

    protected final void releaseClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseClient()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.releaseClient(client);
        } else {
            if (mDetachedClients.size() > 0) {
                this.removeDetachedClient(client);
            }
            if (client.isAlive()) {
                client.disconnect(false);
            }
        }
    }

    protected final void releaseWithCancel(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in releaseWithCancel()", true);
            return;
        }
        client.sessionId = null;
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        } else if (mDetachedClients.size() > 0) {
            this.removeDetachedClient(client);
        }
        client.cancel();
    }

    protected final void clearClient(ClientConnection client) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in clearClient()", true);
            return;
        }
        ClientFactory pool = client.pool;
        if (pool != null) {
            pool.detachFromPool(client);
        } else if (mDetachedClients.size() > 0) {
            this.removeDetachedClient(client);
        }
        client.free();
    }

    protected final void restoreClient(ClientConnection client, String destinationId, boolean allocate) throws JCoException {
        if (client == null) {
            Trace.fireTraceCritical("[JCoAPI] ClientConnection is null in restoreClient()", true);
            return;
        }
        ClientFactory factory = mFactories.get(destinationId);
        if (factory != null) {
            factory.attachToPool(client, allocate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClientFactory getFactory(InternalDestination destination, boolean forRepository, boolean create) throws JCoException {
        String key = forRepository ? destination.getRepositoryKey() : destination.getDestinationID();
        ClientFactory factory = mFactories.get(key);
        if (factory == null && create) {
            AtomicInteger semaphore = null;
            Serializable serializable = mCreationSemaphores;
            synchronized (serializable) {
                factory = mFactories.get(key);
                if (factory == null) {
                    semaphore = mCreationSemaphores.get(key);
                    if (semaphore == null) {
                        semaphore = new AtomicInteger(1);
                        mCreationSemaphores.put(key, semaphore);
                    } else {
                        semaphore.incrementAndGet();
                    }
                }
            }
            if (semaphore != null) {
                serializable = semaphore;
                synchronized (serializable) {
                    HashMap<String, AtomicInteger> hashMap;
                    try {
                        factory = mFactories.get(key);
                        if (factory == null) {
                            factory = this.createFactory(destination, forRepository);
                            HashMap<String, ClientFactory> hashMap2 = mFactories;
                            synchronized (hashMap2) {
                                ClientFactory tmpFactory = mFactories.get(key);
                                if (tmpFactory == null) {
                                    mFactories.put(key, factory);
                                } else {
                                    factory.clear();
                                    factory = tmpFactory;
                                }
                                if (mDetachedClients.size() > 0) {
                                    ClientConnection client = this.removeDetachedClient(key);
                                    while (client != null) {
                                        factory.attachToPool(client, true);
                                        client = this.removeDetachedClient(key);
                                    }
                                }
                            }
                        }
                        Object var13_13 = null;
                        hashMap = mCreationSemaphores;
                    }
                    catch (Throwable throwable) {
                        Object var13_14 = null;
                        HashMap<String, AtomicInteger> hashMap3 = mCreationSemaphores;
                        synchronized (hashMap3) {
                            if (semaphore.decrementAndGet() == 0) {
                                mCreationSemaphores.remove(key);
                            }
                        }
                        throw throwable;
                    }
                    synchronized (hashMap) {
                        if (semaphore.decrementAndGet() == 0) {
                            mCreationSemaphores.remove(key);
                        }
                    }
                }
            }
        }
        return factory;
    }

    protected ClientFactory createFactory(InternalDestination destination, boolean forRepository) throws JCoException {
        PoolingFactory factory = new PoolingFactory(destination, forRepository);
        ((ClientFactory)factory).init(destination);
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFactories(InternalDestination destination) {
        ClientFactory removed = null;
        ClientFactory removedRepositoryFactory = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            removed = mFactories.remove(destination.getDestinationID());
            removedRepositoryFactory = mFactories.remove(destination.getRepositoryKey());
        }
        if (removed != null) {
            removed.clear();
            removed.removeDestinationMonitor();
        }
        if (removedRepositoryFactory != null) {
            removedRepositoryFactory.clear();
            removedRepositoryFactory.removeDestinationMonitor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean removeFactory(ClientFactory factory) {
        if (factory.getCurrentPoolSize() > 0) {
            return false;
        }
        ClientFactory removed = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            if (factory.getCurrentPoolSize() > 0) {
                return false;
            }
            String destinaionID = factory.getDestinationID();
            if (mFactories.get(destinaionID) == factory) {
                removed = mFactories.remove(destinaionID);
            }
        }
        if (removed != null) {
            removed.removeDestinationMonitor();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected final void internalExecute(JCoFunction function, JCoDestination destination, boolean repositoryCall) throws JCoException {
        ClientConnection client = null;
        if (destination == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "Destination is null and not allowed, hence the call cannot be executed.");
        }
        try {
            InternalDestination dest = (InternalDestination)destination;
            client = ConnectionManager.getConnectionManager().getClient(dest, repositoryCall, false);
            client.execute(function, (RepositoryProvider)dest);
            Object var7_6 = null;
            if (client == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (client == null) throw throwable;
            ConnectionManager.getConnectionManager().releaseClient(client);
            throw throwable;
        }
        ConnectionManager.getConnectionManager().releaseClient(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDetachedClient(String destinationId, ClientConnection client) {
        if (client != null) {
            ArrayList<ClientConnection> arrayList = mDetachedClients;
            synchronized (arrayList) {
                mDetachedClients.add(client);
                if (destinationId != null && destinationId.length() > 0) {
                    mDetachedClientDestinationIds.add(destinationId);
                    mDetachedClientGroupNames.add(new StringBuilder(destinationId.length() + 11).append(destinationId).append(" (detached)").toString());
                } else {
                    mDetachedClientDestinationIds.add("");
                    mDetachedClientGroupNames.add("single client");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeDetachedClient(ClientConnection client) {
        if (client != null) {
            ArrayList<ClientConnection> arrayList = mDetachedClients;
            synchronized (arrayList) {
                int index = mDetachedClients.indexOf(client);
                if (index >= 0) {
                    mDetachedClients.remove(index);
                    mDetachedClientDestinationIds.remove(index);
                    mDetachedClientGroupNames.remove(index);
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientConnection removeDetachedClient(String destinationId) {
        ArrayList<ClientConnection> arrayList = mDetachedClients;
        synchronized (arrayList) {
            int index = mDetachedClientDestinationIds.indexOf(destinationId);
            if (index >= 0) {
                mDetachedClientDestinationIds.remove(index);
                mDetachedClientGroupNames.remove(index);
                return mDetachedClients.remove(index);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void getMonitoredData(List<MonitoredConnectionData> monitoredData) {
        List<ClientFactory> factories = null;
        ClientConnection[] clients = null;
        String[] groupNames = null;
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            factories = this.getCopyOfAllFactories();
            if (mDetachedClients.size() > 0) {
                ArrayList<ClientConnection> arrayList = mDetachedClients;
                synchronized (arrayList) {
                    clients = mDetachedClients.toArray(new ClientConnection[mDetachedClients.size()]);
                    groupNames = mDetachedClientGroupNames.toArray(new String[mDetachedClientGroupNames.size()]);
                }
            }
        }
        for (ClientFactory factory : factories) {
            factory.getMonitoredData(monitoredData);
        }
        if (clients != null) {
            for (int i = 0; i < clients.length; ++i) {
                MonitoredConnectionData mcd = clients[i].getMonitoredData();
                mcd.group = groupNames[i];
                monitoredData.add(mcd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<ClientFactory> getCopyOfAllFactories() {
        HashMap<String, ClientFactory> hashMap = mFactories;
        synchronized (hashMap) {
            ArrayList<ClientFactory> factories = new ArrayList<ClientFactory>(mFactories.size());
            factories.addAll(mFactories.values());
            return factories;
        }
    }

    ClientFactory getFactoryByDestinationID(String destinationID) {
        if (destinationID != null) {
            return mFactories.get(destinationID);
        }
        return null;
    }

    private class PoolFinalizer
    implements Runnable {
        private PoolFinalizer() {
        }

        public void run() {
            ConnectionManager.this.clearAllFactories();
            ConnectionManager.this.closeAllDetachedClients();
        }
    }
}

