/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.rt.AbstractRecord;
import com.sap.conn.jco.rt.BasXMLWriter;
import com.sap.conn.jco.rt.Converter;
import com.sap.conn.jco.rt.DefaultParameterList;
import com.sap.conn.rfc.api.BasXMLAware;
import com.sap.conn.rfc.api.IRfcParameter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class Parameter
implements IRfcParameter,
BasXMLAware {
    DefaultParameterList parameterList;
    int index;
    Converter converter;
    int numBytes;
    boolean active;

    public Parameter(DefaultParameterList parameterList, int index, Converter converter) {
        this.parameterList = parameterList;
        this.index = index;
        this.converter = converter;
        this.numBytes = 0;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public String getName() {
        return this.parameterList.metaData.name[this.index];
    }

    public int getType() {
        return this.parameterList.metaData.type[this.index];
    }

    public byte[] getBytes() {
        byte[] ret = null;
        switch (this.parameterList.metaData.type[this.index]) {
            case 0: 
            case 1: 
            case 3: 
            case 6: {
                int length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeChar(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: {
                int length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeNumber(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 2: 
            case 4: {
                int length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeBinary(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 23: 
            case 24: {
                int length = this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
                ret = new byte[length];
                this.converter.decodeDecNumber(this.parameterList, ret, this.index, 0, length);
                break;
            }
            case 29: {
                try {
                    String value = (String)this.parameterList.odata[this.parameterList.metaData.oindex[this.index]];
                    if (value == null) {
                        ret = new byte[1];
                    } else {
                        byte[] temp = value.getBytes("UTF-8");
                        ret = new byte[temp.length + 1];
                        System.arraycopy(temp, 0, ret, 0, temp.length);
                    }
                    this.numBytes = ret.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 30: {
                ret = (byte[])this.parameterList.odata[this.parameterList.metaData.oindex[this.index]];
                if (ret == null) {
                    ret = new byte[]{};
                }
                this.numBytes = ret.length;
                break;
            }
            default: {
                ret = new byte[]{};
            }
        }
        return ret;
    }

    public void setBytes(byte[] rfcBytes) {
        switch (this.parameterList.metaData.type[this.index]) {
            case 0: 
            case 1: 
            case 3: {
                this.converter.encodeChar(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 6: {
                this.converter.encodeNumchar(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 40: {
                this.converter.encodeNumber(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 2: 
            case 4: {
                this.converter.encodeBinary(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 23: 
            case 24: {
                this.converter.encodeDecNumber(this.parameterList, rfcBytes, this.index, 0, rfcBytes.length);
                break;
            }
            case 29: {
                try {
                    this.parameterList.odata[this.parameterList.metaData.oindex[this.index]] = new String(rfcBytes, 0, rfcBytes.length - 1, "UTF-8");
                    this.numBytes = rfcBytes.length;
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
                break;
            }
            case 30: {
                this.parameterList.odata[this.parameterList.metaData.oindex[this.index]] = rfcBytes;
                this.numBytes = rfcBytes.length;
                break;
            }
        }
        int n = this.index;
        this.parameterList.flags[n] = (byte)(this.parameterList.flags[n] & 0xFFFFFFFE);
    }

    public int getNumBytes() {
        switch (this.parameterList.metaData.type[this.index]) {
            case 29: 
            case 30: {
                return this.numBytes;
            }
        }
        return this.parameterList.metaData.length[this.converter.sendCodepageType][this.index];
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive() {
        this.active = true;
    }

    public int getIndex() {
        return this.index;
    }

    public AbstractRecord getParameterRecord() {
        int n = this.index;
        this.parameterList.flags[n] = (byte)(this.parameterList.flags[n] & 0xFFFFFFFE);
        return this.parameterList;
    }

    public void writebASXML(BasXMLWriter writer) throws IOException {
        writer.encode(this.parameterList, this.index);
    }
}

