/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.DestinationDataEventListener;
import com.sap.conn.jco.ext.DestinationDataProvider;
import com.sap.conn.jco.rt.Obfuscator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyFileDestinationDataProvider
implements DestinationDataProvider {
    private static String DESTFILE_SUFFIX = ".jcoDestination";
    private static String TEMPFILE_SUFFIX = ".tmp";
    private static final String[] obfuscationKeys = new String[]{"jco.client.passwd", "jco.destination.repository.passwd", "passwd", "PASSWD"};
    private Counter updatesRunning = new Counter();
    private File parentDirectory = null;
    private boolean directoryWriteAccess = false;
    private Map<String, Long> lastObfuscationCheck = null;

    PropertyFileDestinationDataProvider(String directory) throws FileNotFoundException {
        File file;
        File dir = new File(directory);
        if (!dir.exists()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 27).append("Directory \"").append(path).append("\" does not exist").toString());
        }
        if (!dir.canRead()) {
            String path = dir.getAbsolutePath();
            throw new FileNotFoundException(new StringBuilder(path.length() + 34).append("Read access to directory \"").append(path).append("\" denied").toString());
        }
        this.parentDirectory = dir;
        String FILE_SUFFIX = new StringBuilder(DESTFILE_SUFFIX.length() + TEMPFILE_SUFFIX.length()).append(DESTFILE_SUFFIX).append(TEMPFILE_SUFFIX).toString();
        try {
            if (dir.canWrite()) {
                file = new File(this.parentDirectory, FILE_SUFFIX);
                if (file.exists()) {
                    file.delete();
                }
                this.directoryWriteAccess = file.createNewFile() && file.delete();
            }
        }
        catch (IOException exc) {
            this.directoryWriteAccess = false;
        }
        catch (SecurityException exc) {
            this.directoryWriteAccess = false;
        }
        if (this.directoryWriteAccess) {
            this.lastObfuscationCheck = Collections.synchronizedMap(new HashMap(64));
            long timestamp = System.currentTimeMillis() - 300000L;
            String[] filenames = this.parentDirectory.list();
            if (filenames != null) {
                for (int i = 0; i < filenames.length; ++i) {
                    if (!filenames[i].endsWith(FILE_SUFFIX)) continue;
                    try {
                        file = new File(this.parentDirectory, filenames[i]);
                        if (file.lastModified() > timestamp) continue;
                        file.delete();
                        continue;
                    }
                    catch (SecurityException exc) {
                        // empty catch block
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Properties getDestinationProperties(String destinationName) {
        String filename;
        File propertiesFile;
        if (destinationName == null) {
            destinationName = "";
        }
        if (!(propertiesFile = new File(this.parentDirectory, filename = new StringBuilder(destinationName.length() + DESTFILE_SUFFIX.length()).append(destinationName).append(DESTFILE_SUFFIX).toString())).exists()) {
            return null;
        }
        if (!propertiesFile.canRead()) {
            String path = propertiesFile.getAbsolutePath();
            throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 29).append("Read access to file \"").append(path).append("\" denied").toString(), null);
        }
        Properties properties = new Properties();
        BufferedInputStream in = null;
        try {
            try {
                Long lastCheck;
                if (this.updatesRunning.count == 0) {
                    in = new PropertiesInputStream(new FileInputStream(propertiesFile));
                    in.mark(Integer.MAX_VALUE);
                    properties.load(in);
                } else {
                    Counter counter = this.updatesRunning;
                    synchronized (counter) {
                        in = new PropertiesInputStream(new FileInputStream(propertiesFile));
                        in.mark(Integer.MAX_VALUE);
                        properties.load(in);
                    }
                }
                if (this.directoryWriteAccess && ((lastCheck = this.lastObfuscationCheck.get(destinationName)) == null || propertiesFile.lastModified() > lastCheck)) {
                    ArrayList<KeyValuePair> toObfuscate = this.checkForObfuscation(properties);
                    if (toObfuscate != null && this.updatePropertyFile(filename, propertiesFile, (PropertiesInputStream)in, toObfuscate)) {
                        in = null;
                    }
                    this.lastObfuscationCheck.put(destinationName, new Long(System.currentTimeMillis()));
                }
            }
            catch (IOException exc) {
                String path = propertiesFile.getAbsolutePath();
                throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 22).append("Failed to read file \"").append(path).append('\"').toString(), exc);
            }
            Object var9_11 = null;
            if (in == null) return properties;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception exc) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exc) {}
        in.close();
        return properties;
    }

    private ArrayList<KeyValuePair> checkForObfuscation(Properties properties) {
        ArrayList<KeyValuePair> toObfuscate = null;
        for (int i = 0; i < obfuscationKeys.length; ++i) {
            String value = properties.getProperty(obfuscationKeys[i]);
            if (value == null || value.length() >= 48) continue;
            if (toObfuscate == null) {
                toObfuscate = new ArrayList<KeyValuePair>(2);
            }
            toObfuscate.add(new KeyValuePair(obfuscationKeys[i], value));
        }
        return toObfuscate;
    }

    private TreeSet<BufferRegion> identifyBufferRegions(byte[] buffer, int count, ArrayList<KeyValuePair> toObfuscate) {
        TreeSet<BufferRegion> bufferRegions = new TreeSet<BufferRegion>();
        int ch = 0;
        block0: for (int index = 0; index < toObfuscate.size(); ++index) {
            KeyValuePair property = toObfuscate.get(index);
            byte[] key = property.key.getBytes();
            int i = count;
            while (i > 0) {
                int j = key.length - 1;
                while (i > 0 && buffer[--i] != key[j]) {
                }
                while (i > 0 && j > 0 && buffer[--i] == key[--j]) {
                }
                if (j > 0) continue;
                j = i + key.length - 1;
                while (i > 0 && ((ch = buffer[--i]) == 32 || ch == 9 || ch == 12)) {
                }
                if (i > 0 && ch != 10 && ch != 13) continue;
                while (j < count && ((ch = buffer[++j]) == 32 || ch == 9 || ch == 12)) {
                }
                if (ch == 61 || ch == 58) {
                    while (j < count && ((ch = buffer[++j]) == 32 || ch == 9 || ch == 12)) {
                    }
                }
                int pos = j;
                if (ch == 10 || ch == 13) {
                    --j;
                }
                while (true) {
                    if (j < count && (ch = buffer[++j]) != 10 && ch != 13) {
                        continue;
                    }
                    i = j;
                    int bsl = 0;
                    while (buffer[--i] == 92) {
                        ++bsl;
                    }
                    bsl %= 2;
                    while (bsl == 1 && j < count && (ch = buffer[++j]) == 10 && ch == 13) {
                    }
                    if (bsl != 1 || j >= count) break;
                }
                bufferRegions.add(new BufferRegion(pos, j - pos, property.value));
                continue block0;
            }
        }
        return bufferRegions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updatePropertyFile(String destFilename, File destFile, PropertiesInputStream in, ArrayList<KeyValuePair> toObfuscate) {
        success = false;
        out = null;
        buffer = in.getBuffer();
        count = in.getBufferCount();
        tmpFile = new File(this.parentDirectory, new StringBuilder(destFilename.length() + PropertyFileDestinationDataProvider.TEMPFILE_SUFFIX.length()).append(destFilename).append(PropertyFileDestinationDataProvider.TEMPFILE_SUFFIX).toString());
        if (tmpFile.exists()) {
            return false;
        }
        try {
            block35: {
                var10_10 = this.updatesRunning;
                synchronized (var10_10) {
                    Counter.access$108(this.updatesRunning);
                    if (!tmpFile.exists()) ** break block34
                    var11_14 = false;
                }
                var16_18 = null;
                if (out == null) break block35;
                try {
                    out.close();
                }
                catch (Exception exc) {
                }
            }
            var20_24 = null;
            var21_27 = this.updatesRunning;
            synchronized (var21_27) {
                Counter.access$110(this.updatesRunning);
                return var11_14;
            }
            {
                try {
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(tmpFile), count + (toObfuscate.size() << 6));
                        // MONITOREXIT @DISABLED, blocks:[0, 3, 4, 12] lbl35 : MonitorExitStatement: MONITOREXIT : var10_10
                        bufferRegions = this.identifyBufferRegions(buffer, count, toObfuscate);
                        offset = 0;
                        for (BufferRegion region : bufferRegions) {
                            if (BufferRegion.access$600(region) < 0) continue;
                            out.write(buffer, offset, BufferRegion.access$600(region) - offset);
                            offset = BufferRegion.access$600(region) + BufferRegion.access$700(region);
                            if (BufferRegion.access$700(region) == 0 && (ch = buffer[offset - 1]) != 61 && ch != 58 && ch != 32) {
                                out.write(61);
                            }
                            out.write(Obfuscator.encode(BufferRegion.access$800(region)));
                        }
                        out.write(buffer, offset, count - offset);
                        success = true;
                    }
                    catch (IOException exc) {
                        path = tmpFile.getAbsolutePath();
                        throw new DataProviderException(DataProviderException.Reason.IO_ERROR, new StringBuilder(path.length() + 23).append("Failed to write file \"").append(path).append('\"').toString(), exc);
                    }
                    var16_19 = null;
                    if (out != null) {
                        try {}
                        catch (Exception exc) {}
                        out.close();
                    }
                }
                catch (Throwable var15_33) {
                    var16_20 = null;
                    if (out == null) throw var15_33;
                    ** try [egrp 6[TRYBLOCK] [8 : 393->401)] { 
lbl64:
                    // 1 sources

                    out.close();
                    throw var15_33;
lbl66:
                    // 1 sources

                    catch (Exception exc) {
                        // empty catch block
                    }
                    throw var15_33;
                }
            }
            if (success) {
                try {
                    in.close();
                }
                catch (Exception exc) {
                    // empty catch block
                }
                try {
                    exc = this.updatesRunning;
                    synchronized (exc) {
                        success = destFile.delete();
                        if (!success) {
                            count = 0;
                            do {
                                try {
                                    Thread.sleep(10L);
                                }
                                catch (InterruptedException exc) {
                                    // empty catch block
                                }
                            } while (!(success = destFile.delete()) && ++count < 3);
                        }
                        if (success) {
                            success = tmpFile.renameTo(destFile);
                        }
                    }
                }
                catch (SecurityException exc) {
                    success = false;
                }
            }
            var20_25 = null;
            var21_28 = this.updatesRunning;
            synchronized (var21_28) {
                Counter.access$110(this.updatesRunning);
                return success;
            }
        }
        catch (Throwable var19_34) {
            var20_26 = null;
            var21_29 = this.updatesRunning;
            synchronized (var21_29) {
                Counter.access$110(this.updatesRunning);
                throw var19_34;
            }
        }
    }

    @Override
    public boolean supportsEvents() {
        return false;
    }

    @Override
    public void setDestinationDataEventListener(DestinationDataEventListener eventListener) {
    }

    private static class PropertiesInputStream
    extends BufferedInputStream {
        PropertiesInputStream(InputStream in) {
            super(in, 4096);
        }

        byte[] getBuffer() {
            return this.buf;
        }

        int getBufferCount() {
            return this.count;
        }
    }

    private static class KeyValuePair {
        private String key;
        private String value;

        private KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    private static class Counter {
        private int count = 0;

        private Counter() {
        }

        static /* synthetic */ int access$108(Counter x0) {
            return x0.count++;
        }

        static /* synthetic */ int access$110(Counter x0) {
            return x0.count--;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BufferRegion
    implements Comparable<BufferRegion> {
        private int offset;
        private int length;
        private String value;

        private BufferRegion(int offset, int length, String value) {
            this.offset = offset;
            this.length = length;
            this.value = value;
        }

        @Override
        public final int compareTo(BufferRegion obj) {
            if (this.offset < obj.offset) {
                return -1;
            }
            if (this.offset > obj.offset) {
                return 1;
            }
            return 0;
        }

        static /* synthetic */ int access$600(BufferRegion x0) {
            return x0.offset;
        }

        static /* synthetic */ int access$700(BufferRegion x0) {
            return x0.length;
        }

        static /* synthetic */ String access$800(BufferRegion x0) {
            return x0.value;
        }
    }
}

