/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRuntimeException;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.InternalDestination;
import com.sap.conn.jco.rt.RfcDestination;
import com.sap.conn.jco.rt.Trace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryManager {
    private HashMap<String, BasicRepository> repositories = new HashMap(29);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(InternalDestination destination) throws JCoException {
        String key = destination.getSystemID();
        BasicRepository repo = this.repositories.get(key);
        if (repo == null) {
            HashMap<String, BasicRepository> hashMap = this.repositories;
            synchronized (hashMap) {
                repo = this.repositories.get(key);
                if (repo == null) {
                    if (Trace.isOn(32)) {
                        Trace.fireTrace(32, "[JCoAPI] Adding a repository for " + key);
                    }
                    repo = new AbapRepository(key, destination);
                    this.repositories.put(key, repo);
                } else if (repo instanceof AbapRepository) {
                    ((AbapRepository)repo).destinationList.addDestination(destination);
                }
            }
        } else if (repo instanceof AbapRepository) {
            ((AbapRepository)repo).destinationList.addDestination(destination);
        }
        return repo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerRepository(BasicRepository repository) {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            BasicRepository repo = this.repositories.get(repository.getName());
            if (repo == null) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] Registering repository " + repository.getName());
                }
            } else {
                throw new JCoRuntimeException(108, "JCO_ERROR_INTERNAL", "Repository " + repository.getName() + " already registered");
            }
            this.repositories.put(repository.getName(), repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseRepository(RfcDestination destination) {
        if (destination.repository != null) {
            HashMap<String, BasicRepository> hashMap = this.repositories;
            synchronized (hashMap) {
                BasicRepository repo = this.repositories.get(destination.repository.getName());
                if (repo != null && repo instanceof AbapRepository) {
                    ((AbapRepository)repo).destinationList.removeDestination(destination);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getRepositoryIDs() {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            return new ArrayList<String>(this.repositories.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BasicRepository getRepository(String repositoryID) {
        HashMap<String, BasicRepository> hashMap = this.repositories;
        synchronized (hashMap) {
            return this.repositories.get(repositoryID);
        }
    }
}

