/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.AbapClassException;
import com.sap.conn.jco.AbapException;
import com.sap.conn.jco.JCoAttributes;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoFunction;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.RepositoryProvider;
import com.sap.conn.jco.rt.ServerAuthorizationData;
import com.sap.conn.jco.rt.ServerConnection;
import com.sap.conn.jco.rt.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public abstract class ServerWorker
implements RepositoryProvider,
Runnable {
    ServerConnection conn;
    DefaultServer server;

    abstract void removeConnectionHandle();

    abstract void onSessionClose(String var1, boolean var2);

    abstract void fireServerExceptionOccurred(Exception var1);

    abstract void fireServerErrorOccurred(Error var1);

    abstract boolean onCheckTID(String var1);

    abstract void onConfirmTID(String var1);

    abstract void onCommit(String var1);

    abstract void onRollback(String var1);

    abstract JCoFunction getFunction(String var1) throws JCoException;

    abstract boolean checkAuthorization(String var1, ServerAuthorizationData var2);

    abstract void callFinishedInternal(String var1);

    abstract String callStartedInternal();

    abstract void setState(byte var1);

    abstract byte getState();

    abstract void dispatchRequest(JCoFunction var1) throws AbapException, AbapClassException;

    abstract Thread getThread();

    ServerConnection getConnection() {
        return this.conn;
    }

    public JCoRepository getRepository() {
        return this.server.getRepository();
    }

    final void sessionClosingInternal(String message, boolean error) {
        block3: {
            try {
                if (Trace.isOn(16)) {
                    Trace.fireTrace(16, "[JCoAPI] JCoServer.onSessionClose(" + message + (error ? "," : ", no") + " error)");
                }
                this.onSessionClose(message, error);
            }
            catch (Exception e) {
                if (!Trace.isOn(2)) break block3;
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                pw.close();
                Trace.fireTrace(2, new StringBuilder(1000).append("[JCoAPI] JCoServer.onSessionClose(").append(message).append(error ? Character.valueOf(',') : ", no").append(" error) threw exception: ").append(sw.getBuffer().toString()).toString());
            }
        }
    }

    public JCoAttributes getAttributes() throws JCoException {
        return this.conn.getAttributes();
    }

    public boolean isValid() {
        return this.conn.isValid();
    }

    protected long getConnectionHandle() {
        return this.conn.getConnectionHandle();
    }

    protected Properties getProperties() {
        return this.server.getProperties();
    }

    protected DefaultServer getServer() {
        return this.server;
    }

    protected String getSessionId() {
        return this.conn.getSessionId();
    }

    public void setTrace(boolean trace) {
        this.server.setTrace(trace);
    }

    public boolean getTrace() {
        return this.server.getTrace();
    }

    public boolean isAlive() {
        return this.conn.isAlive();
    }
}

