/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt;

import com.sap.conn.jco.JCoCustomRepository;
import com.sap.conn.jco.JCoException;
import com.sap.conn.jco.JCoRepository;
import com.sap.conn.jco.ext.DataProviderException;
import com.sap.conn.jco.ext.ServerDataEventListener;
import com.sap.conn.jco.ext.ServerDataProvider;
import com.sap.conn.jco.rt.AbapRepository;
import com.sap.conn.jco.rt.DefaultJCoRuntime;
import com.sap.conn.jco.rt.DefaultServer;
import com.sap.conn.jco.rt.DefaultServerManager;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.JCoRuntimeFactory;
import com.sap.conn.jco.rt.Trace;
import com.sap.conn.jco.server.JCoServer;
import com.sap.conn.jco.server.JCoServerFactory;
import com.sap.conn.jco.server.JCoServerState;
import com.sap.conn.jco.util.FastStringBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public final class StandaloneServerFactory
extends JCoServerFactory
implements ServerDataEventListener {
    private static ServerDataProvider serverDataProvider;
    private DefaultServerManager serverManager = null;
    private static Hashtable<String, DefaultServer> availableServers;
    private static Hashtable<String, Properties> availableServerCfgs;

    public static StandaloneServerFactory get() {
        JCoRuntime runtime = JCoRuntimeFactory.getRuntime();
        try {
            return ((DefaultJCoRuntime)runtime).getServerFactory();
        }
        catch (ClassCastException ex) {
            throw new RuntimeException("StandaloneServerFactory is only available in standalone environment");
        }
    }

    StandaloneServerFactory(ServerDataProvider provider, DefaultServerManager serverManager) {
        this.serverManager = serverManager;
        if (provider != null) {
            this.updateServerDataProvider(provider);
        }
    }

    final void updateServerDataProvider(ServerDataProvider provider) {
        serverDataProvider = provider;
        if (provider != null) {
            if (provider.supportsEvents()) {
                provider.setServerDataEventListener(this);
            }
            ArrayList<String> cachedServersCfgs = new ArrayList<String>();
            cachedServersCfgs.addAll(availableServerCfgs.keySet());
            for (String cachedCfg : cachedServersCfgs) {
                try {
                    this.update(cachedCfg, availableServerCfgs.get(cachedCfg));
                }
                catch (JCoException e) {
                    if (e.getGroup() == 106) {
                        this.deleted(cachedCfg);
                        continue;
                    }
                    Trace.fireTraceCritical("[JCoAPI] exception during update of cached destination", e);
                }
            }
        }
    }

    public static synchronized StandaloneServerFactory createServerFactory(DefaultServerManager serverManager) {
        HashSet<String> friends = new HashSet<String>();
        friends.add("com.sap.conn.idoc.jco.JCoIDoc");
        if (!JCoRuntime.checkAccess(friends, StandaloneServerFactory.class.getName())) {
            throw new UnsupportedOperationException("It is not allowed to use the StandaloneServerFactory");
        }
        StandaloneServerFactory serverFactory = new StandaloneServerFactory(serverDataProvider, serverManager);
        ((DefaultJCoRuntime)JCoRuntimeFactory.getRuntime()).adjustServerFactory(serverFactory);
        return serverFactory;
    }

    private CompareResult compareServerCfg(Properties current, Properties updated) {
        if (updated == null) {
            return CompareResult.REMOVED;
        }
        if (current == null) {
            return CompareResult.CREATED;
        }
        if (!(this.isPropertyValueEqual("jco.server.gwhost", current, updated) && this.isPropertyValueEqual("jco.server.gwserv", current, updated) && this.isPropertyValueEqual("jco.server.progid", current, updated) && this.isPropertyValueEqual("jco.server.saprouter", current, updated) && this.isPropertyValueEqual("jco.server.snc_lib", current, updated) && this.isPropertyValueEqual("jco.server.snc_mode", current, updated) && this.isPropertyValueEqual("jco.server.snc_myname", current, updated) && this.isPropertyValueEqual("jco.server.snc_qop", current, updated) && this.isPropertyValueEqual("jco.server.trace", current, updated) && this.isPropertyValueEqual("jco.server.repository_destination", current, updated) && this.isPropertyValueEqual("jco.server.repository_map", current, updated))) {
            return CompareResult.CHANGED_RESTART;
        }
        if (!(this.isPropertyValueEqual("jco.server.max_startup_delay", current, updated) && this.isPropertyValueEqual("jco.server.worker_thread_count", current, updated) && this.isPropertyValueEqual("jco.server.worker_thread_min_count", current, updated) && this.isPropertyValueEqual("jco.server.connection_count", current, updated))) {
            return CompareResult.CHANGED_UPDATE;
        }
        return CompareResult.EQUALS;
    }

    private boolean isPropertyValueEqual(String key, Properties cached, Properties actual) {
        String actualValue = actual.getProperty(key);
        String cachedValue = cached.getProperty(key);
        return cachedValue == actualValue || cachedValue != null && cachedValue.equals(actualValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JCoServer getServerInstance(String serverName) throws JCoException {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new FastStringBuffer().append("[JCoAPI] JCoServerFactory.getServer(").append(serverName == null ? "null" : serverName).append(") called on provider ").append(serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()).toString());
        }
        if (serverName == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "server name is null when looking up the server data. Please specify a valid server name.");
        }
        Properties serverCfg = null;
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            serverCfg = availableServerCfgs.get(serverName);
        }
        DefaultServer availableServer = null;
        if (serverCfg == null || !serverDataProvider.supportsEvents()) {
            availableServer = this.update(serverName, serverCfg);
        } else {
            String serverKey = DefaultServerManager.computeGroupKey(serverCfg);
            StandaloneServerFactory standaloneServerFactory2 = this;
            synchronized (standaloneServerFactory2) {
                availableServer = availableServers.get(serverKey);
            }
            if (availableServer == null) {
                throw new JCoException(108, "JCO_ERROR_INTERNAL", "Unable to find the server instance, although the server configuration is in cache.");
            }
        }
        return availableServer;
    }

    public int getNumServerConnections(String serverName) throws JCoException {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, new FastStringBuffer().append("[JCoAPI] JCoServerFactory.getNumServerConnections(").append(serverName == null ? "null" : serverName).append(") called on provider ").append(serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()).toString());
        }
        if (serverName == null) {
            throw new JCoException(106, "JCO_ERROR_RESOURCE", "server name is null when looking up the server data. Please specify a valid server name.");
        }
        Properties serverProperties = serverDataProvider.getServerProperties(serverName);
        if (serverProperties == null) {
            throw new JCoException(131, "JCO_ERROR_ILLEGAL_ARGUMENT", "server configuration for " + serverName + " was not found");
        }
        return this.serverManager.getNumServerConnections(serverProperties);
    }

    public void deleted(String serverName) {
        if (Trace.isOn(8, true)) {
            Trace.fireTrace(8, "[JCoAPI] StandaloneServerFactory got event deleted for server " + (serverName == null ? "null" : serverName) + ") ");
        }
        this.removeFromCache(serverName, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeFromCache(String serverName, boolean wasDeleted, DefaultServer[] removedServer) {
        boolean restartNecessary = false;
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            String key;
            DefaultServer availableServer;
            Properties cfg = availableServerCfgs.remove(serverName);
            if (cfg != null && (availableServer = availableServers.remove(key = DefaultServerManager.computeGroupKey(cfg))) != null) {
                if (wasDeleted) {
                    availableServer.markDeleted();
                } else {
                    removedServer[0] = availableServer;
                    availableServer.markChanged();
                }
                if (availableServer.getState() != JCoServerState.STOPPED) {
                    availableServer.stop();
                    restartNecessary = true;
                }
            }
        }
        return restartNecessary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updated(String serverName) {
        if (Trace.isOn(8)) {
            Trace.fireTrace(8, "[JCoAPI] StandaloneServerFactory got event updated for server " + (serverName == null ? "null" : serverName) + ") ");
        }
        Properties currentCfg = null;
        StandaloneServerFactory standaloneServerFactory = this;
        synchronized (standaloneServerFactory) {
            currentCfg = availableServerCfgs.get(serverName);
        }
        if (currentCfg != null) {
            try {
                this.update(serverName, currentCfg);
            }
            catch (JCoException je) {
                Trace.fireTraceCritical("[JCoAPI] ServerDataEventListener.updated(" + serverName + ") called by provider " + (serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()) + " throws exception: " + je.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DefaultServer update(String serverName, Properties currentCfg) throws JCoException {
        Throwable serverProvidersException;
        Properties updatedCfg;
        block41: {
            updatedCfg = null;
            serverProvidersException = null;
            try {
                updatedCfg = serverDataProvider.getServerProperties(serverName);
                if (Trace.isOn(8)) {
                    StringBuilder buf = Trace.bufferForConnectionProperties(updatedCfg);
                    Trace.fireTrace(8, "[JCoAPI] StandaloneServerFactory.getServerInstance(" + serverName + ") got from provider " + (serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()) + " the following properties: " + buf.toString());
                }
            }
            catch (DataProviderException dpe) {
                if (Trace.isOn(4)) {
                    Trace.fireTrace(4, "[JCoAPI] <standaloneServerFactory>.getServerInstance(" + serverName + ") called on provider " + (serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()) + " thrown " + dpe.toString(), dpe);
                }
                if (dpe.getReason() == DataProviderException.Reason.INVALID_CONFIGURATION) {
                    throw new JCoException(101, dpe.getMessage(), dpe);
                }
                throw new JCoException(156, dpe.getMessage(), dpe);
            }
            catch (Throwable th) {
                serverProvidersException = th;
                if (!Trace.isOn(32, true)) break block41;
                Trace.fireTrace(32, "Server " + serverName + ") called on provider " + (serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()) + " could not be created: " + th.getMessage(), th);
            }
        }
        DefaultServer availableServer = null;
        if (currentCfg == null) {
            if (updatedCfg == null) {
                if (Trace.isOn(32)) {
                    Trace.fireTrace(32, "[JCoAPI] StandaloneServerFactory.getServerInstance(" + serverName + ") called on provider " + (serverDataProvider == null ? "null" : serverDataProvider.getClass().getName()) + " returned " + (serverProvidersException == null ? "null" : serverProvidersException.toString()) + " on update");
                }
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Server " + serverName + " does not exist", serverProvidersException);
            }
            if (Trace.isOn(128)) {
                StringBuilder buffer = new StringBuilder(100);
                buffer.append("[JCoAPI] StandaloneServerFactory.searchServer(").append(serverName);
                buffer.append(") ").append(CompareResult.CREATED.toString());
                Trace.fireTrace(128, buffer.toString());
            }
            String serverKey = DefaultServerManager.computeGroupKey(updatedCfg);
            StandaloneServerFactory standaloneServerFactory = this;
            synchronized (standaloneServerFactory) {
                if (this.serverManager.isAvailable(serverKey)) {
                    throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Server configuration for " + serverName + " is already used for a running server");
                }
                updatedCfg.setProperty("jco.server.group_key", serverKey);
                availableServer = this.serverManager.getServer(updatedCfg, true);
                availableServer.setServerName(serverName);
                availableServers.put(serverKey, availableServer);
                availableServerCfgs.put(serverName, updatedCfg);
            }
        }
        CompareResult cmpResult = this.compareServerCfg(currentCfg, updatedCfg);
        if (Trace.isOn(128)) {
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("[JCoAPI] StandaloneServerFactory.searchServer(").append(serverName).append(") got from provider ").append(serverDataProvider == null ? "null" : serverDataProvider.getClass().getName());
            buffer.append(cmpResult == CompareResult.EQUALS ? " NO ACTION - properties are not changed" : " " + (Object)((Object)cmpResult));
            Trace.fireTrace(128, buffer.toString());
        }
        String serverKey = null;
        boolean restart = false;
        DefaultServer[] changedAndToRestart = new DefaultServer[1];
        switch (cmpResult) {
            case REMOVED: {
                this.deleted(serverName);
                throw new JCoException(106, "JCO_ERROR_RESOURCE", "Server " + serverName + " does no longer exist", serverProvidersException);
            }
            case CHANGED_RESTART: {
                restart = this.removeFromCache(serverName, false, changedAndToRestart);
                changedAndToRestart[0].releaseAndSetToStopped();
                for (int i = 0; this.serverManager.isAvailable(changedAndToRestart[0].getServerKey()) && i < 10; ++i) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    changedAndToRestart[0].releaseAndSetToStopped();
                }
                serverKey = DefaultServerManager.computeGroupKey(updatedCfg);
                updatedCfg.setProperty("jco.server.group_key", serverKey);
                StandaloneServerFactory i = this;
                synchronized (i) {
                    if (this.serverManager.isAvailable(serverKey)) {
                        throw new JCoException(101, "JCO_ERROR_CONFIGURATION", "Server configuration for " + serverName + " is already used for a running server");
                    }
                    availableServer = this.serverManager.getServer(updatedCfg, true);
                    availableServer.setServerName(serverName);
                    availableServers.put(serverKey, availableServer);
                    availableServerCfgs.put(serverName, updatedCfg);
                }
                JCoRepository serverRepo = changedAndToRestart[0].getRepository();
                if (serverRepo instanceof JCoCustomRepository || !(serverRepo instanceof AbapRepository)) {
                    availableServer.setRepository(serverRepo);
                }
                try {
                    availableServer.updateOnChange(changedAndToRestart[0]);
                }
                catch (Exception ex) {
                    throw new JCoException(101, "JCO_ERROR_CONFIGURATION", ex.getMessage(), ex);
                }
                if (!restart) break;
                availableServer.start();
                break;
            }
            case CHANGED_UPDATE: {
                serverKey = DefaultServerManager.computeGroupKey(updatedCfg);
                StandaloneServerFactory standaloneServerFactory = this;
                synchronized (standaloneServerFactory) {
                    availableServer = availableServers.get(serverKey);
                }
                if (availableServer == null) {
                    throw new JCoException(108, "JCO_ERROR_INTERNAL", "Unable to find the server instance, although the server configuration is in cache.");
                }
                availableServer.updateRunning(updatedCfg);
                standaloneServerFactory = this;
                synchronized (standaloneServerFactory) {
                    availableServerCfgs.put(serverName, updatedCfg);
                    break;
                }
            }
            case EQUALS: {
                serverKey = DefaultServerManager.computeGroupKey(updatedCfg);
                StandaloneServerFactory standaloneServerFactory = this;
                synchronized (standaloneServerFactory) {
                    availableServer = availableServers.get(serverKey);
                    break;
                }
            }
        }
        return availableServer;
    }

    static {
        availableServers = new Hashtable();
        availableServerCfgs = new Hashtable();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CompareResult {
        REMOVED,
        CHANGED_RESTART,
        CHANGED_UPDATE,
        EQUALS,
        CREATED;

    }
}

