/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.json.JCoRepositorySerializationException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;

class JSonParser {
    private Reader reader;
    private int next = -1;
    private int charsRead = 0;
    private boolean undone = false;

    JSonParser(Reader reader) {
        this.reader = reader;
    }

    long position() {
        return this.charsRead;
    }

    private int nextChar() throws IOException {
        if (this.undone) {
            this.undone = false;
            return this.next;
        }
        this.next = this.reader.read();
        if (this.next != -1) {
            ++this.charsRead;
        }
        return this.next;
    }

    int nextNonBlankChar() throws IOException {
        if (this.undone) {
            this.undone = false;
            return this.next;
        }
        while ((this.next = this.reader.read()) != -1) {
            ++this.charsRead;
            if (this.next <= 32) continue;
            return this.next;
        }
        this.next = -1;
        return -1;
    }

    char unescape(char escapedPart) {
        switch (escapedPart) {
            case '\\': {
                return '\\';
            }
            case '\"': {
                return '\"';
            }
            case 'a': {
                return '\u0007';
            }
            case 'b': {
                return '\b';
            }
            case 'f': {
                return '\f';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'v': {
                return '\u000b';
            }
            case '0': {
                return '\u0000';
            }
        }
        throw new JCoRepositorySerializationException("Unexpected char [" + escapedPart + "] in unescape()");
    }

    String nextString() throws IOException {
        if (this.nextNonBlankChar() != 34) {
            throw new JCoRepositorySerializationException("'\"' expected, but '" + (char)this.next + "' read", this);
        }
        StringBuilder sb = new StringBuilder();
        this.nextChar();
        boolean escaped = false;
        while (this.next != -1 && (this.next != 34 || escaped)) {
            if (escaped) {
                sb.append(this.unescape((char)this.next));
                escaped = false;
            } else if (this.next == 92) {
                escaped = true;
            } else {
                sb.append((char)this.next);
            }
            this.nextChar();
        }
        if (this.next == -1) {
            throw new JCoRepositorySerializationException("Unterminated string");
        }
        return sb.toString();
    }

    int nextInt() throws IOException {
        int n = 0;
        int ch = this.nextNonBlankChar();
        boolean noDigit = true;
        while (Character.isDigit((char)ch)) {
            noDigit = false;
            n *= 10;
            n += this.next - 48;
            ch = this.nextChar();
        }
        this.undo();
        if (noDigit) {
            throw new JCoRepositorySerializationException("Digit(s) expected", this);
        }
        return n;
    }

    boolean nextBool() throws IOException {
        switch (this.nextNonBlankChar()) {
            case 116: {
                this.assertString("rue");
                return true;
            }
            case 102: {
                this.assertString("alse");
                return false;
            }
        }
        throw new JCoRepositorySerializationException("Boolean value (true or false) expected", this);
    }

    public void nextValue() throws IOException {
        int c = this.nextNonBlankChar();
        this.undo();
        if (c == 34) {
            this.nextString();
        } else if (Character.isDigit(c)) {
            this.nextInt();
        } else {
            this.nextBool();
        }
    }

    void undo() {
        if (this.next > 32) {
            this.undone = true;
        }
    }

    void assertChar(char c) throws IOException {
        if (this.nextNonBlankChar() != c) {
            throw new JCoRepositorySerializationException("'" + c + "' expected, but '" + (char)this.next + "' read", this);
        }
    }

    String[] readStringArray() throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        this.assertChar('[');
        while (this.nextNonBlankChar() == 34) {
            this.undo();
            strings.add(this.nextString());
            if (this.nextNonBlankChar() == 44) continue;
        }
        this.undo();
        this.assertChar(']');
        return strings.toArray(new String[strings.size()]);
    }

    private void assertString(String s) throws IOException {
        for (int i = 0; i < s.length(); ++i) {
            if (this.nextChar() == s.charAt(i)) continue;
            throw new JCoRepositorySerializationException("'" + s.charAt(i) + "' expected, but '" + (char)this.next + "' read", this);
        }
    }

    public String getPositionMessage() {
        StringBuilder sb = new StringBuilder(" near position ").append(this.charsRead).append(' ');
        return sb.toString();
    }
}

