/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.jco.rt.json;

import com.sap.conn.jco.rt.BasicRepository;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.jco.rt.json.RepWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSonWriter
extends Writer {
    Writer writer;

    public JSonWriter(Writer writer) {
        this.writer = writer;
    }

    public JSonWriter write(BasicRepository rep) throws IOException {
        new RepWriter(rep).write(this);
        return this;
    }

    void writeNVPair(String name, String value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(58);
        this.writeQuoted(JSonWriter.escapeString(value));
    }

    void writeQuoted(String str) throws IOException {
        this.writer.write(34);
        this.writer.write(str);
        this.writer.write(34);
    }

    static String escapeString(String str) {
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                sb.append("\\\\");
                continue;
            }
            if (c <= '\"') {
                switch (c) {
                    case '\"': {
                        sb.append("\\\"");
                        break;
                    }
                    case '\u0007': {
                        sb.append("\\a");
                        break;
                    }
                    case '\b': {
                        sb.append("\\b");
                        break;
                    }
                    case '\f': {
                        sb.append("\\f");
                        break;
                    }
                    case '\n': {
                        sb.append("\\n");
                        break;
                    }
                    case '\r': {
                        sb.append("\\r");
                        break;
                    }
                    case '\t': {
                        sb.append("\\t");
                        break;
                    }
                    case '\u000b': {
                        sb.append("\\v");
                        break;
                    }
                    case '\u0000': {
                        sb.append("\\0");
                        break;
                    }
                    default: {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    void writeNVPair(String name, char value) throws IOException {
        this.writeNVPair(name, String.valueOf(value));
    }

    void writeSubsequentPair(String key, boolean value) throws IOException {
        this.writer.write(44);
        this.writeNVPair(key, value);
    }

    void writeNVPair(String name, boolean value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(":");
        this.writer.write(String.valueOf(value));
    }

    void writeNVPair(String name, Object value) throws IOException {
        this.writeQuoted(name);
        this.writer.write(58);
        this.writer.write(value.toString());
    }

    void writeSubsequentPair(String key, Object value) throws IOException {
        if (value != null && value.toString().length() > 0) {
            this.writer.write(44);
            this.writeNVPair(key, value);
        }
    }

    void writeSubsequentPair(String key, String value) throws IOException {
        if (value != null && value.length() > 0) {
            this.writer.write(44);
            this.writeNVPair(key, value);
        }
    }

    void writeSubsequentPair(String name, char value) throws IOException {
        this.writer.write(44);
        this.writeNVPair(name, value);
    }

    void writeStrings(String key, List<String> stringList) throws IOException {
        this.writeQuoted(key);
        this.writer.write(58);
        this.writer.write(91);
        boolean first = true;
        for (String str : stringList) {
            if (first) {
                first = false;
            } else {
                this.writer.write(44);
            }
            this.writer.write(34);
            this.writer.write(JSonWriter.escapeString(str));
            this.writer.write(34);
        }
        this.writer.write(93);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.writer.write(cbuf, off, len);
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    public void writeLine() throws IOException {
        this.writer.write(JCoRuntime.CRLF);
    }
}

