/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.rfc.exceptions;

import com.sap.conn.jco.ext.Environment;
import com.sap.conn.jco.rt.AbapClassExceptionInfo;
import com.sap.conn.jco.rt.JCoRuntime;
import com.sap.conn.rfc.engine.AbSysInfo;
import com.sap.conn.rfc.engine.RfcIoControl;
import com.sap.conn.rfc.engine.RfcIoOpenCntl;
import com.sap.conn.rfc.engine.Trc;
import com.sap.conn.rfc.exceptions.RfcGetException;
import com.sap.conn.rfc.exceptions.RfcIoException;
import java.io.PrintWriter;
import java.io.StringWriter;

public final class RfcException
extends Exception {
    private static final long serialVersionUID = 300012082005L;
    private int m_rfcRc;
    private int m_errorGroup;
    private String m_key;
    private String messageClass;
    private char messageType;
    private String messageNumber;
    private String[] messageParameters;
    private String systemInfo;
    private AbapClassExceptionInfo classExceptionInfo;

    public static int rfcIOtoRC(int iorc) {
        switch (iorc) {
            case 0: {
                return 0;
            }
            case 4: {
                return 18;
            }
            case 2: {
                return 11;
            }
            case 10: 
            case 29: {
                return 6;
            }
            case 25: 
            case 26: {
                return 21;
            }
            case 17: {
                return 7;
            }
            case 35: {
                return 25;
            }
        }
        return 1;
    }

    private static String getKey(int group) {
        switch (group) {
            case 101: {
                return "RFC_ERROR_PROGRAM";
            }
            case 102: {
                return "RFC_ERROR_COMMUNICATION";
            }
            case 103: {
                return "RFC_ERROR_LOGON_FAILURE";
            }
            case 104: {
                return "RFC_ERROR_SYSTEM_FAILURE";
            }
            case 105: {
                return "RFC_ERROR_APPLICATION_EXCEPTION";
            }
            case 111: {
                return "RFC_ERROR_CLASS_EXCEPTION";
            }
            case 106: {
                return "RFC_ERROR_RESOURCE";
            }
            case 107: {
                return "RFC_ERROR_PROTOCOL";
            }
            case 108: {
                return "RFC_ERROR_INTERNAL";
            }
            case 109: {
                return "RFC_ERROR_CANCELLED";
            }
            case 110: {
                return "RFC_ERROR_BUSY";
            }
            case 112: {
                return "RFC_ERROR_REQUEST_CANCELLED";
            }
        }
        return "UNKNOWN_" + group;
    }

    public static String getRcAsString(int rfcRc) {
        switch (rfcRc) {
            case 0: {
                return "RFC_OK";
            }
            case 1: {
                return "RFC_FAILURE";
            }
            case 2: {
                return "RFC_EXCEPTION";
            }
            case 24: {
                return "RFC_CLASS_EXCEPTION";
            }
            case 3: {
                return "RFC_SYS_EXCEPTION";
            }
            case 4: {
                return "RFC_CALL";
            }
            case 5: {
                return "RFC_INTERNAL_COM";
            }
            case 6: {
                return "RFC_CLOSED";
            }
            case 7: {
                return "RFC_RETRY";
            }
            case 8: {
                return "RFC_NO_TID";
            }
            case 9: {
                return "RFC_EXECUTED";
            }
            case 10: {
                return "RFC_SYNCHRONIZE";
            }
            case 11: {
                return "RFC_MEMORY_INSUFFICIENT";
            }
            case 12: {
                return "RFC_VERSION_MISMATCH";
            }
            case 13: {
                return "RFC_NOT_FOUND";
            }
            case 14: {
                return "RFC_CALL_NOT_SUPPORTED";
            }
            case 15: {
                return "RFC_NOT_OWNER";
            }
            case 16: {
                return "RFC_NOT_INITIALIZED";
            }
            case 17: {
                return "RFC_SYSTEM_CALLED";
            }
            case 18: {
                return "RFC_INVALID_HANDLE";
            }
            case 19: {
                return "RFC_INVALID_PARAMETER";
            }
            case 20: {
                return "RFC_CANCELED";
            }
            case 21: {
                return "RFC_CONVERSION";
            }
            case 22: {
                return "RFC_INVALID_PROTOCOL";
            }
            case 23: {
                return "RFC_TIMEOUT";
            }
            case 25: {
                return "RFC_REG_DENIED";
            }
        }
        return "Unknown RFC return code " + rfcRc;
    }

    private static int rfcGetToRc(int getRc) {
        switch (getRc) {
            case 0: {
                return 0;
            }
            case 1: {
                return 18;
            }
            case 2: {
                return 22;
            }
            case 7: {
                return 3;
            }
            case 14: {
                return 21;
            }
            case 8: {
                return 2;
            }
            case 13: {
                return 19;
            }
            case 12: {
                return 11;
            }
            case 11: {
                return 6;
            }
            case 22: {
                return 24;
            }
        }
        return 1;
    }

    public RfcException(int rfc_rc, String message, int errorGroup, long handle, boolean trace) {
        this(rfc_rc, message, errorGroup, handle, trace, null);
    }

    public RfcException(int rfc_rc, String message, int errorGroup, long handle, boolean trace, Throwable cause) {
        super(message, cause);
        if (cause instanceof RfcException) {
            RfcException causeRe = (RfcException)cause;
            this.messageClass = causeRe.messageClass;
            this.messageNumber = causeRe.messageNumber;
            this.messageParameters = causeRe.messageParameters;
            this.messageType = causeRe.messageType;
        }
        this.m_rfcRc = rfc_rc;
        this.m_errorGroup = errorGroup;
        this.m_key = RfcException.getKey(errorGroup);
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl != null) {
            if (act_cntl.rfc_role == 'C') {
                this.systemInfo = new StringBuilder(40).append('[').append(act_cntl.sysid == null ? "<noSID>" : act_cntl.sysid).append('|').append(act_cntl.target).append('|').append(act_cntl.systnr).append(']').toString();
            } else if (act_cntl.rfc_role == 'S') {
                this.systemInfo = new StringBuilder(60).append('[').append(AbSysInfo.host).append('|').append(act_cntl.destination).append(']').toString();
            }
        }
        if (trace) {
            if (this.m_rfcRc != 2 && this.m_rfcRc != 24) {
                if (errorGroup == 101) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    this.printStackTrace(pw);
                    pw.close();
                    Trc.criticalTrace(handle, sw.toString());
                    if (act_cntl != null && act_cntl.trace && !Environment.inJTS()) {
                        Trc.ab_rfctrc(this.toString());
                    }
                } else {
                    String msg = this.toString();
                    Trc.criticalTrace(handle, msg);
                    if (act_cntl != null && act_cntl.trace && !Environment.inJTS()) {
                        Trc.ab_rfctrc(msg);
                    }
                }
            }
        } else if (act_cntl != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public RfcException(RfcIoException ioEx) {
        super(ioEx.getMessage(), ioEx);
        this.m_rfcRc = RfcException.rfcIOtoRC(ioEx.getIoRc());
        this.m_errorGroup = ioEx.getErrorGroup();
        this.m_key = ioEx.getKey();
    }

    public RfcException(RfcGetException getEx, long handle) {
        super(getEx.getMessage(), getEx);
        this.m_rfcRc = RfcException.rfcGetToRc(getEx.getRc());
        this.m_errorGroup = getEx.getErrorGroup();
        this.m_key = getEx.getKey();
        switch (getEx.getRc()) {
            case 7: 
            case 8: {
                this.messageClass = getEx.getMessageClass();
                this.messageType = getEx.getMessageType();
                this.messageNumber = getEx.getMessageNumber();
                this.messageParameters = getEx.getMessageParameters();
                break;
            }
            case 22: {
                this.classExceptionInfo = getEx.getClassExceptionInfo();
                break;
            }
        }
        RfcIoOpenCntl act_cntl = RfcIoControl.ab_rfccntl(handle);
        if (act_cntl != null) {
            if (act_cntl.rfc_role == 'C') {
                this.systemInfo = new StringBuilder(40).append('[').append(act_cntl.sysid == null ? "<noSID>" : act_cntl.sysid).append('|').append(act_cntl.target).append('|').append(act_cntl.systnr).append(']').toString();
            } else if (act_cntl.rfc_role == 'S') {
                this.systemInfo = new StringBuilder(60).append('[').append(AbSysInfo.host).append('|').append(act_cntl.destination).append(']').toString();
            }
        }
        if (act_cntl != null && act_cntl.trace) {
            Trc.ab_rfctrc(this.toString());
        }
    }

    public int getRc() {
        return this.m_rfcRc;
    }

    public int getErrorGroup() {
        return this.m_errorGroup;
    }

    public String getKey() {
        return this.m_key;
    }

    public String getMessageClass() {
        return this.messageClass;
    }

    public char getMessageType() {
        return this.messageType;
    }

    public String getMessageNumber() {
        return this.messageNumber;
    }

    public String[] getMessageParameters() {
        return this.messageParameters;
    }

    public AbapClassExceptionInfo getClassExceptionInfo() {
        return this.classExceptionInfo;
    }

    public String remoteSystemInfo() {
        return this.systemInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(300);
        sb.append("RfcException");
        if (this.systemInfo != null) {
            sb.append(" raised by system ").append(this.systemInfo);
        }
        sb.append(':').append(JCoRuntime.CRLF).append("\tmessage: ").append(this.getMessage() == null ? "<null>" : this.getMessage());
        sb.append(JCoRuntime.CRLF).append("\treturn code: ").append(RfcException.getRcAsString(this.m_rfcRc));
        sb.append(" (").append(this.m_rfcRc).append(')');
        sb.append(JCoRuntime.CRLF).append("\terror group: ").append(this.m_errorGroup);
        sb.append(JCoRuntime.CRLF).append("\tkey: ").append(this.m_key);
        if (this.messageClass != null && this.messageClass.length() > 0) {
            sb.append(JCoRuntime.CRLF).append("\tmessage class: ").append(this.messageClass);
        }
        if (this.messageType != '\u0000') {
            sb.append(JCoRuntime.CRLF).append("\tmessage type: ").append(this.messageType);
        }
        if (this.messageNumber != null && this.messageNumber.length() > 0) {
            sb.append(JCoRuntime.CRLF).append("\tmessage number: ").append(this.messageNumber);
        }
        if (this.messageParameters != null) {
            for (int i = 0; i < this.messageParameters.length; ++i) {
                if (this.messageParameters[i] == null || this.messageParameters[i].length() <= 0) continue;
                sb.append(JCoRuntime.CRLF).append("\tmessage parameter ").append(i).append(": ").append(this.messageParameters[i]);
            }
        }
        if (this.classExceptionInfo != null) {
            sb.append(JCoRuntime.CRLF).append("\tclass exception: ").append(this.classExceptionInfo.getName());
        }
        return sb.toString();
    }
}

