/*
 * Decompiled with CFR 0.152.
 */
package com.sap.i18n.cp;

import com.sap.i18n.cp.ConvertSimpleBase;
import com.sap.i18n.cp.ConverterJNITestDataSingleCToX;
import com.sap.i18n.cp.ConverterJNITestDataSingleXToC;
import com.sap.i18n.cp.StrUtil;
import com.sap.i18n.verify.intf.VerifyIntf;

public class ConvertTImplBase {
    protected VerifyIntf m_oVerify;
    protected static final long m_nStressRepeat = 1L;

    protected ConvertTImplBase(VerifyIntf oVerify) {
        this.m_oVerify = oVerify;
    }

    protected void verify(boolean bCond, String sErrText, String sTestName) {
        this.m_oVerify.verifyTest(bCond, sErrText, sTestName);
    }

    protected void printLogln(String sLogText) {
        this.m_oVerify.printLogln(sLogText);
    }

    protected void verifyConvertInit(String sName, ConvertSimpleBase oCnvObj, int nReturnExpected) {
        int nReturn = oCnvObj.GetLastRet();
        this.verify(nReturn == nReturnExpected, oCnvObj.getCnvDisplayText() + ": Init returned " + nReturn + " (" + nReturnExpected + ")", sName);
        if (nReturnExpected != 0) {
            this.printLogln("Expected error occured:\n" + oCnvObj.GetLastError().GetText());
        }
    }

    String describeTestCToX(ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleCToX oTestData, byte[] abOut) {
        int nReturn = oCnvObj.GetLastRet();
        int nReturnExpected = oTestData.m_nReturn;
        String sInBytes = StrUtil.buildByteString(new String(oTestData.m_acDataIn));
        String sOutBytes = StrUtil.buildByteString(abOut);
        String sOutBytesExpected = StrUtil.buildByteString(oTestData.m_abDataOut);
        String sDescription = oCnvObj.getCnvDisplayText() + " " + sInBytes + "->" + sOutBytes + " ret:" + nReturn + " (" + sOutBytesExpected + ", ret:" + nReturnExpected + ")";
        return sDescription;
    }

    void verifyConvertCToX(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleCToX oTestData, byte[] abOut) {
        int nReturnExpected;
        int nReturn = oCnvObj.GetLastRet();
        this.verify(nReturn == (nReturnExpected = oTestData.m_nReturn), this.describeTestCToX(oCnvObj, oTestData, abOut), sName);
        String sOutBytes = StrUtil.buildByteString(abOut);
        String sOutBytesExpected = StrUtil.buildByteString(oTestData.m_abDataOut);
        this.verify(sOutBytes.equals(sOutBytesExpected), this.describeTestCToX(oCnvObj, oTestData, abOut), sName);
        if (nReturnExpected != 0) {
            this.printLogln("Expected error occured:\n" + oCnvObj.GetLastError().GetText());
        }
    }

    String describeTestXToC(ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleXToC oTestData, String sOut) {
        int nReturn = oCnvObj.GetLastRet();
        int nReturnExpected = oTestData.m_nReturn;
        String sInBytes = StrUtil.buildByteString(new String(oTestData.m_abDataIn));
        String sOutBytes = StrUtil.buildByteString(sOut);
        String sOutBytesExpected = StrUtil.buildByteString(new String(oTestData.m_acDataOut));
        String sDescription = oCnvObj.getCnvDisplayText() + " " + sInBytes + "->" + sOutBytes + " ret:" + nReturn + " (" + sOutBytesExpected + ", ret:" + nReturnExpected + ")";
        return sDescription;
    }

    protected void verifyConvertXToC(String sName, ConvertSimpleBase oCnvObj, ConverterJNITestDataSingleXToC oTestData, String sOut) {
        int nReturn = oCnvObj.GetLastRet();
        int nReturnExpected = ConvertSimpleBase.isIgnorableReturn(oTestData.m_nReturn) ? 0 : oTestData.m_nReturn;
        this.verify(nReturn == nReturnExpected, this.describeTestXToC(oCnvObj, oTestData, sOut), sName);
        String sOutBytes = StrUtil.buildByteString(sOut);
        String sOutExpectedBytes = StrUtil.buildByteString(new String(oTestData.m_acDataOut));
        this.verify(sOutBytes.equals(sOutExpectedBytes), this.describeTestXToC(oCnvObj, oTestData, sOut), sName);
        if (nReturnExpected != 0) {
            this.printLogln("Expected error occured:\n" + oCnvObj.GetLastError().GetText());
        }
    }

    protected void timecheckPrintResult(String name, long startLoop, long endLoop, long numOp, long numChar) {
        long timeLoop = endLoop - startLoop;
        long timeperopLoop = (endLoop - startLoop) * 1000L * 1000L / numOp;
        this.printLogln("Time " + name + " Loop (ms): " + timeLoop + "; per op (ns): " + timeperopLoop + "; per char (ns): " + timeperopLoop / numChar);
    }

    protected byte[] appendByteArr(byte[] ab, byte b) {
        byte[] abNew = new byte[ab.length + 1];
        System.arraycopy(ab, 0, abNew, 0, ab.length);
        abNew[ab.length] = b;
        return abNew;
    }

    protected byte[] moveByteArrBegin(byte[] ab, int n) {
        byte[] abNew = new byte[ab.length + n];
        System.arraycopy(ab, 0, abNew, n, ab.length);
        return abNew;
    }

    protected byte[] moveByteArrBeginBack(byte[] ab, int n) {
        byte[] abNew = new byte[ab.length - n];
        System.arraycopy(ab, n, abNew, 0, abNew.length);
        return abNew;
    }

    protected char[] appendCharArr(char[] ac, char cb) {
        char[] acNew = new char[ac.length + 1];
        System.arraycopy(ac, 0, acNew, 0, ac.length);
        acNew[ac.length] = cb;
        return acNew;
    }

    protected char[] moveCharArrBegin(char[] ac, int n) {
        char[] acNew = new char[ac.length + n];
        System.arraycopy(ac, 0, acNew, n, ac.length);
        return acNew;
    }

    protected char[] moveCharArrBeginBack(char[] ac, int n) {
        char[] acNew = new char[ac.length - n];
        System.arraycopy(ac, n, acNew, 0, acNew.length);
        return acNew;
    }
}

