/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.tools.lv.CmdOptionPrefixes;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class CmdOption {
    private static final int namePrefixLength = 2;
    private String opPrefix = null;
    private String name = null;
    private String namePrefix = null;
    private List values = new LinkedList();

    CmdOption() {
    }

    CmdOption(String name, String opPrefix) {
        if (opPrefix.equals(name.substring(0, 1))) {
            if (name.length() < 2 + opPrefix.length()) {
                this.setNamePrefix(name.substring(opPrefix.length()));
                this.setName(CmdOptionPrefixes.parse(this.getNamePrefix()));
            } else {
                this.setName(name.substring(opPrefix.length()));
            }
            this.setOpPrefix(opPrefix);
        } else {
            this.setName(name);
        }
    }

    public String getOpPrefix() {
        return this.opPrefix;
    }

    public String getName() {
        return this.name;
    }

    public String getNamePrefix() {
        return this.namePrefix;
    }

    public Iterator getValues() {
        return this.values.iterator();
    }

    public String[] toArray() {
        return this.values.toArray(new String[this.values.size()]);
    }

    public int size() {
        return this.values.size();
    }

    public String getValueAt(int index) {
        return (String)this.values.get(index);
    }

    void setOpPrefix(String opPrefix) {
        this.opPrefix = opPrefix;
    }

    void setName(String name) {
        this.name = name;
    }

    void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    void addValue(String value) {
        this.values.add(value);
    }

    String getMethodName(String prefix) {
        return prefix + this.getName();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        Iterator it = this.getValues();
        while (it.hasNext()) {
            buf.append((String)it.next());
            buf.append(' ');
        }
        return buf.toString();
    }
}

