/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.InfrastructureSpec;
import io.fabric8.openshift.api.model.InfrastructureSpecFluent;
import io.fabric8.openshift.api.model.InfrastructureSpecFluentImpl;
import java.util.Objects;

public class InfrastructureSpecBuilder
extends InfrastructureSpecFluentImpl<InfrastructureSpecBuilder>
implements VisitableBuilder<InfrastructureSpec, InfrastructureSpecBuilder> {
    InfrastructureSpecFluent<?> fluent;
    Boolean validationEnabled;

    public InfrastructureSpecBuilder() {
        this(false);
    }

    public InfrastructureSpecBuilder(Boolean validationEnabled) {
        this(new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new InfrastructureSpec(), validationEnabled);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, InfrastructureSpec instance) {
        this(fluent, instance, false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpecFluent<?> fluent, InfrastructureSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withCloudConfig(instance.getCloudConfig());
        fluent.withPlatformSpec(instance.getPlatformSpec());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance) {
        this(instance, (Boolean)false);
    }

    public InfrastructureSpecBuilder(InfrastructureSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withCloudConfig(instance.getCloudConfig());
        this.withPlatformSpec(instance.getPlatformSpec());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public InfrastructureSpec build() {
        InfrastructureSpec buildable = new InfrastructureSpec(this.fluent.getCloudConfig(), this.fluent.getPlatformSpec());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InfrastructureSpecBuilder that = (InfrastructureSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

