/*
 * Decompiled with CFR 0.152.
 */
package io.github.asleepyfish.enums;

import io.github.asleepyfish.enums.ChatGPTErrorEnum;
import io.github.asleepyfish.exception.ChatGPTException;
import java.util.Objects;

public enum ModelEnum {
    TEXT_DAVINCI_003("text-davinci-003", 4000),
    TEXT_CURIE_001("text-curie-001", 2048),
    TEXT_BABBAGE_001("text-babbage-001", 2048),
    TEXT_ADA_001("text-ada-001", 2048);

    private final String modelName;
    private final Integer maxTokens;

    private ModelEnum(String modelName, Integer maxTokens) {
        this.modelName = modelName;
        this.maxTokens = maxTokens;
    }

    public String getModelName() {
        return this.modelName;
    }

    public Integer getMaxTokens() {
        return this.maxTokens;
    }

    public static Integer getMaxTokens(String modelName) {
        for (ModelEnum modelEnum : ModelEnum.values()) {
            if (!Objects.equals(modelEnum.getModelName(), modelName)) continue;
            return modelEnum.getMaxTokens();
        }
        throw new ChatGPTException(ChatGPTErrorEnum.MODEL_SELECTION_ERROR);
    }
}

