/*
 * Decompiled with CFR 0.152.
 */
package io.lettuce.core.search.arguments;

import io.lettuce.core.protocol.CommandArgs;
import io.lettuce.core.protocol.CommandKeyword;
import io.lettuce.core.search.arguments.QueryDialects;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AggregateArgs<K, V> {
    private Optional<Boolean> verbatim = Optional.empty();
    private final List<LoadField<K>> loadFields = new ArrayList<LoadField<K>>();
    private Optional<Duration> timeout = Optional.empty();
    private final List<PipelineOperation<K, ?>> pipelineOperations = new ArrayList();
    private Optional<WithCursor> withCursor = Optional.empty();
    private final Map<K, V> params = new HashMap();
    private Optional<V> scorer = Optional.empty();
    private Optional<Boolean> addScores = Optional.empty();
    private QueryDialects dialect = QueryDialects.DIALECT2;

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public void build(CommandArgs<K, V> args) {
        this.verbatim.ifPresent(v -> args.add(CommandKeyword.VERBATIM));
        if (!this.loadFields.isEmpty()) {
            args.add(CommandKeyword.LOAD);
            if (this.loadFields.size() == 1 && this.loadFields.get((int)0).field == null) {
                args.add("*");
            } else {
                int argCount = 0;
                for (LoadField<K> loadField : this.loadFields) {
                    ++argCount;
                    if (loadField.alias == null) continue;
                    argCount += 2;
                }
                args.add(argCount);
                for (LoadField<K> loadField : this.loadFields) {
                    args.addKey(loadField.field);
                    if (loadField.alias == null) continue;
                    args.add(CommandKeyword.AS);
                    args.addKey(loadField.alias);
                }
            }
        }
        this.timeout.ifPresent(t -> {
            args.add(CommandKeyword.TIMEOUT);
            args.add(t.toMillis());
        });
        Iterator<PipelineOperation<K, ?>> iterator = this.pipelineOperations.iterator();
        while (iterator.hasNext()) {
            PipelineOperation<K, ?> operation;
            PipelineOperation<K, ?> typedOperation = operation = iterator.next();
            typedOperation.build(args);
        }
        this.withCursor.ifPresent(wc -> {
            args.add(CommandKeyword.WITHCURSOR);
            wc.count.ifPresent(c -> {
                args.add(CommandKeyword.COUNT);
                args.add((long)c);
            });
            wc.maxIdle.ifPresent(mi -> {
                args.add(CommandKeyword.MAXIDLE);
                args.add(mi.toMillis());
            });
        });
        if (!this.params.isEmpty()) {
            args.add(CommandKeyword.PARAMS);
            args.add((long)this.params.size() * 2L);
            this.params.forEach((key, value) -> {
                args.addKey(key);
                args.addValue(value);
            });
        }
        this.scorer.ifPresent(s -> {
            args.add(CommandKeyword.SCORER);
            args.addValue(s);
        });
        this.addScores.ifPresent(v -> args.add(CommandKeyword.ADDSCORES));
        args.add(CommandKeyword.DIALECT);
        args.add(this.dialect.toString());
    }

    public Optional<WithCursor> getWithCursor() {
        return this.withCursor;
    }

    public static enum SortDirection {
        ASC,
        DESC;

    }

    public static class SortProperty<K> {
        final K property;
        final SortDirection direction;

        public SortProperty(K property, SortDirection direction) {
            this.property = property;
            this.direction = direction;
        }
    }

    public static class Filter<K, V>
    implements PipelineOperation<K, V> {
        private final V expression;

        public Filter(V expression) {
            this.expression = expression;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.FILTER);
            args.addValue(this.expression);
        }
    }

    public static class Reducer<K, V> {
        private final String function;
        private final List<V> args;
        private Optional<K> alias = Optional.empty();

        public Reducer(String function, List<V> args) {
            this.function = function;
            this.args = new ArrayList<V>(args);
        }

        public Reducer<K, V> as(K alias) {
            this.alias = Optional.of(alias);
            return this;
        }

        public static <K, V> Reducer<K, V> count() {
            return new Reducer("COUNT", Collections.emptyList());
        }

        public static <K, V> Reducer<K, V> sum(V field) {
            return new Reducer<K, V>("SUM", Collections.singletonList(field));
        }

        public static <K, V> Reducer<K, V> avg(V field) {
            return new Reducer<K, V>("AVG", Collections.singletonList(field));
        }

        public static <K, V> Reducer<K, V> min(V field) {
            return new Reducer<K, V>("MIN", Collections.singletonList(field));
        }

        public static <K, V> Reducer<K, V> max(V field) {
            return new Reducer<K, V>("MAX", Collections.singletonList(field));
        }

        public static <K, V> Reducer<K, V> countDistinct(V field) {
            return new Reducer<K, V>("COUNT_DISTINCT", Collections.singletonList(field));
        }

        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.REDUCE);
            args.add(this.function);
            args.add(this.args.size());
            for (V arg : this.args) {
                args.addValue(arg);
            }
            this.alias.ifPresent(a -> {
                args.add(CommandKeyword.AS);
                args.addKey(a);
            });
        }
    }

    public static class Apply<K, V>
    implements PipelineOperation<K, V> {
        private final V expression;
        private final K name;

        public Apply(V expression, K name) {
            this.expression = expression;
            this.name = name;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.APPLY);
            args.addValue(this.expression);
            args.add(CommandKeyword.AS);
            args.addKey(this.name);
        }

        public static <K, V> Apply<K, V> of(V expression, K name) {
            return new Apply<K, V>(expression, name);
        }
    }

    public static class SortBy<K>
    implements PipelineOperation<K, Object> {
        private final List<SortProperty<K>> properties;
        private Optional<Long> max = Optional.empty();
        private boolean withCount = false;

        public SortBy(List<SortProperty<K>> properties) {
            this.properties = new ArrayList<SortProperty<K>>(properties);
        }

        public SortBy<K> max(long max) {
            this.max = Optional.of(max);
            return this;
        }

        public SortBy<K> withCount() {
            this.withCount = true;
            return this;
        }

        public static <K> SortBy<K> of(K property, SortDirection direction) {
            return new SortBy<K>(Collections.singletonList(new SortProperty<K>(property, direction)));
        }

        @SafeVarargs
        public static <K> SortBy<K> of(SortProperty<K> ... properties) {
            return new SortBy<K>(Arrays.asList(properties));
        }

        @Override
        public void build(CommandArgs<K, Object> args) {
            args.add(CommandKeyword.SORTBY);
            args.add((long)this.properties.size() * 2L);
            for (SortProperty<K> property : this.properties) {
                String propertyStr = property.property.toString();
                if (!propertyStr.startsWith("@")) {
                    args.add("@" + propertyStr);
                } else {
                    args.addKey(property.property);
                }
                args.add(property.direction.name());
            }
            this.max.ifPresent(m -> {
                args.add(CommandKeyword.MAX);
                args.add((long)m);
            });
            if (this.withCount) {
                args.add(CommandKeyword.WITHCOUNT);
            }
        }
    }

    public static class GroupBy<K, V>
    implements PipelineOperation<K, V> {
        private final List<K> properties;
        private final List<Reducer<K, V>> reducers;

        public GroupBy(List<K> properties) {
            this.properties = new ArrayList<K>(properties);
            this.reducers = new ArrayList<Reducer<K, V>>();
        }

        public GroupBy<K, V> reduce(Reducer<K, V> reducer) {
            this.reducers.add(reducer);
            return this;
        }

        @SafeVarargs
        public static <K, V> GroupBy<K, V> of(K ... properties) {
            return new GroupBy<K, V>(Arrays.asList(properties));
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.GROUPBY);
            args.add(this.properties.size());
            for (K k : this.properties) {
                String propertyStr = k.toString();
                if (!propertyStr.startsWith("@")) {
                    args.add("@" + propertyStr);
                    continue;
                }
                args.addKey(k);
            }
            for (Reducer reducer : this.reducers) {
                reducer.build(args);
            }
        }
    }

    public static class WithCursor {
        final Optional<Long> count;
        final Optional<Duration> maxIdle;

        public WithCursor(Long count, Optional<Duration> maxIdle) {
            this.count = Optional.ofNullable(count);
            this.maxIdle = maxIdle;
        }

        public static WithCursor of(Long count, Duration maxIdle) {
            return new WithCursor(count, Optional.of(maxIdle));
        }

        public static WithCursor of(Long count) {
            return new WithCursor(count, Optional.empty());
        }
    }

    public static class Limit<K, V>
    implements PipelineOperation<K, V> {
        final long offset;
        final long num;

        Limit(long offset, long num) {
            this.offset = offset;
            this.num = num;
        }

        @Override
        public void build(CommandArgs<K, V> args) {
            args.add(CommandKeyword.LIMIT);
            args.add(this.offset);
            args.add(this.num);
        }
    }

    public static class LoadField<K> {
        final K field;
        final K alias;

        LoadField(K field, K alias) {
            this.field = field;
            this.alias = alias;
        }
    }

    public static interface PipelineOperation<K, V> {
        public void build(CommandArgs<K, V> var1);
    }

    public static class Builder<K, V> {
        private final AggregateArgs<K, V> args = new AggregateArgs();

        public Builder<K, V> verbatim() {
            ((AggregateArgs)this.args).verbatim = Optional.of(true);
            return this;
        }

        public Builder<K, V> load(K field) {
            ((AggregateArgs)this.args).loadFields.add(new LoadField<Object>(field, null));
            return this;
        }

        public Builder<K, V> load(K field, K alias) {
            ((AggregateArgs)this.args).loadFields.add(new LoadField<K>(field, alias));
            return this;
        }

        public Builder<K, V> loadAll() {
            ((AggregateArgs)this.args).loadFields.add(new LoadField<Object>(null, null));
            return this;
        }

        public Builder<K, V> timeout(Duration timeout) {
            ((AggregateArgs)this.args).timeout = Optional.of(timeout);
            return this;
        }

        public Builder<K, V> groupBy(GroupBy<K, V> groupBy) {
            ((AggregateArgs)this.args).pipelineOperations.add(groupBy);
            return this;
        }

        public Builder<K, V> sortBy(SortBy<K> sortBy) {
            ((AggregateArgs)this.args).pipelineOperations.add(sortBy);
            return this;
        }

        public Builder<K, V> apply(Apply<K, V> apply) {
            ((AggregateArgs)this.args).pipelineOperations.add(apply);
            return this;
        }

        public Builder<K, V> limit(long offset, long num) {
            ((AggregateArgs)this.args).pipelineOperations.add(new Limit(offset, num));
            return this;
        }

        public Builder<K, V> filter(V filter) {
            ((AggregateArgs)this.args).pipelineOperations.add(new Filter(filter));
            return this;
        }

        public Builder<K, V> withCursor(WithCursor withCursor) {
            ((AggregateArgs)this.args).withCursor = Optional.of(withCursor);
            return this;
        }

        public Builder<K, V> param(K name, V value) {
            ((AggregateArgs)this.args).params.put(name, value);
            return this;
        }

        public Builder<K, V> scorer(V scorer) {
            ((AggregateArgs)this.args).scorer = Optional.of(scorer);
            return this;
        }

        public Builder<K, V> addScores() {
            ((AggregateArgs)this.args).addScores = Optional.of(true);
            return this;
        }

        public Builder<K, V> dialect(QueryDialects dialect) {
            ((AggregateArgs)this.args).dialect = dialect;
            return this;
        }

        @SafeVarargs
        public final Builder<K, V> groupBy(K ... properties) {
            return this.groupBy(new GroupBy(Arrays.asList(properties)));
        }

        public Builder<K, V> sortBy(K property, SortDirection direction) {
            return this.sortBy(new SortBy<K>(Collections.singletonList(new SortProperty<K>(property, direction))));
        }

        public Builder<K, V> apply(V expression, K name) {
            return this.apply(new Apply<K, V>(expression, name));
        }

        public AggregateArgs<K, V> build() {
            return this.args;
        }
    }
}

