/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.core.annotation.Internal;
import io.micronaut.http.MediaType;
import io.micronaut.http.exceptions.ContentLengthExceededException;
import io.micronaut.http.netty.MicronautHttpDataFactory;
import io.micronaut.http.server.HttpServerConfiguration;
import io.micronaut.http.server.netty.AbstractHttpContentProcessor;
import io.micronaut.http.server.netty.MicronautHttpPostMultipartRequestDecoder;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.netty.buffer.ByteBufHolder;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpData;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.publisher.Operators;
import reactor.util.context.Context;

@Internal
public class FormDataHttpContentProcessor
extends AbstractHttpContentProcessor<HttpData> {
    private final InterfaceHttpPostRequestDecoder decoder;
    private final boolean enabled;
    private final AtomicLong extraMessages = new AtomicLong(0L);
    private final long partMaxSize;
    private volatile boolean pleaseDestroy = false;
    private volatile boolean inFlight = false;
    private boolean destroyed = false;

    FormDataHttpContentProcessor(NettyHttpRequest<?> nettyHttpRequest, NettyHttpServerConfiguration configuration) {
        super(nettyHttpRequest, configuration);
        Charset characterEncoding = nettyHttpRequest.getCharacterEncoding();
        HttpServerConfiguration.MultipartConfiguration multipart = configuration.getMultipart();
        MicronautHttpDataFactory factory = multipart.isDisk() ? new MicronautHttpDataFactory(true, characterEncoding) : (multipart.isMixed() ? new MicronautHttpDataFactory(multipart.getThreshold(), characterEncoding) : new MicronautHttpDataFactory(false, characterEncoding));
        factory.setMaxLimit(multipart.getMaxFileSize());
        HttpRequest nativeRequest = nettyHttpRequest.getNativeRequest();
        this.decoder = HttpPostRequestDecoder.isMultipart((HttpRequest)nativeRequest) ? new MicronautHttpPostMultipartRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding) : new HttpPostStandardRequestDecoder((HttpDataFactory)factory, nativeRequest, characterEncoding);
        this.enabled = nettyHttpRequest.getContentType().map(type -> type.equals((Object)MediaType.APPLICATION_FORM_URLENCODED_TYPE)).orElse(false) != false || multipart.isEnabled();
        this.partMaxSize = multipart.getMaxFileSize();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    protected void doOnSubscribe(final Subscription subscription, Subscriber<? super HttpData> subscriber) {
        subscriber.onSubscribe(new Subscription(){

            public void request(long n) {
                FormDataHttpContentProcessor.this.extraMessages.updateAndGet(p -> {
                    long newVal = p - n;
                    if (newVal < 0L) {
                        subscription.request(n - p);
                        return 0L;
                    }
                    return newVal;
                });
            }

            public void cancel() {
                subscription.cancel();
                FormDataHttpContentProcessor.this.pleaseDestroy = true;
                FormDataHttpContentProcessor.this.destroyIfRequested();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    protected void onData(ByteBufHolder message) {
        boolean skip;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        // MONITORENTER : formDataHttpContentProcessor
        if (this.destroyed) {
            skip = true;
        } else {
            skip = false;
            this.inFlight = true;
        }
        // MONITOREXIT : formDataHttpContentProcessor
        if (skip) {
            message.release();
            return;
        }
        try {
            block31: {
                Subscriber subscriber = this.getSubscriber();
                if (!(message instanceof HttpContent)) break block31;
                HttpContent httpContent = (HttpContent)message;
                ArrayList<Object> messages = new ArrayList<Object>(1);
                try {
                    InterfaceHttpPostRequestDecoder postRequestDecoder = this.decoder;
                    postRequestDecoder.offer(httpContent);
                    while (postRequestDecoder.hasNext()) {
                        InterfaceHttpData data2 = postRequestDecoder.next();
                        data2.touch();
                        switch (data2.getHttpDataType()) {
                            case Attribute: {
                                Attribute attribute = (Attribute)data2;
                                messages.add(attribute.retain());
                                postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)attribute);
                                break;
                            }
                            case FileUpload: {
                                FileUpload fileUpload = (FileUpload)data2;
                                if (!fileUpload.isCompleted()) break;
                                messages.add(fileUpload.retain());
                                postRequestDecoder.removeHttpDataFromClean((InterfaceHttpData)fileUpload);
                                break;
                            }
                        }
                    }
                    InterfaceHttpData currentPartialHttpData = postRequestDecoder.currentPartialHttpData();
                    if (!(currentPartialHttpData instanceof HttpData)) return;
                    messages.add(currentPartialHttpData.retain());
                    return;
                }
                catch (HttpPostRequestDecoder.EndOfDataDecoderException postRequestDecoder) {
                    if (messages.isEmpty()) {
                        this.subscription.request(1L);
                    } else {
                        this.extraMessages.updateAndGet(p -> p + (long)messages.size() - 1L);
                        messages.stream().map(HttpData.class::cast).forEach(data -> {
                            try {
                                subscriber.onNext(data);
                            }
                            catch (Throwable e) {
                                subscriber.onError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)e, (Object)data, (Context)Context.empty()));
                            }
                        });
                    }
                    httpContent.release();
                    return;
                    catch (HttpPostRequestDecoder.ErrorDataDecoderException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof IOException && cause.getMessage().equals("Size exceed allowed maximum capacity")) {
                            String partName = this.decoder.currentPartialHttpData().getName();
                            try {
                                this.onError((Throwable)new ContentLengthExceededException("The part named [" + partName + "] exceeds the maximum allowed content length [" + this.partMaxSize + "]"));
                                return;
                            }
                            finally {
                                this.parentSubscription.cancel();
                            }
                        }
                        this.onError(e);
                        return;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                        catch (Throwable e2) {
                            block32: {
                                block30: {
                                    this.onError(e2);
                                    if (!messages.isEmpty()) break block30;
                                    this.subscription.request(1L);
                                    break block32;
                                }
                                this.extraMessages.updateAndGet(p -> p + (long)messages.size() - 1L);
                                messages.stream().map(HttpData.class::cast).forEach(data -> {
                                    try {
                                        subscriber.onNext(data);
                                    }
                                    catch (Throwable e) {
                                        subscriber.onError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)e, (Object)data, (Context)Context.empty()));
                                    }
                                });
                            }
                            httpContent.release();
                            return;
                        }
                    }
                }
                finally {
                    if (messages.isEmpty()) {
                        this.subscription.request(1L);
                    } else {
                        this.extraMessages.updateAndGet(p -> p + (long)messages.size() - 1L);
                        messages.stream().map(HttpData.class::cast).forEach(data -> {
                            try {
                                subscriber.onNext(data);
                            }
                            catch (Throwable e) {
                                subscriber.onError(Operators.onOperatorError((Subscription)this.subscription, (Throwable)e, (Object)data, (Context)Context.empty()));
                            }
                        });
                    }
                    httpContent.release();
                }
            }
            message.release();
            return;
        }
        finally {
            this.inFlight = false;
            this.destroyIfRequested();
        }
    }

    protected void doAfterOnError(Throwable throwable) {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    protected void doAfterComplete() {
        this.pleaseDestroy = true;
        this.destroyIfRequested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyIfRequested() {
        boolean destroy;
        FormDataHttpContentProcessor formDataHttpContentProcessor = this;
        synchronized (formDataHttpContentProcessor) {
            if (this.pleaseDestroy && !this.destroyed && !this.inFlight) {
                destroy = true;
                this.destroyed = true;
            } else {
                destroy = false;
            }
        }
        if (destroy) {
            this.decoder.destroy();
        }
    }
}

