/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingException;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelBuildingResult;
import org.apache.maven.model.building.Result;
import org.apache.maven.model.resolution.UnresolvableModelException;
import org.apache.maven.model.resolution.WorkspaceModelResolver;

public class MavenModelBuilder
implements ModelBuilder {
    private final ModelBuilder builder = new BootstrapModelBuilderFactory().newInstance();
    private final WorkspaceModelResolver workspaceResolver;
    private final List<Profile> activeSettingsProfiles;
    private final BootstrapMavenOptions mvnOptions;

    public MavenModelBuilder(WorkspaceModelResolver wsModelResolver, BootstrapMavenOptions mvnOptions, List<Profile> activeSettingsProfiles) {
        this.workspaceResolver = wsModelResolver;
        this.activeSettingsProfiles = activeSettingsProfiles;
        this.mvnOptions = mvnOptions;
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request) throws ModelBuildingException {
        if (this.workspaceResolver != null) {
            request.setWorkspaceModelResolver(this.workspaceResolver);
            Model requestModel = this.getModel(request);
            try {
                if (requestModel != null && this.workspaceResolver.resolveRawModel(ModelUtils.getGroupId(requestModel), requestModel.getArtifactId(), ModelUtils.getVersion(requestModel)) != null) {
                    this.completeWorkspaceProjectBuildRequest(request);
                }
            }
            catch (UnresolvableModelException unresolvableModelException) {
                // empty catch block
            }
        }
        return this.builder.build(request);
    }

    private Model getModel(ModelBuildingRequest request) {
        Model requestModel = request.getRawModel();
        if (requestModel == null && request.getModelSource() != null) {
            try {
                requestModel = ModelUtils.readModel(request.getModelSource().getInputStream());
                request.setRawModel(requestModel);
                if (request.getPomFile() != null) {
                    requestModel.setPomFile(request.getPomFile());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return requestModel;
    }

    private void completeWorkspaceProjectBuildRequest(ModelBuildingRequest request) {
        HashSet addedProfiles = new HashSet();
        List<Profile> profiles = request.getProfiles();
        profiles.forEach(p -> addedProfiles.add(p.getId()));
        this.activeSettingsProfiles.forEach(p -> {
            if (!addedProfiles.contains(p.getId())) {
                profiles.add((Profile)p);
                request.getActiveProfileIds().add(p.getId());
            }
        });
        request.getActiveProfileIds().addAll(this.mvnOptions.getActiveProfileIds());
        request.getInactiveProfileIds().addAll(this.mvnOptions.getInactiveProfileIds());
        request.setUserProperties(System.getProperties());
    }

    @Override
    public ModelBuildingResult build(ModelBuildingRequest request, ModelBuildingResult result) throws ModelBuildingException {
        return this.builder.build(request, result);
    }

    @Override
    public Result<? extends Model> buildRawModel(File pomFile, int validationLevel, boolean locationTracking) {
        return this.builder.buildRawModel(pomFile, validationLevel, locationTracking);
    }
}

