/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.model;

import io.seata.common.exception.ShouldNeverHappenException;
import java.util.HashMap;
import java.util.Map;

public enum BranchStatus {
    Unknown(0),
    Registered(1),
    PhaseOne_Done(2),
    PhaseOne_Failed(3),
    PhaseOne_Timeout(4),
    PhaseTwo_Committed(5),
    PhaseTwo_CommitFailed_Retryable(6),
    PhaseTwo_CommitFailed_Unretryable(7),
    PhaseTwo_Rollbacked(8),
    PhaseTwo_RollbackFailed_Retryable(9),
    PhaseTwo_RollbackFailed_Unretryable(10);

    private int code;
    private static final Map<Integer, BranchStatus> MAP;

    private BranchStatus(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public static BranchStatus get(byte code) {
        return BranchStatus.get((int)code);
    }

    public static BranchStatus get(int code) {
        BranchStatus status = MAP.get(code);
        if (status == null) {
            throw new ShouldNeverHappenException("Unknown BranchStatus[" + code + "]");
        }
        return status;
    }

    static {
        MAP = new HashMap<Integer, BranchStatus>(BranchStatus.values().length);
        for (BranchStatus status : BranchStatus.values()) {
            MAP.put(status.getCode(), status);
        }
    }
}

