/*
 * Decompiled with CFR 0.152.
 */
package io.seata.core.rpc;

import io.seata.common.util.CollectionUtils;
import io.seata.core.rpc.Disposable;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHook
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHook.class);
    private static final ShutdownHook SHUTDOWN_HOOK = new ShutdownHook("ShutdownHook");
    private Set<Disposable> disposables = new TreeSet<Disposable>();
    private final AtomicBoolean destroyed = new AtomicBoolean(false);
    private static final int DEFAULT_PRIORITY = 10;

    private ShutdownHook(String name) {
        super(name);
    }

    public static ShutdownHook getInstance() {
        return SHUTDOWN_HOOK;
    }

    public void addDisposable(Disposable disposable) {
        this.addDisposable(disposable, 10);
    }

    public void addDisposable(Disposable disposable, int priority) {
        this.disposables.add(new DisposablePriorityWrapper(disposable, priority));
    }

    @Override
    public void run() {
        this.destroyAll();
    }

    public void destroyAll() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("destoryAll starting");
        }
        if (!this.destroyed.compareAndSet(false, true) && CollectionUtils.isEmpty(this.disposables)) {
            return;
        }
        for (Disposable disposable : this.disposables) {
            disposable.destroy();
        }
    }

    public static void removeRuntimeShutdownHook() {
        Runtime.getRuntime().removeShutdownHook(SHUTDOWN_HOOK);
    }

    static {
        Runtime.getRuntime().addShutdownHook(SHUTDOWN_HOOK);
    }

    private static class DisposablePriorityWrapper
    implements Comparable<DisposablePriorityWrapper>,
    Disposable {
        private static AtomicLong seq = new AtomicLong();
        private Disposable disposable;
        private int priority;
        private long seqId;

        public DisposablePriorityWrapper(Disposable disposable, int priority) {
            this.disposable = disposable;
            this.priority = priority;
            this.seqId = seq.incrementAndGet();
        }

        @Override
        public int compareTo(DisposablePriorityWrapper disposablePriorityWrapper) {
            int cmp = this.priority - disposablePriorityWrapper.priority;
            if (cmp == 0) {
                cmp = this.seqId > disposablePriorityWrapper.seqId ? 1 : (this.seqId < disposablePriorityWrapper.seqId ? -1 : 0);
            }
            return cmp;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.priority;
            result = 31 * result + (int)(this.seqId ^ this.seqId >>> 32);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DisposablePriorityWrapper other = (DisposablePriorityWrapper)obj;
            if (this.priority != other.priority) {
                return false;
            }
            return this.seqId == other.seqId;
        }

        @Override
        public void destroy() {
            this.disposable.destroy();
        }
    }
}

