/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.swagger.schema;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.StringUtils;
import springfox.documentation.service.AllowableListValues;
import springfox.documentation.service.AllowableRangeValues;
import springfox.documentation.service.AllowableValues;

public final class ApiModelProperties {
    private ApiModelProperties() {
        throw new UnsupportedOperationException();
    }

    public static Function<ApiModelProperty, AllowableValues> toAllowableValues() {
        return new Function<ApiModelProperty, AllowableValues>(){

            public AllowableValues apply(ApiModelProperty annotation) {
                return ApiModelProperties.allowableValueFromString(annotation.allowableValues());
            }
        };
    }

    public static AllowableValues allowableValueFromString(String allowableValueString) {
        AllowableListValues allowableValues = new AllowableListValues((List)Lists.newArrayList(), "LIST");
        String trimmed = allowableValueString.trim();
        if (trimmed.startsWith("range[")) {
            trimmed = trimmed.replaceAll("range\\[", "").replaceAll("]", "");
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)trimmed);
            ArrayList ranges = Lists.newArrayList((Iterable)split);
            allowableValues = new AllowableRangeValues((String)ranges.get(0), (String)ranges.get(1));
        } else if (trimmed.contains(",")) {
            Iterable split = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)trimmed);
            allowableValues = new AllowableListValues((List)Lists.newArrayList((Iterable)split), "LIST");
        } else if (StringUtils.hasText((String)trimmed)) {
            List<String> singleVal = Collections.singletonList(trimmed);
            allowableValues = new AllowableListValues(singleVal, "LIST");
        }
        return allowableValues;
    }

    public static Function<ApiModelProperty, Boolean> toIsRequired() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.required();
            }
        };
    }

    public static Function<ApiModelProperty, Integer> toPosition() {
        return new Function<ApiModelProperty, Integer>(){

            public Integer apply(ApiModelProperty annotation) {
                return annotation.position();
            }
        };
    }

    public static Function<ApiModelProperty, Boolean> toIsReadOnly() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.readOnly();
            }
        };
    }

    public static Function<ApiModelProperty, String> toDescription() {
        return new Function<ApiModelProperty, String>(){

            public String apply(ApiModelProperty annotation) {
                String description = "";
                if (!Strings.isNullOrEmpty((String)annotation.value())) {
                    description = annotation.value();
                } else if (!Strings.isNullOrEmpty((String)annotation.notes())) {
                    description = annotation.notes();
                }
                return description;
            }
        };
    }

    public static Function<ApiModelProperty, ResolvedType> toType(final TypeResolver resolver) {
        return new Function<ApiModelProperty, ResolvedType>(){

            public ResolvedType apply(ApiModelProperty annotation) {
                try {
                    return resolver.resolve(Class.forName(annotation.dataType()), new Type[0]);
                }
                catch (ClassNotFoundException e) {
                    return resolver.resolve(Object.class, new Type[0]);
                }
            }
        };
    }

    public static Optional<ApiModelProperty> findApiModePropertyAnnotation(AnnotatedElement annotated) {
        return Optional.fromNullable((Object)AnnotationUtils.getAnnotation((AnnotatedElement)annotated, ApiModelProperty.class));
    }

    public static Function<ApiModelProperty, Boolean> toHidden() {
        return new Function<ApiModelProperty, Boolean>(){

            public Boolean apply(ApiModelProperty annotation) {
                return annotation.hidden();
            }
        };
    }

    public static Function<ApiModelProperty, String> toExample() {
        return new Function<ApiModelProperty, String>(){

            public String apply(ApiModelProperty annotation) {
                String example = "";
                if (!Strings.isNullOrEmpty((String)annotation.example())) {
                    example = annotation.example();
                }
                return example;
            }
        };
    }
}

