package io.undertow.websockets.jsr;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.Generated;
import java.util.Set;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import java.lang.reflect.Method;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import javax.websocket.server.PathParam;
import java.util.Arrays;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2021-03-30T05:17:07-0300")
public class JsrWebSocketLogger_$logger extends DelegatingBasicLogger implements JsrWebSocketLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JsrWebSocketLogger_$logger.class.getName();
    public JsrWebSocketLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void endpointCreationFailed(final Exception cause) {
        super.log.logf(FQCN, ERROR, cause, endpointCreationFailed$str());
    }
    protected String endpointCreationFailed$str() {
        return "UT026001: Unable to instantiate endpoint";
    }
    @Override
    public final void couldNotInitializeConfiguration(final Class<?> clazz, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, couldNotInitializeConfiguration$str(), clazz);
    }
    protected String couldNotInitializeConfiguration$str() {
        return "UT026002: Unable to instantiate server configuration %s";
    }
    @Override
    public final void addingAnnotatedServerEndpoint(final Class<?> endpoint, final String value) {
        super.log.logf(FQCN, INFO, null, addingAnnotatedServerEndpoint$str(), endpoint, value);
    }
    protected String addingAnnotatedServerEndpoint$str() {
        return "UT026003: Adding annotated server endpoint %s for path %s";
    }
    @Override
    public final void addingAnnotatedClientEndpoint(final Class<?> endpoint) {
        super.log.logf(FQCN, INFO, null, addingAnnotatedClientEndpoint$str(), endpoint);
    }
    protected String addingAnnotatedClientEndpoint$str() {
        return "UT026004: Adding annotated client endpoint %s";
    }
    @Override
    public final void addingProgramaticEndpoint(final Class<?> endpointClass, final String path) {
        super.log.logf(FQCN, INFO, null, addingProgramaticEndpoint$str(), endpointClass, path);
    }
    protected String addingProgramaticEndpoint$str() {
        return "UT026005: Adding programmatic server endpoint %s for path %s";
    }
    @Override
    public final void exceptionInWebSocketMethod(final Throwable e) {
        super.log.logf(FQCN, ERROR, e, exceptionInWebSocketMethod$str());
    }
    protected String exceptionInWebSocketMethod$str() {
        return "UT026006: Exception running web socket method";
    }
    @Override
    public final void pathTemplateNotFound(final Class<?> endpointClass, final PathParam param, final Method method, final Set<String> paths) {
        super.log.logf(FQCN, WARN, null, pathTemplateNotFound$str(), endpointClass, param, method, paths);
    }
    protected String pathTemplateNotFound$str() {
        return "UT026007: On Endpoint class %s path param %s on method %s does not reference a valid parameter, valid parameters are %s.";
    }
    @Override
    public final void couldNotCloseOnUndeploy(final Exception e) {
        super.log.logf(FQCN, ERROR, e, couldNotCloseOnUndeploy$str());
    }
    protected String couldNotCloseOnUndeploy$str() {
        return "UT026008: Could not close endpoint on undeploy.";
    }
    @Override
    public final void xnioWorkerWasNull() {
        super.log.logf(FQCN, WARN, null, xnioWorkerWasNull$str());
    }
    protected String xnioWorkerWasNull$str() {
        return "UT026009: XNIO worker was not set on WebSocketDeploymentInfo, the default worker will be used";
    }
    @Override
    public final void bufferPoolWasNull() {
        super.log.logf(FQCN, WARN, null, bufferPoolWasNull$str());
    }
    protected String bufferPoolWasNull$str() {
        return "UT026010: Buffer pool was not set on WebSocketDeploymentInfo, the default pool will be used";
    }
    protected String xnioWorkerWasNullAndNoDefault$str() {
        return "UT026011: XNIO worker was not set on WebSocketDeploymentInfo, and there is no default to use";
    }
    @Override
    public final IllegalArgumentException xnioWorkerWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), xnioWorkerWasNullAndNoDefault$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String bufferPoolWasNullAndNoDefault$str() {
        return "UT026012: Buffer pool was not set on WebSocketDeploymentInfo, and there is no default to use";
    }
    @Override
    public final IllegalArgumentException bufferPoolWasNullAndNoDefault() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), bufferPoolWasNullAndNoDefault$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
