/*
 * Decompiled with CFR 0.152.
 */
package brave.kafka.streams;

import brave.Span;
import brave.Tracer;
import brave.kafka.streams.KafkaStreamsTracing;
import org.apache.kafka.streams.kstream.ValueTransformer;
import org.apache.kafka.streams.processor.ProcessorContext;

class TracingValueTransformer<V, VR>
implements ValueTransformer<V, VR> {
    final KafkaStreamsTracing kafkaStreamsTracing;
    final Tracer tracer;
    final String spanName;
    final ValueTransformer<V, VR> delegateTransformer;
    ProcessorContext processorContext;

    TracingValueTransformer(KafkaStreamsTracing kafkaStreamsTracing, String spanName, ValueTransformer<V, VR> delegateTransformer) {
        this.kafkaStreamsTracing = kafkaStreamsTracing;
        this.tracer = kafkaStreamsTracing.tracer;
        this.spanName = spanName;
        this.delegateTransformer = delegateTransformer;
    }

    public void init(ProcessorContext processorContext) {
        this.processorContext = processorContext;
        this.delegateTransformer.init(processorContext);
    }

    public VR transform(V v) {
        Span span = this.kafkaStreamsTracing.nextSpan(this.processorContext);
        if (!span.isNoop()) {
            span.name(this.spanName);
            span.start();
        }
        try {
            Object object;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpanInScope(span);
                try {
                    object = this.delegateTransformer.transform(v);
                    if (ws == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Error | RuntimeException e) {
                        span.error(e);
                        throw e;
                    }
                }
                ws.close();
            }
            return (VR)object;
        }
        finally {
            this.kafkaStreamsTracing.injector.inject(span.context(), (Object)this.processorContext.headers());
            span.finish();
        }
    }

    public void close() {
        this.delegateTransformer.close();
    }
}

