/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.LinkedHashSet;
import java.util.List;
import zipkin2.Call;
import zipkin2.storage.AutocompleteTags;
import zipkin2.storage.mysql.v1.DataSourceCall;
import zipkin2.storage.mysql.v1.MySQLStorage;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.SelectAutocompleteValues;

final class MySQLAutocompleteTags
implements AutocompleteTags {
    final DataSourceCall.Factory dataSourceCallFactory;
    final Schema schema;
    final boolean enabled;
    final LinkedHashSet<String> autocompleteKeys;
    final Call<List<String>> keysCall;

    MySQLAutocompleteTags(MySQLStorage storage, Schema schema) {
        this.dataSourceCallFactory = storage.dataSourceCallFactory;
        this.schema = schema;
        this.enabled = storage.searchEnabled && !storage.autocompleteKeys.isEmpty();
        this.autocompleteKeys = new LinkedHashSet<String>(storage.autocompleteKeys);
        this.keysCall = Call.create(storage.autocompleteKeys);
    }

    public Call<List<String>> getKeys() {
        if (!this.enabled) {
            return Call.emptyList();
        }
        return this.keysCall.clone();
    }

    public Call<List<String>> getValues(String key) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("key was empty");
        }
        if (!this.enabled || !this.autocompleteKeys.contains(key)) {
            return Call.emptyList();
        }
        return this.dataSourceCallFactory.create(new SelectAutocompleteValues(this.schema, key));
    }
}

