/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.Iterator;
import java.util.NoSuchElementException;

class PeekingIterator<T>
implements Iterator<T> {
    private final Iterator<T> delegate;
    private State state = State.NOT_READY;
    private T next;

    PeekingIterator(Iterator<T> delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate == null");
        }
        this.delegate = delegate;
    }

    protected T computeNext() {
        if (this.delegate.hasNext()) {
            return this.delegate.next();
        }
        return this.endOfData();
    }

    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        return this.next;
    }

    public T peek() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    private static enum State {
        READY,
        NOT_READY,
        DONE;

    }
}

