/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.storage.mysql.v1;

import java.util.List;
import java.util.function.Function;
import org.jooq.DSLContext;
import org.jooq.TableLike;
import zipkin2.storage.mysql.v1.Schema;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinAnnotations;
import zipkin2.storage.mysql.v1.internal.generated.tables.ZipkinSpans;

final class SelectSpanNames
implements Function<DSLContext, List<String>> {
    final Schema schema;
    final String serviceName;

    SelectSpanNames(Schema schema, String serviceName) {
        this.schema = schema;
        this.serviceName = serviceName;
    }

    @Override
    public List<String> apply(DSLContext context) {
        return context.selectDistinct(ZipkinSpans.ZIPKIN_SPANS.NAME).from((TableLike)ZipkinSpans.ZIPKIN_SPANS).join((TableLike)ZipkinAnnotations.ZIPKIN_ANNOTATIONS).on(this.schema.joinCondition(ZipkinAnnotations.ZIPKIN_ANNOTATIONS)).where(ZipkinAnnotations.ZIPKIN_ANNOTATIONS.ENDPOINT_SERVICE_NAME.eq((Object)this.serviceName)).and(ZipkinSpans.ZIPKIN_SPANS.NAME.notEqual((Object)"")).orderBy(ZipkinSpans.ZIPKIN_SPANS.NAME).fetch(ZipkinSpans.ZIPKIN_SPANS.NAME);
    }

    public String toString() {
        return "SelectSpanNames{serviceName=" + this.serviceName + "}";
    }
}

