/*
 * Decompiled with CFR 0.152.
 */
package net.mingsoft.basic.aop;

import cn.hutool.core.io.FileTypeUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.file.FileNameUtil;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.mingsoft.base.entity.ResultData;
import net.mingsoft.basic.action.BaseFileAction;
import net.mingsoft.basic.aop.BaseAop;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.config.MSProperties;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Aspect
public class FileVerifyAop
extends BaseAop {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileVerifyAop.class);

    @Pointcut(value="execution(* net.mingsoft.basic.action.ManageFileAction.upload(..)) || execution(* net.mingsoft.basic.action.ManageFileAction.uploadTemplate(..))")
    public void uploadPointCut() {
    }

    @Around(value="uploadPointCut()")
    public Object uploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        BaseFileAction.Bean bean = super.getType((JoinPoint)joinPoint, BaseFileAction.Bean.class);
        String uploadFileName = FileNameUtil.cleanInvalid((String)bean.getFile().getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)uploadFileName)) {
            return ResultData.build().error("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        InputStream inputStream = bean.getFile().getInputStream();
        String mimeType = BasicUtil.getMimeType(inputStream, uploadFileName);
        if ("zip".equalsIgnoreCase(mimeType)) {
            try {
                this.checkZip(bean.getFile(), false);
            }
            catch (Exception e) {
                return ResultData.build().error(e.getMessage());
            }
        }
        return joinPoint.proceed();
    }

    @Around(value="execution(* net.mingsoft.basic.action.web.FileAction.upload(..))")
    public Object WebUploadAop(ProceedingJoinPoint joinPoint) throws Throwable {
        BaseFileAction.Bean bean = super.getType((JoinPoint)joinPoint, BaseFileAction.Bean.class);
        String uploadFileName = FileNameUtil.cleanInvalid((String)bean.getFile().getOriginalFilename());
        if (StringUtils.isBlank((CharSequence)uploadFileName)) {
            return ResultData.build().error("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        InputStream inputStream = bean.getFile().getInputStream();
        String mimeType = BasicUtil.getMimeType(inputStream, uploadFileName);
        if ("zip".equalsIgnoreCase(mimeType)) {
            try {
                this.checkZip(bean.getFile(), true);
            }
            catch (Exception e) {
                return ResultData.build().error(e.getMessage());
            }
        }
        return joinPoint.proceed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkZip(MultipartFile multipartFile, boolean isWeb) throws Exception {
        File tempFilePath = FileUtil.mkdir((String)(FileUtil.getTmpDirPath() + "/Zip" + IdUtil.simpleUUID()));
        File zipFile = FileUtil.file((String)(tempFilePath.getAbsolutePath() + "/" + IdUtil.simpleUUID() + ".zip"));
        multipartFile.transferTo(zipFile);
        try {
            this.unzip(zipFile, tempFilePath.getAbsolutePath());
            List files = FileUtil.loopFiles((File)tempFilePath);
            files.remove(zipFile);
            List deniedList = Arrays.stream(MSProperties.upload.denied.split(",")).map(String::toLowerCase).collect(Collectors.toList());
            for (File file : files) {
                FileInputStream fileInputStream = new FileInputStream(file);
                String fileType = FileTypeUtil.getType((File)file).toLowerCase();
                if (deniedList.contains(fileType)) {
                    IOUtils.closeQuietly((Closeable)fileInputStream);
                    throw new RuntimeException(StrUtil.format((CharSequence)"\u538b\u7f29\u5305\u5185\u6587\u4ef6{}\u7684\u7c7b\u578b{}\u7981\u6b62\u4e0a\u4f20", (Object[])new Object[]{file.getName(), fileType}));
                }
                IOUtils.closeQuietly((Closeable)fileInputStream);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            FileUtil.del((File)tempFilePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzip(File file, String descDir) throws IOException {
        ZipArchiveInputStream inputStream = new ZipArchiveInputStream((InputStream)new BufferedInputStream(new FileInputStream(file)));
        File pathFile = new File(descDir);
        if (!pathFile.exists()) {
            pathFile.mkdirs();
        }
        ZipArchiveEntry entry = null;
        while ((entry = inputStream.getNextZipEntry()) != null) {
            String[] dirs = entry.getName().split("/");
            String tempDir = descDir;
            for (String dir : dirs) {
                if (dir.indexOf(".") != -1) continue;
                tempDir = tempDir + File.separator.concat(dir);
                FileUtil.mkdir((String)tempDir);
            }
            if (entry.isDirectory()) {
                File directory = new File(descDir, entry.getName());
                directory.mkdirs();
                continue;
            }
            BufferedOutputStream os = null;
            try {
                LOGGER.debug("file name => {}", (Object)entry.getName());
                try {
                    os = new BufferedOutputStream(new FileOutputStream(new File(descDir, entry.getName())));
                    IOUtils.copy((InputStream)inputStream, (OutputStream)os);
                }
                catch (FileNotFoundException e) {
                    LOGGER.error("\u89e3\u538b{}\u4e0d\u5b58\u5728", (Object)entry.getName());
                    e.printStackTrace();
                }
            }
            finally {
                IOUtils.closeQuietly(os);
            }
        }
        IOUtils.closeQuietly((Closeable)inputStream);
    }
}

